/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.vo.voucher.wrap;

import java.math.BigDecimal;
import kd.bos.entity.datamodel.IDataModel;
import kd.fi.gl.business.vo.voucher.Amount;
import kd.fi.gl.business.vo.voucher.AmountField;
import kd.fi.gl.business.vo.voucher.IVoucherEntry;

public class DataModelEntryWrap
implements IVoucherEntry {
    private final int rowIndex;
    private final IDataModel model;

    public DataModelEntryWrap(int rowIndex, IDataModel model) {
        this.rowIndex = rowIndex;
        this.model = model;
    }

    @Override
    public long getId() {
        return (Long)this.model.getValue("id");
    }

    @Override
    public long getEntryId() {
        return (Long)this.model.getValue("entries.id", this.rowIndex);
    }

    @Override
    public int getSeq() {
        return this.rowIndex;
    }

    @Override
    public long getCurrencyId() {
        return (Long)this.model.getValue("currency.id", this.rowIndex);
    }

    @Override
    public String getEntryDC() {
        return (String)this.model.getValue("entrydc", this.rowIndex);
    }

    @Override
    public BigDecimal getDebitLocAmt() {
        return this.getBigDecimal("debitlocal");
    }

    @Override
    public BigDecimal getDebitOriAmt() {
        return this.getBigDecimal("debitori");
    }

    @Override
    public BigDecimal getCreditLocAmt() {
        return this.getBigDecimal("creditlocal");
    }

    @Override
    public BigDecimal getCreditOriAmt() {
        return this.getBigDecimal("creditori");
    }

    @Override
    public BigDecimal getDebit(AmountField field) {
        return this.getBigDecimal(field.getDebitField());
    }

    @Override
    public BigDecimal getCredit(AmountField field) {
        return this.getBigDecimal(field.getCreditField());
    }

    @Override
    public Amount getAmount(AmountField field) {
        return new Amount(this.getDebit(field), this.getCredit(field));
    }

    @Override
    public BigDecimal getBigDecimal(String prop) {
        return (BigDecimal)this.model.getValue(prop, this.rowIndex);
    }

    @Override
    public Object get(String key) {
        return this.model.getValue(key, this.rowIndex);
    }

    @Override
    public void set(String key, Object value) {
        String removeIdSuffix = key.replaceFirst("_id$", "");
        this.model.setValue(removeIdSuffix, value, this.rowIndex);
    }

    @Override
    public void setBigDecimal(String field, BigDecimal decimal) {
        this.model.setValue(field, (Object)decimal, this.rowIndex);
    }
}

