/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.cache;

import java.util.HashMap;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.fi.gl.cache.CacheKey;
import kd.fi.gl.cache.ICacheService;
import kd.fi.gl.cache.TimeToIdleCacheService;
import kd.fi.gl.cache.TimeToLiveCacheService;

public class CacheServiceHelper {
    private static final Map<Class<?>, ICacheService> SERVICE_MAP = new HashMap(2);

    private static ICacheService getCacheService(Class<?> serviceClass) {
        ICacheService cacheService = SERVICE_MAP.get(serviceClass);
        if (cacheService == null) {
            throw new KDBizException(String.format("can't find cache service by \"%s\".", serviceClass.getName()));
        }
        return cacheService;
    }

    public static void putToTimeToLiveLocalCache(CacheKey key, Object content) {
        CacheServiceHelper.getCacheService(TimeToLiveCacheService.class).put(key, content);
    }

    public static <T> T getFromTimeToLiveLocalCache(CacheKey key, Class<T> clazz) {
        return CacheServiceHelper.getCacheService(TimeToLiveCacheService.class).get(key, clazz);
    }

    public static void removeFromTimeToLiveLocalCache(CacheKey key) {
        CacheServiceHelper.getCacheService(TimeToLiveCacheService.class).remove(key);
    }

    public static void putToTimeToIdleLocalCache(CacheKey key, Object content) {
        CacheServiceHelper.getCacheService(TimeToIdleCacheService.class).put(key, content);
    }

    public static <T> T getFromTimeToIdleLocalCache(CacheKey key, Class<T> clazz) {
        return CacheServiceHelper.getCacheService(TimeToIdleCacheService.class).get(key, clazz);
    }

    public static void removeFromTimeToIdleLocalCache(CacheKey key) {
        CacheServiceHelper.getCacheService(TimeToIdleCacheService.class).remove(key);
    }

    static {
        SERVICE_MAP.put(TimeToLiveCacheService.class, new TimeToLiveCacheService());
        SERVICE_MAP.put(TimeToIdleCacheService.class, new TimeToIdleCacheService());
    }
}

