/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.cache;

import java.util.Map;
import kd.fi.gl.cache.IValueCreator;

public class MapCache<K, V> {
    private final Map<K, V> cache;
    private IValueCreator<K, V> creator;

    public MapCache(Map<K, V> cache) {
        this.cache = cache;
    }

    public MapCache(Map<K, V> cache, IValueCreator<K, V> creator) {
        this.cache = cache;
        this.creator = creator;
    }

    public Map<K, V> getCache() {
        return this.cache;
    }

    public IValueCreator<K, V> getCreator() {
        return this.creator;
    }

    public void setCreator(IValueCreator<K, V> creator) {
        this.creator = creator;
    }

    public V get(K k) {
        if (null != this.creator) {
            return this.get(k, this.creator);
        }
        return this.getCache().get(k);
    }

    public V get(K k, IValueCreator<K, V> creator) {
        if (this.getCache().containsKey(k)) {
            return this.getCache().get(k);
        }
        V v = creator.create(k);
        this.getCache().put(k, v);
        return v;
    }
}

