/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.checktools;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.ext.fi.ai.FIDataCheckTask;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.ext.fi.util.FIDataCheckUtil;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.checktools.CashflowCheck;
import kd.fi.gl.util.BalanceCheckHelper;
import kd.fi.gl.util.CheckCashAccHasCF;
import kd.fi.gl.util.GLUtil;

public class CheckCashAcctHasMainCFTask
implements FIDataCheckTask {
    private static final Log logger = LogFactory.getLog((String)"kd.fi.gl.checktools.CheckCashAcctHasMainCFTask");

    public boolean execute() {
        if (FIDataCheckUtil.isStop()) {
            return false;
        }
        String tenantId = RequestContext.get().getTenantId();
        if (tenantId.equals("agilepre") || tenantId.equals("pretest")) {
            return true;
        }
        return this.check() & this.checkPreset() & this.checkVoucherCashflow();
    }

    private boolean check() {
        DynamicObjectCollection books = BalanceCheckHelper.getAllBooks(null);
        ArrayList<String> errorVouchers = new ArrayList<String>(16);
        for (DynamicObject book : books) {
            List<Long> periods = GLUtil.getPeriodIds(book.getLong("startperiod"), book.getLong("curperiod"));
            if (periods.size() == 0 || periods.size() == 1 && periods.get(0) == 0L) continue;
            errorVouchers.addAll(CheckCashAccHasCF.checkCashAccHasCF(Collections.singletonList(book.getLong("org")), periods, false));
        }
        if (errorVouchers.size() > 0) {
            FIDataCheckUtil.saveResult((String)"cashacchascf", (String)"gl", (boolean)false, (String)ResManager.loadKDString((String)"\u51ed\u8bc1\u6709\u73b0\u91d1\u79d1\u76ee\u6307\u5b9a\u4e86\u4e3b\u8868\u9879\u76ee\u3002", (String)"CheckCashAcctHasMainCFTask_0", (String)"fi-gl-common", (Object[])new Object[0]), (String)"kd.fi.gl.checktools.BalanceCheckTask");
            logger.info("vouchererrinfo:{}", (Object)((Object)errorVouchers).toString());
            return false;
        }
        return true;
    }

    private boolean checkPreset() {
        String sql = "select fgroupid,fcreateorgid,faccounttableid from t_gl_presetcashflowitem group by fgroupid,fcreateorgid,faccounttableid having count(1) > 1";
        ArrayList<String> errorPreset = new ArrayList<String>(8);
        try (DataSet ds = DB.queryDataSet((String)"", (DBRoute)DBRoute.of((String)"fi"), (String)sql);){
            for (Row row : ds) {
                errorPreset.add(row.getLong("fgroupid") + "_" + row.getLong("fcreateorgid") + "_" + row.getLong("faccounttableid"));
            }
        }
        if (errorPreset.size() > 0) {
            FIDataCheckUtil.saveResult((String)"cashacchascf", (String)"gl", (boolean)false, (String)ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u73b0\u91d1\u6d41\u91cf\u6620\u5c04\u5173\u7cfb\u3002", (String)"CheckCashAcctHasMainCFTask_1", (String)"fi-gl-common", (Object[])new Object[0]), (String)"kd.fi.gl.checktools.BalanceCheckTask");
            logger.info("errorpresetinfo:{}", (Object)((Object)errorPreset).toString());
            return false;
        }
        return true;
    }

    private boolean checkVoucherCashflow() {
        HashSet errorVouchers = new HashSet();
        DataSet accountBooksDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_accountbook", (String)"org,bookstype,curperiod", (QFilter[])new QFilter[]{new QFilter("cashinitperiod", ">", (Object)0L)}, null);
        ArrayList<Future> resultList = new ArrayList<Future>();
        String sels = "id,org,mainstatus,suppstatus,period,booktype,sourcetype,entries.account.iscash iscash,entries.account.isbank isbank,entries.account.iscashequivalent iscashequivalent,entries.account.pltype pltype,entries.debitlocal debit,entries.creditlocal credit,entries.maincfitem maincfitem,entries.maincfitem.direction direction,entries.maincfitem.isdealactivity isdealactivity,entries.maincfamount maincfamount,entries.suppcfitem suppcfitem,entries.suppcfamount suppcfamount";
        for (Row bookRow : accountBooksDs) {
            QFilter orgQf = new QFilter("org", "=", (Object)bookRow.getLong("org"));
            QFilter booktypeQf = new QFilter("booktype", "=", (Object)bookRow.getLong("bookstype"));
            QFilter periodQf = new QFilter("period", "=", (Object)bookRow.getLong("curperiod"));
            Future future = ThreadService.submit(() -> {
                HashSet<String> errorVchs = new HashSet<String>();
                QFilter billstatusQf = new QFilter("billstatus", "in", (Object)new String[]{"B", "C"});
                long voucherId = 0L;
                CashflowCheck cashflowCheck = new CashflowCheck();
                String mainStatus = "0";
                String suppStatus = "0";
                long orgId = 0L;
                long bookTypeId = 0L;
                long periodId = 0L;
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_voucher", (String)sels, (QFilter[])new QFilter[]{orgQf, booktypeQf, periodQf, billstatusQf}, (String)"id");){
                    if (!ds.isEmpty()) {
                        for (Row row : ds) {
                            if (voucherId != 0L && voucherId != row.getLong("id")) {
                                String[] rightStatus = this.getRightCfStatus(cashflowCheck);
                                if (!mainStatus.equals(rightStatus[0]) || !suppStatus.equals(rightStatus[1])) {
                                    String key = orgId + "-" + bookTypeId + "-" + periodId + "-" + voucherId;
                                    errorVchs.add(key);
                                }
                                cashflowCheck = new CashflowCheck();
                                mainStatus = row.getString("mainstatus");
                                suppStatus = row.getString("suppstatus");
                                voucherId = row.getLong("id");
                                orgId = row.getLong("org");
                                bookTypeId = row.getLong("booktype");
                                periodId = row.getLong("period");
                                cashflowCheck.setProfitAndLossValue("1".equals(row.getString("sourcetype")));
                            } else if (voucherId == 0L) {
                                voucherId = row.getLong("id");
                                orgId = row.getLong("org");
                                bookTypeId = row.getLong("booktype");
                                periodId = row.getLong("period");
                                mainStatus = row.getString("mainstatus");
                                suppStatus = row.getString("suppstatus");
                                cashflowCheck.setProfitAndLossValue("1".equals(row.getString("sourcetype")));
                            }
                            this.initCashCheck(row, cashflowCheck);
                        }
                        String[] rightStatus = this.getRightCfStatus(cashflowCheck);
                        if (!mainStatus.equals(rightStatus[0]) || !suppStatus.equals(rightStatus[1])) {
                            String key = orgId + "-" + bookTypeId + "-" + periodId + "-" + voucherId;
                            errorVchs.add(key);
                        }
                    }
                }
                return errorVchs;
            }, (TaskType)TaskType.GL_PARELLEL_COMPUTE);
            resultList.add(future);
            if (resultList.size() <= 100) continue;
            for (Future taskResult : resultList) {
                try {
                    errorVouchers.addAll((Collection)taskResult.get());
                }
                catch (Exception e) {
                    logger.error("checkVoucherCashflow_failed on " + e.getMessage(), (Throwable)e);
                    return false;
                }
            }
            resultList.clear();
        }
        if (!CollectionUtils.isEmpty(resultList)) {
            for (Future taskResult : resultList) {
                try {
                    errorVouchers.addAll((Collection)taskResult.get());
                }
                catch (Exception e) {
                    logger.error("checkVoucherCashflow_failed on " + e.getMessage(), (Throwable)e);
                    return false;
                }
            }
        }
        if (!CollectionUtils.isEmpty(errorVouchers)) {
            String errorInfo = StringUtils.setToString(errorVouchers);
            FIDataCheckUtil.saveResult((String)"checkVoucherCashflow", (String)"gl", (boolean)false, (String)String.format(ResManager.loadKDString((String)"\u5b58\u5728\u73b0\u91d1\u6d41\u91cf\u6307\u5b9a\u4e0d\u5e73\u7684\u51ed\u8bc1: %1$s", (String)"CheckCashAcctHasMainCFTask_2", (String)"fi-gl-common", (Object[])new Object[0]), "kd.fi.gl.checktools.BalanceCheckTask"), (String)errorInfo);
            logger.info("errorvoucherinfo:{}", (Object)errorInfo);
            return false;
        }
        return true;
    }

    private void initCashCheck(Row row, CashflowCheck cashflowCheck) {
        if (this.isCash(row)) {
            cashflowCheck.setHasCash(true);
            cashflowCheck.setCashAmount(cashflowCheck.getCashAmount().add(this.passAmount(row.getBigDecimal("debit")).subtract(this.passAmount(row.getBigDecimal("credit")))));
        }
        if (!"0".equals(row.getString("pltype"))) {
            cashflowCheck.setHasPltype(true);
            cashflowCheck.setSuppAcctAmount(cashflowCheck.getSuppAcctAmount().add(this.passAmount(row.getBigDecimal("credit")).subtract(this.passAmount(row.getBigDecimal("debit")))));
        }
        if (!row.getBoolean("iscash").booleanValue() && !row.getBoolean("isbank").booleanValue() && !row.getBoolean("iscashequivalent").booleanValue() && "0".equals(row.getString("pltype"))) {
            cashflowCheck.setHasOther(true);
        }
        if (row.getLong("maincfitem") != null && row.getLong("maincfitem") != 0L) {
            cashflowCheck.setHasMainCf(true);
            boolean isdealactivity = row.getBoolean("isdealactivity");
            if (!cashflowCheck.isNeedDesign()) {
                if (!"0".equals(row.getString("pltype"))) {
                    if (!isdealactivity) {
                        cashflowCheck.setNeedDesign(true);
                    }
                } else if (isdealactivity) {
                    cashflowCheck.setNeedDesign(true);
                }
            }
            BigDecimal maincfamount = "o".equals(row.getString("direction")) ? this.passAmount(row.getBigDecimal("maincfamount")).negate() : this.passAmount(row.getBigDecimal("maincfamount"));
            cashflowCheck.setMainCfAmount(cashflowCheck.getMainCfAmount().add(maincfamount));
            if (isdealactivity) {
                cashflowCheck.setDealactivityAmount(cashflowCheck.getDealactivityAmount().add(maincfamount));
            }
            if (!cashflowCheck.isPlMainCf() && !"0".equals(row.getString("pltype"))) {
                cashflowCheck.setPlMainCf(true);
            }
        }
        if (row.getLong("suppcfitem") != null && row.getLong("suppcfitem") != 0L) {
            cashflowCheck.setHasSuppCf(true);
            cashflowCheck.setSuppCfAmount(cashflowCheck.getSuppCfAmount().add(this.passAmount(row.getBigDecimal("suppcfamount"))));
        }
    }

    private String[] getRightCfStatus(CashflowCheck cashflowCheck) {
        if (!cashflowCheck.isNeedDesign() && !cashflowCheck.isHasCash() && cashflowCheck.isHasPltype() && cashflowCheck.isHasOther()) {
            cashflowCheck.setHasOther(true);
        }
        String[] rightStatus = new String[]{"0", "0"};
        if (cashflowCheck.isProfitAndLossValue()) {
            return rightStatus;
        }
        if (cashflowCheck.isHasCash()) {
            if (cashflowCheck.isHasPltype() || cashflowCheck.isHasOther()) {
                if (cashflowCheck.isHasMainCf()) {
                    rightStatus[0] = cashflowCheck.getCashAmount().compareTo(cashflowCheck.getMainCfAmount()) == 0 ? "3" : "2";
                    if (cashflowCheck.isNeedDesign()) {
                        BigDecimal suppAmt = cashflowCheck.getDealactivityAmount().subtract(cashflowCheck.getSuppAcctAmount());
                        if (cashflowCheck.isHasCash() && !cashflowCheck.isPlMainCf()) {
                            suppAmt = cashflowCheck.getDealactivityAmount();
                        }
                        rightStatus[1] = suppAmt.compareTo(cashflowCheck.getSuppCfAmount()) != 0 ? (cashflowCheck.getSuppCfAmount().signum() == 0 ? "1" : "2") : "3";
                    }
                } else {
                    rightStatus[0] = "1";
                }
            }
        } else if (cashflowCheck.isHasPltype()) {
            if (cashflowCheck.isHasOther()) {
                BigDecimal suppAmt = cashflowCheck.getDealactivityAmount().subtract(cashflowCheck.getSuppAcctAmount());
                if (cashflowCheck.isHasCash() && !cashflowCheck.isPlMainCf()) {
                    suppAmt = cashflowCheck.getDealactivityAmount();
                }
                rightStatus[1] = suppAmt.compareTo(cashflowCheck.getSuppCfAmount()) != 0 ? (cashflowCheck.getSuppCfAmount().signum() == 0 ? "1" : "2") : "3";
            }
        } else {
            rightStatus[1] = cashflowCheck.isHasSuppCf() ? (cashflowCheck.getSuppCfAmount().compareTo(BigDecimal.ZERO) == 0 ? "c" : "b") : "a";
        }
        return rightStatus;
    }

    private BigDecimal passAmount(BigDecimal amount) {
        if (amount == null) {
            return BigDecimal.ZERO;
        }
        return amount;
    }

    private boolean isCash(Row row) {
        return row.getBoolean("iscash") != false || row.getBoolean("isbank") != false || row.getBoolean("iscashequivalent") != false;
    }
}

