/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.closeperiod;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfo;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.business.service.GLAccountBookService;
import kd.fi.gl.closeperiod.AnitCloseCheckResult;
import kd.fi.gl.closeperiod.ClosePeriodUtils;
import kd.fi.gl.closeperiod.IAntiCloseChecker;
import kd.fi.gl.util.GLUtil;

public class GlCloseStateAntiCloseChecker
implements IAntiCloseChecker {
    private static final String GL = "gl";
    private static final String BIZ_SYSTEM_CLOSE_STATUS = "BizSystemCloseStatus";
    public static final GlCloseStateAntiCloseChecker instance = new GlCloseStateAntiCloseChecker();

    private GlCloseStateAntiCloseChecker() {
    }

    @Override
    public boolean enable(String bizAppCode, String subBizAppCode, Long orgId) {
        return ClosePeriodUtils.getCheckItemEnable(GL, subBizAppCode, orgId, BIZ_SYSTEM_CLOSE_STATUS);
    }

    @Override
    public AnitCloseCheckResult check(String bizFormId, String bizAppId, String bookTypeField, long orgId, String bizBookType, long periodId) {
        AnitCloseCheckResult anitCloseCheckResult = new AnitCloseCheckResult();
        anitCloseCheckResult.setSuccess(true);
        BookRegisterInfo bookRegisterInfo = BookRegisterService.queryByBizApp((String)bizAppId);
        Set<Long> accountBookIds = GLAccountBookGetterFactory.getAccountBookGetter(bookRegisterInfo).getGLAccountBook(bookRegisterInfo, orgId, StringUtils.isEmpty((String)bizBookType) ? 0L : Long.parseLong(bizBookType));
        if (CollectionUtils.isNotEmpty(accountBookIds) && this.existsClosedGLBook(accountBookIds, periodId)) {
            anitCloseCheckResult.setResultMessage(ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u603b\u8d26\u8d26\u7c3f\u5f53\u671f\u5df2\u7ed3\u8d26\uff0c\u4e1a\u52a1\u7cfb\u7edf\u4e0d\u5141\u8bb8\u53cd\u7ed3\u8d26\u3002", (String)"GlCloseStateAntiCloseChecker_0", (String)"fi-gl-common", (Object[])new Object[0]));
            anitCloseCheckResult.setSuccess(false);
        }
        return anitCloseCheckResult;
    }

    private boolean existsClosedGLBook(Set<Long> accountBookIds, long periodId) {
        DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"org.id, bookstype.id, curperiod.id", (QFilter[])new QFilter("id", "in", accountBookIds).toArray());
        List closedGLBooks = books.stream().filter(x -> ClosePeriodUtils.comparePeriod(x.getLong("curperiod.id"), periodId) > 0).collect(Collectors.toList());
        Iterator iterator = closedGLBooks.iterator();
        while (iterator.hasNext()) {
            DynamicObject book = (DynamicObject)iterator.next();
            List<Long> openPeriodIds = GLUtil.getOpenPeriod(book.getLong("org.id"), book.getLong("bookstype.id"));
            if (openPeriodIds.isEmpty() || !openPeriodIds.stream().anyMatch(x -> ClosePeriodUtils.comparePeriod(x, periodId) == 0)) continue;
            iterator.remove();
        }
        return !closedGLBooks.isEmpty();
    }

    private static class GetAccountBookByBizBook
    implements IGLAccountBookGetter {
        private GetAccountBookByBizBook() {
        }

        @Override
        public Set<Long> getGLAccountBook(BookRegisterInfo bookRegisterInfo, Long bizOrgId, Long bizBookTypeId) {
            DynamicObject bizBook = BusinessDataServiceHelper.loadSingle((String)bookRegisterInfo.getBookEntityId(), (String)"id", (QFilter[])new QFilter(bookRegisterInfo.getOrgFieldOnBookEntity(), "=", (Object)bizOrgId).and(bookRegisterInfo.getBookTypeFieldOnBookEntity(), "=", (Object)bizBookTypeId).toArray());
            if (bizBook == null) {
                return Collections.emptySet();
            }
            return GLAccountBookService.queryGlAccountBook((String)BizAppServiceHelp.getAppIdByAppNumber((String)bookRegisterInfo.getBizApp()), (Long)((Long)bizBook.getPkValue()), (Long)0L);
        }
    }

    private static class GetAccountBookByBizBookWithoutBookType
    implements IGLAccountBookGetter {
        private GetAccountBookByBizBookWithoutBookType() {
        }

        @Override
        public Set<Long> getGLAccountBook(BookRegisterInfo bookRegisterInfo, Long bizOrgId, Long bizBookTypeId) {
            DynamicObject bizBook = BusinessDataServiceHelper.loadSingle((String)bookRegisterInfo.getBookEntityId(), (String)"id", (QFilter[])new QFilter(bookRegisterInfo.getOrgFieldOnBookEntity(), "=", (Object)bizOrgId).toArray());
            if (bizBook == null) {
                return Collections.emptySet();
            }
            return GLAccountBookService.queryGlAccountBook((String)BizAppServiceHelp.getAppIdByAppNumber((String)bookRegisterInfo.getBizApp()), (Long)((Long)bizBook.getPkValue()), (Long)0L);
        }
    }

    private static class GetAccountBookByBizOrg
    implements IGLAccountBookGetter {
        private GetAccountBookByBizOrg() {
        }

        @Override
        public Set<Long> getGLAccountBook(BookRegisterInfo bookRegisterInfo, Long bizOrgId, Long bizBookTypeId) {
            return GLAccountBookService.queryGlAccountBook((String)BizAppServiceHelp.getAppIdByAppNumber((String)bookRegisterInfo.getBizApp()), (Long)0L, (Long)bizOrgId);
        }
    }

    private static interface IGLAccountBookGetter {
        public Set<Long> getGLAccountBook(BookRegisterInfo var1, Long var2, Long var3);
    }

    private static class GLAccountBookGetterFactory {
        private GLAccountBookGetterFactory() {
        }

        public static IGLAccountBookGetter getAccountBookGetter(BookRegisterInfo bookRegisterInfo) {
            if (StringUtils.isEmpty((String)bookRegisterInfo.getBookEntityId())) {
                return new GetAccountBookByBizOrg();
            }
            if (StringUtils.isEmpty((String)bookRegisterInfo.getBookTypeFieldOnBookEntity())) {
                return new GetAccountBookByBizBookWithoutBookType();
            }
            return new GetAccountBookByBizBook();
        }
    }
}

