/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.closeperiod.breakpoint;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.voucher.VoucherNumberUtils;

public class BreakPointCommonUtil {
    public static List<Long> getOrgIds(AbstractFormPlugin formPlugin) {
        String orgIdsStr = (String)formPlugin.getView().getFormShowParameter().getCustomParam("orgIds");
        if (StringUtils.isEmpty((String)orgIdsStr)) {
            return Collections.EMPTY_LIST;
        }
        List orgIdList = JSON.parseArray((String)orgIdsStr, String.class);
        orgIdList.sort(Comparator.naturalOrder());
        List<Long> orgIds = orgIdList.stream().map(Long::valueOf).collect(Collectors.toList());
        return orgIds;
    }

    public static List<ComboItem> getOrgComboItems(AbstractFormPlugin formPlugin) {
        List<Long> orgIds = BreakPointCommonUtil.getOrgIds(formPlugin);
        return BreakPointCommonUtil.getOrgComboItems(orgIds);
    }

    public static List<ComboItem> getOrgComboItems(List<Long> orgIds) {
        LinkedHashMap<String, ComboItem> orgComboItemMap = new LinkedHashMap<String, ComboItem>(8);
        try (DataSet orgSets = BatchProcessUtil.batchQueryDataSet(orgIds, batch -> QueryServiceHelper.queryDataSet((String)"kd.fi.gl.formplugin.breakpoint.initfilter", (String)"gl_accountbook", (String)"org.id orgId,org.number,org.name orgname", (QFilter[])new QFilter("org", "in", batch).toArray(), (String)"org.number")).orderBy(new String[]{"org.number"});){
            for (Row r : orgSets) {
                String orgPk = r.getString("orgId");
                orgComboItemMap.putIfAbsent(orgPk, new ComboItem(new LocaleString(r.getString("orgname")), orgPk));
            }
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(orgComboItemMap.values());
        return comboItems;
    }

    public static List<Map<String, String>> getBookByOrgBooktype(Long org, Long booktype) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("org", "=", org);
        qfBuilder.add("isbizunit", "=", Boolean.TRUE);
        List<Long> bootTypeIds = AccSysUtil.getBookTypeDataPermission(Collections.singletonList(org));
        if (bootTypeIds != null) {
            qfBuilder.add("bookstype", "in", bootTypeIds);
        }
        if (null != booktype) {
            qfBuilder.add("bookstype", "=", booktype);
        }
        String selectFields = String.join((CharSequence)",", "curperiod", "startperiod", "org", "bookstype", "periodtype");
        Map booksMap = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (String)selectFields, (QFilter[])qfBuilder.toArray());
        ArrayList<Map<String, String>> books = new ArrayList<Map<String, String>>(booksMap.size());
        for (Map.Entry bookEntry : booksMap.entrySet()) {
            DynamicObject book = (DynamicObject)bookEntry.getValue();
            HashMap<String, String> mapForList = new HashMap<String, String>(3);
            mapForList.put("bookNm", book.getDynamicObject("bookstype").getString("name"));
            mapForList.put("masterId", book.getDynamicObject("bookstype").getString("masterid"));
            mapForList.put("curperiodPkId", null == book.getDynamicObject("curperiod") ? "" : book.getDynamicObject("curperiod").getPkValue().toString());
            mapForList.put("startperiodPkId", null == book.getDynamicObject("startperiod") ? "" : book.getDynamicObject("startperiod").getPkValue().toString());
            books.add(mapForList);
        }
        return books;
    }

    public static List<Map<String, String>> getBooksByOrg(Long org) {
        return BreakPointCommonUtil.getBookByOrgBooktype(org, null);
    }

    public static Map<Long, DynamicObject> getVoucherMap(List<Long> voucherIds) {
        DynamicObject[] vouchers = BusinessDataServiceHelper.load((Object[])voucherIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_voucher"));
        HashMap<Long, DynamicObject> voucherMap = new HashMap<Long, DynamicObject>(vouchers.length);
        for (DynamicObject v : vouchers) {
            voucherMap.put(v.getLong("id"), v);
        }
        return voucherMap;
    }

    public static DynamicObject buildVoucherBreakPoint(DynamicObject voucher, MainEntityType voucherBreakPointType) {
        DynamicObject voucherBreakPoint = new DynamicObject((DynamicObjectType)voucherBreakPointType);
        voucherBreakPoint.set("org", voucher.get("org"));
        voucherBreakPoint.set("isadjust", (Object)"2");
        voucherBreakPoint.set("bookeddate", voucher.get("bookeddate"));
        voucherBreakPoint.set("bizdate", voucher.get("bizdate"));
        voucherBreakPoint.set("vouchertype", voucher.get("vouchertype"));
        voucherBreakPoint.set("voucherno", (Object)voucher.getString("billno"));
        voucherBreakPoint.set("voucherid", voucher.get("id"));
        voucherBreakPoint.set("periodid", voucher.getDynamicObject("period").getPkValue());
        voucherBreakPoint.set("booktypeid", voucher.getDynamicObject("booktype").getPkValue());
        return voucherBreakPoint;
    }

    public static DynamicObject buildVoucherBreakPointFromRow(Row voucherRow, MainEntityType voucherBreakPointType) {
        DynamicObject voucherBreakPoint = new DynamicObject((DynamicObjectType)voucherBreakPointType);
        voucherBreakPoint.set("org", voucherRow.get("org.id"));
        voucherBreakPoint.set("isadjust", (Object)"2");
        voucherBreakPoint.set("bookeddate", voucherRow.get("bookeddate"));
        voucherBreakPoint.set("bizdate", voucherRow.get("bizdate"));
        voucherBreakPoint.set("vouchertype", voucherRow.get("vouchertype"));
        voucherBreakPoint.set("voucherno", (Object)voucherRow.getString("billno"));
        voucherBreakPoint.set("voucherid", voucherRow.get("id"));
        voucherBreakPoint.set("periodid", voucherRow.get("periodid"));
        voucherBreakPoint.set("booktypeid", voucherRow.get("booktypeid"));
        return voucherBreakPoint;
    }

    public static String getOrgName(String orgid) {
        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(orgid)).toArray());
        String orgName = "";
        if (org != null) {
            orgName = org.getString("name");
        }
        return orgName;
    }

    public static Long getDefaultOrgId(AbstractFormPlugin formPlugin) {
        List<ComboItem> orgComboItems = BreakPointCommonUtil.getOrgComboItems(formPlugin);
        if (CollectionUtils.isEmpty(orgComboItems)) {
            return null;
        }
        String orgIdStr = orgComboItems.get(0).getValue();
        return Long.parseLong(orgIdStr);
    }

    public static List<Map<String, String>> getOrgBooks(String curOrg, AbstractFormPlugin formPlugin) {
        FormShowParameter formShowParameter = formPlugin.getView().getFormShowParameter();
        String orgAndBooksMapStr = (String)formShowParameter.getCustomParam("orgAndBooksForPointList");
        List<Map<String, String>> books = new ArrayList<Map<String, String>>(8);
        if (!StringUtils.isEmpty((String)orgAndBooksMapStr)) {
            Map orgAndBooksMap = (Map)JSON.parseObject((String)orgAndBooksMapStr, HashMap.class);
            books = (List)orgAndBooksMap.get(curOrg);
        }
        if (CollectionUtils.isEmpty(books)) {
            books = BreakPointCommonUtil.getBooksByOrg(Long.parseLong(curOrg));
        }
        return books;
    }

    public static long getCurentPeriod(long curOrg, long curBooktype) {
        long curPeriodId = new AccountBookInfo(curOrg, curBooktype).getCurPeriodId();
        return curPeriodId;
    }

    public static boolean checkSamePeriodType(String lastPeriod, String defaultCurperiod) {
        DynamicObject lastPeriodDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(lastPeriod), (String)"bd_period", (String)"periodtype");
        DynamicObject curPeriodDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(defaultCurperiod), (String)"bd_period", (String)"periodtype");
        return lastPeriodDyo.getLong("periodtype.id") == curPeriodDyo.getLong("periodtype.id");
    }

    public static List<Long> getLastPeriodIds(long periodid, int nums) {
        ArrayList<Long> lastPeriodIds = new ArrayList<Long>(nums);
        SqlBuilder sql = new SqlBuilder();
        sql.append("select top " + nums + " a.fid,a.ftypeid from t_bd_period a ", new Object[0]);
        sql.append("join t_bd_period b on a.ftypeid=b.ftypeid ", new Object[0]);
        sql.append("where a.fid <= ? ", new Object[]{periodid});
        sql.append("and b.fid = ? ", new Object[]{periodid});
        sql.append("order by a.fid desc ", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"VocherBreakPointList.getPeriodtypeAndLastThreePeriodIds", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                lastPeriodIds.add(row.getLong("fid"));
            }
        }
        return lastPeriodIds;
    }

    public static Long getStartPeriod(String curorg, String curBooktype, AbstractFormPlugin formPlugin) {
        List<Map<String, String>> orgBooks = BreakPointCommonUtil.getOrgBooks(curorg, formPlugin);
        for (Map<String, String> book : orgBooks) {
            if (!Objects.equals(curBooktype, book.get("masterId"))) continue;
            return Long.parseLong(book.get("startperiodPkId"));
        }
        return 0L;
    }

    public static boolean checkInOpenPeriod(Long lastPeriod, Long curentPeriod, Long orgId, Long booktypeId) {
        List<Long> openPeriods = GLUtil.getOpenPeriod(orgId, booktypeId);
        if (openPeriods.contains(lastPeriod)) {
            return true;
        }
        DynamicObject currPeriodDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)curentPeriod, (String)"bd_period", (String)"periodtype");
        Long periodtype = currPeriodDyo.getLong("periodtype.id");
        QFilter qtype = new QFilter("periodtype", "=", (Object)periodtype);
        QFilter qids = new QFilter("id", ">=", (Object)curentPeriod);
        qids.and(new QFilter("id", "=", (Object)lastPeriod));
        return QueryServiceHelper.exists((String)"bd_period", (QFilter[])new QFilter[]{qtype, qids});
    }

    public static CodeRuleInfo getCodeRuleInfo(String orgId) {
        CodeRuleInfo codeRule = VoucherNumberUtils.getCodeRuleInfo(Long.parseLong(orgId), "B");
        if (codeRule == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u63d0\u4ea4\u51ed\u8bc1\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u524d\u5f80\u7f16\u7801\u89c4\u5219\u914d\u7f6e\u8bbe\u7f6e\u3002", (String)"BreakPointCommonUtil_0", (String)"fi-gl-common", (Object[])new Object[0]), orgId));
        }
        return codeRule;
    }
}

