/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.closeperiod.plugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.fcm.CheckContext;
import kd.bos.ext.fi.fcm.CheckResult;
import kd.bos.ext.fi.fcm.IClosePeriodCheckPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public abstract class AbstractNoticeCheckStatusCloseChecker
implements IClosePeriodCheckPlugin {
    private static Log logger = LogFactory.getLog(AbstractNoticeCheckStatusCloseChecker.class);

    public CheckResult execute(CheckContext context) throws Throwable {
        DynamicObject periodDyn;
        QFilter f1 = new QFilter("org", "=", (Object)context.getOrgId());
        QFilter f2 = new QFilter("booktype", "=", (Object)Long.valueOf(context.getSubBizAppId()));
        QFilter f3 = new QFilter("checkout", "!=", (Object)"1");
        QFilter f4 = new QFilter("checkstatus", "=", (Object)"0");
        try {
            periodDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)context.getPeriodId(), (String)"bd_period", (String)"begindate, enddate");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        QFilter dateFilter = QFilter.of((String)"bookeddate >= ? and bookeddate <= ?", (Object[])new Object[]{periodDyn.getDate("begindate"), periodDyn.getDate("enddate")});
        QFilter[] qFilters = new QFilter[]{f1, f2, f3, f4, dateFilter};
        return this.getCheckResult(qFilters);
    }

    public abstract CheckResult getCheckResult(QFilter[] var1);
}

