/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.closeperiod.plugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.ext.fi.fcm.CheckContext;
import kd.bos.ext.fi.fcm.CheckResult;
import kd.bos.ext.fi.fcm.IClosePeriodCheckPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.util.QFBuilder;

public class AccountTableRefCloseChecker
implements IClosePeriodCheckPlugin {
    public CheckResult execute(CheckContext context) throws Throwable {
        CheckResult checkResult = new CheckResult();
        checkResult.setIsSuccess(true);
        Long orgId = context.getOrgId();
        long bookTypeId = Long.parseLong(context.getSubBizAppId());
        AccountBookInfo accountBookInfo = AccSysUtil.getBookFromAccSys(orgId, bookTypeId);
        if (Objects.isNull(accountBookInfo)) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u8d26\u7c3f\u4e0d\u5b58\u5728\u3002", (String)"AccountTableRefCloseChecker_0", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        Long periodId = context.getPeriodId();
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "=", periodId);
        qfBuilder.add("isadjustperiod", "=", Boolean.TRUE);
        ArrayList<String> errorMsg = new ArrayList<String>(1);
        if (QueryServiceHelper.exists((String)"bd_period", (QFilter[])qfBuilder.toArray()) && this.checkIsLastAdjuestPeriod(periodId).booleanValue()) {
            qfBuilder.clear();
            qfBuilder.add("org", "=", orgId);
            qfBuilder.add("booktype", "=", bookTypeId);
            Map versionDOs = BusinessDataServiceHelper.loadFromCache((String)"gl_book_version", (QFilter[])qfBuilder.toArray());
            ArrayList versions = new ArrayList(versionDOs.values());
            List masterIds = null;
            for (DynamicObject version : versions) {
                long enablePeriod = version.getLong(GLField.id_("enableperiod"));
                if (enablePeriod != periodId) continue;
                qfBuilder.clear();
                qfBuilder.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accounttableref", (Long)orgId));
                qfBuilder.add("oldacttable", "=", version.getLong(GLField.id_("oldaccttab")));
                qfBuilder.add("newacttable", "=", version.getLong(GLField.id_("accounttable")));
                qfBuilder.add("enabledate", "=", version.getDate("enabledate"));
                masterIds = BusinessDataServiceHelper.loadFromCache((String)"bd_accounttableref", (String)"masterid", (QFilter[])qfBuilder.toArray()).values().stream().map(x -> x.getLong("masterid")).collect(Collectors.toList());
                break;
            }
            if (Objects.isNull(masterIds)) {
                qfBuilder.clear();
                qfBuilder.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accounttableref", (Long)orgId));
                qfBuilder.add("oldacttable", "=", AccSysUtil.getCurPeriodAccountTableId(orgId, bookTypeId, periodId));
                Date periodStartDate = context.getPeriodStartDate();
                Date periodEndDate = context.getPeriodEndDate();
                qfBuilder.add("enabledate", ">=", periodStartDate);
                qfBuilder.add("enabledate", "<=", periodEndDate);
                masterIds = BusinessDataServiceHelper.loadFromCache((String)"bd_accounttableref", (String)"masterid", (QFilter[])qfBuilder.toArray()).values().stream().map(x -> x.getLong("masterid")).collect(Collectors.toList());
            }
            if (CollectionUtils.isNotEmpty(masterIds)) {
                for (Long masterId : masterIds) {
                    qfBuilder.clear();
                    qfBuilder.add("org", "=", orgId);
                    qfBuilder.add("accountref.masterid", "=", masterId);
                    if (!QueryServiceHelper.exists((String)"bd_accttabref_record", (QFilter[])qfBuilder.toArray())) {
                        checkResult.setIsSuccess(false);
                        errorMsg.add(ResManager.loadKDString((String)"\u5f53\u671f\u5b58\u5728\u79d1\u76ee\u8868\u7248\u672c\u5316\u672a\u542f\u7528\u3002", (String)"AccountTableRefCloseChecker_1", (String)"fi-gl-common", (Object[])new Object[0]));
                        checkResult.setMessages(errorMsg);
                        return checkResult;
                    }
                    qfBuilder.add("enablestatus", "!=", Character.valueOf('C'));
                    if (!QueryServiceHelper.exists((String)"bd_accttabref_record", (QFilter[])qfBuilder.toArray())) continue;
                    checkResult.setIsSuccess(false);
                    errorMsg.add(ResManager.loadKDString((String)"\u5f53\u671f\u5b58\u5728\u79d1\u76ee\u8868\u7248\u672c\u5316\u672a\u542f\u7528\u3002", (String)"AccountTableRefCloseChecker_1", (String)"fi-gl-common", (Object[])new Object[0]));
                    checkResult.setMessages(errorMsg);
                    return checkResult;
                }
            }
        }
        errorMsg.add(ResManager.loadKDString((String)"\u5f53\u671f\u65e0\u9700\u542f\u7528\u3002", (String)"AccountTableRefCloseChecker_2", (String)"fi-gl-common", (Object[])new Object[0]));
        checkResult.setMessages(errorMsg);
        return checkResult;
    }

    private Boolean checkIsLastAdjuestPeriod(Long periodId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select 1 from t_bd_period a inner join t_bd_period b  ", new Object[0]);
        sqlBuilder.append(" on a.fperiodyear = b.fperiodyear and a.ftypeid = b.ftypeid ", new Object[0]);
        sqlBuilder.append(" where a.fisadjustperiod = ? ", new Object[]{"1"});
        sqlBuilder.append(" and b.fisadjustperiod = ? ", new Object[]{"1"});
        sqlBuilder.append(" and b.fperiodnumber > a.fperiodnumber ", new Object[0]);
        sqlBuilder.append(" and a.fid = ? ", new Object[]{periodId});
        DataSet dataSet = DB.queryDataSet((String)(this.getClass().getName() + "checkIsLastAdjuestPeriod"), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
        if (dataSet.hasNext()) {
            return false;
        }
        return true;
    }
}

