/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.closeperiod.plugin;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.ext.fi.fcm.CheckContext;
import kd.bos.ext.fi.fcm.CheckResult;
import kd.bos.ext.fi.fcm.IClosePeriodCheckPlugin;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfo;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterService;
import kd.bos.ext.fi.gl.dao.BookDAOFactory;
import kd.bos.ext.fi.gl.vo.BookVO;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.business.service.GLAccountBookService;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.closeperiod.ClosePeriodUtils;

public class BizSystemCloseChecker
implements IClosePeriodCheckPlugin {
    public CheckResult execute(CheckContext context) throws Throwable {
        CheckResult checkResult = new CheckResult();
        AccountBookInfo accountBook = AccSysUtil.getBookFromAccSys(context.getOrgId(), Long.parseLong(context.getSubBizAppId()));
        Long periodId = context.getPeriodId();
        DynamicObject periodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"isadjustperiod", (QFilter[])new QFilter("id", "=", (Object)periodId).toArray());
        ArrayList<String> errorMsg = new ArrayList<String>(5);
        if (accountBook != null && periodDyn != null && !periodDyn.getBoolean("isadjustperiod")) {
            Map bizBookMap = GLAccountBookService.queryAllBizAccountBook((long)accountBook.getId());
            for (Map.Entry entry : bizBookMap.entrySet()) {
                String app;
                BookRegisterInfo bookRegisterInfo;
                Map<Long, BookVO> relatedBooks;
                List relatedIds = (List)entry.getValue();
                if (relatedIds.isEmpty() || (relatedBooks = RelatedBookGetterFactory.getRelatedBookGetter(bookRegisterInfo = BookRegisterService.queryByBizApp((String)(app = (String)entry.getKey()))).getBooks(bookRegisterInfo, relatedIds)) == null || !relatedBooks.values().stream().anyMatch(x -> x != null && x.isEndInit() != false && ClosePeriodUtils.comparePeriod(x.getCurPeriodId(), periodId) <= 0)) continue;
                LocaleString name = EntityMetadataCache.getAppInfo((String)BizAppServiceHelp.getAppIdByAppNumber((String)app)).getName();
                String appName = name == null ? app : name.getLocaleValue();
                errorMsg.add(String.format(ResManager.loadKDString((String)"\u603b\u8d26\u8d26\u7c3f\u5173\u8054%1$s\u5f53\u524d\u671f\u95f4\u672a\u7ed3\u8d26\u3002", (String)"BizSystemCloseChecker_0", (String)"fi-gl-common", (Object[])new Object[0]), appName));
            }
        }
        if (errorMsg.isEmpty()) {
            checkResult.setIsSuccess(true);
        } else {
            checkResult.setMessages(errorMsg);
            checkResult.setIsSuccess(false);
        }
        return checkResult;
    }

    private static class RelatedBookGetter
    implements IRelatedBookGetter {
        private RelatedBookGetter() {
        }

        @Override
        public Map<Long, BookVO> getBooks(BookRegisterInfo bookRegisterInfo, List<Long> relatedIds) {
            String orgProp = bookRegisterInfo.getOrgFieldOnBookEntity();
            String bookTypeProp = bookRegisterInfo.getBookTypeFieldOnBookEntity();
            DynamicObject[] relatedBooks = BusinessDataServiceHelper.load((String)bookRegisterInfo.getBookEntityId(), (String)(orgProp + ".id," + bookTypeProp + ".id"), (QFilter[])new QFilter("id", "in", relatedIds).toArray());
            List orgIds = Arrays.stream(relatedBooks).map(x -> x.getLong(orgProp + ".id")).collect(Collectors.toList());
            HashMap<Long, BookVO> result = new HashMap<Long, BookVO>(relatedBooks.length);
            if (CollectionUtils.isEmpty(orgIds)) {
                return result;
            }
            Table bookTable = BookDAOFactory.getBookDAO((String)bookRegisterInfo.getBizApp()).query(bookRegisterInfo.getBizApp(), orgIds, null);
            for (DynamicObject relatedBook : relatedBooks) {
                BookVO bookVO = (BookVO)bookTable.get((Object)relatedBook.getLong(orgProp + ".id"), (Object)relatedBook.getLong(bookTypeProp + ".id"));
                if (bookVO == null) continue;
                result.put(relatedBook.getLong("id"), bookVO);
            }
            return result;
        }
    }

    private static class RelatedBookWithOutBookTypeGetter
    implements IRelatedBookGetter {
        private RelatedBookWithOutBookTypeGetter() {
        }

        @Override
        public Map<Long, BookVO> getBooks(BookRegisterInfo bookRegisterInfo, List<Long> relatedIds) {
            String orgProp = bookRegisterInfo.getOrgFieldOnBookEntity();
            DynamicObject[] relatedBooks = BusinessDataServiceHelper.load((String)bookRegisterInfo.getBookEntityId(), (String)(orgProp + ".id"), (QFilter[])new QFilter("id", "in", relatedIds).toArray());
            List orgIds = Arrays.stream(relatedBooks).map(x -> x.getLong(orgProp + ".id")).collect(Collectors.toList());
            HashMap<Long, BookVO> result = new HashMap<Long, BookVO>(relatedBooks.length);
            if (CollectionUtils.isEmpty(orgIds)) {
                return result;
            }
            Table bookTable = BookDAOFactory.getBookDAO((String)bookRegisterInfo.getBizApp()).query(bookRegisterInfo.getBizApp(), orgIds, null);
            for (DynamicObject relatedBook : relatedBooks) {
                BookVO bookVO = (BookVO)bookTable.get((Object)relatedBook.getLong(orgProp + ".id"), (Object)0L);
                if (bookVO == null) continue;
                result.put(relatedBook.getLong("id"), bookVO);
            }
            return result;
        }
    }

    private static class RelatedOrgBookGetter
    implements IRelatedBookGetter {
        private RelatedOrgBookGetter() {
        }

        @Override
        public Map<Long, BookVO> getBooks(BookRegisterInfo bookRegisterInfo, List<Long> relatedIds) {
            Table bookTable = BookDAOFactory.getBookDAO((String)bookRegisterInfo.getBizApp()).query(bookRegisterInfo.getBizApp(), relatedIds, null);
            return bookTable.values().stream().collect(Collectors.toMap(BookVO::getOrgId, x -> x, (o, n) -> n));
        }
    }

    private static interface IRelatedBookGetter {
        public Map<Long, BookVO> getBooks(BookRegisterInfo var1, List<Long> var2);
    }

    private static class RelatedBookGetterFactory {
        private RelatedBookGetterFactory() {
        }

        public static IRelatedBookGetter getRelatedBookGetter(BookRegisterInfo bookRegisterInfo) {
            if (StringUtils.isEmpty((String)bookRegisterInfo.getBookEntityId())) {
                return new RelatedOrgBookGetter();
            }
            if (StringUtils.isNotEmpty((String)bookRegisterInfo.getBookTypeFieldOnBookEntity())) {
                return new RelatedBookGetter();
            }
            return new RelatedBookWithOutBookTypeGetter();
        }
    }
}

