/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.comassist;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.Row;
import kd.fi.gl.comassist.model.ComAssistTable;

public class CommonDimensionValue {
    public final long org;
    public final long bookType;
    public final long[] commonAssists;

    public static CommonDimensionValue createOnlyBalanced(Long org, Long bookType, Row row) {
        List<String> maxCommonAssistKeys = ComAssistTable.getMaxCommonAssistKeys();
        long[] commonAssists = new long[maxCommonAssistKeys.size()];
        for (int i = 0; i < commonAssists.length; ++i) {
            commonAssists[i] = row.getLong(maxCommonAssistKeys.get(i));
        }
        return new CommonDimensionValue(org, bookType, commonAssists, true);
    }

    private CommonDimensionValue(long org, long bookType, long[] allCommonAssists, boolean onlyBalanced) {
        this.org = org;
        this.bookType = bookType;
        List<String> maxCommonAssistKeys = ComAssistTable.getMaxCommonAssistKeys();
        if (allCommonAssists.length != maxCommonAssistKeys.size()) {
            throw new IllegalStateException("length match failed.");
        }
        if (onlyBalanced) {
            this.commonAssists = new long[allCommonAssists.length];
            ComAssistTable.get(org, bookType).ifPresent(commonAssistTable -> {
                for (int i = 0; i < maxCommonAssistKeys.size(); ++i) {
                    Boolean isBalanced = commonAssistTable.getCommonAssist((String)maxCommonAssistKeys.get(i)).map(commonAssist -> commonAssist.isBalanced).orElse(false);
                    this.commonAssists[i] = isBalanced != false ? allCommonAssists[i] : 0L;
                }
            });
        } else {
            this.commonAssists = allCommonAssists;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonDimensionValue that = (CommonDimensionValue)o;
        return this.org == that.org && this.bookType == that.bookType && Arrays.equals(this.commonAssists, that.commonAssists);
    }

    public int hashCode() {
        int result = Objects.hash(this.org, this.bookType);
        result = 31 * result + Arrays.hashCode(this.commonAssists);
        return result;
    }
}

