/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.common;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.business.service.voucher.mc.MulLocalConfig;
import kd.fi.gl.business.service.voucher.writeoff.WriteOffService;
import kd.fi.gl.business.vo.voucher.AmountField;
import kd.fi.gl.cache.CacheKey;
import kd.fi.gl.cache.CacheKeyPrefix;
import kd.fi.gl.common.VoucherOpOption;
import kd.fi.gl.common.WriteOffBalance;
import kd.fi.gl.enums.WriteOffTypeEnum;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.voucher.vo.DynamicVoucher;
import kd.fi.gl.voucher.writeoff.DynamicWriteOffVoucher;
import kd.fi.gl.voucher.writeoff.WriteOffBalanceMap;
import kd.fi.gl.voucher.writeoff.WriteOffEntry;

public class VoucherAgainst {
    public static final String REVERSE_RELATION = "gl_reverserelation";
    public static final String SOURCE_ENTITY_ID = "srcentity";
    public static final String AGAINST_VOUCHER_ID = "targentity";
    public static final String AGAINSTTYPE = "againsttype";
    private static final int BATCHSIZE = 5000;

    @Deprecated
    public static void against(IFormView view) {
        String str;
        DynamicObject loadSingle;
        Object voucherid = view instanceof IListView ? ((IListView)view).getSelectedRows().getPrimaryKeyValues()[0] : view.getModel().getDataEntity().getPkValue();
        try {
            loadSingle = BusinessDataServiceHelper.loadSingle((Object)voucherid, (String)"gl_voucher");
        }
        catch (RuntimeException e) {
            return;
        }
        int vn = loadSingle.getDynamicObject("period").getInt("periodyear");
        DynamicObject cuPeriod = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"curperiod.periodyear periodyear", (QFilter[])new QFilter("id", "=", loadSingle.get("book.id")).toArray());
        int bn = cuPeriod.getInt("periodyear");
        if (vn != bn) {
            DynamicObjectCollection entries = loadSingle.getDynamicObjectCollection("entries");
            for (DynamicObject entry : entries) {
                long accounttypeid = entry.getDynamicObject("account").getDynamicObject("accounttype").getLong("id");
                DynamicObject accounttype = BusinessDataServiceHelper.loadSingle((Object)accounttypeid, (String)"bd_accounttype");
                if (accounttype == null || !"4".equals(accounttype.getString("accounttype"))) continue;
                view.showTipNotification(ResManager.loadKDString((String)"\u635f\u76ca\u7c7b\u79d1\u76ee\u4e0d\u5141\u8bb8\u8de8\u5e74\u51b2\u9500\uff0c\u5efa\u8bae\u901a\u8fc7\u201c\u4ee5\u524d\u5e74\u5ea6\u635f\u76ca\u8c03\u6574\u201d\u79d1\u76ee\u505a\u8c03\u6574\u51ed\u8bc1\u3002", (String)"VoucherAgainst_1", (String)"fi-gl-common", (Object[])new Object[0]));
                return;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(str = VoucherAgainst.judgeBalance(loadSingle)))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u51ed\u8bc1\u672a\u51b2\u9500\u91d1\u989d\u4e3a\u96f6\u6216\u4e3a\u8d1f\uff0c\u4e0d\u53ef\u8fdb\u884c\u51b2\u9500\u3002", (String)"VoucherAgainst_2", (String)"fi-gl-common", (Object[])new Object[0]));
            return;
        }
        BillShowParameter show = new BillShowParameter();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("voucheragainst", "true");
        map.put("voucherid", voucherid);
        show.setCustomParams(map);
        show.setFormId("gl_voucher");
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        show.setBillStatus(BillOperationStatus.ADDNEW);
        view.showForm((FormShowParameter)show);
    }

    public static void openVoucher(IFormView view, Collection<Object> voucherIds) {
        List<Long> targetVocuhers = VoucherAgainst.getTargetVocuhers(voucherIds);
        if (targetVocuhers.size() == 1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("gl_voucher");
            showParameter.setPkId((Object)targetVocuhers.get(0));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setBillStatus(BillOperationStatus.EDIT);
            showParameter.setStatus(OperationStatus.EDIT);
            view.showForm((FormShowParameter)showParameter);
        } else if (targetVocuhers.size() > 1) {
            ListShowParameter list = new ListShowParameter();
            list.setBillFormId("gl_voucher");
            list.setFormId("bos_list");
            list.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            list.getOpenStyle().setTargetKey("tabap");
            targetVocuhers.forEach(arg_0 -> ((ListShowParameter)list).addLinkQueryPkId(arg_0));
            view.showForm((FormShowParameter)list);
        }
    }

    public static List<Long> getTargetVocuhers(Collection<Object> srcVoucherIds) {
        ArrayList<Long> targetVoucherIds = new ArrayList<Long>(srcVoucherIds.size());
        SqlBuilder sqlBuilder = new SqlBuilder().appendIn("SELECT FSRCENTITYID, MAX(FTARGENTITYID) LATESTVOUCHERID FROM t_gl_reverserelation WHERE FISEFFECTIVE = '1'AND FSRCENTITYID", srcVoucherIds.toArray()).append(" GROUP BY FSRCENTITYID", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"VoucherAgainst#getTargetVouchers", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
            dataSet.forEachRemaining(row -> targetVoucherIds.add(row.getLong("LATESTVOUCHERID")));
        }
        return targetVoucherIds;
    }

    @Deprecated
    public static boolean exist(long sourceId, String type) {
        QFilter[] qf = new QFilter[]{new QFilter(SOURCE_ENTITY_ID, "=", (Object)sourceId), new QFilter(AGAINSTTYPE, "=", (Object)type)};
        return QueryServiceHelper.exists((String)REVERSE_RELATION, (QFilter[])qf);
    }

    public static String judgeBalance(DynamicObject srcVchDyn) {
        Map<Integer, WriteOffBalance> writeOffBalance = VoucherAgainst.getWriteOffBalance(srcVchDyn, null);
        boolean canReverse = writeOffBalance.values().stream().anyMatch(WriteOffBalance::hasRemaining);
        if (!canReverse) {
            return ResManager.loadKDString((String)"\u8be5\u51ed\u8bc1\u672a\u51b2\u9500\u91d1\u989d\u4e3a\u96f6\u6216\u4e3a\u8d1f\uff0c\u4e0d\u53ef\u8fdb\u884c\u51b2\u9500\u3002", (String)"VoucherAgainst_2", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        return "";
    }

    public static Map<Long, Map<Integer, WriteOffBalance>> judgeBalanceBatch(Map<Long, DynamicObject> srcVchDyn, Collection<Long> excludeTargetIds) {
        Map<Long, WriteOffBalanceMap> sourceVoucherBalances = WriteOffService.querySourceVoucherBalances(srcVchDyn.keySet(), new QFilter(AGAINST_VOUCHER_ID, "not in", excludeTargetIds).toArray(), MulLocalConfig.getEnabledAmountFields());
        return sourceVoucherBalances.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> ((WriteOffBalanceMap)x.getValue()).getEntrySeqValueMap()));
    }

    @Deprecated
    public static String judgeBalance(DynamicObject loadSingle, Object revPK) {
        WriteOffBalance next;
        Map<Integer, WriteOffBalance> calculateAmount;
        QFilter qf = null;
        if (StringUtils.isNotBlank((Object)revPK)) {
            qf = new QFilter(AGAINST_VOUCHER_ID, "!=", revPK);
        }
        if ((calculateAmount = VoucherAgainst.getWriteOffBalance(loadSingle, qf == null ? null : qf.toArray())).size() > 0 && !(next = calculateAmount.values().iterator().next()).hasRemainingLocal()) {
            return ResManager.loadKDString((String)"\u8be5\u51ed\u8bc1\u672a\u51b2\u9500\u91d1\u989d\u4e3a\u96f6\u6216\u4e3a\u8d1f\uff0c\u4e0d\u53ef\u8fdb\u884c\u51b2\u9500\u3002", (String)"VoucherAgainst_2", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        return "";
    }

    public static String saveValidator(DynamicObject reverseVoucher, boolean isSave) {
        Map srcVchDyn;
        DynamicObject voucher = isSave ? (!CollectionUtils.isEmpty((Map)(srcVchDyn = (Map)ThreadCache.get((Object)CacheKey.getCacheKey(CacheKeyPrefix.REVERSEVOU_DYN, new Object[0]).toString()))) ? (DynamicObject)srcVchDyn.get(reverseVoucher.getLong("sourcebill")) : BusinessDataServiceHelper.loadSingle((Object)reverseVoucher.get("sourcebill"), (String)"gl_voucher")) : BusinessDataServiceHelper.loadSingle((Object)reverseVoucher.get("sourcebill"), (String)"gl_voucher");
        DynamicObjectCollection sourceEntries = voucher.getDynamicObjectCollection("entries");
        if (!VoucherOpOption.isEditAction() || Objects.isNull(reverseVoucher.getDataEntityType().getProperties().get((Object)"entries")) || reverseVoucher.getDataEntityState().getFromDatabase() && sourceEntries.size() > 5000) {
            reverseVoucher = BusinessDataServiceHelper.loadSingle((Object)reverseVoucher.getLong("id"), (String)"gl_voucher");
        }
        if (reverseVoucher.getDate("bookeddate").compareTo(voucher.getDate("bookeddate")) < 0) {
            return ResManager.loadKDString((String)"\u51b2\u9500\u51ed\u8bc1\u8bb0\u8d26\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u6e90\u51ed\u8bc1\u8bb0\u8d26\u65e5\u671f\u3002", (String)"VoucherAgainst_13", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        DynamicWriteOffVoucher writeOffVoucher = new DynamicWriteOffVoucher(reverseVoucher, new DynamicVoucher(voucher));
        Map<Long, ThreeTuple<BigDecimal, BigDecimal, Set<Long>>> accurentVchIdSet = VoucherAgainst.getOriVchWriteOffBal(voucher);
        int index = 0;
        long orgId = reverseVoucher.getLong("org.id");
        long bookTypeId = reverseVoucher.getLong("booktype.id");
        AmountField[] localAmountFields = MulLocalConfig.getEnabledLocalAmountFields(orgId, bookTypeId);
        for (DynamicObject sourceEntry : sourceEntries) {
            DynamicObject mappingEntry = writeOffVoucher.findMappingEntry(sourceEntry).orElse(null);
            if (mappingEntry == null) continue;
            ThreeTuple<BigDecimal, BigDecimal, Set<Long>> tuple = accurentVchIdSet.get(sourceEntry.getLong("id"));
            BigDecimal amountbalfor = Objects.isNull(tuple) ? null : (BigDecimal)tuple.item1;
            BigDecimal amountbal = Objects.isNull(tuple) ? null : (BigDecimal)tuple.item2;
            BigDecimal oriamount = mappingEntry.getBigDecimal("debitori").abs().compareTo(BigDecimal.ZERO) == 0 ? mappingEntry.getBigDecimal("creditori").abs() : mappingEntry.getBigDecimal("debitori").abs();
            int seq = index + 1;
            if (!isSave && (Objects.nonNull(amountbalfor) && oriamount.compareTo(amountbalfor.abs()) > 0 || Objects.nonNull(amountbal) && (mappingEntry.getBigDecimal("debitlocal").abs().compareTo(amountbal.abs()) > 0 || mappingEntry.getBigDecimal("creditlocal").abs().compareTo(amountbal.abs()) > 0)) && !((Set)tuple.item3).contains(mappingEntry.getLong("id"))) {
                return String.format(ResManager.loadKDString((String)"\u51ed\u8bc1%1$s\u51b2\u9500\u5931\u8d25\uff0c\u7b2c%2$s\u884c\u51b2\u9500\u91d1\u989d\u4e0d\u5f97\u5927\u4e8e\u5f80\u6765\u8d26\u7684\u672a\u6838\u9500\u4f59\u989d\u3002", (String)"VoucherAgainst_14", (String)"fi-gl-common", (Object[])new Object[0]), voucher.getString("billno"), seq);
            }
            WriteOffTypeEnum type = WriteOffTypeEnum.get(reverseVoucher.getString(AGAINSTTYPE));
            Optional<String> error = type.validate(sourceEntry, mappingEntry, localAmountFields);
            if (error.isPresent()) {
                return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c%2$s", (String)"VoucherAgainst_15", (String)GLApp.instance.commonModule(), (Object[])new Object[0]), seq, error.get());
            }
            ++index;
        }
        Optional<String> isCanRev = VoucherAgainst.judgeBalanceIsZero(writeOffVoucher, isSave, localAmountFields);
        return isCanRev.orElse("");
    }

    private static Map<Long, ThreeTuple<BigDecimal, BigDecimal, Set<Long>>> getOriVchWriteOffBal(DynamicObject voucher) {
        HashMap<Long, ThreeTuple<BigDecimal, BigDecimal, Set<Long>>> accurentVchIdSet = new HashMap<Long, ThreeTuple<BigDecimal, BigDecimal, Set<Long>>>(voucher.getDynamicObjectCollection("entries").size());
        QFilter fentryId = new QFilter("voucherid", "=", (Object)voucher.getLong("id"));
        QFilter fstatus = new QFilter("status", "!=", (Object)"0");
        DynamicObjectCollection acccurent = QueryServiceHelper.query((String)"gl_acccurrent", (String)"id,voucherid,voucherentry,amountbalfor,amountbal", (QFilter[])new QFilter[]{fentryId, fstatus});
        Set<Long> accCurrentIds = acccurent.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        Set<Long> allAccCurrentIds = VoucherAgainst.getAllVchEntryId("buyerentry", accCurrentIds);
        allAccCurrentIds.addAll(VoucherAgainst.getAllVchEntryId("writeoffentry", accCurrentIds));
        DynamicObjectCollection allAcccurent = QueryServiceHelper.query((String)"gl_acccurrent", (String)"id,voucherid,voucherentry,amountbalfor,amountbal", (QFilter[])new QFilter("id", "in", allAccCurrentIds).toArray());
        Set allVchEntryIds = allAcccurent.stream().map(v -> v.getLong("voucherentry")).collect(Collectors.toSet());
        for (DynamicObject dyn : acccurent) {
            long voucherentry = dyn.getLong("voucherentry");
            BigDecimal amountbalfor = dyn.getBigDecimal("amountbalfor");
            BigDecimal amountbal = dyn.getBigDecimal("amountbal");
            accurentVchIdSet.put(voucherentry, (ThreeTuple<BigDecimal, BigDecimal, Set<Long>>)new ThreeTuple((Object)amountbalfor, (Object)amountbal, allVchEntryIds));
        }
        return accurentVchIdSet;
    }

    private static Set<Long> getAllVchEntryId(String filedName, Set<Long> accCurrentIds) {
        QFilter faccCCurrentids = new QFilter(filedName, "in", accCurrentIds);
        DynamicObjectCollection entryDyns = QueryServiceHelper.query((String)"gl_reciprocal_log", (String)"buyerentry,writeoffentry", (QFilter[])faccCCurrentids.toArray());
        return entryDyns.stream().flatMap(v -> Stream.of(v.getLong("buyerentry"), v.getLong("writeoffentry"))).collect(Collectors.toSet());
    }

    public static Map<Integer, WriteOffBalance> getWriteOffBalance(DynamicObject sourceVoucher, QFilter[] filters) {
        long id = sourceVoucher.getLong("id");
        return VoucherAgainst.getWriteOffBalance(id, filters);
    }

    public static Map<Integer, WriteOffBalance> getWriteOffBalance(long sourceVoucherId, QFilter[] filters) {
        WriteOffBalanceMap sourceBalance = WriteOffService.querySourceVoucherBalances(Collections.singletonList(sourceVoucherId), filters, MulLocalConfig.getEnabledAmountFields()).get(sourceVoucherId);
        return sourceBalance == null ? Collections.emptyMap() : sourceBalance.getEntrySeqValueMap();
    }

    @Deprecated
    public static Map<Integer, List<Object>> calculateAmount(DynamicObject srcVchDyn, QFilter[] qFilters) {
        return new HashMap<Integer, List<Object>>();
    }

    private static Optional<String> judgeBalanceIsZero(DynamicWriteOffVoucher writeOffVoucher, boolean isSave, AmountField ... amountFields) {
        Map map;
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{new QFilter(AGAINST_VOUCHER_ID, "!=", (Object)writeOffVoucher.getId())});
        Map<Integer, WriteOffBalance> writeOffBalance = isSave ? (!CollectionUtils.isEmpty((Map)(map = (Map)ThreadCache.get((Object)CacheKey.getCacheKey(CacheKeyPrefix.REVERSE_INFO, new Object[0]).toString()))) ? (Map<Integer, WriteOffBalance>)map.get(writeOffVoucher.getSourceVoucherId()) : VoucherAgainst.getWriteOffBalance(writeOffVoucher.getSourceVoucherId(), filters.toArray(new QFilter[0]))) : VoucherAgainst.getWriteOffBalance(writeOffVoucher.getSourceVoucherId(), filters.toArray(new QFilter[0]));
        WriteOffEntry writeOffEntry = new WriteOffEntry();
        for (DynamicObject mappingEntry : writeOffVoucher.getEntries()) {
            DynamicObject sourceEntry = writeOffVoucher.findSourceEntry(mappingEntry).orElse(null);
            if (sourceEntry == null) continue;
            WriteOffBalance rowBal = writeOffBalance.get(sourceEntry.getInt("seq"));
            writeOffEntry.setDc(mappingEntry.getString("entrydc"));
            writeOffEntry.resetQuantity(mappingEntry.getBigDecimal("quantity"));
            writeOffEntry.resetAmount(AmountField.LOCAL, mappingEntry.getBigDecimal("debitlocal"), mappingEntry.getBigDecimal("creditlocal"));
            writeOffEntry.resetAmount(AmountField.ORIGINAL, mappingEntry.getBigDecimal("debitori"), mappingEntry.getBigDecimal("creditori"));
            if (amountFields != null) {
                for (AmountField amountField : amountFields) {
                    writeOffEntry.resetAmount(amountField, mappingEntry.getBigDecimal(amountField.getDebitField()), mappingEntry.getBigDecimal(amountField.getCreditField()));
                }
            }
            rowBal.addWriteOffEntry(writeOffEntry);
            writeOffEntry.reset();
            int seq = mappingEntry.getInt("seq");
            if (rowBal.isLocalBalanceBeyond()) {
                return Optional.of(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u51b2\u9500\u51ed\u8bc1\u672c\u4f4d\u5e01\u91d1\u989d\u8d85\u8fc7\u672a\u51b2\u9500\u91d1\u989d\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539\u3002", (String)"VoucherAgainst_12", (String)"fi-gl-common", (Object[])new Object[0]), seq));
            }
            if (rowBal.isOriginalBalanceBeyond()) {
                return Optional.of(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u51b2\u9500\u51ed\u8bc1\u539f\u5e01\u91d1\u989d\u8d85\u8fc7\u672a\u51b2\u9500\u91d1\u989d\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539\u3002", (String)"VoucherAgainst_16", (String)"fi-gl-common", (Object[])new Object[0]), seq));
            }
            if (rowBal.isQuantityBalanceBeyond()) {
                return Optional.of(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u51b2\u9500\u51ed\u8bc1\u6570\u91cf\u8d85\u8fc7\u672a\u51b2\u9500\u6570\u91cf\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539\u3002", (String)"VoucherAgainst_17", (String)"fi-gl-common", (Object[])new Object[0]), seq));
            }
            if (amountFields == null) continue;
            for (AmountField amountField : amountFields) {
                if (!rowBal.getAmountBalance(amountField).isBeyond()) continue;
                return Optional.of(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u51b2\u9500\u51ed\u8bc1%2$s\u91d1\u989d\u8d85\u8fc7\u672a\u51b2\u91d1\u989d\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539\u3002", (String)"VoucherAgainst_18", (String)"fi-gl-common", (Object[])new Object[]{seq, amountField.getCurrencyField().getDesc()}));
            }
        }
        return Optional.empty();
    }
}

