/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.enums;

import kd.bos.dataentity.utils.StringUtils;

public enum AutoTransAmtTypeEnum {
    NONE_VALUE(0),
    TRANS_INTO_VALUE(1),
    TRANS_OUT_ENDBAL_BY_RATE_VALUE(2),
    TRANS_OUT_DEBIT_BY_RATE_VALUE(3),
    TRANS_OUT_CREDIT_BY_RATE_VALUE(4),
    TRANS_OUT_FORMULA_VALUE(5),
    TRANS_IN_FORMULA_VALUE(6),
    TRANS_IN_REMAIN_VALUE(7),
    TRANS_OUT_RPT_VALUE(8),
    TRANS_IN_RPT_VALUE(9),
    TRANS_OUT_EXCEL_VALUE(10),
    TRANS_IN_EXCEL_VALUE(11),
    TRANS_IN_BCM_FORMULA(12),
    TRANS_OUT_BCM_FORMULA(13);

    private final int value;

    private AutoTransAmtTypeEnum(int value) {
        this.value = value;
    }

    public static AutoTransAmtTypeEnum valueOfHash(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return NONE_VALUE;
        }
        switch (Integer.parseInt(value)) {
            case 1: {
                return TRANS_INTO_VALUE;
            }
            case 2: {
                return TRANS_OUT_ENDBAL_BY_RATE_VALUE;
            }
            case 3: {
                return TRANS_OUT_DEBIT_BY_RATE_VALUE;
            }
            case 4: {
                return TRANS_OUT_CREDIT_BY_RATE_VALUE;
            }
            case 5: {
                return TRANS_OUT_FORMULA_VALUE;
            }
            case 6: {
                return TRANS_IN_FORMULA_VALUE;
            }
            case 7: {
                return TRANS_IN_REMAIN_VALUE;
            }
            case 8: {
                return TRANS_OUT_RPT_VALUE;
            }
            case 9: {
                return TRANS_IN_RPT_VALUE;
            }
            case 10: {
                return TRANS_OUT_EXCEL_VALUE;
            }
            case 11: {
                return TRANS_IN_EXCEL_VALUE;
            }
            case 12: {
                return TRANS_IN_BCM_FORMULA;
            }
            case 13: {
                return TRANS_OUT_BCM_FORMULA;
            }
        }
        return NONE_VALUE;
    }

    public boolean valueEquals(AutoTransAmtTypeEnum obj) {
        if (obj == null) {
            return false;
        }
        return this.value == obj.value;
    }

    public static boolean checkIfFormulaKind(AutoTransAmtTypeEnum amtType) {
        return amtType.value > AutoTransAmtTypeEnum.TRANS_OUT_CREDIT_BY_RATE_VALUE.value && amtType != TRANS_IN_REMAIN_VALUE;
    }

    public static boolean checkIfBalanceKind(AutoTransAmtTypeEnum amtType) {
        return amtType.value >= AutoTransAmtTypeEnum.TRANS_OUT_ENDBAL_BY_RATE_VALUE.value && amtType.value <= AutoTransAmtTypeEnum.TRANS_OUT_CREDIT_BY_RATE_VALUE.value;
    }
}

