/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocess.info;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.fi.gl.finalprocess.info.AmountInfo;
import kd.fi.gl.finalprocess.info.BalanceInfo;

public class DimensionSumBalacneInfo {
    private Map<String, BalanceInfo> balances;

    public DimensionSumBalacneInfo() {
        this.setBalances(new HashMap<String, BalanceInfo>());
    }

    public final void update(AmountInfo amount, Function<AmountInfo, String> sumFunction) {
        String key = sumFunction.apply(amount);
        this.update(amount, key);
    }

    public final void update(AmountInfo amount, String key) {
        this.getBalances().compute(key, (k, v) -> {
            if (v == null) {
                v = new BalanceInfo();
            }
            v.update(amount);
            return v;
        });
    }

    public final BalanceInfo getSumVal(Function<String, Boolean> compareFunction) {
        BalanceInfo result = new BalanceInfo();
        this.getBalances().entrySet().stream().filter(x -> (Boolean)compareFunction.apply((String)x.getKey())).forEach(x -> result.sum((BalanceInfo)x.getValue()));
        return result;
    }

    public final Map<String, BalanceInfo> getMatchVals(Function<String, Boolean> compareFunction) {
        return this.getBalances().entrySet().stream().filter(x -> (Boolean)compareFunction.apply((String)x.getKey())).collect(Collectors.toMap(x -> (String)x.getKey(), x -> (BalanceInfo)x.getValue()));
    }

    public final Map<String, BalanceInfo> getBalances() {
        return this.balances;
    }

    public final void setBalances(Map<String, BalanceInfo> balances) {
        this.balances = balances;
    }
}

