/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocess.info;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.util.QFBuilder;

public class ExpressionInfo {
    private String rowId;
    public static final String EXP_SEPARATOR = ",";
    public static final String ASSGRP__SEPARATOR = "|";
    public static final String VALUE_SEPARATOR = ";";
    public static final String TYPE_VALUE_SEPARATOR = ":";
    public static final String NULL = "null";
    private final String[] itemOrder = new String[]{"accountNum", "assgrp", "currencyNum", "unitNum", "qty", "amountType", "periodRange"};
    private final Map<String, String> expression = new HashMap<String, String>();
    private int normLength = 7;
    private String comAssistPre = "comAssistGroup";

    public ExpressionInfo() {
    }

    public ExpressionInfo(String exp) {
        this(exp, false);
    }

    public ExpressionInfo(String exp, boolean containsComAssist) {
        this.initNormExp(exp, containsComAssist);
    }

    public ExpressionInfo(DynamicObject formula, Map<Long, String> assistNameMap) {
        this(formula, assistNameMap, Collections.emptyList(), Collections.emptyList());
    }

    public ExpressionInfo(DynamicObject formula, Map<Long, String> assistNameMap, List<CommonAssist> commonAssists, List<Map<Long, String>> collectedComAssistVal) {
        this.initDynExp(formula, assistNameMap, commonAssists, collectedComAssistVal);
    }

    public final void initDynExp(DynamicObject formula, Map<Long, String> assistNameMap, List<CommonAssist> commonAssists, List<Map<Long, String>> collectedComAssistVal) {
        if (!this.expression.isEmpty() || formula == null) {
            return;
        }
        this.rowId = formula.getString("autorowid");
        this.expression.put("accountNum", formula.getString("account.number"));
        this.expression.put("assgrp", assistNameMap.get(formula.getLong("assgrp_id")));
        this.expression.put("currencyNum", formula.getString("currency.number"));
        this.expression.put("unitNum", formula.getString("unit.number"));
        this.expression.put("qty", String.valueOf(formula.getInt("qty")));
        this.expression.put("amountType", formula.getString("amounttype"));
        this.expression.put("periodRange", StringUtils.isEmpty((CharSequence)formula.getString("periodrange")) ? "0" : formula.getString("periodrange"));
        if (!commonAssists.isEmpty()) {
            for (int i = 1; i <= commonAssists.size(); ++i) {
                List comAssistValues = formula.getDynamicObjectCollection("comassist" + i).stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toList());
                Map<Long, String> comAssistIdToNum = collectedComAssistVal.get(i - 1);
                String comAssistNum = comAssistValues.stream().map(id -> comAssistIdToNum.getOrDefault(id, NULL)).collect(Collectors.joining(VALUE_SEPARATOR));
                this.expression.put(this.comAssistPre + i, commonAssists.get(i - 1).getName() + TYPE_VALUE_SEPARATOR + comAssistNum);
            }
        }
    }

    public final void initNormExp(String exp, boolean containsComAssist) {
        int i;
        if (exp == null || !this.expression.isEmpty()) {
            return;
        }
        String[] split = exp.split(EXP_SEPARATOR);
        int minLength = Math.min(split.length, this.normLength);
        for (i = 0; i < minLength; ++i) {
            this.expression.put(this.itemOrder[i], split[i]);
        }
        if (containsComAssist) {
            for (i = 1; i <= split.length - this.normLength; ++i) {
                this.expression.put(this.comAssistPre + i, split[i - 1 + this.normLength]);
            }
        }
    }

    public String getComAssistGroup(int idx) {
        return this.expression.getOrDefault("comAssistGroup" + idx, "");
    }

    public String getAccountNum() {
        return this.expression.getOrDefault("accountNum", "");
    }

    public String getAssgrp() {
        return this.expression.getOrDefault("assgrp", "");
    }

    public String getCurrencyNum() {
        return this.expression.getOrDefault("currencyNum", "");
    }

    public String getUnitNum() {
        return this.expression.getOrDefault("unitNum", "");
    }

    public String getQty() {
        return this.expression.getOrDefault("qty", "");
    }

    public String getPeriodRange() {
        return this.expression.getOrDefault("periodRange", "0");
    }

    public String getAmountType() {
        return this.expression.getOrDefault("amountType", "");
    }

    public int getNormLength() {
        return this.normLength;
    }

    public String getRowId() {
        return this.rowId;
    }

    public void fillExpComAssist(DynamicObject autoExpEntity, List<CommonAssist> commonAssists) {
        if (this.expression.size() != this.normLength + commonAssists.size()) {
            return;
        }
        for (int i = 1; i <= commonAssists.size(); ++i) {
            String comAssistValue = this.expression.get(this.comAssistPre + i);
            CommonAssist commonAssist = commonAssists.get(i - 1);
            String comAssistKey = "comassist" + i;
            if (NULL.equals(comAssistValue) || comAssistValue.split(TYPE_VALUE_SEPARATOR).length != 2) continue;
            String[] comAssist1Split = comAssistValue.split(TYPE_VALUE_SEPARATOR);
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(new QFilter("number", "in", (Object)comAssist1Split[1].split(VALUE_SEPARATOR)));
            if (AssistValueType.isAssistData(commonAssist.valueSourceType)) {
                qfBuilder.add(new QFilter("group", "=", (Object)commonAssist.assistType));
            }
            if (AssistValueType.isManualTxt(commonAssist.valueSourceType)) {
                autoExpEntity.set(comAssistKey, (Object)comAssistValue);
            }
            DataSet comAssistDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.formplugin.AutoTransEditPlugin.dealComAssist", (String)commonAssist.valueSource, (String)"id", (QFilter[])qfBuilder.toArray(), null);
            ArrayList<Object> res = new ArrayList<Object>();
            for (Row row : comAssistDataSet) {
                res.add(row.getLong("id"));
            }
            this.comAssistToDyn(comAssistKey, autoExpEntity, res);
        }
    }

    private void comAssistToDyn(String comAssistKey, DynamicObject autoExpEntity, List<Object> values) {
        for (Object value : values) {
            DynamicObjectCollection comAssist = autoExpEntity.getDynamicObjectCollection(comAssistKey);
            DynamicObject mulBaseRow = new DynamicObject(comAssist.getDynamicObjectType());
            mulBaseRow.set("fbasedataid", value);
            comAssist.add((Object)mulBaseRow);
        }
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (String s : this.itemOrder) {
            res.append(this.expression.get(s)).append(EXP_SEPARATOR);
        }
        if (this.expression.size() > this.normLength) {
            for (int i = 1; i <= this.expression.size() - this.normLength; ++i) {
                res.append(this.expression.get(this.comAssistPre + i)).append(EXP_SEPARATOR);
            }
        }
        return res.substring(0, res.toString().length() - 1);
    }
}

