/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocess.merge;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.gl.bean.EntryFieldInfo;
import kd.fi.gl.bean.GlVoucherField;
import kd.fi.gl.finalprocess.VoucherEntryDBHelper;
import kd.fi.gl.finalprocess.merge.EntryMergeOption;

public class VoucherEntryDSMergeHelper {
    private static final int BATCH_SIZE = 10000;
    private static final int BATCH_SIZE_MIN = 1;
    private EntryMergeOption entryMergeOption;
    private long lastUnMergedId = 0L;
    private long currentUnMergedId = 0L;
    private long currentMergedId = 0L;
    private Set<Object> mergedIds = new HashSet<Object>(16);
    private EntryGroup lastEntryGroupCache = null;
    private EntryGroup currentEntryGroup = EntryGroup.create();
    private LinkedHashMap<EntryMergeKey, EntryMergeValue> entriesCache = new LinkedHashMap(10000);
    private Map<Long, DynamicObject> currencyMap = new HashMap<Long, DynamicObject>(8);
    private int seq = 1;
    private Long id = 0L;
    private static GlVoucherField glVoucherField;
    private static final Log logger;

    public static VoucherEntryDSMergeHelper create() {
        return new VoucherEntryDSMergeHelper();
    }

    public VoucherEntryDSMergeHelper init(EntryMergeOption entryMergeOption, GlVoucherField glVoucherField) {
        this.entryMergeOption = entryMergeOption;
        VoucherEntryDSMergeHelper.glVoucherField = glVoucherField;
        return this;
    }

    public Map<Long, Long> merge(Set<Object> destVids) {
        HashMap<Long, Long> mergedDestVidMap = new HashMap<Long, Long>(destVids.size());
        Iterator<Long> mergedVoucherIDItr = this.genVids(destVids.size());
        logger.info("destVids: {}", destVids);
        DataSet sortedEntries = VoucherEntryDBHelper.querySortedEntries(destVids, glVoucherField);
        try {
            while (sortedEntries.hasNext()) {
                Tuple<Long, Long> destVidAndMergedDestVid = this.mergeByRow(sortedEntries.next(), mergedVoucherIDItr);
                if (destVidAndMergedDestVid == null) continue;
                mergedDestVidMap.put((Long)destVidAndMergedDestVid.item1, (Long)destVidAndMergedDestVid.item2);
            }
            this.saveEntriesFromCache(1);
        }
        catch (Exception e) {
            logger.error("VoucherEntryDSMergeHelper.merge error: ", (Throwable)e);
            this.deleteEntriesMergedInException();
            throw e;
        }
        this.clearEntriesUnMerged(destVids);
        return mergedDestVidMap;
    }

    private Tuple<Long, Long> mergeByRow(Row entry, Iterator<Long> mergedVoucherIDItr) {
        Tuple destVidAndMergedDestVid = null;
        Long vid = entry.getLong("fid");
        if (!this.checkSameVoucher(vid)) {
            this.lastUnMergedId = vid;
            this.currentUnMergedId = vid;
            this.currentMergedId = mergedVoucherIDItr.next();
            this.mergedIds.add(this.currentMergedId);
            this.seq = 1;
            destVidAndMergedDestVid = Tuple.create((Object)this.currentUnMergedId, (Object)this.currentMergedId);
        }
        if (!this.checkSameGroup(entry)) {
            this.saveEntriesFromCache(10000);
        }
        this.updateEntriesCache(entry);
        return destVidAndMergedDestVid;
    }

    private boolean checkSameVoucher(Long vid) {
        return Objects.equals(vid, this.lastUnMergedId);
    }

    private void updateEntriesCache(Row entry) {
        EntryMergeKey entryMergeKey = EntryMergeKey.create().init(entry, this.entryMergeOption);
        EntryMergeValue entryMergeValue = this.entriesCache.get(entryMergeKey);
        if (entryMergeValue == null) {
            entryMergeValue = EntryMergeValue.create().init(entry, this.entryMergeOption, this.currentMergedId);
            this.entriesCache.put(entryMergeKey, entryMergeValue);
        } else {
            entryMergeValue.merge(entry, this.entryMergeOption);
        }
    }

    private void saveEntriesFromCache(int batchSize) {
        if (this.entriesCache.size() >= batchSize) {
            List<Object[]> paramList = this.transToParamList();
            VoucherEntryDBHelper.saveMergedEntries(paramList, glVoucherField);
            this.entriesCache.clear();
        }
    }

    private List<Object[]> transToParamList() {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(this.entriesCache.size());
        SequenceReader sReader = new SequenceReader(new DBRoute("gl"));
        Iterator newVoucherEntryIDItr = Arrays.stream(sReader.getSequences((Object[])new Long[this.entriesCache.size()], "T_GL_VOUCHERENTRY", this.entriesCache.size())).iterator();
        for (Map.Entry<EntryMergeKey, EntryMergeValue> e : this.entriesCache.entrySet()) {
            Object[] param = new Object[26 + glVoucherField.getAllEntryFieldInfos().size()];
            EntryMergeKey entryMergeKey = e.getKey();
            EntryMergeValue entryMergeValue = e.getValue();
            entryMergeValue.finishCalc(this.entryMergeOption, this::getCachedCurrencyDO);
            param[0] = entryMergeValue.mergedId;
            param[1] = newVoucherEntryIDItr.next();
            param[2] = entryMergeKey.accountId;
            param[3] = entryMergeKey.assgrpId;
            param[4] = entryMergeKey.currencyId;
            param[5] = entryMergeKey.localExchangeRate;
            param[6] = entryMergeKey.measureUnitId;
            param[7] = entryMergeKey.mainCfItemId;
            param[8] = entryMergeKey.mainCfAssgrpId;
            param[9] = entryMergeValue.mainCfAmount;
            param[10] = entryMergeKey.suppCfItemId;
            param[11] = entryMergeValue.suppCfAmount;
            param[12] = entryMergeValue.oriDebit;
            param[13] = entryMergeValue.oriCredit;
            param[14] = entryMergeValue.localDebit;
            param[15] = entryMergeValue.localCredit;
            param[16] = entryMergeValue.qty;
            param[17] = entryMergeValue.price;
            param[18] = entryMergeValue.eDesc;
            param[19] = entryMergeValue.entryDc;
            param[20] = entryMergeValue.expireDate;
            param[21] = entryMergeValue.businessNum;
            param[22] = entryMergeValue.bizNumRecordId;
            param[23] = entryMergeValue.orgId;
            param[24] = entryMergeValue.periodId;
            if (Long.compare(this.id, entryMergeValue.mergedId) != 0) {
                this.id = entryMergeValue.mergedId;
                this.seq = 1;
                param[25] = this.seq;
            } else {
                ++this.seq;
                param[25] = this.seq;
            }
            if (!entryMergeValue.propertyName2Value.isEmpty()) {
                Set propertys = entryMergeValue.propertyName2Value.keySet();
                int index = 26;
                for (String property : propertys) {
                    param[index] = entryMergeValue.propertyName2Value.get(property);
                    ++index;
                }
            }
            paramList.add(param);
        }
        return paramList;
    }

    private boolean checkSameGroup(Row entry) {
        this.currentEntryGroup.initKey(entry);
        if (this.lastEntryGroupCache == null) {
            this.lastEntryGroupCache = this.currentEntryGroup;
            return true;
        }
        if (Objects.equals(this.lastEntryGroupCache, this.currentEntryGroup)) {
            return true;
        }
        this.lastEntryGroupCache = this.currentEntryGroup;
        return false;
    }

    private Iterator<Long> genVids(int count) {
        SequenceReader sReader = new SequenceReader(new DBRoute("gl"));
        final Long[] voucherIds = (Long[])sReader.getSequences((Object[])new Long[count], "T_GL_VOUCHER", count);
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onEnded(boolean rollbacked) {
                if (rollbacked) {
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"gl_voucher"), (Object[])voucherIds);
                }
            }
        });
        Iterator<Long> mergedVoucherIDItr = Arrays.stream(voucherIds).iterator();
        return mergedVoucherIDItr;
    }

    private void clearEntriesUnMerged(Set<Object> destVids) {
        String sqlTag = "clearEntriesUnMerged";
        VoucherEntryDBHelper.deleteEntryById(destVids, sqlTag);
    }

    private void deleteEntriesMergedInException() {
        String sqlTag = "VoucherEntryDSMergeHelper.merge.error";
        VoucherEntryDBHelper.deleteEntryById(this.mergedIds, sqlTag);
    }

    private DynamicObject getCachedCurrencyDO(long currencyId) {
        DynamicObject curr = this.currencyMap.get(currencyId);
        if (curr == null) {
            curr = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency", (String)"amtprecision,priceprecision");
            this.currencyMap.put(currencyId, curr);
        }
        return curr;
    }

    static {
        logger = LogFactory.getLog((String)VoucherEntryDSMergeHelper.class.getTypeName());
    }

    private static class EntryMergeKey {
        private long id;
        private long accountId;
        private long assgrpId;
        private long currencyId;
        private long mainCfItemId;
        private long suppCfItemId;
        private long mainCfAssgrpId;
        private long measureUnitId;
        private BigDecimal localExchangeRate;
        private String eDesc;
        private int entryDc;
        private BigDecimal price;

        private EntryMergeKey() {
        }

        public static EntryMergeKey create() {
            return new EntryMergeKey();
        }

        public EntryMergeKey init(Row entry, EntryMergeOption entryMergeOption) {
            this.id = entry.getLong("fid");
            this.accountId = entry.getLong("faccountid");
            this.assgrpId = entry.getLong("fassgrpid");
            this.currencyId = entry.getLong("fcurrencyid");
            this.mainCfItemId = entry.getLong("fmaincfitemid");
            this.suppCfItemId = entry.getLong("fsuppcfitemid");
            this.mainCfAssgrpId = entry.getLong("fmaincfassgrpid");
            this.measureUnitId = entry.getLong("fmeasureunitid");
            this.localExchangeRate = entry.getBigDecimal("flocalexchangerate");
            this.eDesc = entryMergeOption.isDescriptionMerge() ? "" : entry.getString("fdescription");
            this.entryDc = entryMergeOption.isDcMerge() ? 1 : entry.getInteger("fentrydc");
            this.price = entryMergeOption.isPriceMerge() ? BigDecimal.ZERO : entry.getBigDecimal("fprice");
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntryMergeKey that = (EntryMergeKey)o;
            if (this.id != that.id) {
                return false;
            }
            if (this.accountId != that.accountId) {
                return false;
            }
            if (this.assgrpId != that.assgrpId) {
                return false;
            }
            if (this.currencyId != that.currencyId) {
                return false;
            }
            if (this.mainCfItemId != that.mainCfItemId) {
                return false;
            }
            if (this.suppCfItemId != that.suppCfItemId) {
                return false;
            }
            if (this.mainCfAssgrpId != that.mainCfAssgrpId) {
                return false;
            }
            if (this.measureUnitId != that.measureUnitId) {
                return false;
            }
            if (this.entryDc != that.entryDc) {
                return false;
            }
            if (this.localExchangeRate != null ? !this.localExchangeRate.equals(that.localExchangeRate) : that.localExchangeRate != null) {
                return false;
            }
            if (this.eDesc != null ? !this.eDesc.equals(that.eDesc) : that.eDesc != null) {
                return false;
            }
            return this.price != null ? this.price.equals(that.price) : that.price == null;
        }

        public int hashCode() {
            int result = (int)(this.id ^ this.id >>> 32);
            result = 31 * result + (int)(this.accountId ^ this.accountId >>> 32);
            result = 31 * result + (int)(this.assgrpId ^ this.assgrpId >>> 32);
            result = 31 * result + (int)(this.currencyId ^ this.currencyId >>> 32);
            result = 31 * result + (int)(this.mainCfItemId ^ this.mainCfItemId >>> 32);
            result = 31 * result + (int)(this.suppCfItemId ^ this.suppCfItemId >>> 32);
            result = 31 * result + (int)(this.mainCfAssgrpId ^ this.mainCfAssgrpId >>> 32);
            result = 31 * result + (int)(this.measureUnitId ^ this.measureUnitId >>> 32);
            result = 31 * result + (this.localExchangeRate != null ? this.localExchangeRate.hashCode() : 0);
            result = 31 * result + (this.eDesc != null ? this.eDesc.hashCode() : 0);
            result = 31 * result + this.entryDc;
            result = 31 * result + (this.price != null ? this.price.hashCode() : 0);
            return result;
        }
    }

    private static class EntryMergeValue {
        private static final int DEFAULT_PRICE_PRECISION = 4;
        private long mergedId;
        private long currencyId;
        private BigDecimal mainCfAmount;
        private BigDecimal suppCfAmount;
        private BigDecimal oriDebit;
        private BigDecimal oriCredit;
        private BigDecimal localDebit;
        private BigDecimal localCredit;
        private BigDecimal qty;
        private BigDecimal price;
        private String eDesc;
        private int entryDc;
        private Date expireDate;
        private String businessNum;
        private long bizNumRecordId;
        private long orgId;
        private long periodId;
        private LinkedHashMap<String, Object> propertyName2Value = new LinkedHashMap();

        private EntryMergeValue() {
        }

        public static EntryMergeValue create() {
            return new EntryMergeValue();
        }

        public EntryMergeValue init(Row entry, EntryMergeOption entryMergeOption, long mergedDestVid) {
            this.mergedId = mergedDestVid;
            this.currencyId = entry.getLong("fcurrencyid");
            this.mainCfAmount = entry.getBigDecimal("fmaincfamount");
            this.suppCfAmount = entry.getBigDecimal("fsuppcfamount");
            this.oriDebit = entry.getBigDecimal("foriginaldebit");
            this.oriCredit = entry.getBigDecimal("foriginalcredit");
            this.localDebit = entry.getBigDecimal("flocaldebit");
            this.localCredit = entry.getBigDecimal("flocalcredit");
            if (entryMergeOption.isDcMerge()) {
                this.qty = entry.getBigDecimal("fquantity").multiply(new BigDecimal(entry.getInteger("fentrydc")));
                this.entryDc = 1;
            } else {
                this.qty = entry.getBigDecimal("fquantity");
                this.entryDc = entry.getInteger("fentrydc");
            }
            this.price = entry.getBigDecimal("fprice");
            this.eDesc = entry.getString("fdescription");
            this.expireDate = entry.getDate("fexpiredate");
            this.businessNum = entry.getString("fbusinessnum");
            this.bizNumRecordId = entry.getLong("fbiznumrecordid");
            this.orgId = entry.getLong("forgid");
            this.periodId = entry.getLong("fperiodid");
            if (glVoucherField != null) {
                List<EntryFieldInfo> allEntryFieldInfos = glVoucherField.getAllEntryFieldInfos();
                for (EntryFieldInfo entryFieldInfo : allEntryFieldInfos) {
                    Object value = DataType.convertValue((DataType)entryFieldInfo.getDataType(), (Object)entry.get(entryFieldInfo.getAlias()));
                    this.propertyName2Value.put(entryFieldInfo.getAlias(), value);
                }
            }
            return this;
        }

        public void merge(Row entry, EntryMergeOption entryMergeOption) {
            this.mainCfAmount = this.mainCfAmount.add(entry.getBigDecimal("fmaincfamount"));
            this.suppCfAmount = this.suppCfAmount.add(entry.getBigDecimal("fsuppcfamount"));
            this.oriDebit = this.oriDebit.add(entry.getBigDecimal("foriginaldebit"));
            this.oriCredit = this.oriCredit.add(entry.getBigDecimal("foriginalcredit"));
            this.localDebit = this.localDebit.add(entry.getBigDecimal("flocaldebit"));
            this.localCredit = this.localCredit.add(entry.getBigDecimal("flocalcredit"));
            this.qty = entryMergeOption.isDcMerge() ? this.qty.add(entry.getBigDecimal("fquantity").multiply(new BigDecimal(entry.getInteger("fentrydc")))) : this.qty.add(entry.getBigDecimal("fquantity"));
            this.price = entry.getBigDecimal("fprice");
            this.eDesc = entry.getString("fdescription");
        }

        public void finishCalc(EntryMergeOption entryMergeOption, Function<Long, DynamicObject> getCachedCurrencyDOFun) {
            if (entryMergeOption.isDcMerge()) {
                boolean isDebitDc;
                boolean bl = isDebitDc = this.oriDebit.signum() != 0 && this.oriCredit.signum() == 0 || this.oriDebit.signum() != 0 && this.oriCredit.signum() != 0 && this.oriDebit.compareTo(this.oriCredit) > 0;
                if (isDebitDc) {
                    this.entryDc = 1;
                    this.oriDebit = this.oriDebit.subtract(this.oriCredit);
                    this.oriCredit = BigDecimal.ZERO;
                    this.localDebit = this.localDebit.subtract(this.localCredit);
                    this.localCredit = BigDecimal.ZERO;
                } else {
                    this.entryDc = -1;
                    this.oriCredit = this.oriCredit.subtract(this.oriDebit);
                    this.oriDebit = BigDecimal.ZERO;
                    this.localCredit = this.localCredit.subtract(this.localDebit);
                    this.localDebit = BigDecimal.ZERO;
                    this.qty = this.qty.negate();
                }
            }
            if (entryMergeOption.isPriceMerge()) {
                if (this.qty.compareTo(BigDecimal.ZERO) == 0) {
                    this.price = BigDecimal.ZERO;
                } else {
                    BigDecimal oriAmount = this.oriDebit.add(this.oriCredit);
                    DynamicObject currencyDO = getCachedCurrencyDOFun.apply(this.currencyId);
                    this.price = oriAmount.divide(this.qty, currencyDO == null ? 4 : currencyDO.getInt("priceprecision"), RoundingMode.HALF_UP);
                }
            }
        }
    }

    private static class EntryGroup {
        private long id;
        private long accountId;
        private long assgrpId;
        private long currencyId;
        private long mainCfItemId;
        private long suppCfItemId;

        private EntryGroup() {
        }

        public static EntryGroup create() {
            return new EntryGroup();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntryGroup that = (EntryGroup)o;
            if (this.id != that.id) {
                return false;
            }
            if (this.accountId != that.accountId) {
                return false;
            }
            if (this.assgrpId != that.assgrpId) {
                return false;
            }
            if (this.currencyId != that.currencyId) {
                return false;
            }
            if (this.mainCfItemId != that.mainCfItemId) {
                return false;
            }
            return this.suppCfItemId == that.suppCfItemId;
        }

        public int hashCode() {
            int result = (int)(this.id ^ this.id >>> 32);
            result = 31 * result + (int)(this.accountId ^ this.accountId >>> 32);
            result = 31 * result + (int)(this.assgrpId ^ this.assgrpId >>> 32);
            result = 31 * result + (int)(this.currencyId ^ this.currencyId >>> 32);
            result = 31 * result + (int)(this.mainCfItemId ^ this.mainCfItemId >>> 32);
            result = 31 * result + (int)(this.suppCfItemId ^ this.suppCfItemId >>> 32);
            return result;
        }

        public EntryGroup initKey(Row entry) {
            this.id = entry.getLong("fid");
            this.accountId = entry.getLong("faccountid");
            this.assgrpId = entry.getLong("fassgrpid");
            this.currencyId = entry.getLong("fcurrencyid");
            this.mainCfItemId = entry.getLong("fmaincfitemid");
            this.suppCfItemId = entry.getLong("fsuppcfitemid");
            return this;
        }
    }
}

