/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.amort.dest;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bd.rate.IRateCalculator;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.common.VoucherEntryInfo;
import kd.fi.gl.common.VoucherInfo;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.finalprocess.info.AmountInfo;
import kd.fi.gl.finalprocessing.info.AmortGenVchInfo;
import kd.fi.gl.finalprocessing.info.AmortRowKey;
import kd.fi.gl.voucher.carryover.genentry.IEntryGenerator;

public class DestEntryGenerator
implements IEntryGenerator {
    protected AmortGenVchInfo amortInfo;
    protected DynamicObject destRow;

    @Override
    public void generateEntry(VoucherInfo voucherInfo) {
        String rowId = this.destRow.getString("destrowid");
        this.amortInfo.getDestDetailInfoTable().get(rowId).entrySet().forEach(entry -> {
            VoucherEntryInfo voucherEntry = voucherInfo.createNewEntry();
            voucherEntry.setDesc(this.amortInfo.getVoucherAbstract());
            voucherEntry.loadAmountInfo(this.transDetailRow2AmountInfo((Map.Entry<AmortRowKey, Tuple<BigDecimal, BigDecimal>>)entry));
        });
    }

    private AmountInfo transDetailRow2AmountInfo(Map.Entry<AmortRowKey, Tuple<BigDecimal, BigDecimal>> entry) {
        AmortRowKey key = entry.getKey();
        Tuple<BigDecimal, BigDecimal> amount = entry.getValue();
        int ratePrecision = this.amortInfo.getRatePrecisionByOriginCurrency(this.destRow.getLong(GLField.id_("destcurrency")));
        return new AmountInfo.Builder().assgrpId(key.getAssgrpId()).accountId(key.getAccountId()).currencyId(this.destRow.getLong(GLField.id_("destcurrency"))).oriAmount((BigDecimal)amount.item1).locAmount((BigDecimal)amount.item2).rate(this.getRateCalculator().calRate((BigDecimal)amount.item1, (BigDecimal)amount.item2, ratePrecision)).dc(this.amortInfo.getDestDc()).comAssistIdMap(key.getComAssistIdMap()).build();
    }

    @Override
    public IEntryGenerator build(Map<String, Object> paramMap) {
        this.amortInfo = (AmortGenVchInfo)paramMap.get("amortInfo");
        this.destRow = (DynamicObject)paramMap.get("destRow");
        return this;
    }

    public BigDecimal getCoefficient() {
        return BigDecimal.ONE;
    }

    @Override
    public IRateCalculator getRateCalculator() {
        return RateServiceHelper.getRateType((long)this.destRow.getLong(GLField.id_("destcurrency")), (long)this.amortInfo.getBaseCurrencyId(), (Date)this.amortInfo.getCurPeriodEndDate()).getRateCalculator();
    }
}

