/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.amort.plantype;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bd.rate.IRateCalculator;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.common.VoucherEntryInfo;
import kd.fi.gl.common.VoucherInfo;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.finalprocess.info.AmountInfo;
import kd.fi.gl.finalprocessing.info.AmortGenVchInfo;
import kd.fi.gl.finalprocessing.info.AmortRowKey;
import kd.fi.gl.voucher.carryover.genentry.IEntryGenerator;

public abstract class AbstractTargetEntryGenerator
implements IEntryGenerator {
    protected AmortGenVchInfo amortInfo;
    protected DynamicObject targetRow;

    @Override
    public IEntryGenerator build(Map<String, Object> paramMap) {
        this.amortInfo = (AmortGenVchInfo)paramMap.get("amortInfo");
        this.targetRow = (DynamicObject)paramMap.get("targetRow");
        return this;
    }

    @Override
    public void generateEntry(VoucherInfo voucherInfo) {
        String rowId = this.targetRow.getString("targetrowid");
        this.amortInfo.getDetailEntry().stream().filter(detailRow -> detailRow.getString("detailrowid").equals(rowId)).map(detailRow -> this.transDetailRow2AmountInfo((DynamicObject)detailRow, this.getRateCalculator())).forEach(detailAmountInfo -> {
            VoucherEntryInfo voucherEntry = voucherInfo.createNewEntry();
            voucherEntry.setDesc(this.amortInfo.getVoucherAbstract());
            voucherEntry.loadAmountInfo((AmountInfo)detailAmountInfo);
        });
    }

    protected AmountInfo transDetailRow2AmountInfo(DynamicObject detailRow, IRateCalculator rateCalculator) {
        BigDecimal coefficient = this.getCoefficient();
        int comAssistCount = this.amortInfo.getComAssistCount();
        HashMap<Integer, Long> comAssistIdMap = new HashMap<Integer, Long>(8);
        for (int i = 1; i <= comAssistCount; ++i) {
            comAssistIdMap.put(i, detailRow.getLong("detailcomassist" + i));
        }
        Tuple<BigDecimal, BigDecimal> amountTuple = this.amortInfo.getTargetDetailInfoTable().get(new AmortRowKey(detailRow.getLong("detailaccount"), detailRow.getLong("detailassgrp"), comAssistIdMap));
        BigDecimal toAmortOriForNow = ((BigDecimal)Objects.requireNonNull(amountTuple).item1).multiply(coefficient);
        BigDecimal toAmortLocForNow = ((BigDecimal)Objects.requireNonNull(amountTuple).item2).multiply(coefficient);
        return new AmountInfo.Builder().assgrpId(detailRow.getLong("detailassgrp")).accountId(detailRow.getLong("detailaccount")).currencyId(this.targetRow.getLong(GLField.id_("targetcurrency"))).oriAmount(toAmortOriForNow).locAmount(toAmortLocForNow).rate(rateCalculator.calRate(toAmortOriForNow, toAmortLocForNow, 4)).dc(this.amortInfo.getTargetDc()).comAssistIdMap(comAssistIdMap).build();
    }

    public BigDecimal getCoefficient() {
        return BigDecimal.ONE;
    }

    @Override
    public IRateCalculator getRateCalculator() {
        return RateServiceHelper.getRateType((long)this.targetRow.getLong(GLField.id_("targetcurrency")), (long)this.amortInfo.getBaseCurrencyId(), (Date)this.amortInfo.getCurPeriodEndDate()).getRateCalculator();
    }
}

