/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.info;

import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.constant.basedata.CurrencyConstant;
import kd.fi.gl.enums.AmortStyle;
import kd.fi.gl.finalprocess.info.AmountInfo;
import kd.fi.gl.finalprocessing.amort.amortstyle.AbstractAmortInfoGetter;
import kd.fi.gl.finalprocessing.amort.amortstyle.AmortInfoGetterFactory;
import kd.fi.gl.finalprocessing.info.AmortInfoSummaryCollector;
import kd.fi.gl.finalprocessing.info.AmortRowKey;
import kd.fi.gl.finalprocessing.info.FinalProcessingInfo;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.FinalProcessUtil;
import kd.fi.gl.util.VoucherAmortSchemeUtils;

public class AmortGenVchInfo
extends FinalProcessingInfo {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(AmortGenVchInfo.class);
    private AmountInfo amountForNow;
    private AmountInfo amountForTotal;
    Map<AmortRowKey, Tuple<BigDecimal, BigDecimal>> targetDetailInfoTable;
    Map<String, Map<AmortRowKey, Tuple<BigDecimal, BigDecimal>>> destDetailInfoTable;
    private boolean isLastPeriod;
    private DynamicObjectCollection detailEntry;
    private DynamicObjectCollection targetEntry;
    private DynamicObjectCollection destEntry;
    private String targetDc;
    private String destDc;
    private DynamicObject locCurrencyDyn;
    private DynamicObject destOriCurrencyDyn;
    private boolean isCustom;
    private String voucherAbstract;
    private Map<String, Long> balanceAssistMap;
    private int comAssistCount;
    private final Map<Long, Integer> exchangeRatePrecisionMap = new HashMap<Long, Integer>(2);

    public AmortGenVchInfo(DynamicObject dataEntity, OperateOption option) {
        super(dataEntity, "accountbooks", option);
        this.initSytleIrrelevantValue();
        this.initStyleRelevantValue();
        if (option.containsVariable("inittable") && !this.detailEntry.isEmpty()) {
            this.reloadDetailEntry();
            this.initTargetDetailInfoTable();
            this.initDestDetailInfoTable();
            this.logIfEnable();
        }
    }

    private void initDestDetailInfoTable() {
        this.destDetailInfoTable = new HashMap<String, Map<AmortRowKey, Tuple<BigDecimal, BigDecimal>>>();
        VoucherAmortSchemeUtils.DestAmountCalculator destAmountCalculator = new VoucherAmortSchemeUtils.DestAmountCalculator(this);
        DynamicObjectCollection destEntry = this.dataEntity.getDynamicObjectCollection("destaccounts");
        Map<String, Set<Long>> rowToHgs = this.parseRowToHgs(destEntry);
        destEntry.forEach(destRow -> {
            BigDecimal lastOri;
            int index;
            HashMap<Integer, Long> comAssistMap;
            BigDecimal rate = this.getDestRowRate((DynamicObject)destRow);
            String destRowId = destRow.getString("destrowid");
            HashMap<AmortRowKey, Tuple<BigDecimal, BigDecimal>> detailMap = new HashMap<AmortRowKey, Tuple<BigDecimal, BigDecimal>>(8);
            this.destDetailInfoTable.put(destRowId, detailMap);
            Set<Long> allAccts = VoucherAmortSchemeUtils.getLeafAccountIds(destRow, this);
            Set allHgs = Optional.ofNullable(rowToHgs.get(destRowId)).orElseGet(() -> Stream.of(Long.valueOf(0L)).collect(Collectors.toSet()));
            ArrayList<List<Long>> comAssistIdList = new ArrayList<List<Long>>(this.balanceAssistMap.size());
            for (int i = 1; i <= this.comAssistCount; ++i) {
                Long balanceAssistId = this.balanceAssistMap.get(CommonAssistUtil.getComassistField(i));
                if (balanceAssistId != null && balanceAssistId != 0L) {
                    comAssistIdList.add(Collections.singletonList(balanceAssistId));
                    continue;
                }
                comAssistIdList.add(destRow.getDynamicObjectCollection(CommonAssistUtil.getComassistField(i) + "dest").stream().map(comAssist -> comAssist.get("fbasedataid_id")).collect(Collectors.toList()));
            }
            ArrayList<List<Object>> combinationLists = new ArrayList<List<Object>>(8);
            combinationLists.add(Arrays.asList(allAccts.toArray()));
            combinationLists.add(Arrays.asList(allHgs.toArray()));
            combinationLists.addAll(comAssistIdList);
            List<List<Object>> combination = FinalProcessUtil.getCartesianProduct(combinationLists);
            if (combination.isEmpty()) {
                return;
            }
            AmountInfo destAmount = destAmountCalculator.calculate((DynamicObject)destRow);
            BigDecimal destrowOri = destAmount.getOriAmount();
            BigDecimal destrowLoc = destAmount.getLocAmount();
            BigDecimal eachLoc = destrowLoc.divide(new BigDecimal(combination.size()), VoucherAmortSchemeUtils.getLocScale(this.dataEntity), RoundingMode.HALF_UP);
            BigDecimal eachOri = this.isCustom ? destrowOri.divide(new BigDecimal(combination.size()), VoucherAmortSchemeUtils.getOriScale(destRow), RoundingMode.HALF_UP) : eachLoc.divide(rate, VoucherAmortSchemeUtils.getOriScale(destRow), RoundingMode.HALF_UP);
            for (int i = 0; i < combination.size() - 1; ++i) {
                List destRowKetList = combination.get(i).stream().map(value -> Long.parseLong(value.toString())).collect(Collectors.toList());
                comAssistMap = new HashMap<Integer, Long>(8);
                for (index = 2; index < destRowKetList.size(); ++index) {
                    comAssistMap.put(index - 1, (Long)destRowKetList.get(index));
                }
                detailMap.put(new AmortRowKey((Long)destRowKetList.get(0), (Long)destRowKetList.get(1), comAssistMap), Tuple.create(eachOri, eachLoc));
            }
            List lastDestRowKetList = combination.get(combination.size() - 1).stream().map(value -> Long.parseLong(value.toString())).collect(Collectors.toList());
            BigDecimal lastLoc = destrowLoc.subtract(eachLoc.multiply(new BigDecimal(combination.size() - 1)));
            comAssistMap = new HashMap(8);
            for (index = 2; index < lastDestRowKetList.size(); ++index) {
                comAssistMap.put(index - 1, (Long)lastDestRowKetList.get(index));
            }
            BigDecimal bigDecimal = lastOri = this.isCustom ? this.amountForNow.getOriAmount() : lastLoc.divide(rate, VoucherAmortSchemeUtils.getOriScale(destRow), RoundingMode.HALF_UP);
            if (rate.signum() != 0) {
                detailMap.put(new AmortRowKey((Long)lastDestRowKetList.get(0), (Long)lastDestRowKetList.get(1), comAssistMap), Tuple.create(lastOri, lastLoc));
            }
        });
    }

    private Map<String, Set<Long>> parseRowToHgs(DynamicObjectCollection destEntry) {
        Set<String> destRowIds = destEntry.stream().map(destRow -> destRow.getString("destrowid")).collect(Collectors.toSet());
        return VoucherAmortSchemeUtils.batchLoadRowId2Assgrp(destRowIds);
    }

    @Override
    public Date getBizDate() {
        return new Date();
    }

    public long getVoucherTypeId() {
        return this.dataEntity.getDynamicObject("vouchertype").getLong("id");
    }

    public String getVoucherDesc() {
        return this.dataEntity.getString("description");
    }

    private void initStyleRelevantValue() {
        AmortStyle amortstyle = AmortStyle.getEnumObj(this.dataEntity.getString("amortstyle"));
        AbstractAmortInfoGetter amortInfoGetter = AmortInfoGetterFactory.get(amortstyle).build(this.dataEntity, this);
        this.isLastPeriod = amortInfoGetter.isLastPeriod();
        this.amountForTotal = amortInfoGetter.calAmountForTotal();
        this.amountForNow = amortInfoGetter.calAmountForNow();
        this.isCustom = "4".equals(this.dataEntity.getString("amortstyle"));
        if (this.isCustom) {
            this.destOriCurrencyDyn = ((DynamicObject)this.targetEntry.get(0)).getDynamicObject("targetcurrency");
        }
    }

    private void initSytleIrrelevantValue() {
        this.voucherAbstract = this.dataEntity.getString("amortabstract");
        this.targetEntry = this.dataEntity.getDynamicObjectCollection("targetaccounts");
        this.destEntry = this.dataEntity.getDynamicObjectCollection("destaccounts");
        this.detailEntry = this.dataEntity.getDynamicObjectCollection("detailentry");
        this.targetDc = ((DynamicObject)this.targetEntry.get(0)).getString("plandirection");
        this.destDc = ((DynamicObject)this.destEntry.get(0)).getString("destdirection");
        this.locCurrencyDyn = this.getBaseCurrencyDyn();
        this.balanceAssistMap = new HashMap<String, Long>(8);
        List balanceAssistKeyList = ((BillEntityType)this.dataEntity.getDataEntityType()).getAllFields().keySet().stream().filter(k -> k.startsWith("comassist") && !k.endsWith("target") && !k.endsWith("dest")).collect(Collectors.toList());
        for (String balanceAssistKey : balanceAssistKeyList) {
            this.balanceAssistMap.put(balanceAssistKey, this.dataEntity.getLong(GLField.id_(balanceAssistKey)));
        }
        this.comAssistCount = ComAssistTable.get(this.getAccountBookInfo().getAccountTableId()).getCommonAssists().size();
    }

    private void reloadDetailEntry() {
        this.detailEntry.forEach(detailRow -> detailRow.set("detailcurrency", (Object)this.targetEntry.stream().filter(targetRow -> targetRow.getString("targetrowid").equals(detailRow.getString("detailrowid"))).findFirst().get().getDynamicObject("targetcurrency")));
    }

    private void initTargetDetailInfoTable() {
        this.targetDetailInfoTable = new HashMap<AmortRowKey, Tuple<BigDecimal, BigDecimal>>(8);
        if (this.isLastPeriod) {
            this.initTargetDetailInfoForLastPeriod();
        } else {
            this.initTargetDetailInfoForUsual();
        }
        for (Tuple<BigDecimal, BigDecimal> value : this.targetDetailInfoTable.values()) {
            value.item2 = ((BigDecimal)value.item2).setScale(this.getBaseCurrencyDyn().getInt(CurrencyConstant.Entity_AMT_Scale.key), RoundingMode.HALF_UP);
        }
    }

    private void initTargetDetailInfoForUsual() {
        int index;
        BigDecimal oriCoefficient = this.amountForNow.getOriAmount().divide(this.amountForTotal.getOriAmount(), 10, RoundingMode.HALF_UP);
        BigDecimal locCoefficient = this.amountForNow.getLocAmount().divide(this.amountForTotal.getLocAmount(), 10, RoundingMode.HALF_UP);
        BigDecimal oriSum = BigDecimal.ZERO;
        BigDecimal locSum = BigDecimal.ZERO;
        for (index = 0; index < this.detailEntry.size() - 1; ++index) {
            DynamicObject detailRow = (DynamicObject)this.detailEntry.get(index);
            BigDecimal detailOriForNow = detailRow.getBigDecimal("detailoritotal").multiply(oriCoefficient).setScale(VoucherAmortSchemeUtils.getOriScale(detailRow), RoundingMode.HALF_UP);
            BigDecimal detailLocForNow = detailRow.getBigDecimal("detailloctotal").multiply(locCoefficient).setScale(VoucherAmortSchemeUtils.getLocScale(this.dataEntity), RoundingMode.HALF_UP);
            oriSum = oriSum.add(detailOriForNow);
            locSum = locSum.add(detailLocForNow);
            HashMap<Integer, Long> comAssistMap = new HashMap<Integer, Long>(8);
            for (int i = 1; i <= this.comAssistCount; ++i) {
                comAssistMap.put(i, detailRow.getLong("detailcomassist" + i));
            }
            this.targetDetailInfoTable.put(new AmortRowKey(detailRow.getLong("detailaccount"), detailRow.getLong("detailassgrp"), comAssistMap), Tuple.create(detailOriForNow, detailLocForNow));
        }
        DynamicObject lastDetailRow = (DynamicObject)this.detailEntry.get(index);
        HashMap<Integer, Long> comAssistMap = new HashMap<Integer, Long>(8);
        for (int i = 1; i <= this.comAssistCount; ++i) {
            comAssistMap.put(i, lastDetailRow.getLong("detailcomassist" + i));
        }
        this.targetDetailInfoTable.put(new AmortRowKey(lastDetailRow.getLong("detailaccount"), lastDetailRow.getLong("detailassgrp"), comAssistMap), Tuple.create(this.amountForNow.getOriAmount().subtract(oriSum), this.amountForNow.getLocAmount().subtract(locSum)));
    }

    private void initTargetDetailInfoForLastPeriod() {
        this.targetDetailInfoTable = this.detailEntry.stream().collect(Collector.of(HashMap::new, (key, detailRow) -> {
            HashMap<Integer, Long> comAssistMap = new HashMap<Integer, Long>(8);
            for (int index = 1; index <= this.comAssistCount; ++index) {
                comAssistMap.put(index, detailRow.getLong("detailcomassist" + index));
            }
            key.put(new AmortRowKey(detailRow.getLong("detailaccount"), detailRow.getLong("detailassgrp"), comAssistMap), Tuple.create(detailRow.getBigDecimal("detailoritotal"), detailRow.getBigDecimal("detailloctotal")));
        }, (table1, table2) -> {
            table1.putAll(table2);
            return table1;
        }, Collector.Characteristics.CONCURRENT));
        Map<AmortRowKey, Tuple<BigDecimal, BigDecimal>> sumInfo = this.dataEntity.getDynamicObjectCollection("policies").stream().filter(policyRow -> StringUtils.isNotBlank((CharSequence)policyRow.getString("perioddetail"))).map(policyRow -> {
            Object periodDetail = SerializationUtils.deSerializeFromBase64((String)policyRow.getString("perioddetail"));
            if (periodDetail instanceof Table) {
                HashMap<AmortRowKey, Object> periodDetailMap = new HashMap<AmortRowKey, Object>(8);
                for (Table.Cell periodDetailCell : ((Table)periodDetail).cellSet()) {
                    AmortRowKey amortRowKey = new AmortRowKey((Long)periodDetailCell.getRowKey(), (Long)periodDetailCell.getColumnKey(), Collections.EMPTY_MAP);
                    periodDetailMap.put(amortRowKey, periodDetailCell.getValue());
                }
                return periodDetailMap;
            }
            return (Map)SerializationUtils.deSerializeFromBase64((String)policyRow.getString("perioddetail"));
        }).collect(new AmortInfoSummaryCollector());
        if (!sumInfo.isEmpty()) {
            sumInfo.keySet().forEach(key -> {
                Tuple<BigDecimal, BigDecimal> resultAmountBuf = this.targetDetailInfoTable.get(key);
                if (resultAmountBuf != null) {
                    resultAmountBuf.merge((Tuple)sumInfo.get(key), BigDecimal::subtract, BigDecimal::subtract);
                } else {
                    Optional<AmortRowKey> inheritRow = this.targetDetailInfoTable.keySet().stream().filter(rowKey -> Objects.equals(rowKey.getAccountId(), key.getAccountId()) && Objects.equals(rowKey.getComAssistIdMap(), key.getComAssistIdMap())).findFirst();
                    inheritRow.ifPresent(row -> this.targetDetailInfoTable.get(row).merge((Tuple)sumInfo.get(key), BigDecimal::subtract, BigDecimal::subtract));
                }
            });
        }
    }

    public DynamicObjectCollection getDetailEntry() {
        return this.detailEntry;
    }

    public DynamicObjectCollection getTargetEntry() {
        return this.targetEntry;
    }

    public AmountInfo getAmountForNow() {
        return this.amountForNow;
    }

    public AmountInfo getAmountForTotal() {
        return this.amountForTotal;
    }

    public boolean isLastPeriod() {
        return this.isLastPeriod;
    }

    public String getTargetDc() {
        return this.targetDc;
    }

    public String getDestDc() {
        return this.destDc;
    }

    public Map<String, Map<AmortRowKey, Tuple<BigDecimal, BigDecimal>>> getDestDetailInfoTable() {
        return this.destDetailInfoTable;
    }

    public DynamicObjectCollection getDestEntry() {
        return this.destEntry;
    }

    public String getVoucherAbstract() {
        return this.voucherAbstract;
    }

    public Map<AmortRowKey, Tuple<BigDecimal, BigDecimal>> getTargetDetailInfoTable() {
        return this.targetDetailInfoTable;
    }

    private void logIfEnable() {
        if (DebugTrace.enable()) {
            logger.info("target table:{}, dest table:{}", (Object)this.targetDetailInfoTable.toString(), (Object)this.destDetailInfoTable.toString());
        }
    }

    public Map<String, Long> getBalanceAssistMap() {
        return this.balanceAssistMap;
    }

    public int getComAssistCount() {
        return this.comAssistCount;
    }

    private BigDecimal getDestRowRate(DynamicObject destRow) {
        BigDecimal result = AmortStyle.CUSTOME.getValue().equals(this.dataEntity.getString("amortstyle")) ? ((DynamicObject)this.getTargetEntry().get(0)).getBigDecimal("rate") : (destRow.getBigDecimal("destamount").compareTo(BigDecimal.ZERO) == 0 ? Optional.ofNullable(RateServiceHelper.getExchangeRate((Long)destRow.getLong(GLField.id_("destcurrency")), (Long)this.getAccountBookInfo().getBaseCurrencyId(), (Long)this.getAccountBookInfo().getExrateTableId(), (Date)this.getCurPeriodEndDate())).orElseGet(RateServiceHelper::getDefaultOne).getDirectRate() : destRow.getBigDecimal("destlocal").divide(destRow.getBigDecimal("destamount"), 10, RoundingMode.HALF_UP));
        return result;
    }

    public Integer getRatePrecisionByOriginCurrency(Long currencyId) {
        return this.exchangeRatePrecisionMap.computeIfAbsent(currencyId, c -> RateServiceHelper.getRatePrecision((Long)c, (Long)this.getBaseCurrencyId(), (Long)this.getExchangeTableId(), (Date)this.getCurPeriodEndDate()));
    }
}

