/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.flex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kd.fi.gl.flex.FlexValueEntry;

public class FlexValue {
    private final Map<String, Object> flexToValues;
    private final List<FlexValueEntry> flexValueEntries;

    public FlexValue(Map<String, Object> flexToValues) {
        this.flexToValues = new HashMap<String, Object>(flexToValues.size());
        this.flexValueEntries = new ArrayList<FlexValueEntry>(flexToValues.size());
        for (Map.Entry<String, Object> flexToValue : flexToValues.entrySet()) {
            FlexValueEntry flexValueEntry = new FlexValueEntry(flexToValue.getKey(), flexToValue.getValue());
            this.flexValueEntries.add(flexValueEntry);
            this.flexToValues.put(flexToValue.getKey(), flexValueEntry.getValue());
        }
    }

    public Map<String, Object> getFlexToValues() {
        return this.flexToValues;
    }

    public List<FlexValueEntry> getFlexValueEntries() {
        return this.flexValueEntries;
    }

    public boolean remove(Predicate<FlexValueEntry> filter) {
        boolean result = false;
        Iterator<FlexValueEntry> iterator = this.flexValueEntries.iterator();
        while (iterator.hasNext()) {
            FlexValueEntry next = iterator.next();
            if (!filter.test(next)) continue;
            this.flexToValues.remove(next.getFlexField());
            iterator.remove();
            result = true;
        }
        return result;
    }

    public void addIfAbsent(String flexField, Object value) {
        if (this.flexToValues.containsKey(flexField)) {
            return;
        }
        this.flexValueEntries.add(new FlexValueEntry(flexField, value));
        this.flexToValues.put(flexField, value);
    }
}

