/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.lock;

import java.util.Date;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.fi.gl.lock.LockHandler;
import kd.fi.gl.lock.LockKey;

public class Lock {
    public static boolean tryLock(long orgId, long bookTypeId, LockKey lockKey, LockHandler handler) {
        String book = orgId + "-" + bookTypeId;
        try (DLock lock = DLock.create((String)("fi/gl/" + (Object)((Object)lockKey) + "/" + book)).fastMode();){
            if (lock.tryLock()) {
                try (TXHandle h = TX.required((String)("fi_gl_" + (Object)((Object)lockKey)));){
                    try {
                        Lock.dbLock(book, lockKey);
                        handler.handle();
                    }
                    catch (Exception e) {
                        h.markRollback();
                        throw e;
                    }
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static boolean tryLock(long orgId, long bookTypeId, LockKey lockKey, long timeoutMillis, LockHandler handler) {
        String book = orgId + "-" + bookTypeId;
        try (DLock lock = DLock.create((String)("fi/gl/" + (Object)((Object)lockKey) + "/" + book)).fastMode();){
            if (lock.tryLock(timeoutMillis)) {
                try (TXHandle h = TX.required((String)("fi_gl_" + (Object)((Object)lockKey)));){
                    try {
                        Lock.dbLock(book, lockKey);
                        handler.handle();
                    }
                    catch (Exception e) {
                        h.markRollback();
                        throw e;
                    }
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static boolean tryLock(long orgId, long bookTypeId, long accountId, LockKey lockKey, LockHandler handler) {
        String book = orgId + "-" + bookTypeId + "-" + accountId;
        try (DLock lock = DLock.create((String)("fi/gl/" + (Object)((Object)lockKey) + "/" + book)).fastMode();){
            if (lock.tryLock()) {
                try (TXHandle h = TX.required((String)("fi_gl_" + (Object)((Object)lockKey)));){
                    try {
                        Lock.dbLock(book, lockKey);
                        handler.handle();
                    }
                    catch (Exception e) {
                        h.markRollback();
                        throw e;
                    }
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static void lock(long orgId, long bookTypeId, LockKey lockKey, LockHandler handler) {
        String book = orgId + "-" + bookTypeId;
        try (DLock lock = DLock.create((String)("fi/gl/" + (Object)((Object)lockKey) + "/" + book)).fastMode();){
            lock.lock();
            try (TXHandle h = TX.required((String)("fi_gl_" + (Object)((Object)lockKey)));){
                try {
                    handler.handle();
                }
                catch (Exception e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public static void dbLock(String book, LockKey lockKey) {
        DBRoute gl = DBRoute.of((String)"gl");
        if (!DB.execute((DBRoute)gl, (String)"update t_gl_transaction set fmodifytime = ? where fid= ?", (Object[])new Object[]{new Date(), (Object)((Object)lockKey) + "_" + book})) {
            DB.execute((DBRoute)gl, (String)"insert into t_gl_transaction(fid,fmodifytime) values(?,?)", (Object[])new Object[]{(Object)((Object)lockKey) + "_" + book, new Date()});
        }
    }

    private Lock() {
        throw new IllegalStateException("Utility class");
    }
}

