/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.notice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.notice.AbstractNoticeSender;
import kd.fi.gl.notice.NoticeTuple;
import kd.fi.gl.notice.NoticeUtils;
import kd.fi.gl.util.BatchProcessPipe;
import kd.fi.gl.util.GLUtil;

public class ACNoticeSender
extends AbstractNoticeSender {
    private static final String VOUCHER_SELECT = "id, creator, sourcetype, org, vouchertype.name vouchertype, billno, booktype, bookeddate, localcur, entries.id entryid, entries.account.acnotice acnotice, entries.assgrp assgrp, entries.seq seq, entries.account account, entries.entrydc entrydc, entries.currency currency, entries.debitori debitori, entries.creditori creditori, entries.debitlocal debitlocal, entries.creditlocal creditlocal, entries.edescription desc";
    private static final String ACCOUNT_NOTICE_FILTER = "acnotice = true and assgrp > 0";

    @Override
    public int excuteSend(List<Long> voucherIds) {
        final Map<Long, NoticeTuple> vchEntry2notice = NoticeUtils.batchGetNoticesByVoucherIds("gl_acnotice", voucherIds);
        DataSet voucherDataSet = this.filterVoucherIds(voucherIds);
        final Map<String, Map<Long, Map<Long, Date>>> receiveOrgs = this.getReceiveOrgs(voucherDataSet);
        final Map<Long, String> asspRecvTypes = this.getAsspRecvTypes(voucherDataSet);
        final ArrayList<Long> deleteEntryIds = new ArrayList<Long>();
        final ArrayList modifyEntryIds = new ArrayList();
        final Iterator rowItr = voucherDataSet.iterator();
        BatchProcessPipe<DynamicObject> noticeSavePipe = new BatchProcessPipe<DynamicObject>(new BatchProcessPipe.Producer<DynamicObject>(){

            @Override
            public List<DynamicObject> nextBatch() {
                return ACNoticeSender.this.dealNoticeByVoucherEntryRow((Row)rowItr.next(), receiveOrgs, vchEntry2notice, deleteEntryIds, modifyEntryIds, asspRecvTypes);
            }

            @Override
            public boolean hasNext() {
                return rowItr.hasNext();
            }
        }, saveList -> NoticeUtils.saveAndAutoCheckNotice("gl_acnotice", saveList), this.getBatchSaveSize());
        noticeSavePipe.run();
        HashSet<Long> hadSendNoticeEntryIds = new HashSet<Long>(vchEntry2notice.keySet());
        hadSendNoticeEntryIds.removeAll(modifyEntryIds);
        deleteEntryIds.addAll(hadSendNoticeEntryIds);
        if (!deleteEntryIds.isEmpty()) {
            NoticeUtils.deleteNoticeByVoucherEntryIds("gl_acnotice", deleteEntryIds);
        }
        return 0;
    }

    private List<DynamicObject> dealNoticeByVoucherEntryRow(Row entryRow, Map<String, Map<Long, Map<Long, Date>>> receiveOrgs, Map<Long, NoticeTuple> vchEntry2notice, List<Long> deleteEntryIds, List<Long> modifyEntryIds, Map<Long, String> sendTypes) {
        if (entryRow == null) {
            return null;
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(32);
        Long assgrpId = entryRow.getLong("assgrp");
        Long sendOrgId = entryRow.getLong("org");
        Date bookedDate = entryRow.getDate("bookeddate");
        Long accountId = entryRow.getLong("account");
        String type = sendTypes.get(accountId);
        Long receiveOrg = NoticeUtils.getReceiveOrgByAssgrpIdWithGivenType(receiveOrgs, assgrpId, sendOrgId, bookedDate, type);
        Long entryId = entryRow.getLong("entryid");
        if (receiveOrg == null) {
            deleteEntryIds.add(entryId);
            return saveList;
        }
        NoticeTuple oldNotices = vchEntry2notice.get(entryId);
        if (oldNotices != null) {
            modifyEntryIds.add(entryId);
            this.modifyOldNotices(entryRow, oldNotices, receiveOrg, saveList);
        } else {
            this.createNewNotices(entryRow, receiveOrg, saveList);
        }
        return saveList;
    }

    private void modifyOldNotices(Row entryRow, NoticeTuple oldNotices, Long receiveOrg, List<DynamicObject> saveList) {
        DynamicObject sendNotice = oldNotices.getSendNotice();
        if (sendNotice != null) {
            this.handleVoucherInfoToNotice(entryRow, sendNotice, Boolean.TRUE, receiveOrg, Boolean.TRUE);
        } else {
            sendNotice = BusinessDataServiceHelper.newDynamicObject((String)"gl_acnotice");
            this.handleVoucherInfoToNotice(entryRow, sendNotice, Boolean.TRUE, receiveOrg, Boolean.FALSE);
        }
        DynamicObject receiveNotice = oldNotices.getReceiveNotice();
        if (receiveNotice != null) {
            this.handleVoucherInfoToNotice(entryRow, receiveNotice, Boolean.FALSE, receiveOrg, Boolean.TRUE);
        } else {
            receiveNotice = BusinessDataServiceHelper.newDynamicObject((String)"gl_acnotice");
            this.handleVoucherInfoToNotice(entryRow, receiveNotice, Boolean.FALSE, receiveOrg, Boolean.FALSE);
        }
        saveList.add(sendNotice);
        saveList.add(receiveNotice);
    }

    private void createNewNotices(Row entryRow, Long receiveOrg, List<DynamicObject> saveList) {
        DynamicObject sendNotice = BusinessDataServiceHelper.newDynamicObject((String)"gl_acnotice");
        DynamicObject receiveNotice = BusinessDataServiceHelper.newDynamicObject((String)"gl_acnotice");
        this.handleVoucherInfoToNotice(entryRow, sendNotice, Boolean.TRUE, receiveOrg, Boolean.FALSE);
        this.handleVoucherInfoToNotice(entryRow, receiveNotice, Boolean.FALSE, receiveOrg, Boolean.FALSE);
        saveList.add(sendNotice);
        saveList.add(receiveNotice);
    }

    private void handleVoucherInfoToNotice(Row entryRow, DynamicObject notice, Boolean isSend, Long receiveOrg, Boolean isModify) {
        Object useId = entryRow.get("creator");
        notice.set("creator", useId);
        notice.set("modifier", useId);
        notice.set("auditor", useId);
        String voucherBillNo = entryRow.getString("vouchertype") + " " + entryRow.getString("billno");
        notice.set("billno", (Object)(voucherBillNo + entryRow.getString("seq")));
        Date bookDate = entryRow.getDate("bookeddate");
        notice.set("createtime", (Object)bookDate);
        notice.set("modifytime", (Object)bookDate);
        notice.set("auditdate", (Object)bookDate);
        notice.set("bookeddate", (Object)bookDate);
        notice.set("booktype", (Object)entryRow.getLong("booktype"));
        notice.set("account", (Object)entryRow.getLong("account"));
        String assgrp = GLUtil.assgrpId2String(entryRow.getLong("assgrp"));
        notice.set("assgrp", (Object)(NoticeUtils.getChineseStrLen(assgrp) > 85 ? assgrp.substring(0, 85) : assgrp));
        String dc = entryRow.getString("entrydc");
        notice.set("entrydc", (Object)dc);
        notice.set("desc", (Object)entryRow.getString("desc"));
        notice.set("currency", (Object)entryRow.getLong("currency"));
        String oriAmountField = "1".equals(dc) ? "debitori" : "creditori";
        notice.set("amount", (Object)entryRow.getBigDecimal(oriAmountField));
        notice.set("localcur", (Object)entryRow.getLong("localcur"));
        String locAmountField = "1".equals(dc) ? "debitlocal" : "creditlocal";
        notice.set("locamount", (Object)entryRow.getBigDecimal(locAmountField));
        Long sendOrg = entryRow.getLong("org");
        notice.set("sendorg", (Object)sendOrg);
        notice.set("receiveorg", (Object)receiveOrg);
        if (isSend.booleanValue()) {
            notice.set("org", (Object)sendOrg);
            notice.set("noticetype", (Object)"1");
            notice.set("peerorg", (Object)receiveOrg);
        } else {
            notice.set("org", (Object)receiveOrg);
            notice.set("noticetype", (Object)"0");
            notice.set("peerorg", (Object)sendOrg);
        }
        notice.set("voucher", (Object)entryRow.getLong("id"));
        notice.set("voucherentry", (Object)entryRow.getLong("entryid"));
        if (!isModify.booleanValue()) {
            notice.set("checkstatus", (Object)"0");
            notice.set("billstatus", (Object)"C");
            notice.set("checkout", (Object)"0");
        }
    }

    private DataSet filterVoucherIds(List<Long> voucherIds) {
        DataSet mainBookVoucherDataSet = NoticeUtils.getMainBookVoucherDataSet(voucherIds, VOUCHER_SELECT);
        return mainBookVoucherDataSet.filter(ACCOUNT_NOTICE_FILTER);
    }

    private Map<String, Map<Long, Map<Long, Date>>> getReceiveOrgs(DataSet voucherDataSet) {
        ArrayList<Long> assgrpIds = new ArrayList<Long>(10);
        voucherDataSet.copy().forEach(row -> assgrpIds.add(row.getLong("assgrp")));
        return NoticeUtils.batchGetOrgByAssgrp(assgrpIds);
    }

    private Map<Long, String> getAsspRecvTypes(DataSet voucherDataSet) {
        ArrayList<Long> accountIds = new ArrayList<Long>(10);
        voucherDataSet.copy().forEach(row -> accountIds.add(row.getLong("account")));
        return NoticeUtils.batchGetAsspRecvTypesByAccount(accountIds, "source");
    }
}

