/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.notice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.notice.AbstractNoticeSender;
import kd.fi.gl.notice.NoticeTuple;
import kd.fi.gl.notice.NoticeUtils;
import kd.fi.gl.util.BatchProcessPipe;

public class CFNoticeSender
extends AbstractNoticeSender {
    private static final String VOUCHER_SELECT = "id, creator, sourcetype, org, vouchertype.name vouchertype, billno, booktype, bookeddate, localcur, entries.id entryid, entries.maincfitem.notice notice, entries.maincfassgrp maincfassgrp, entries.seq seq, entries.maincfitem maincfitem, entries.maincfitem.direction direction, entries.maincfamount maincfamount, entries.edescription desc";
    private static final String CASHFLOW_NOTICE_FILTER = "notice = true and maincfassgrp > 0";

    @Override
    public int excuteSend(List<Long> voucherIds) {
        final Map<Long, NoticeTuple> vchEntry2notice = NoticeUtils.batchGetNoticesByVoucherIds("gl_cfnotice", voucherIds);
        DataSet voucherDataSet = this.filterVoucherIds(voucherIds);
        final Map<String, Map<Long, Map<Long, Date>>> receiveOrgs = this.getReceiveOrgs(voucherDataSet);
        final ArrayList<Long> deleteEntryIds = new ArrayList<Long>();
        final ArrayList modifyEntryIds = new ArrayList();
        final Iterator rowItr = voucherDataSet.iterator();
        BatchProcessPipe<DynamicObject> noticeSavePipe = new BatchProcessPipe<DynamicObject>(new BatchProcessPipe.Producer<DynamicObject>(){

            @Override
            public List<DynamicObject> nextBatch() {
                return CFNoticeSender.this.dealNoticeByVoucherEntryRow((Row)rowItr.next(), receiveOrgs, vchEntry2notice, deleteEntryIds, modifyEntryIds);
            }

            @Override
            public boolean hasNext() {
                return rowItr.hasNext();
            }
        }, saveList -> NoticeUtils.saveAndAutoCheckNotice("gl_cfnotice", saveList), this.getBatchSaveSize());
        noticeSavePipe.run();
        HashSet<Long> hadSendNoticeEntryIds = new HashSet<Long>(vchEntry2notice.keySet());
        hadSendNoticeEntryIds.removeAll(modifyEntryIds);
        deleteEntryIds.addAll(hadSendNoticeEntryIds);
        if (!deleteEntryIds.isEmpty()) {
            NoticeUtils.deleteNoticeByVoucherEntryIds("gl_cfnotice", deleteEntryIds);
        }
        return 0;
    }

    private List<DynamicObject> dealNoticeByVoucherEntryRow(Row entryRow, Map<String, Map<Long, Map<Long, Date>>> receiveOrgs, Map<Long, NoticeTuple> vchEntry2notice, List<Long> deleteEntryIds, List<Long> modifyEntryIds) {
        if (entryRow == null) {
            return null;
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(32);
        Long assgrpId = entryRow.getLong("maincfassgrp");
        Long sendOrgId = entryRow.getLong("org");
        Date bookedDate = entryRow.getDate("bookeddate");
        Long receiveOrg = NoticeUtils.getReceiveOrgByAssgrpId(receiveOrgs, assgrpId, sendOrgId, bookedDate);
        Long entryId = entryRow.getLong("entryid");
        if (receiveOrg == null) {
            deleteEntryIds.add(entryId);
            return saveList;
        }
        NoticeTuple oldNotices = vchEntry2notice.get(entryId);
        if (oldNotices != null) {
            modifyEntryIds.add(entryId);
            this.modifyOldNotices(entryRow, oldNotices, receiveOrg, saveList);
        } else {
            this.createNewNotices(entryRow, receiveOrg, saveList);
        }
        return saveList;
    }

    private void modifyOldNotices(Row entryRow, NoticeTuple oldNotices, Long receiveOrg, List<DynamicObject> saveList) {
        DynamicObject sendNotice = oldNotices.getSendNotice();
        if (sendNotice != null) {
            this.handleVoucherInfoToNotice(entryRow, sendNotice, Boolean.TRUE, receiveOrg, Boolean.TRUE);
        } else {
            sendNotice = BusinessDataServiceHelper.newDynamicObject((String)"gl_cfnotice");
            this.handleVoucherInfoToNotice(entryRow, sendNotice, Boolean.TRUE, receiveOrg, Boolean.FALSE);
        }
        DynamicObject receiveNotice = oldNotices.getReceiveNotice();
        if (receiveNotice != null) {
            this.handleVoucherInfoToNotice(entryRow, receiveNotice, Boolean.FALSE, receiveOrg, Boolean.TRUE);
        } else {
            receiveNotice = BusinessDataServiceHelper.newDynamicObject((String)"gl_cfnotice");
            this.handleVoucherInfoToNotice(entryRow, receiveNotice, Boolean.FALSE, receiveOrg, Boolean.FALSE);
        }
        saveList.add(sendNotice);
        saveList.add(receiveNotice);
    }

    private void createNewNotices(Row entryRow, Long receiveOrg, List<DynamicObject> saveList) {
        DynamicObject sendNotice = BusinessDataServiceHelper.newDynamicObject((String)"gl_cfnotice");
        DynamicObject receiveNotice = BusinessDataServiceHelper.newDynamicObject((String)"gl_cfnotice");
        this.handleVoucherInfoToNotice(entryRow, sendNotice, Boolean.TRUE, receiveOrg, Boolean.FALSE);
        this.handleVoucherInfoToNotice(entryRow, receiveNotice, Boolean.FALSE, receiveOrg, Boolean.FALSE);
        saveList.add(sendNotice);
        saveList.add(receiveNotice);
    }

    private void handleVoucherInfoToNotice(Row entryRow, DynamicObject notice, Boolean isSend, Long receiveOrg, Boolean isModify) {
        Object useId = entryRow.get("creator");
        notice.set("creator", useId);
        notice.set("modifier", useId);
        notice.set("auditor", useId);
        String voucherBillNo = entryRow.getString("vouchertype") + " " + entryRow.getString("billno");
        notice.set("billno", (Object)(voucherBillNo + entryRow.getString("seq")));
        Date bookDate = entryRow.getDate("bookeddate");
        notice.set("createtime", (Object)bookDate);
        notice.set("modifytime", (Object)bookDate);
        notice.set("auditdate", (Object)bookDate);
        notice.set("bookeddate", (Object)bookDate);
        notice.set("booktype", (Object)entryRow.getLong("booktype"));
        notice.set("maincfitem", (Object)entryRow.getLong("maincfitem"));
        notice.set("entrydc", (Object)entryRow.getString("direction"));
        notice.set("desc", (Object)entryRow.getString("desc"));
        notice.set("currency", (Object)entryRow.getLong("localcur"));
        notice.set("amount", (Object)entryRow.getBigDecimal("maincfamount"));
        Long sendOrg = entryRow.getLong("org");
        notice.set("sendorg", (Object)sendOrg);
        notice.set("receiveorg", (Object)receiveOrg);
        if (isSend.booleanValue()) {
            notice.set("org", (Object)sendOrg);
            notice.set("noticetype", (Object)"1");
            notice.set("peerorg", (Object)receiveOrg);
        } else {
            notice.set("org", (Object)receiveOrg);
            notice.set("noticetype", (Object)"0");
            notice.set("peerorg", (Object)sendOrg);
        }
        notice.set("voucher", (Object)entryRow.getLong("id"));
        notice.set("voucherentry", (Object)entryRow.getLong("entryid"));
        if (!isModify.booleanValue()) {
            notice.set("checkstatus", (Object)"0");
            notice.set("billstatus", (Object)"C");
            notice.set("checkout", (Object)"0");
        }
    }

    private DataSet filterVoucherIds(List<Long> voucherIds) {
        DataSet mainBookVoucherDataSet = NoticeUtils.getMainBookVoucherDataSet(voucherIds, VOUCHER_SELECT);
        return mainBookVoucherDataSet.filter(CASHFLOW_NOTICE_FILTER);
    }

    private Map<String, Map<Long, Map<Long, Date>>> getReceiveOrgs(DataSet voucherDataSet) {
        ArrayList<Long> assgrpIds = new ArrayList<Long>(10);
        voucherDataSet.copy().forEach(row -> assgrpIds.add(row.getLong("maincfassgrp")));
        return NoticeUtils.batchGetOrgByAssgrp(assgrpIds);
    }
}

