/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.notice;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.NoticeData;
import kd.fi.gl.enums.AccountBooksType;
import kd.fi.gl.notice.NoticeTriggerTiming;
import kd.fi.gl.notice.NoticeTuple;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.voucher.util.VoucherUtils;
import kd.sdk.fi.gl.extpoint.notice.INoticeVoucherIdsProvider;
import kd.sdk.fi.gl.extpoint.notice.INoticeVoucherSourceType;

public class NoticeUtils {
    private static final String ACCOUNTTYPE_SUFFIX = ".accounttype";
    private static final Log log = LogFactory.getLog((String)NoticeUtils.class.getName());
    private static final String HG = "hg";
    private static final String ASSVAL = "assval";
    private static final String ASSTYPE = "asstype";
    private static final String GL_ASSIST_BD = "gl_assist_bd";
    private static final String INTERNAL_COMPANY = "internal_company";
    private static final String BOOK_BEGINDATE = String.join((CharSequence)".", "startperiod", "begindate");

    private NoticeUtils() {
    }

    public static DataSet getMainBookVoucherDataSet(List<Long> voucherIds, String selectFields) {
        QFilter mainBookFilter = new QFilter("booktype.accounttype", "=", (Object)AccountBooksType.MAIN_BOOK.getValue());
        QFilter idFilter = new QFilter("id", "in", voucherIds);
        QFilter notBalanceCarryOver = new QFilter("sourcetype", "!=", (Object)"c");
        return QueryServiceHelper.queryDataSet((String)(NoticeUtils.class.getName() + ".getMainBookVoucherDataSet"), (String)"gl_voucher", (String)selectFields, (QFilter[])new QFilter[]{mainBookFilter, idFilter, notBalanceCarryOver}, (String)"id");
    }

    public static Map<String, Map<Long, Map<Long, Date>>> batchGetOrgByAssgrp(List<Long> assistIds) {
        if (assistIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, String> noticeSendFlexFields = NoticeUtils.getNoticeSendFlexFields();
        if (noticeSendFlexFields.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Map> entity2assistId2assistValues = new HashMap<String, Map>(NoticeData.getAcEntity().size());
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(ASSTYPE, "in", noticeSendFlexFields.keySet());
        qfBuilder.add(HG, "in", assistIds);
        try (DataSet assistValueSet = QueryServiceHelper.queryDataSet((String)NoticeUtils.class.getName(), (String)GL_ASSIST_BD, (String)String.join((CharSequence)",", HG, ASSTYPE, ASSVAL), (QFilter[])qfBuilder.toArray(), (String)HG);){
            assistValueSet.forEach(row -> {
                String entity = (String)noticeSendFlexFields.get(row.getString(ASSTYPE));
                entity2assistId2assistValues.compute(entity, (entityKey, assistId2assistValues) -> {
                    if (null == assistId2assistValues) {
                        assistId2assistValues = new HashMap<Long, List>(16);
                    }
                    assistId2assistValues.compute(row.getLong(HG), (assistIdKey, assistValues) -> {
                        if (null == assistValues) {
                            assistValues = new ArrayList<Long>(10);
                        }
                        assistValues.add(row.getLong(ASSVAL));
                        return assistValues;
                    });
                    return assistId2assistValues;
                });
            });
            HashMap<String, Map<Long, List<Long>>> entity2assistId2orgs = new HashMap<String, Map<Long, List<Long>>>(NoticeData.getAcEntity().size());
            entity2assistId2assistValues.forEach((entity, assistId2assistValues) -> {
                if (!"bos_org".equals(entity)) {
                    assistId2assistValues = NoticeUtils.castAssistValueToOrg(entity, assistId2assistValues);
                }
                if (!assistId2assistValues.isEmpty()) {
                    entity2assistId2orgs.put((String)entity, (Map<Long, List<Long>>)assistId2assistValues);
                }
            });
            if (entity2assistId2orgs.isEmpty()) {
                Map<String, Map<Long, Map<Long, Date>>> map = Collections.emptyMap();
                return map;
            }
            Map<String, Map<Long, Map<Long, Date>>> map = NoticeUtils.getMainBookOrgs(entity2assistId2orgs);
            return map;
        }
    }

    private static Map<Long, List<Long>> castAssistValueToOrg(String entityName, Map<Long, List<Long>> assistId2assistValues) {
        if (assistId2assistValues.isEmpty()) {
            return assistId2assistValues;
        }
        List allAssistValues = assistId2assistValues.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", allAssistValues);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)NoticeUtils.class.getName(), (String)entityName, (String)String.join((CharSequence)",", "id", INTERNAL_COMPANY), (QFilter[])qfBuilder.toArray(), (String)"id");){
            HashMap<Long, Long> assistValue2org = new HashMap<Long, Long>(allAssistValues.size());
            for (Row row : dataSet) {
                Long org = row.getLong(INTERNAL_COMPANY);
                if (null == org || org == 0L) continue;
                assistValue2org.put(row.getLong("id"), org);
            }
            if (assistValue2org.isEmpty()) {
                Map map = Collections.emptyMap();
                return map;
            }
            HashMap assistId2orgs = new HashMap(assistId2assistValues.size());
            for (Map.Entry<Long, List<Long>> entry : assistId2assistValues.entrySet()) {
                List<Long> assistValues = entry.getValue();
                List orgs = assistValues.stream().map(assistValue2org::get).filter(Objects::nonNull).collect(Collectors.toList());
                if (orgs.isEmpty()) continue;
                assistId2orgs.put(entry.getKey(), orgs);
            }
            HashMap hashMap = assistId2orgs;
            return hashMap;
        }
    }

    private static Map<String, Map<Long, Map<Long, Date>>> getMainBookOrgs(Map<String, Map<Long, List<Long>>> entity2assistId2orgs) {
        ArrayList<Long> allOrgIds = new ArrayList<Long>(10);
        for (Map<Long, List<Long>> assistId2orgs : entity2assistId2orgs.values()) {
            for (List<Long> orgs : assistId2orgs.values()) {
                allOrgIds.addAll(orgs);
            }
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("org", "in", allOrgIds);
        qfBuilder.add("isbizunit", "=", Boolean.TRUE);
        qfBuilder.add("enable", "=", Boolean.TRUE);
        qfBuilder.add("bookstype.accounttype", "=", AccountBooksType.MAIN_BOOK.getValue());
        HashMap<Long, Date> allOrg2date = new HashMap<Long, Date>(allOrgIds.size());
        DataSet accountBookSet = QueryServiceHelper.queryDataSet((String)NoticeUtils.class.getName(), (String)"gl_accountbook", (String)String.join((CharSequence)",", "org", BOOK_BEGINDATE), (QFilter[])qfBuilder.toArray(), null);
        Object object = null;
        try {
            allOrgIds.clear();
            for (Row row : accountBookSet) {
                Long orgId = row.getLong("org");
                if (orgId <= 0L) continue;
                allOrgIds.add(orgId);
                allOrg2date.put(orgId, row.getDate(BOOK_BEGINDATE));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (accountBookSet != null) {
                if (object != null) {
                    try {
                        accountBookSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    accountBookSet.close();
                }
            }
        }
        HashMap<String, Map<Long, Map<Long, Date>>> entity2assistId2org2date = new HashMap<String, Map<Long, Map<Long, Date>>>(entity2assistId2orgs.size());
        for (Map.Entry entry : entity2assistId2orgs.entrySet()) {
            Map assistId2orgs = (Map)entry.getValue();
            HashMap assistId2org2date = new HashMap(assistId2orgs.size());
            for (Map.Entry entry2 : assistId2orgs.entrySet()) {
                List orgs = (List)entry2.getValue();
                orgs.retainAll(allOrgIds);
                if (orgs.isEmpty()) continue;
                HashMap org2date = new HashMap(orgs.size());
                Iterator iterator = orgs.iterator();
                while (iterator.hasNext()) {
                    long org = (Long)iterator.next();
                    org2date.put(org, allOrg2date.get(org));
                }
                assistId2org2date.put(entry2.getKey(), org2date);
            }
            if (assistId2org2date.isEmpty()) continue;
            entity2assistId2org2date.put((String)entry.getKey(), assistId2org2date);
        }
        return entity2assistId2org2date;
    }

    private static Map<String, String> getNoticeSendFlexFields() {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("valuesource.number", "in", NoticeData.getAcEntity());
        qfBuilder.add("valuetype", "=", "1");
        DynamicObjectCollection dimensions = QueryServiceHelper.query((String)"bd_asstacttype", (String)String.join((CharSequence)",", "flexfield", "valuesource.number"), (QFilter[])qfBuilder.toArray());
        return dimensions.stream().collect(Collectors.toMap(x -> x.getString("flexfield"), x -> x.getString("valuesource.number")));
    }

    public static Map<Long, NoticeTuple> batchGetNoticesByVoucherIds(String noticeEntity, List<Long> voucherIds) {
        QFilter voucherIdFilter = new QFilter("voucher", "in", voucherIds);
        Map noticeDyns = BusinessDataServiceHelper.loadFromCache((String)noticeEntity, (QFilter[])voucherIdFilter.toArray());
        HashMap<Long, NoticeTuple> result = new HashMap<Long, NoticeTuple>(noticeDyns.size());
        noticeDyns.values().forEach(x -> {
            Long key = x.getLong("voucherentry");
            result.compute(key, (k, v) -> {
                if (v == null) {
                    v = new NoticeTuple();
                }
                if ("1".equals(x.getString("noticetype"))) {
                    v.setSendNotice((DynamicObject)x);
                } else {
                    v.setReceiveNotice((DynamicObject)x);
                }
                return v;
            });
        });
        return result;
    }

    public static Long getReceiveOrgByAssgrpId(Map<String, Map<Long, Map<Long, Date>>> receiveOrgs, Long assgrpId, Long sendOrgId, Date bookedDate) {
        Long receiveOrg = null;
        for (String type : NoticeData.getAcEntity()) {
            receiveOrg = NoticeUtils.getReceiveOrgByAssgrpIdAndEntityType(receiveOrgs, assgrpId, sendOrgId, type, bookedDate);
            if (receiveOrg == null) continue;
            return receiveOrg;
        }
        return receiveOrg;
    }

    public static Long getReceiveOrgByAssgrpIdWithGivenType(Map<String, Map<Long, Map<Long, Date>>> receiveOrgs, Long assgrpId, Long sendOrgId, Date bookedDate, String type) {
        if (type == null) {
            return null;
        }
        return NoticeUtils.getReceiveOrgByAssgrpIdAndEntityType(receiveOrgs, assgrpId, sendOrgId, type, bookedDate);
    }

    public static Map<Long, String> batchGetAsspRecvTypesByAccount(List<Long> accountIds, String prop) {
        if (accountIds == null || accountIds.isEmpty()) {
            return Collections.emptyMap();
        }
        log.info("batchGetAsspRecvTypesByAccount \u5165\u53c2,\u79d1\u76eeid: " + accountIds);
        HashMap<Long, String> asspRecvTypes = new HashMap<Long, String>(accountIds.size());
        String selectField = "id,checkitementry.asstactitem.valuesource.number source, checkitementry.asstactitem.flexfield flexfield";
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", accountIds);
        String orderBy = "checkitementry.seq";
        try (DataSet accountDataSet = QueryServiceHelper.queryDataSet((String)(NoticeUtils.class.getName() + "#batchGetAsspRecvTypesByAccount()"), (String)"bd_accountview", (String)selectField, (QFilter[])qfBuilder.toArray(), (String)orderBy);){
            List<String> acEntity = NoticeData.getAcEntity();
            accountDataSet.forEach(row -> {
                Long accountId;
                String sourceEntity = row.getString("source");
                if (acEntity.contains(sourceEntity) && !asspRecvTypes.containsKey(accountId = row.getLong("id"))) {
                    asspRecvTypes.put(accountId, row.getString(prop));
                }
            });
        }
        if (DebugTrace.enable()) {
            log.info("batchGetAsspRecvTypesByAccount \u8f93\u51fa: " + asspRecvTypes);
        }
        return asspRecvTypes;
    }

    private static Long getReceiveOrgByAssgrpIdAndEntityType(Map<String, Map<Long, Map<Long, Date>>> receiveOrgs, Long assgrpId, Long sendOrgId, String type, Date bookedDate) {
        log.info("getReceiveOrg \u5165\u53c2[\u6838\u7b97\u7ef4\u5ea6id,\u6838\u7b97\u7ef4\u5ea6\u503c\u6765\u6e90]: [" + assgrpId + "," + type + "]");
        Map<Long, Map<Long, Date>> hg2org2date = receiveOrgs.get(type);
        if (hg2org2date == null) {
            return null;
        }
        Map<Long, Date> org2date = hg2org2date.get(assgrpId);
        if (org2date == null) {
            return null;
        }
        log.info("getReceiveOrg \u5185\u90e8\u5355\u5143id: " + org2date);
        for (Map.Entry<Long, Date> entry : org2date.entrySet()) {
            Long org = entry.getKey();
            Date date = entry.getValue();
            if (sendOrgId.equals(org) || date == null || bookedDate.compareTo(date) < 0) continue;
            return org;
        }
        return null;
    }

    public static void deleteNoticeByVoucherEntryIds(String entityName, List<Long> entryIds) {
        QFilter filter = new QFilter("voucherentry", "in", entryIds);
        NoticeUtils.deleteNotice(entityName, filter.toArray());
    }

    public static void deleteNoticeByVoucherIds(String entityName, List<Long> voucherIds) {
        QFilter filter = new QFilter("voucher", "in", voucherIds);
        NoticeUtils.deleteNotice(entityName, filter.toArray());
    }

    private static void deleteNotice(String entityName, QFilter[] filters) {
        List noticeIds = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])filters, null, (int)-1);
        if (!noticeIds.isEmpty()) {
            OperationServiceHelper.executeOperate((String)"delete", (String)entityName, (Object[])noticeIds.toArray(), (OperateOption)OperateOption.create());
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityName), (Object[])noticeIds.toArray());
        }
    }

    public static int saveAndAutoCheckNotice(String entityName, List<DynamicObject> notices) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)entityName, (DynamicObject[])notices.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        List successPkIds = operationResult.getSuccessPkIds();
        OperateOption option = OperateOption.create();
        option.setVariableValue("checktype", "checktype_semi_auto");
        OperationServiceHelper.executeOperate((String)"checkstatus", (String)entityName, (Object[])successPkIds.toArray(new Object[0]), (OperateOption)option);
        return successPkIds.size();
    }

    public static List<Long> getTheOtherCheckVoucherIds(long ownNoticeEntryId, String checkLogEntity) {
        ArrayList<Long> theOtherCheckVoucherIds = new ArrayList<Long>(10);
        QFilter entryIdFilter = new QFilter(NoticeData.ENTRY_ID_FIELD, "=", (Object)ownNoticeEntryId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)NoticeUtils.class.getName(), (String)checkLogEntity, (String)NoticeData.OP_VOUCHER_ID_FIELD, (QFilter[])entryIdFilter.toArray(), null);){
            for (Row row : ds) {
                theOtherCheckVoucherIds.add(row.getLong(NoticeData.OP_VOUCHER_ID_FIELD));
            }
        }
        if (theOtherCheckVoucherIds.isEmpty()) {
            QFilter opEntryIdFilter = new QFilter(NoticeData.OP_ENTRY_ID_FIELD, "=", (Object)ownNoticeEntryId);
            DataSet ds = QueryServiceHelper.queryDataSet((String)NoticeUtils.class.getName(), (String)checkLogEntity, (String)NoticeData.VOUCHER_ID_FIELD, (QFilter[])opEntryIdFilter.toArray(), null);
            Object object = null;
            try {
                for (Row row : ds) {
                    theOtherCheckVoucherIds.add(row.getLong(NoticeData.VOUCHER_ID_FIELD));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        return theOtherCheckVoucherIds;
    }

    public static Set<Long> getNoticeCheckedVoucherIdSet(Collection<Long> voucherIds) {
        if (CollectionUtils.isEmpty(voucherIds)) {
            return Collections.emptySet();
        }
        HashSet<Long> voucherIdSet = new HashSet<Long>(voucherIds);
        voucherIdSet.remove(0L);
        HashSet<Long> checkedVoucherIdSet = new HashSet<Long>(voucherIdSet.size());
        QFilter checkedFilter = new QFilter("voucher", "in", voucherIdSet).and(new QFilter("checkstatus", "=", (Object)"1"));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)NoticeUtils.class.getName(), (String)"gl_acnotice", (String)"voucher", (QFilter[])checkedFilter.toArray(), null);){
            for (Row row : ds) {
                checkedVoucherIdSet.add(row.getLong("voucher"));
            }
        }
        if (CollectionUtils.isEmpty(voucherIdSet)) {
            return checkedVoucherIdSet;
        }
        ds = QueryServiceHelper.queryDataSet((String)NoticeUtils.class.getName(), (String)"gl_cfnotice", (String)"voucher", (QFilter[])checkedFilter.toArray(), null);
        var5_5 = null;
        try {
            for (Row row : ds) {
                checkedVoucherIdSet.add(row.getLong("voucher"));
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var5_5 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        return checkedVoucherIdSet;
    }

    public static <T> List<List<T>> splitList(List<T> list, int len) {
        int size = list.size();
        int count = (size + len - 1) / len;
        ArrayList<List<T>> result = new ArrayList<List<T>>(count);
        for (int i = 0; i < count; ++i) {
            List<T> subList = list.subList(i * len, Math.min((i + 1) * len, size));
            result.add(subList);
        }
        return result;
    }

    public static List<String> getNonNoticeVchs(List<String> status, Long orgId) {
        QFBuilder qfBuilder = new QFBuilder();
        String selectProperties = "entries.account,billno, entries.assgrp ";
        long mainBookTypeId = AccSysUtil.getMainBookTypeId();
        long curPeriodId = new AccountBookInfo(orgId, mainBookTypeId).getCurPeriodId();
        qfBuilder.add("booktype.id", "=", mainBookTypeId);
        qfBuilder.add("billstatus", "in", status);
        qfBuilder.add("org.id", "=", orgId);
        qfBuilder.add("period.id", ">=", curPeriodId);
        if (status.contains(NoticeTriggerTiming.AUDIT.getValue())) {
            qfBuilder.add("ispost", "=", "0");
        }
        DynamicObject[] vouchers = BusinessDataServiceHelper.load((String)"gl_voucher", (String)selectProperties, (QFilter[])qfBuilder.toArray());
        return NoticeUtils.filterNoAcnoticeVchs(vouchers);
    }

    public static List<String> filterNoAcnoticeVchs(DynamicObject[] vchs) {
        if (vchs == null || vchs.length == 0) {
            return Collections.emptyList();
        }
        List<DynamicObject> entryList = Arrays.stream(vchs).flatMap(x -> x.getDynamicObjectCollection("entries").stream()).filter(x -> x.getBoolean("account.acnotice")).collect(Collectors.toList());
        List<Long> accounts = entryList.stream().map(x -> x.getLong("account_id")).distinct().collect(Collectors.toList());
        List assgrps = entryList.stream().map(x -> x.getLong("assgrp_id")).collect(Collectors.toList());
        Map<Long, String> acc2flex = NoticeUtils.batchGetAsspRecvTypesByAccount(accounts, "flexfield");
        HashMap flex2AssIds = new HashMap(16);
        HashBasedTable table = HashBasedTable.create();
        BusinessDataServiceHelper.loadFromCache((String)GL_ASSIST_BD, (String)"hg_id,asstype,assval", (QFilter[])new QFilter[]{new QFilter("hg_id", "in", assgrps)}).values().forEach(arg_0 -> NoticeUtils.lambda$filterNoAcnoticeVchs$13(acc2flex, (Table)table, flex2AssIds, arg_0));
        HashMap<String, String> flex2source = new HashMap<String, String>(16);
        BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (String)"flexfield, valuesource.number", (QFilter[])new QFilter[]{new QFilter("flexfield", "in", flex2AssIds.keySet())}).values().forEach(result -> flex2source.put(result.getString("flexfield"), result.getString("valuesource.number")));
        HashSet legalAssIds = new HashSet(32);
        flex2source.forEach((flex, source) -> {
            List ids = (List)flex2AssIds.get(flex);
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("id", "in", ids);
            if (!source.equals("bos_org") && !source.equals("bos_adminorg")) {
                qfBuilder.add(INTERNAL_COMPANY, "!=", 0L);
            }
            legalAssIds.addAll(BusinessDataServiceHelper.loadFromCache((String)source, (String)"id", (QFilter[])qfBuilder.toArray()).values().stream().map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toSet()));
        });
        HashSet illegalEntryIds = new HashSet(64);
        entryList.forEach(arg_0 -> NoticeUtils.lambda$filterNoAcnoticeVchs$16(acc2flex, (Table)table, legalAssIds, illegalEntryIds, arg_0));
        Set legalEntryIds = Arrays.stream(BusinessDataServiceHelper.load((String)"gl_acnotice", (String)"voucherentry", (QFilter[])new QFilter[]{new QFilter("voucherentry", "in", illegalEntryIds)})).map(x -> x.getLong("voucherentry")).collect(Collectors.toSet());
        illegalEntryIds.removeAll(legalEntryIds);
        ArrayList<String> illegalVchNos = new ArrayList<String>(vchs.length);
        block0: for (DynamicObject vch : vchs) {
            DynamicObjectCollection entries = vch.getDynamicObjectCollection("entries");
            for (DynamicObject row : entries) {
                if (!illegalEntryIds.contains((Long)row.getPkValue())) continue;
                illegalVchNos.add(vch.getString("billno"));
                continue block0;
            }
        }
        return illegalVchNos;
    }

    public static int getChineseStrLen(String str) {
        int ULen = 0;
        try {
            ULen = str.getBytes("utf-8").length;
        }
        catch (UnsupportedEncodingException e) {
            log.error(ResManager.loadKDString((String)"\u83b7\u53d6\u5b57\u7b26\u4e32\u5b57\u8282\u957f\u5ea6\u51fa\u9519\u3002", (String)"AbstractNoticeCheckService_3", (String)"fi-gl-opplugin", (Object[])new Object[0]) + GLUtil.printError(e));
        }
        int len = str.length();
        int CLen = (ULen - len) / 2;
        return CLen + (len - CLen + 1) / 2;
    }

    public static NoticeTriggerTiming getTriggerTiming(Long orgId) {
        return NoticeUtils.batchGetTriggerTiming(new Long[]{orgId}).get(orgId);
    }

    public static Map<Long, NoticeTriggerTiming> batchGetTriggerTiming(Long[] orgIds) {
        return GLUtil.batchGetSystemParam("timetosend", orgIds, NoticeTriggerTiming.SUBMIT.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> NoticeTriggerTiming.fromValue(String.valueOf(e.getValue()))));
    }

    public static Set<Long> preFilterVouchersForNotice(DynamicObject[] voucherDynArray, String voucherAction) {
        if (ArrayUtils.isEmpty((Object[])voucherDynArray) || voucherAction == null) {
            return Collections.emptySet();
        }
        DynamicProperty sourceTypeProp = voucherDynArray[0].getDynamicObjectType().getProperty("sourcetype");
        Map<Long, List<DynamicObject>> orgIdVoucherDynsMap = VoucherUtils.groupVoucherDynsByOrg(voucherDynArray);
        Map<Long, NoticeTriggerTiming> orgIdTimingMap = NoticeUtils.batchGetTriggerTiming(orgIdVoucherDynsMap.keySet().toArray(new Long[0]));
        orgIdVoucherDynsMap.entrySet().removeIf(e -> !((NoticeTriggerTiming)((Object)((Object)orgIdTimingMap.get(e.getKey())))).getTriggerOperationKeys().contains(voucherAction));
        HashSet<String> noSendSourceTypes = new HashSet<String>(1);
        noSendSourceTypes.add("1");
        noSendSourceTypes.addAll(NoticeUtils.addExtendPluginSourceTypes());
        Set<Long> sourceTypeFilterIdSet = orgIdVoucherDynsMap.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream()).filter(v -> !noSendSourceTypes.contains(sourceTypeProp.getValueFast(v))).map(v -> (Long)v.getPkValue()).collect(Collectors.toSet());
        Set<Long> customFilterVchIdSet = NoticeUtils.extendPluginVchIdsFilter(sourceTypeFilterIdSet);
        sourceTypeFilterIdSet.retainAll(customFilterVchIdSet);
        return sourceTypeFilterIdSet;
    }

    public static Set<String> addExtendPluginSourceTypes() {
        PluginProxy pluginProxy = PluginProxy.create(null, INoticeVoucherSourceType.class, (String)"kd.sdk.fi.gl.extpoint.notice.INoticeVoucherSourceType.noSendType", null);
        List sourceTypesList = pluginProxy.callReplace(INoticeVoucherSourceType::noSendNoticeSourceType);
        HashSet<String> extendNoSendSourceTypes = new HashSet<String>(2);
        if (!sourceTypesList.isEmpty()) {
            extendNoSendSourceTypes.addAll(sourceTypesList.stream().flatMap(Collection::stream).collect(Collectors.toSet()));
            if (DebugTrace.enable()) {
                log.info("noSendNotice_voucherSourceTypes:{}", (Object)((Object)extendNoSendSourceTypes).toString());
            }
        }
        return extendNoSendSourceTypes;
    }

    public static Set<Long> extendPluginVchIdsFilter(Set<Long> sourceTypeFilterIdSet) {
        PluginProxy pluginProxy = PluginProxy.create(null, INoticeVoucherIdsProvider.class, (String)"kd.sdk.fi.gl.extpoint.notice.INoticeVoucherIdsProvider.customFilterVchIds", null);
        List customFilterVchIds = pluginProxy.callReplace(p -> p.customFilterVchIds(sourceTypeFilterIdSet));
        if (!customFilterVchIds.isEmpty()) {
            Set<Long> customFilterVchIdSet = customFilterVchIds.stream().flatMap(Collection::stream).collect(Collectors.toSet());
            if (DebugTrace.enable()) {
                log.info("noSendNotice_sourceTypeFilterIdSet:{}\uff0ccustomFilterVchIds\uff1a{}", (Object)sourceTypeFilterIdSet.toString(), (Object)customFilterVchIdSet.toString());
            }
            return customFilterVchIdSet;
        }
        return sourceTypeFilterIdSet;
    }

    private static /* synthetic */ void lambda$filterNoAcnoticeVchs$16(Map acc2flex, Table table, Set legalAssIds, Set illegalEntryIds, DynamicObject entry) {
        long accountId = entry.getLong("account_id");
        long assgrpId = entry.getLong("assgrp_id");
        String flexfield = (String)acc2flex.get(accountId);
        Long assval = (Long)table.get((Object)assgrpId, (Object)flexfield);
        if (legalAssIds.contains(assval)) {
            illegalEntryIds.add((Long)entry.getPkValue());
        }
    }

    private static /* synthetic */ void lambda$filterNoAcnoticeVchs$13(Map acc2flex, Table table, Map flex2AssIds, DynamicObject result) {
        String flexField = result.getString(ASSTYPE);
        if (!acc2flex.containsValue(flexField)) {
            return;
        }
        long hg_id = result.getLong("hg_id");
        long assval = result.getLong(ASSVAL);
        table.put((Object)hg_id, (Object)flexField, (Object)assval);
        if (flex2AssIds.containsKey(flexField)) {
            ((List)flex2AssIds.get(flexField)).add(assval);
        } else {
            ArrayList<Long> assIds = new ArrayList<Long>(20);
            assIds.add(assval);
            flex2AssIds.put(flexField, assIds);
        }
    }
}

