/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.reciprocal.RcpWriteOffUtils;
import kd.fi.gl.reciprocal.ReciprocalContext;
import kd.fi.gl.reciprocal.ReciprocalRecord;
import kd.fi.gl.reciprocal.ReciprocalScheme;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.util.MultiIndexTreeCache;

public class FifoAutoWriteOffService {
    private static final Log logger = LogFactory.getLog(FifoAutoWriteOffService.class);
    private DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.writeoff);
    private static final String SELECTFIELDS = "id, org.id org, booktype.id booktype, accounttable.id accounttable, period.id period, account.id account, assgrp.id assgrp, assgrp.value assval, currency.id currency,amountfor,amountbalfor,localcurrency,amount,amountbal,masterid,voucherid,voucherentry";
    private static final String[] SELECTFIELDSALIAS = new String[]{"id", "org", "booktype", "accounttable", "period", "account", "assgrp", "assval", "currency", "amountfor", "amountbalfor", "localcurrency", "amount", "amountbal", "masterid"};
    private static final String UPDATE_ACCCURRENT_SQL = "UPDATE T_GL_ACCCURRENT SET FAMOUNTBAL=?, FAMOUNTBALFOR=?, FSTATUS=?, FMODIFYTIME=?, FWRITEOFFPERSONID=? WHERE FMASTERID=?";
    private ReciprocalContext ctx;

    public FifoAutoWriteOffService(ReciprocalContext context) {
        this.ctx = context;
    }

    public void autoWriteOff() {
        List<QFilter> filters = this.getFilters(this.ctx.getScheme());
        filters.add(this.getPermQFilter(this.ctx));
        MultiIndexTreeCache<Map<String, ThreeTuple<Integer, BigDecimal, BigDecimal>>> groupByMinAmt = this.getMinAmt(filters);
        DataSet filterVoucherDt = ReciprocalUtils.getFilterVoucherDt(this.ctx.getScheme());
        DataSet ds = QueryServiceHelper.queryDataSet((String)"FifoAutoWriteOffService.autoWriteOff", (String)"gl_acccurrent", (String)SELECTFIELDS, (QFilter[])filters.toArray(new QFilter[0]), (String)" account asc, assgrp asc, currency asc, bizdate asc, id asc");
        if (filterVoucherDt != null) {
            ds = ds.join(filterVoucherDt).on("voucherid", "fvoucherid").on("voucherentry", "vchentryid").select(SELECTFIELDSALIAS).finish();
        }
        LinkedList<ReciprocalRecord> buyerQueue = new LinkedList<ReciprocalRecord>();
        LinkedList<ReciprocalRecord> writeoffQueue = new LinkedList<ReciprocalRecord>();
        while (ds.hasNext()) {
            Row row = ds.next();
            ReciprocalRecord curRecord = this.getRecord(row);
            this.writeOff(curRecord, buyerQueue, writeoffQueue, groupByMinAmt);
            if (this.ctx.getReciprocalLogs().size() <= 1000 && (ds.hasNext() || this.ctx.getReciprocalLogs().size() <= 0)) continue;
            RcpWriteOffUtils.saveReciprocalLog(this.ctx);
            this.reWriteReciprocalRecord(this.ctx);
        }
        this.delBalZeroRecords();
    }

    private void writeOff(ReciprocalRecord curRecord, Queue<ReciprocalRecord> buyerQueue, Queue<ReciprocalRecord> writeoffQueue, MultiIndexTreeCache<Map<String, ThreeTuple<Integer, BigDecimal, BigDecimal>>> groupByMinAmt) {
        Object[] baseKey = new Object[]{curRecord.getAccount(), curRecord.getAssgrp(), curRecord.getCurrency()};
        Map<String, ThreeTuple<Integer, BigDecimal, BigDecimal>> retrieval = groupByMinAmt.retrieval(baseKey);
        if (Objects.isNull(retrieval)) {
            return;
        }
        ThreeTuple<Integer, BigDecimal, BigDecimal> buyer = retrieval.get("buyer");
        if (Objects.isNull(buyer)) {
            return;
        }
        if (((BigDecimal)buyer.item2).compareTo(BigDecimal.ZERO) == 0 && ((BigDecimal)buyer.item3).compareTo(BigDecimal.ZERO) == 0) {
            retrieval.put("buyer", null);
        }
        if (curRecord.getAmountBalFor().compareTo(BigDecimal.ZERO) >= 0 && curRecord.getAmount().compareTo(BigDecimal.ZERO) >= 0) {
            buyerQueue.add(curRecord);
            this.loopWriteOff(curRecord, writeoffQueue, buyerQueue);
        } else if (curRecord.getAmountBalFor().compareTo(BigDecimal.ZERO) <= 0 && curRecord.getAmount().compareTo(BigDecimal.ZERO) <= 0) {
            writeoffQueue.add(curRecord);
            this.loopWriteOff(curRecord, buyerQueue, writeoffQueue);
        } else {
            buyerQueue.add(curRecord);
            writeoffQueue.add(curRecord);
            this.loopWriteOff(curRecord, buyerQueue, writeoffQueue);
            this.loopWriteOff(curRecord, writeoffQueue, buyerQueue);
        }
        if (curRecord.getAmountBalFor().compareTo(BigDecimal.ZERO) <= 0 || curRecord.getAmountBal().compareTo(BigDecimal.ZERO) <= 0) {
            BigDecimal remainAmtBalFor = BigDecimal.ZERO;
            if (curRecord.getAmountBalFor().compareTo(BigDecimal.ZERO) <= 0) {
                remainAmtBalFor = ((BigDecimal)buyer.item2).subtract(curRecord.getAmountFor().abs().subtract(curRecord.getAmountBalFor().abs()));
            }
            BigDecimal remainAmtBal = BigDecimal.ZERO;
            if (curRecord.getAmountBal().compareTo(BigDecimal.ZERO) <= 0) {
                remainAmtBal = ((BigDecimal)buyer.item3).subtract(curRecord.getAmount().abs().subtract(curRecord.getAmountBal().abs()));
            }
            retrieval.put("buyer", (ThreeTuple<Integer, BigDecimal, BigDecimal>)new ThreeTuple(buyer.item1, (Object)remainAmtBalFor, (Object)remainAmtBal));
        }
    }

    private void loopWriteOff(ReciprocalRecord curRecord, Queue<ReciprocalRecord> queue, Queue<ReciprocalRecord> negateQueue) {
        ReciprocalRecord firstRecord;
        LinkedList<ReciprocalRecord> noWfRecordQueue = new LinkedList<ReciprocalRecord>();
        while (!Objects.isNull(firstRecord = queue.peek())) {
            if (firstRecord.getId().equals(curRecord.getId()) || !firstRecord.getBaseKey().equals(curRecord.getBaseKey())) {
                queue.remove(firstRecord);
                noWfRecordQueue.add(firstRecord);
                continue;
            }
            if (RcpWriteOffUtils.isZeroByMultiply(firstRecord.getAmountBalFor(), curRecord.getAmountBalFor()) && RcpWriteOffUtils.isSameDc(firstRecord.getAmountBal(), curRecord.getAmountBal()).booleanValue() || RcpWriteOffUtils.isZeroByMultiply(firstRecord.getAmountBal(), curRecord.getAmountBal()) && RcpWriteOffUtils.isSameDc(firstRecord.getAmountBalFor(), curRecord.getAmountBalFor()).booleanValue()) {
                queue.remove(firstRecord);
                noWfRecordQueue.add(firstRecord);
                continue;
            }
            if (RcpWriteOffUtils.isZero(curRecord.getAmountBalFor().multiply(firstRecord.getAmountBalFor())) && RcpWriteOffUtils.isZero(curRecord.getAmountBal().multiply(firstRecord.getAmountBal()))) {
                queue.remove(firstRecord);
                noWfRecordQueue.add(firstRecord);
                continue;
            }
            this.doWriteOff(queue, negateQueue, firstRecord, curRecord);
        }
        if (noWfRecordQueue.size() > 0) {
            queue.addAll(noWfRecordQueue);
        }
    }

    private void doWriteOff(Queue<ReciprocalRecord> buyerQueue, Queue<ReciprocalRecord> writeoffQueue, ReciprocalRecord firstRecord, ReciprocalRecord curRecord) {
        RcpWriteOffUtils.generateWriteOffLog(firstRecord, curRecord, this.ctx, Boolean.FALSE);
        if (curRecord.getAmountBalFor().compareTo(BigDecimal.ZERO) == 0 && curRecord.getAmountBal().compareTo(BigDecimal.ZERO) == 0) {
            buyerQueue.remove(curRecord);
            writeoffQueue.remove(curRecord);
        }
        if (firstRecord.getAmountBalFor().compareTo(BigDecimal.ZERO) == 0 && firstRecord.getAmountBal().compareTo(BigDecimal.ZERO) == 0) {
            buyerQueue.remove(firstRecord);
            writeoffQueue.remove(firstRecord);
        }
        this.delBalZeroRecords();
    }

    public ReciprocalRecord getRecord(Row row) {
        ReciprocalRecord record = new ReciprocalRecord();
        record.setId(row.getLong("id"));
        record.setMasterId(row.getLong("masterid"));
        record.setOrg(row.getLong("org"));
        record.setBookType(row.getLong("booktype"));
        record.setAccountTable(row.getLong("accounttable"));
        record.setAccount(row.getLong("account"));
        record.setAssgrp(row.getLong("assgrp"));
        String assgrpVal = row.getString("assval");
        if (StringUtils.isNotEmpty((String)assgrpVal)) {
            record.setAssgrpVals((Map<String, Object>)JSONObject.parseObject((String)assgrpVal));
        }
        record.setCurrency(row.getLong("currency"));
        record.setAmountFor(row.getBigDecimal("amountfor"));
        record.setAmountBalFor(row.getBigDecimal("amountbalfor"));
        record.setLocalCurrency(row.getLong("localcurrency"));
        record.setAmount(row.getBigDecimal("amount"));
        record.setAmountBal(row.getBigDecimal("amountbal"));
        record.setPeriod(row.getLong("period"));
        return record;
    }

    private MultiIndexTreeCache<Map<String, ThreeTuple<Integer, BigDecimal, BigDecimal>>> getMinAmt(List<QFilter> filters) {
        MultiIndexTreeCache<Map<String, ThreeTuple<Integer, BigDecimal, BigDecimal>>> groupByAmt = new MultiIndexTreeCache<Map<String, ThreeTuple<Integer, BigDecimal, BigDecimal>>>("fifoAutoWriteAmt_groupByAmt", 1000000);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"LoadRcpRecordUtils.splitWriteOffRecords", (String)"gl_acccurrent", (String)SELECTFIELDS, (QFilter[])filters.toArray(new QFilter[0]), null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                ReciprocalRecord record = this.getRecord(row);
                if (record.getAmountBalFor().compareTo(BigDecimal.ZERO) < 0 && record.getAmountBal().compareTo(BigDecimal.ZERO) < 0) continue;
                this.buyerAmt(record, groupByAmt, "buyer");
            }
        }
        return groupByAmt;
    }

    private void buyerAmt(ReciprocalRecord record, MultiIndexTreeCache<Map<String, ThreeTuple<Integer, BigDecimal, BigDecimal>>> groupByAmt, String type) {
        BigDecimal amtbal;
        Object[] dimensionKey = new Object[]{record.getAccount(), record.getAssgrp(), record.getCurrency()};
        Map<String, ThreeTuple<Integer, BigDecimal, BigDecimal>> retrieval = groupByAmt.retrieval(dimensionKey);
        Integer amtDc = record.getAmountBalFor().compareTo(BigDecimal.ZERO) > 0 ? 1 : -1;
        BigDecimal amtbalFor = record.getAmountBalFor().compareTo(BigDecimal.ZERO) > 0 ? record.getAmountBalFor() : BigDecimal.ZERO;
        BigDecimal bigDecimal = amtbal = record.getAmountBal().compareTo(BigDecimal.ZERO) > 0 ? record.getAmountBal() : BigDecimal.ZERO;
        if (Objects.isNull(retrieval)) {
            retrieval = new HashMap<String, ThreeTuple<Integer, BigDecimal, BigDecimal>>(2);
            retrieval.put(type, (ThreeTuple<Integer, BigDecimal, BigDecimal>)new ThreeTuple((Object)amtDc, (Object)amtbalFor, (Object)amtbal));
            groupByAmt.addData(retrieval, dimensionKey);
        } else {
            ThreeTuple<Integer, BigDecimal, BigDecimal> threeTuple = retrieval.get(type);
            if (Objects.isNull(threeTuple)) {
                retrieval.put(type, (ThreeTuple<Integer, BigDecimal, BigDecimal>)new ThreeTuple((Object)amtDc, (Object)amtbalFor, (Object)amtbal));
            } else {
                retrieval.put(type, (ThreeTuple<Integer, BigDecimal, BigDecimal>)new ThreeTuple((Object)amtDc, (Object)((BigDecimal)threeTuple.item2).add(amtbalFor), (Object)((BigDecimal)threeTuple.item3).add(amtbal)));
            }
        }
    }

    private List<QFilter> getFilters(ReciprocalScheme scheme) {
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>();
        lstFilters.add(new QFilter("org", "=", (Object)scheme.getOrg()));
        lstFilters.add(new QFilter("booktype", "=", (Object)scheme.getBookType()));
        if (scheme.getAccountList().size() > 0) {
            lstFilters.add(new QFilter("account", "in", scheme.getAccountList()));
        }
        if (scheme.getWriteOffType() == 1 && scheme.getAccountListFromPage() != null && !scheme.getAccountListFromPage().isEmpty()) {
            lstFilters.add(new QFilter("account", "in", scheme.getAccountListFromPage()));
        }
        if (scheme.getCurrencyList().size() > 0) {
            lstFilters.add(new QFilter("currency", "in", scheme.getCurrencyList()));
        }
        lstFilters.add(new QFilter("status", "in", Arrays.asList("0", "1")));
        lstFilters.add(new QFilter("uneffectivedate", "=", (Object)BalanceTransferUtils.getEndDate()));
        if (scheme.getAssgrpIdList() != null && scheme.getAssgrpIdList().size() > 0) {
            lstFilters.add(new QFilter("assgrp", "in", scheme.getAssgrpIdList()));
        }
        if (scheme.getReciprocalIdList() != null && scheme.getReciprocalIdList().size() > 0) {
            lstFilters.add(new QFilter("id", "in", scheme.getReciprocalIdList()));
        }
        QFilter periodFilter = null;
        if (scheme.getStartPeriod() != null && scheme.getStartPeriod() > 0L) {
            periodFilter = new QFilter("period", ">=", (Object)scheme.getStartPeriod());
        }
        if (scheme.getEndPeriod() != null && scheme.getEndPeriod() > 0L) {
            if (periodFilter != null) {
                periodFilter.and(new QFilter("period", "<=", (Object)scheme.getEndPeriod()));
            } else {
                periodFilter = new QFilter("period", "<=", (Object)scheme.getEndPeriod());
            }
        }
        if (periodFilter != null) {
            lstFilters.add(periodFilter);
        }
        return lstFilters;
    }

    protected void reWriteReciprocalRecord(ReciprocalContext context) {
        List<ReciprocalRecord> lstSuccessRecords = context.getSuccessRecords();
        Date modifyDate = TimeServiceHelper.now();
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(1024);
        Long zeroId = 0L;
        for (ReciprocalRecord record : lstSuccessRecords) {
            if (zeroId.equals(record.getMasterId())) continue;
            updateParams.add(new Object[]{record.getAmountBal(), record.getAmountBalFor(), record.getStatus(), modifyDate, context.getWriter(), record.getMasterId()});
        }
        if (!updateParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)UPDATE_ACCCURRENT_SQL, updateParams);
            lstSuccessRecords.clear();
        }
    }

    private void delBalZeroRecords() {
        List<ReciprocalRecord> balZeroRecords = this.ctx.getBalZeroRecords();
        if (this.ctx.getScheme().getWriteOffType() == 1) {
            String key = this.ctx.getScheme().getOrg() + "" + this.ctx.getScheme().getBookType() + "haswriteoffcount";
            String writeOffCount = this.cache.get(key);
            int num = StringUtils.isEmpty((String)writeOffCount) ? 0 : Integer.parseInt(writeOffCount);
            this.cache.put(key, num + this.ctx.getSuccessWriteOffSize().get() + "");
        }
        Set excludeIds = null;
        if (this.ctx.IsSimulate().booleanValue()) {
            excludeIds = balZeroRecords.stream().filter(x -> x.getAmountBal().compareTo(BigDecimal.ZERO) != 0).map(x -> x.getId()).collect(Collectors.toSet());
        }
        this.ctx.removeRecords(balZeroRecords, excludeIds);
        balZeroRecords.clear();
    }

    private QFilter getPermQFilter(ReciprocalContext context) {
        try {
            ITimeService timeService = (ITimeService)Class.forName(context.getScheme().getTimeService()).newInstance();
            IUserService userService = (IUserService)Class.forName(context.getScheme().getUserService()).newInstance();
            String ruleId = ReciprocalUtils.checkSpecialPerm(true);
            if (StringUtils.isNotEmpty((String)ruleId)) {
                return ReciprocalUtils.getSpecialPermFilter(ruleId, timeService, userService);
            }
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
        return null;
    }
}

