/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.fi.gl.reciprocal.simulate.SimulateRecord;

public class RcpTask {
    private String taskId;
    private Map<String, Set<Long>> srcTypeAndEntryIdMap = new HashMap<String, Set<Long>>();
    private Set<Long> srcEntryIds = new HashSet<Long>();
    private Set<Long> tgtEntryIds = new HashSet<Long>();
    private Set<String> keys = new HashSet<String>();
    private Set<Long> accountIds;
    private Set<Long> assgrpIds;
    Map<Long, SimulateRecord> recordAndWOAmountMap;

    public Map<Long, SimulateRecord> getRecordAndWOAmountMap() {
        return this.recordAndWOAmountMap;
    }

    public void setRecordAndWOAmountMap(Map<Long, SimulateRecord> recordAndWOAmountMap) {
        this.recordAndWOAmountMap = recordAndWOAmountMap;
    }

    public Set<Long> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(Set<Long> accountIds) {
        this.accountIds = accountIds;
    }

    public Set<Long> getAssgrpIds() {
        return this.assgrpIds;
    }

    public void setAssgrpIds(Set<Long> assgrpIds) {
        this.assgrpIds = assgrpIds;
    }

    public RcpTask() {
        this.taskId = UUID.randomUUID().toString().replaceAll("-", "");
    }

    public String getTaskId() {
        return this.taskId;
    }

    public Set<String> getKeys() {
        return this.keys;
    }

    public void addKey(String key) {
        this.keys.add(key);
    }

    public Set<Long> getEntryIds(String srcType) {
        if ("-1".equals(srcType)) {
            HashSet<Long> ids = new HashSet<Long>();
            for (Set<Long> tmpIds : this.srcTypeAndEntryIdMap.values()) {
                ids.addAll(tmpIds);
            }
            return ids;
        }
        return this.srcTypeAndEntryIdMap.get(srcType);
    }

    public void addEntryId(String srcType, Long id) {
        Set ids = this.srcTypeAndEntryIdMap.computeIfAbsent(srcType, k -> new LinkedHashSet());
        ids.add(id);
    }

    public void addSrcEntryId(Long id) {
        this.srcEntryIds.add(id);
    }

    public Set<Long> getSrcEntryId() {
        return this.srcEntryIds;
    }

    public void addTgtEntryId(Long id) {
        this.tgtEntryIds.add(id);
    }

    public Set<Long> getTgtEntryId() {
        return this.tgtEntryIds;
    }

    public void addAccount(Long accountId) {
        Set<Long> accountIds = this.getAccountIds();
        if (accountIds == null) {
            accountIds = new HashSet<Long>();
        }
        accountIds.add(accountId);
        this.setAccountIds(accountIds);
    }

    public void addAssgrp(Long assgrpId) {
        Set<Long> assgrpIds = this.getAssgrpIds();
        if (assgrpIds == null) {
            assgrpIds = new HashSet<Long>();
        }
        assgrpIds.add(assgrpId);
        this.setAssgrpIds(assgrpIds);
    }
}

