/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.impl.RequestContextRunnable;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.business.dao.recip.AcccurrentDAO;
import kd.fi.gl.business.service.reciprocal.UnAcccurrentUpdateUtil;
import kd.fi.gl.business.vo.reciprocal.AccountGroup;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.constant.AccCurrent;
import kd.fi.gl.enums.WriteOffMode;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;
import kd.fi.gl.reciprocal.RcpTask;
import kd.fi.gl.reciprocal.ReciprocalScheme;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.reciprocal.SingleReciprocalEngine;
import kd.fi.gl.reciprocal.simulate.WriteOff;
import kd.fi.gl.util.GLUtil;
import org.apache.commons.lang3.tuple.Pair;

public class ReciprocalEngine
implements Callable<Boolean> {
    private static final String ORG = "org";
    private static final String BOOKTYPE = "booktype";
    private static final String ACCOUNT = "account";
    private static final String CURRENCY = "currency";
    private static final String ASSGRP = "assgrp";
    private static final String SOURCETYPE = "sourcetype";
    private static final String BIZNUM = "biznum";
    private static final int BATCH_COUNT = 1000;
    private static final String MASTERID = "masterid";
    private static final String ACCCUQUERYFIELD = "id, org, booktype, account, assgrp, currency, abs(amountbal) amountbal, amountfor, amount, sourcetype, voucherid, voucherentry, bizdate, biznum, createtime";
    private RequestContext requestCtx;
    private List<ReciprocalScheme> schemes;
    private DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.writeoff);
    private Boolean isSuccess = Boolean.TRUE;
    private static final Log logger = LogFactory.getLog(ReciprocalEngine.class);

    public ReciprocalEngine(List<ReciprocalScheme> lstSchemes, RequestContext requestCtx) {
        this.requestCtx = requestCtx;
        this.schemes = lstSchemes;
    }

    @Override
    public Boolean call() throws Exception {
        new RequestContextRunnable(new Runnable(){

            @Override
            public void run() {
                ReciprocalEngine.this.doWriteOff();
            }
        }, this.requestCtx).run();
        return this.isSuccess;
    }

    private void doWriteOff() {
        Collections.sort(this.schemes);
        for (ReciprocalScheme scheme : this.schemes) {
            String taskId = scheme.getOrg() + "" + scheme.getBookType();
            try {
                if (Lock.tryLock(scheme.getOrg(), scheme.getBookType(), LockKey.Reciprocal, () -> {
                    Map<AccountGroup, Pair<Set<Long>, Set<Long>>> acctGroupMap = ReciprocalEngine.getAccountGroupByScheme(scheme);
                    UnAcccurrentUpdateUtil.ongoingCalculateAccount(acctGroupMap);
                    if (scheme.getWriteOffMode() == WriteOffMode.BALANCE) {
                        WriteOff.getWriteOffInstance().schemeAutoWriteOff(scheme);
                    } else {
                        List<RcpTask> tasks = this.splitLoadRecordIds(scheme);
                        for (RcpTask task : tasks) {
                            SingleReciprocalEngine engine = new SingleReciprocalEngine(scheme, task);
                            engine.run();
                        }
                    }
                    UnAcccurrentUpdateUtil.asyncCalAndDeleteStatus(acctGroupMap);
                })) continue;
                this.addErrMsg(taskId, ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\uff0c\u4e0a\u4e00\u6b21\u6267\u884c\u7684\u81ea\u52a8\u6838\u9500\u5c1a\u672a\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReciprocalEngine_0", (String)"fi-gl-common", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5206\u5e03\u5f0f\u9501%s\u672a\u91ca\u653e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReciprocalEngine_1", (String)"fi-gl-common", (Object[])new Object[0]), taskId));
            }
            catch (Exception e) {
                this.cache.put(taskId + "isFinish", String.valueOf(true));
                String errMsg = GLUtil.printError(e);
                this.addErrMsg(taskId, errMsg, errMsg);
                logger.error(e.getMessage(), (Throwable)e);
                throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
    }

    private static Map<AccountGroup, Pair<Set<Long>, Set<Long>>> getAccountGroupByScheme(ReciprocalScheme scheme) {
        HashMap<AccountGroup, Pair<Set<Long>, Set<Long>>> accountGroups = new HashMap<AccountGroup, Pair<Set<Long>, Set<Long>>>(scheme.getAccountList().size());
        if (DebugTrace.enable()) {
            logger.info("ReciprocalEngine#getAccountGroupByScheme scheme:{}", (Object)scheme);
        }
        if (Objects.nonNull(scheme.getReciprocalIdList()) && scheme.getReciprocalIdList().size() > 0) {
            QFilter filter = new QFilter("id", "in", scheme.getReciprocalIdList());
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)AcccurrentDAO.class.getName(), (String)AccCurrent.ENTITY, (String)"account,assgrp,currency", (QFilter[])filter.toArray(), null);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long acctMasterId = row.getLong(ACCOUNT);
                    Long currencyId = row.getLong(CURRENCY);
                    AccountGroup acctGroup = AccountGroup.of(scheme.getOrg(), scheme.getBookType(), scheme.getAccountTableId(), acctMasterId, currencyId);
                    Pair pair = (Pair)accountGroups.get(acctGroup);
                    if (Objects.isNull(pair)) {
                        accountGroups.put(acctGroup, (Pair<Set<Long>, Set<Long>>)Pair.of((Object)Sets.newHashSet((Object[])new Long[]{row.getLong(ASSGRP)}), (Object)Sets.newHashSet()));
                        continue;
                    }
                    ((Set)pair.getLeft()).add(row.getLong(ASSGRP));
                }
            }
        } else if (Objects.nonNull(scheme.getAccountListFromPage())) {
            scheme.getAccountListFromPage().forEach(accountId -> {
                AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys(scheme.getOrg(), (long)scheme.getBookType());
                scheme.setAccountTableId(bookInfo.getAccountTableId());
                if (scheme.getCurrencyList().size() > 0) {
                    scheme.getCurrencyList().forEach(currencyId -> {
                        AccountGroup acctGroup = AccountGroup.of(scheme.getOrg(), scheme.getBookType(), scheme.getAccountTableId(), accountId, currencyId);
                        Pair pair = (Pair)accountGroups.get(acctGroup);
                        if (Objects.isNull(pair)) {
                            accountGroups.put(acctGroup, Pair.of((Object)Sets.newHashSet(), (Object)Sets.newHashSet()));
                        }
                    });
                } else {
                    AccountGroup acctGroup = AccountGroup.of(scheme.getOrg(), scheme.getBookType(), scheme.getAccountTableId(), accountId, 0L);
                    accountGroups.put(acctGroup, Pair.of((Object)Sets.newHashSet(), (Object)Sets.newHashSet()));
                }
            });
        }
        return accountGroups;
    }

    private void addErrMsg(String taskId, String errMsg, String logMsg) {
        this.cache.put(taskId + "isSuccess", String.valueOf(false));
        this.cache.put(taskId + "errMsg", errMsg);
        logger.info(logMsg);
        this.isSuccess = Boolean.FALSE;
    }

    private List<RcpTask> splitLoadRecordIds(ReciprocalScheme scheme) {
        ArrayList<RcpTask> tasks = new ArrayList<RcpTask>();
        Tuple<List<QFilter>, List<QFilter>> qfs = this.getFilters(scheme);
        List lstFilters = (List)qfs.item1;
        List voucherfield = (List)qfs.item2;
        String orderFields = this.getOrderString(scheme);
        HashSet<Long> postSet = new HashSet<Long>(8);
        if (scheme.isExculdeUnPostVoucher()) {
            DataSet vouSt = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_voucher", (String)"id", (QFilter[])voucherfield.toArray(new QFilter[0]), null);
            for (Row row : vouSt) {
                postSet.add(row.getLong("id"));
            }
            vouSt.close();
        }
        DataSet filterVoucherDt = ReciprocalUtils.getFilterVoucherDt(scheme);
        DataSet dt = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_acccurrent", (String)ACCCUQUERYFIELD, (QFilter[])lstFilters.toArray(new QFilter[0]), null);
        if (filterVoucherDt != null) {
            dt = dt.join(filterVoucherDt).on("voucherid", "fvoucherid").on("voucherentry", "vchentryid").select(ACCCUQUERYFIELD.split(","), new String[0]).finish();
        }
        dt = dt.orderBy(orderFields.split(","));
        String currentKey = "";
        RcpTask task = new RcpTask();
        int iCount = 0;
        HashMap<String, Set<Long>> srcTypeAndEntryIdMap = new HashMap<String, Set<Long>>();
        boolean iExistSrcRecords = false;
        boolean iExistTgtRecords = false;
        for (Row row : dt) {
            Long voucherid = row.getLong("voucherid");
            if (scheme.isExculdeUnPostVoucher() && voucherid != 0L && !postSet.contains(voucherid)) continue;
            Long id = row.getLong("id");
            String srcType = row.getString(SOURCETYPE);
            String key = row.get(ACCOUNT) + "-" + row.get(ASSGRP) + "-" + row.get(CURRENCY);
            if (StringUtils.isEmpty((CharSequence)currentKey)) {
                currentKey = key;
            }
            if (!currentKey.equals(key)) {
                if (iExistSrcRecords && iExistTgtRecords) {
                    int curCount = this.addIdsToTask(task, srcTypeAndEntryIdMap);
                    iCount += curCount;
                    task.addKey(currentKey);
                    logger.info(String.format("%s\u6dfb\u52a0\u5230task\uff1a%s\uff0c\u6570\u91cf\u4e3a%s", currentKey, task.getTaskId(), curCount));
                }
                currentKey = key;
                srcTypeAndEntryIdMap.clear();
                iExistSrcRecords = false;
                iExistTgtRecords = false;
                if (iCount >= 1000) {
                    tasks.add(task);
                    task = new RcpTask();
                    iCount = 0;
                }
            }
            Set ids = srcTypeAndEntryIdMap.computeIfAbsent(srcType, k -> new LinkedHashSet());
            ids.add(id);
            if (row.getBigDecimal("amountfor").compareTo(BigDecimal.ZERO) > 0) {
                iExistSrcRecords = true;
            } else {
                iExistTgtRecords = true;
            }
            if (row.getBigDecimal("amount").compareTo(BigDecimal.ZERO) > 0) {
                iExistSrcRecords = true;
                continue;
            }
            iExistTgtRecords = true;
        }
        if (iExistSrcRecords && iExistTgtRecords) {
            int curCount = this.addIdsToTask(task, srcTypeAndEntryIdMap);
            iCount += curCount;
            task.addKey(currentKey);
            logger.info(String.format("%s\u6dfb\u52a0\u5230task\uff1a%s\uff0c\u6570\u91cf\u4e3a%s", currentKey, task.getTaskId(), curCount));
        }
        if (iCount > 0) {
            tasks.add(task);
        }
        return tasks;
    }

    private int addIdsToTask(RcpTask task, Map<String, Set<Long>> srcTypeAndEntryIdMap) {
        int iCount = 0;
        for (Map.Entry<String, Set<Long>> entry : srcTypeAndEntryIdMap.entrySet()) {
            String type = entry.getKey();
            Set<Long> idSet = entry.getValue();
            for (Long tmpId : idSet) {
                task.addEntryId(type, tmpId);
                ++iCount;
            }
        }
        return iCount;
    }

    private Tuple<List<QFilter>, List<QFilter>> getFilters(ReciprocalScheme scheme) {
        List<Long> accountIds;
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>();
        ArrayList<QFilter> voucherFilters = new ArrayList<QFilter>();
        lstFilters.add(new QFilter(ORG, "=", (Object)scheme.getOrg()));
        voucherFilters.add(new QFilter(ORG, "=", (Object)scheme.getOrg()));
        lstFilters.add(new QFilter(BOOKTYPE, "=", (Object)scheme.getBookType()));
        voucherFilters.add(new QFilter(BOOKTYPE, "=", (Object)scheme.getBookType()));
        if (scheme.getAccountList().size() > 0) {
            lstFilters.add(new QFilter(ACCOUNT, "in", scheme.getAccountList()));
            List<Long> accountMasterIdList = scheme.getAccountList();
            accountIds = this.getAccountIds(accountMasterIdList);
            voucherFilters.add(new QFilter("entries.account", "in", accountIds));
        }
        if (scheme.getWriteOffType() == 1 && scheme.getAccountListFromPage() != null && !scheme.getAccountListFromPage().isEmpty()) {
            lstFilters.add(new QFilter(ACCOUNT, "in", scheme.getAccountListFromPage()));
            List<Long> accountMasterIdListFromPage = scheme.getAccountListFromPage();
            accountIds = this.getAccountIds(accountMasterIdListFromPage);
            voucherFilters.add(new QFilter("entries.account", "in", accountIds));
        }
        if (scheme.getCurrencyList().size() > 0) {
            lstFilters.add(new QFilter(CURRENCY, "in", scheme.getCurrencyList()));
        }
        ArrayList<String> lstStatus = new ArrayList<String>();
        lstStatus.add("0");
        lstStatus.add("1");
        lstFilters.add(new QFilter("status", "in", lstStatus));
        if (scheme.isNoVerifiBusiNoEmpty()) {
            lstFilters.add(new QFilter(BIZNUM, "!=", (Object)" "));
        }
        lstFilters.add(new QFilter("uneffectivedate", "=", (Object)BalanceTransferUtils.getEndDate()));
        if (scheme.getAssgrpIdList() != null && scheme.getAssgrpIdList().size() > 0) {
            lstFilters.add(new QFilter(ASSGRP, "in", scheme.getAssgrpIdList()));
        }
        if (scheme.getVchQFilterFromPage() != null) {
            voucherFilters.add(scheme.getVchQFilterFromPage());
        }
        if (scheme.getReciprocalIdList() != null && scheme.getReciprocalIdList().size() > 0) {
            lstFilters.add(new QFilter("id", "in", scheme.getReciprocalIdList()));
        }
        QFilter periodFilter = null;
        if (scheme.getStartPeriod() != null && scheme.getStartPeriod() > 0L) {
            periodFilter = new QFilter("period", ">=", (Object)scheme.getStartPeriod());
        }
        if (scheme.getEndPeriod() != null && scheme.getEndPeriod() > 0L) {
            if (periodFilter != null) {
                periodFilter.and(new QFilter("period", "<=", (Object)scheme.getEndPeriod()));
            } else {
                periodFilter = new QFilter("period", "<=", (Object)scheme.getEndPeriod());
            }
        }
        if (periodFilter != null) {
            lstFilters.add(periodFilter);
            voucherFilters.add(periodFilter);
        }
        voucherFilters.add(new QFilter("ispost", "=", (Object)true));
        return new Tuple(lstFilters, voucherFilters);
    }

    private List<Long> getAccountIds(List<Long> accountMasterIdList) {
        QFilter masterIdFilter = new QFilter(MASTERID, "in", accountMasterIdList);
        DataSet accountDateSet = QueryServiceHelper.queryDataSet((String)"ReciprocalEngine.getFilters.queryacct", (String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{masterIdFilter}, null);
        ArrayList<Long> accountIds = new ArrayList<Long>();
        for (Row row : accountDateSet) {
            accountIds.add(row.getLong("id"));
        }
        return accountIds;
    }

    private String getOrderString(ReciprocalScheme scheme) {
        StringBuilder orderFields = new StringBuilder();
        orderFields.append("org, booktype, account, assgrp, currency, amountbal");
        if ("0".equals(scheme.getVerifiOrder())) {
            orderFields.append(",bizdate, biznum");
        } else {
            orderFields.append(",biznum, bizdate");
        }
        orderFields.append(",createtime");
        return orderFields.toString();
    }
}

