/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.reciprocal.ReciprocalInitUtils;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.util.FlexUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class TransBalToReciUtil {
    private List<String> notAccheckFlexField;
    private Map<String, Long> assgrpValues = new HashMap<String, Long>();
    private Map<Long, Long> assgrpReplace = new HashMap<Long, Long>();
    private static Log logger = LogFactory.getLog(TransBalToReciUtil.class);
    private List<String> accheckFlexField = new ArrayList<String>();

    protected Long getAssgrpValues(String key) {
        return this.assgrpValues.get(key);
    }

    public StringBuilder transBalanceToReciprocalAndSave(DynamicObject account, Collection<FlexUtils.AssistFilterEntry> assistFilterEntries, Long periodId, Long[] currencyIds, AccountBookInfo accountBookInfo) {
        HashMap<String, DynamicObject> readyToSaveMap = new HashMap<String, DynamicObject>();
        ArrayList<DynamicObject> notReadySaveList = new ArrayList<DynamicObject>();
        HashMap<Long, Map<String, Object>> assgrpMap = new HashMap<Long, Map<String, Object>>();
        account = BusinessDataServiceHelper.loadSingle((Object)account.get("id"), (String)"bd_accountview");
        String number = account.getString("number");
        String fullName = account.getString("fullname");
        String accountShow = number + fullName;
        this.collectNotAccheckFlexField(account);
        BigDecimal dc = new BigDecimal(account.getString("dc"));
        DynamicObject period = BusinessDataServiceHelper.loadSingle((Object)periodId, (String)"bd_period");
        long curLocal = accountBookInfo.getBaseCurrencyId();
        StringBuilder validateMsg = new StringBuilder();
        try (DataSet ds = ReciprocalInitUtils.getBalanceNoAccheck(accountBookInfo, account, assistFilterEntries, periodId, currencyIds);){
            if (ds != null) {
                for (Row row : ds) {
                    if (row.getBigDecimal("beginfor").compareTo(BigDecimal.ZERO) == 0 && row.getBigDecimal("beginlocal").compareTo(BigDecimal.ZERO) == 0) continue;
                    DynamicObject reciprocalInit = this.initReciprocalInit(accountBookInfo);
                    Date date = period.getDate("begindate");
                    date = new Date(date.getTime() - 86400000L);
                    Long currencyId = row.getLong("currency");
                    reciprocalInit.set("account", account.get("id"));
                    reciprocalInit.set("currency", (Object)currencyId);
                    reciprocalInit.set("amountfor", (Object)row.getBigDecimal("beginfor").multiply(dc));
                    reciprocalInit.set("amountlocal", (Object)row.getBigDecimal("beginlocal").multiply(dc));
                    reciprocalInit.set("description", (Object)ResManager.loadKDString((String)"\u521d\u59cb\u5316\u91d1\u989d", (String)"TransBalToReciUtil_0", (String)"fi-gl-common", (Object[])new Object[0]));
                    reciprocalInit.set("bizdate", (Object)date);
                    reciprocalInit.set("deadlinedate", (Object)date);
                    Long balAssgrpId = row.getLong("assgrp");
                    reciprocalInit.set("assgrp", (Object)balAssgrpId);
                    assgrpMap.put(balAssgrpId, null);
                    notReadySaveList.add(reciprocalInit);
                    if (notReadySaveList.size() < 5000) continue;
                    this.validateAndSaveReciprocalInit(account, readyToSaveMap, notReadySaveList, assgrpMap, accountShow, curLocal, validateMsg);
                    if (validateMsg.length() > 0) {
                        StringBuilder stringBuilder = validateMsg;
                        return stringBuilder;
                    }
                    notReadySaveList.clear();
                    readyToSaveMap.clear();
                    assgrpMap.clear();
                }
            }
        }
        this.validateAndSaveReciprocalInit(account, readyToSaveMap, notReadySaveList, assgrpMap, accountShow, curLocal, validateMsg);
        return validateMsg;
    }

    private void validateAndSaveReciprocalInit(DynamicObject account, Map<String, DynamicObject> readyToSaveMap, List<DynamicObject> notReadySaveList, Map<Long, Map<String, Object>> assgrpMap, String accountShow, long curLocal, StringBuilder validateMsg) {
        validateMsg.append(this.handleSaveReciprocal(account, readyToSaveMap, notReadySaveList, assgrpMap));
        if (!validateMsg.toString().isEmpty()) {
            return;
        }
        Collection<DynamicObject> reciprocalColl = readyToSaveMap.values();
        validateMsg.append((CharSequence)this.validateReciprocalInit(accountShow, curLocal, reciprocalColl));
        SaveServiceHelper.save((DynamicObject[])reciprocalColl.toArray(new DynamicObject[0]));
    }

    private StringBuilder validateReciprocalInit(String accountShow, long curLocal, Collection<DynamicObject> reciprocalColl) {
        HashSet<Long> assgrpIdSet = new HashSet<Long>();
        HashSet<Long> currencyIdSet = new HashSet<Long>();
        ArrayList<List<Object>> msgCacheList = new ArrayList<List<Object>>();
        StringBuilder validateMsg = new StringBuilder();
        DynamicObject[] reciprocalArray = reciprocalColl.toArray(new DynamicObject[0]);
        for (int i = 0; i < reciprocalArray.length; ++i) {
            DynamicObject reciprocalInit = reciprocalArray[i];
            if (curLocal != reciprocalInit.getLong("currency")) continue;
            BigDecimal amountFor = reciprocalInit.getBigDecimal("amountfor");
            BigDecimal amountLocal = reciprocalInit.getBigDecimal("amountlocal");
            amountFor = amountFor == null ? BigDecimal.ZERO : amountFor;
            BigDecimal bigDecimal = amountLocal = amountLocal == null ? BigDecimal.ZERO : amountLocal;
            if (amountFor.signum() == 0) {
                reciprocalInit.set("amountfor", (Object)amountLocal);
                continue;
            }
            if (amountLocal.signum() == 0) {
                reciprocalInit.set("amountlocal", (Object)amountFor);
                continue;
            }
            if (amountFor.compareTo(amountLocal) == 0) continue;
            Long assgrpId = reciprocalInit.getLong("assgrp");
            this.addMsgCache(accountShow, assgrpIdSet, currencyIdSet, msgCacheList, curLocal, assgrpId);
            reciprocalColl.remove(reciprocalInit);
        }
        Map<Long, String> assgrpNameMap = ReciprocalInitUtils.analyzeAssgrpNameById(assgrpIdSet);
        Map<Long, String> currencyNameMap = ReciprocalInitUtils.getCurrencyName(currencyIdSet);
        for (int i = 0; i < msgCacheList.size(); ++i) {
            List msgCache = (List)msgCacheList.get(i);
            String currencyName = currencyNameMap.get((Long)msgCache.get(1));
            String assgrpName = assgrpNameMap.get((Long)msgCache.get(2));
            validateMsg.append(String.format(ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u4e0e\u539f\u5e01\u5e01\u79cd\u4e00\u81f4\uff0c%1$s\u79d1\u76ee\u4e0b%2$s\u5e01\u79cd\u7684%3$s\u6838\u7b97\u7ef4\u5ea6\u7684\u539f\u5e01\u91d1\u989d\u4e0e\u672c\u4f4d\u5e01\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u5bfc\u5165\u4f59\u989d\u3002", (String)"TransBalToReciUtil_1", (String)"fi-gl-common", (Object[])new Object[0]) + "\r\n", accountShow, currencyName, assgrpName));
        }
        return validateMsg;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String compareBalanceWithReciprocal(DynamicObject account, Long periodId, AccountBookInfo accountBookInfo) {
        StringBuilder compareMsg = new StringBuilder();
        long tick = System.currentTimeMillis();
        String number = account.getString("number");
        String fullName = account.getString("fullname");
        String accountShow = number + fullName;
        BigDecimal dc = new BigDecimal(account.getString("dc"));
        List<String> accheckFlexField = this.collectNotAccheckFlexField(account);
        ArrayList<List<Object>> msgCacheList = new ArrayList<List<Object>>();
        HashSet<Long> assgrpIdSet = new HashSet<Long>();
        HashSet<Long> currencyIdSet = new HashSet<Long>();
        try (DataSet initDs = ReciprocalInitUtils.getDynamicOrmDataSet(accountBookInfo, account, periodId, accheckFlexField, "gl_initacccurrent");
             DataSet balDs = ReciprocalInitUtils.getDynamicOrmDataSet(accountBookInfo, account, periodId, accheckFlexField, "gl_balance").filter("beginfor != 0 or beginlocal != 0");){
            Object accbeginFor;
            String wrongType = null;
            Row balRow = null;
            Row initRow = null;
            DataSet accountBalDs = balDs.copy().groupBy(new String[]{"account"}).sum("beginfor").sum("beginlocal").finish();
            DataSet accountInitDs = initDs.copy().groupBy(new String[]{"account"}).sum("amountfor").sum("amountlocal").finish();
            if (accountBalDs.hasNext()) {
                Row accountBalRow = accountBalDs.next();
                accbeginFor = accountBalRow.getBigDecimal("beginfor").multiply(dc);
                BigDecimal accbeginLocal = accountBalRow.getBigDecimal("beginlocal").multiply(dc);
                if (accountInitDs.isEmpty() && (((BigDecimal)accbeginFor).compareTo(BigDecimal.ZERO) != 0 || accbeginLocal.compareTo(BigDecimal.ZERO) != 0)) {
                    compareMsg.append(String.format(ResManager.loadKDString((String)"%s\u7684\u79d1\u76ee\u4f59\u989d\u4e0e\u5f80\u6765\u521d\u59cb\u5316\u79d1\u76ee\u4f59\u989d\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"TransBalToReciUtil_4", (String)"fi-gl-common", (Object[])new Object[0]), accountShow));
                    String string = compareMsg.toString();
                    return string;
                }
                if (accountInitDs.hasNext()) {
                    Row accountInitRow = accountInitDs.next();
                    BigDecimal initAmountFor = accountInitRow.getBigDecimal("amountfor");
                    BigDecimal initAmountLocal = accountInitRow.getBigDecimal("amountlocal");
                    if (((BigDecimal)accbeginFor).compareTo(initAmountFor) != 0 || accbeginLocal.compareTo(initAmountLocal) != 0) {
                        compareMsg.append(String.format(ResManager.loadKDString((String)"%s\u7684\u79d1\u76ee\u4f59\u989d\u4e0e\u5f80\u6765\u521d\u59cb\u5316\u79d1\u76ee\u4f59\u989d\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"TransBalToReciUtil_4", (String)"fi-gl-common", (Object[])new Object[0]), accountShow));
                        String string = compareMsg.toString();
                        return string;
                    }
                }
            }
            while (true) {
                if ("bal".equals(wrongType)) {
                    if (!balDs.hasNext()) {
                        while (initDs.hasNext() && !this.handleWrong(accountShow, accheckFlexField, initRow = initDs.next(), msgCacheList, assgrpIdSet, currencyIdSet)) {
                        }
                        break;
                    }
                    balRow = balDs.next();
                } else if ("init".equals(wrongType)) {
                    if (!initDs.hasNext()) {
                        while (balDs.hasNext() && !this.handleWrong(accountShow, accheckFlexField, balRow = balDs.next(), msgCacheList, assgrpIdSet, currencyIdSet)) {
                        }
                        break;
                    }
                    initRow = initDs.next();
                } else {
                    if (!balDs.hasNext()) {
                        while (initDs.hasNext() && !this.handleWrong(accountShow, accheckFlexField, initRow = initDs.next(), msgCacheList, assgrpIdSet, currencyIdSet)) {
                        }
                        break;
                    }
                    if (!initDs.hasNext()) {
                        while (balDs.hasNext() && !this.handleWrong(accountShow, accheckFlexField, balRow = balDs.next(), msgCacheList, assgrpIdSet, currencyIdSet)) {
                        }
                        break;
                    }
                    balRow = balDs.next();
                    initRow = initDs.next();
                }
                Tuple2<String, Boolean> result = this.compareAssist(balRow, initRow, accheckFlexField);
                if (((Boolean)result.t2).booleanValue()) {
                    compareMsg.append(String.format(ResManager.loadKDString((String)"%s\u79d1\u76ee\uff0c\u5b58\u5728\u6ca1\u6709\u5f80\u6765\u7ef4\u5ea6\u7684\u4f59\u989d\u6570\u636e,\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"TransBalToReciUtil_5", (String)"fi-gl-common", (Object[])new Object[0]), accountShow));
                    accbeginFor = compareMsg.toString();
                    return accbeginFor;
                }
                wrongType = (String)result.t1;
                if ("bal".equals(wrongType)) {
                    if (!this.handleWrong(accountShow, accheckFlexField, balRow, msgCacheList, assgrpIdSet, currencyIdSet)) continue;
                    break;
                }
                if ("init".equals(wrongType)) {
                    if (!this.handleWrong(accountShow, accheckFlexField, initRow, msgCacheList, assgrpIdSet, currencyIdSet)) continue;
                    break;
                }
                if (balRow == null || initRow == null) continue;
                BigDecimal beginFor = balRow.getBigDecimal("beginfor").multiply(dc);
                BigDecimal beginLocal = balRow.getBigDecimal("beginlocal").multiply(dc);
                BigDecimal amountFor = initRow.getBigDecimal("amountfor");
                BigDecimal amountLocal = initRow.getBigDecimal("amountlocal");
                if ((beginFor.compareTo(amountFor) != 0 || beginLocal.compareTo(amountLocal) != 0) && this.handleWrong(accountShow, accheckFlexField, initRow, msgCacheList, assgrpIdSet, currencyIdSet)) break;
            }
        }
        Map<Long, String> assgrpNameMap = ReciprocalInitUtils.analyzeAssgrpNameById(assgrpIdSet);
        Map<Long, String> currencyNameMap = ReciprocalInitUtils.getCurrencyName(currencyIdSet);
        int i = 0;
        while (true) {
            if (i >= msgCacheList.size()) {
                logger.info("endreciprocalinit compareBalanceWithReciprocal totalcost:{}ms", (Object)(System.currentTimeMillis() - tick));
                return compareMsg.toString();
            }
            List msgCache = (List)msgCacheList.get(i);
            String currencyName = currencyNameMap.get((Long)msgCache.get(1));
            String assgrpName = assgrpNameMap.get((Long)msgCache.get(2));
            compareMsg.append(String.format(ResManager.loadKDString((String)"%1$s\u79d1\u76ee\u4e0b%2$s\u5e01\u79cd\u7684%3$s\u6838\u7b97\u7ef4\u5ea6\u7684\u4f59\u989d\u4e0e\u8f85\u52a9\u8d26\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"TransBalToReciUtil_2", (String)"fi-gl-common", (Object[])new Object[0]) + "\r\n", accountShow, currencyName, assgrpName));
            ++i;
        }
    }

    private DataSet queryValidateInitDataSet(DynamicObject account, AccountBookInfo accountBookInfo, List<String> accheckFlexField) {
        long tick = System.currentTimeMillis();
        DataSet initDs = this.queryReciprocalInitDataSet(account, accountBookInfo);
        initDs = this.joinAccheck(accheckFlexField, initDs, "amountfor", "amountlocal");
        logger.info("endreciprocalinit queryValidateInitDataSet cost:{}ms", (Object)(System.currentTimeMillis() - tick));
        return initDs;
    }

    public DataSet queryValidateBalDataSet(DynamicObject account, Collection<FlexUtils.AssistFilterEntry> assistFilterEntries, Long periodId, Long[] currencyIds, AccountBookInfo accountBookInfo, List<String> accheckFlexField) {
        long tick = System.currentTimeMillis();
        DataSet balDataSet = ReciprocalInitUtils.getBalanceNoAccheck(accountBookInfo, account, assistFilterEntries, periodId, currencyIds);
        balDataSet = this.joinAccheck(accheckFlexField, balDataSet, "beginfor", "beginlocal");
        logger.info("endreciprocalinit queryValidateBalDataSet cost:{}ms", (Object)(System.currentTimeMillis() - tick));
        return balDataSet;
    }

    private DataSet joinAccheck(List<String> accheckFlexField, DataSet ds, String sumFieldFor, String sumFieldLocal) {
        ArrayList<String> selectField = new ArrayList<String>(accheckFlexField.size() + 5);
        selectField.add("account");
        selectField.add("currency");
        selectField.add("assgrp");
        selectField.add(sumFieldFor);
        selectField.add(sumFieldLocal);
        ArrayList<String> groupByField = new ArrayList<String>(accheckFlexField.size() + 2);
        groupByField.add("account");
        groupByField.add("currency");
        ArrayList<String> orderByField = new ArrayList<String>();
        orderByField.add("currency");
        orderByField.addAll(accheckFlexField);
        for (int i = 0; i < accheckFlexField.size(); ++i) {
            String flexField = accheckFlexField.get(i);
            QFilter flexFieldFilter = new QFilter("asstype", "=", (Object)flexField);
            DataSet assistDs = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "joinAccheck"), (String)"gl_assist_bd", (String)("hg,assval " + flexField), (QFilter[])flexFieldFilter.toArray(), null);
            selectField.add(flexField);
            groupByField.add(flexField);
            ds = ds.join(assistDs, JoinType.LEFT).on("assgrp", "hg").select(selectField.toArray(new String[0])).finish();
        }
        selectField.remove("assgrp");
        ds = ds.groupBy(groupByField.toArray(new String[0])).sum(sumFieldFor).sum(sumFieldLocal).finish();
        ds = ds.orderBy(orderByField.toArray(new String[0]));
        ds = ds.select(selectField.toArray(new String[0]));
        return ds;
    }

    private boolean handleWrong(String accountShow, List<String> accheckFlexField, Row row, List<List<Object>> msgCacheList, Set<Long> assgrpIdSet, Set<Long> currencyIdSet) {
        if (row.getBigDecimal(2).signum() == 0 && row.getBigDecimal(3).signum() == 0) {
            return false;
        }
        HashMap<String, Object> assist = new HashMap<String, Object>(accheckFlexField.size());
        for (int i = 0; i < accheckFlexField.size(); ++i) {
            String valColumn = accheckFlexField.get(i);
            Long balVal = row.getLong(valColumn);
            assist.put(valColumn, balVal);
        }
        Long assgrpId = ReciprocalUtils.rebuildAssgrpId(assist);
        if (assgrpId == 0L) {
            return false;
        }
        Long currencyId = row.getLong("currency");
        this.addMsgCache(accountShow, assgrpIdSet, currencyIdSet, msgCacheList, currencyId, assgrpId);
        return false;
    }

    private Tuple2<String, Boolean> compareAssist(Row balRow, Row initRow, List<String> accheckFlexField) {
        Long balCur = balRow.getLong("currency");
        balCur = balCur == null ? NumberUtils.LONG_ZERO : balCur;
        Long initCur = initRow.getLong("currency");
        Long l = initCur = initCur == null ? NumberUtils.LONG_ZERO : initCur;
        if (balCur.compareTo(initCur) < 0) {
            return new Tuple2((Object)"bal", (Object)false);
        }
        if (balCur.compareTo(initCur) > 0) {
            return new Tuple2((Object)"init", (Object)false);
        }
        for (int i = 0; i < accheckFlexField.size(); ++i) {
            String valColumn = accheckFlexField.get(i);
            Long balVal = balRow.getLong(valColumn);
            if (balVal == null || balVal == 0L) {
                return new Tuple2((Object)"bal", (Object)true);
            }
            Long initVal = initRow.getLong(valColumn);
            Long l2 = initVal = initVal == null ? NumberUtils.LONG_ZERO : initVal;
            if (balVal.compareTo(initVal) < 0) {
                return new Tuple2((Object)"bal", (Object)false);
            }
            if (balVal.compareTo(initVal) <= 0) continue;
            return new Tuple2((Object)"init", (Object)false);
        }
        return new Tuple2(null, (Object)false);
    }

    private String handleSaveReciprocal(DynamicObject account, Map<String, DynamicObject> readyToSaveMap, List<DynamicObject> notReadySaveList, Map<Long, Map<String, Object>> assgrpMap) {
        QFilter balAssgrpIdFilter = new QFilter("id", "in", assgrpMap.keySet());
        DynamicObjectCollection assistColl = QueryServiceHelper.query((String)"gl_assist", (String)"id,assvals", (QFilter[])balAssgrpIdFilter.toArray());
        assgrpMap.clear();
        HashSet<Long> assgrpIdNotAllData = new HashSet<Long>(16);
        for (DynamicObject assist : assistColl) {
            String assval = assist.getString("assvals");
            Map value = (Map)SerializationUtils.fromJsonString((String)assval, Map.class);
            boolean needRebuild = false;
            for (String flexField : this.notAccheckFlexField) {
                if (!needRebuild) {
                    needRebuild = value.containsKey(flexField);
                }
                value.remove(flexField);
            }
            for (String flexField : this.accheckFlexField) {
                Object flexVal = value.get(flexField);
                if (flexVal != null) continue;
                assgrpIdNotAllData.add(assist.getLong("id"));
                FlexProperty fp = FlexEntityMetaUtils.getFlexProperty((String)flexField);
                if (fp == null) {
                    return flexField + " not exist";
                }
                return String.format(ResManager.loadKDString((String)"%1$s\u79d1\u76ee\u5f80\u6765\u6838\u7b97\u7ef4\u5ea6%2$s\u5b58\u5728\u672a\u5f55\u5165\u7ef4\u5ea6\u503c\u7684\u4f59\u989d\uff0c\u8bf7\u8fdb\u884c\u8c03\u6574\u540e\u518d\u8fdb\u884c\u5f80\u6765\u4f59\u989d\u521d\u59cb\u5316\u3002", (String)"TransBalToReciUtil_3", (String)"fi-gl-common", (Object[])new Object[0]), account.getString("name"), fp.getName().getLocaleValue());
            }
            Long assistId = assist.getLong("id");
            if (needRebuild) {
                assgrpMap.put(assistId, value);
                continue;
            }
            this.assgrpValues.put(assval, assistId);
            this.assgrpReplace.put(assistId, assistId);
        }
        this.genFlexEntireData(assgrpMap);
        for (DynamicObject reciprocalInit : notReadySaveList) {
            Long oldAssgrpId = reciprocalInit.getLong("assgrp");
            Long assgrpIdRebuilt = this.assgrpReplace.get(oldAssgrpId);
            if (assgrpIdRebuilt == null || assgrpIdRebuilt == 0L) continue;
            reciprocalInit.set("assgrp", (Object)assgrpIdRebuilt);
            Long currencyId = reciprocalInit.getLong("currency");
            String key = "" + currencyId + assgrpIdRebuilt;
            this.handleSaveMap(readyToSaveMap, reciprocalInit, key);
        }
        return "";
    }

    public List<String> collectNotAccheckFlexField(DynamicObject account) {
        this.notAccheckFlexField = new ArrayList<String>();
        DynamicObjectCollection assistEntry = account.getDynamicObjectCollection("checkitementry");
        for (DynamicObject assistRow : assistEntry) {
            Boolean enaccheck = assistRow.getBoolean("enaccheck");
            String flexField = assistRow.getString("asstactitem.flexfield");
            if (enaccheck.booleanValue()) {
                this.accheckFlexField.add(flexField);
                continue;
            }
            this.notAccheckFlexField.add(flexField);
        }
        return this.accheckFlexField;
    }

    private void handleSaveMap(Map<String, DynamicObject> readyToSaveMap, DynamicObject reciprocalInit, String key) {
        if (!readyToSaveMap.containsKey(key)) {
            BigDecimal amountFor = reciprocalInit.getBigDecimal("amountfor");
            BigDecimal amountLocal = reciprocalInit.getBigDecimal("amountlocal");
            if (amountFor.signum() == 0 && amountLocal.signum() == 0) {
                return;
            }
            reciprocalInit.set("id", (Object)DB.genGlobalLongId());
            readyToSaveMap.put(key, reciprocalInit);
        } else {
            readyToSaveMap.compute(key, (k, v) -> {
                BigDecimal amountFor = v.getBigDecimal("amountfor").add(reciprocalInit.getBigDecimal("amountfor"));
                v.set("amountfor", (Object)amountFor);
                BigDecimal amountLocal = v.getBigDecimal("amountlocal").add(reciprocalInit.getBigDecimal("amountlocal"));
                v.set("amountlocal", (Object)amountLocal);
                return v;
            });
        }
    }

    private void genFlexEntireData(Map<Long, Map<String, Object>> assgrpMap) {
        ArrayList<FlexEntireData> flexEntireDatas = new ArrayList<FlexEntireData>(assgrpMap.size());
        HashMap<String, String> mapToConcatData = new HashMap<String, String>(16);
        for (Map.Entry<Long, Map<String, Object>> entry : assgrpMap.entrySet()) {
            Map<String, Object> flexFieldValueMap = entry.getValue();
            FlexEntireData flexEntireData = ReciprocalUtils.buildFlexEntireData(flexFieldValueMap);
            mapToConcatData.put(flexFieldValueMap.toString(), flexEntireData.concatFlexData());
            flexEntireDatas.add(flexEntireData);
        }
        Map<String, Long> newVal = ReciprocalUtils.saveNewAssgrpVal(flexEntireDatas);
        for (Map.Entry<Long, Map<String, Object>> entry : assgrpMap.entrySet()) {
            Map<String, Object> flexFieldValueMap = entry.getValue();
            Long assgrpIdRebuilt = newVal.get(mapToConcatData.get(flexFieldValueMap.toString()));
            this.assgrpReplace.put(entry.getKey(), assgrpIdRebuilt);
        }
    }

    private DynamicObject initReciprocalInit(AccountBookInfo accountBookInfo) {
        DynamicObject reciprocalInit = BusinessDataServiceHelper.newDynamicObject((String)"gl_initacccurrent");
        reciprocalInit.set("org", (Object)accountBookInfo.getOrgId());
        reciprocalInit.set("booktype", (Object)accountBookInfo.getBookTypeId());
        reciprocalInit.set("accounttable", (Object)accountBookInfo.getAccountTableId());
        reciprocalInit.set("curlocal", (Object)accountBookInfo.getBaseCurrencyId());
        return reciprocalInit;
    }

    private void addMsgCache(String accountShow, Set<Long> assgrpIdSet, Set<Long> currencyIdSet, List<List<Object>> msgCacheList, Long currencyId, Long assgrpId) {
        assgrpIdSet.add(assgrpId);
        currencyIdSet.add(currencyId);
        ArrayList<Object> msgCache = new ArrayList<Object>();
        msgCache.add(accountShow);
        msgCache.add(currencyId);
        msgCache.add(assgrpId);
        msgCacheList.add(msgCache);
    }

    public DataSet queryReciprocalInitDataSet(DynamicObject account, AccountBookInfo accountBookInfo) {
        QFilter orgFilter = new QFilter("org", "=", (Object)accountBookInfo.getOrgId());
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)accountBookInfo.getBookTypeId());
        QFilter acctFilter = new QFilter("account.masterid", "=", (Object)account.getLong("masterid"));
        String selectFields = "account.masterid account, currency, assgrp, amountfor, amountlocal";
        DataSet ds = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "queryReciprocalInitDataSet"), (String)"gl_initacccurrent", (String)selectFields, (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, acctFilter}, null);
        GroupbyDataSet groupByDs = ds.groupBy(new String[]{"account", "currency", "assgrp"});
        ds = groupByDs.sum("amountfor").sum("amountlocal").finish();
        return ds;
    }
}

