/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal.datarepair.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.reciprocal.datarepair.service.AbstractDataCheckAndRepairService;
import kd.fi.gl.reciprocal.datarepair.util.ReciprocalDataRepairUtil;
import kd.fi.gl.util.GLUtil;

public class AcccurrentDuplicateUnit
extends AbstractDataCheckAndRepairService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String repairSelected(String checkType, List<Long> selectedIds) {
        if (CollectionUtils.isEmpty(selectedIds)) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u590d\u7684\u884c", (String)"ReciprocalDataCheckAndRepairPlugin_7", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        String idStr = StringUtils.join((Object[])selectedIds.toArray(), (String)",");
        StringBuilder sb = new StringBuilder();
        sb.append("select ").append(" distinct fvoucherid,fvchentryid  ").append(" from t_gl_acccurrent acct  where 1=1");
        sb.append(" and acct.fid in ( ");
        sb.append(idStr);
        sb.append(" )");
        DataSet acctSet = DB.queryDataSet((String)"AcccurrentDuplicateUnit_repairSelected", (DBRoute)DBRoute.of((String)"gl"), (String)sb.toString());
        HashSet vchIds = new HashSet(16);
        HashSet vchentryIds = new HashSet(16);
        acctSet.forEach(row -> {
            vchIds.add(row.getLong("fvoucherid"));
            vchentryIds.add(row.getLong("fvchentryid"));
        });
        String vchIdsStr = StringUtils.join((Object[])vchIds.toArray(), (String)",");
        String vchentryIdsStr = StringUtils.join((Object[])vchentryIds.toArray(), (String)",");
        StringBuilder sqlSb = new StringBuilder(64);
        sqlSb.append("select ").append(" fid,fvchentryid,fstatus ").append("from t_gl_acccurrent acct  where 1=1 ");
        sqlSb.append(" and acct.fvoucherid in ( ").append(vchIdsStr).append(" )");
        sqlSb.append(" and acct.fvchentryid in ( ").append(vchentryIdsStr).append(" )");
        sqlSb.append(" order by acct.fvchentryid , acct.fcreatetime ");
        DataSet duplicateSet = DB.queryDataSet((String)"AcccurrentDuplicateUnit_repairSelected", (DBRoute)DBRoute.of((String)"gl"), (String)sqlSb.toString());
        ArrayList<Long> existVchentryIdIds = new ArrayList<Long>(16);
        ArrayList<Long> delAcctIds = new ArrayList<Long>(16);
        ArrayList<Long> writeOffedIds = new ArrayList<Long>(16);
        for (Row row2 : duplicateSet) {
            Long acctId = row2.getLong("fid");
            Long vchentryId = row2.getLong("fvchentryid");
            String status = row2.getString("fstatus");
            if (!existVchentryIdIds.contains(vchentryId)) {
                existVchentryIdIds.add(vchentryId);
                continue;
            }
            delAcctIds.add(acctId);
            if ("0".equals(status)) continue;
            writeOffedIds.add(acctId);
        }
        Date now = new Date();
        String tableName = "";
        String logMessage = "";
        String status = "1";
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                ReciprocalDataRepairUtil.doUnWriteOffByAcctIds(writeOffedIds);
                QFilter delFilter = new QFilter("id", "in", delAcctIds);
                DeleteServiceHelper.delete((String)"gl_acccurrent", (QFilter[])new QFilter[]{delFilter});
            }
            catch (Exception e) {
                txHandle.markRollback();
                logMessage = e.getMessage();
                status = "0";
                throw e;
            }
        }
        finally {
            ReciprocalDataRepairUtil.reciDataRepairLog(checkType, now, tableName, logMessage, status);
        }
        return "";
    }

    @Override
    public String repairByCondition(ReportQueryParam param) {
        DataSet accountErrorDt = this.getAcctDuplicateByCondition(param);
        ArrayList<Long> accountErrorIds = new ArrayList<Long>(16);
        for (Row row : accountErrorDt) {
            accountErrorIds.add(row.getLong("id"));
        }
        String checkType = (String)param.getFilter().getValue("checktype");
        return this.repairSelected(checkType, accountErrorIds);
    }

    @Override
    public DataSet queryCheckDataSet(ReportQueryParam param) {
        return this.getAcctDuplicateByCondition(param);
    }

    private DataSet getAcctDuplicateByCondition(ReportQueryParam param) {
        FilterInfo filterInfo = param.getFilter();
        Long orgId = filterInfo.getLong("org");
        Long bookTypeId = filterInfo.getLong("booktype");
        Long accountTableId = filterInfo.getLong("accounttable");
        if (orgId != null && orgId != 0L) {
            if (bookTypeId == null || bookTypeId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"ReciprocalDataCheckAndRepairPlugin_4", (String)"fi-gl-common", (Object[])new Object[0]));
            }
            if (accountTableId == null || accountTableId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u8868", (String)"ReciprocalDataCheckAndRepairPlugin_8", (String)"fi-gl-common", (Object[])new Object[0]));
            }
        }
        SqlBuilder qslSb = new SqlBuilder();
        qslSb.append("select ", new Object[0]).append(" fvoucherid,fvchentryid ", new Object[0]).append(" from t_gl_acccurrent acct where 1=1", new Object[0]);
        if (orgId != null && orgId != 0L) {
            qslSb.append(" and acct.forgid = ? ", new Object[]{orgId});
            qslSb.append(" and acct.fbooktypeid = ? ", new Object[]{bookTypeId});
            qslSb.append(" and acct.facctableid = ? ", new Object[]{accountTableId});
        }
        qslSb.append(" and acct.fvchentryid != 0 and acct.funeffectivedate = ? group by acct.fvoucherid, acct.fvchentryid having (count(acct.fvchentryid)>1)", new Object[]{GLUtil.getEndDate()});
        DataSet acctIdSet = DB.queryDataSet((String)"ErrorAccountUnit_queryCheckDataSet", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)qslSb);
        HashSet<Long> vchIds = new HashSet<Long>(16);
        HashSet<Long> vchentryIds = new HashSet<Long>(16);
        FilterInfo filter = param.getFilter();
        int pagenumber = 0;
        if (filter.containProp("querynumber")) {
            pagenumber = filter.getInt("querynumber");
        }
        if (pagenumber > 0) {
            int i = 0;
            for (Row row2 : acctIdSet) {
                if (i < pagenumber) {
                    vchIds.add(row2.getLong("fvoucherid"));
                    vchentryIds.add(row2.getLong("fvchentryid"));
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            acctIdSet.forEach(row -> {
                vchIds.add(row.getLong("fvoucherid"));
                vchentryIds.add(row.getLong("fvchentryid"));
            });
        }
        if (vchentryIds.isEmpty()) {
            return GLUtil.getEmptyDS(this.getClass());
        }
        String vchIdStr = StringUtils.join((Object[])vchIds.toArray(), (String)",");
        String idStr = StringUtils.join((Object[])vchentryIds.toArray(), (String)",");
        StringBuilder sb = new StringBuilder();
        sb.append("select ").append(" acct.fid id, acct.forgid org, acct.fbooktypeid booktype, acct.fperiodid period, acct.facctableid accounttable, acct.faccountid account, acct.fassgrpid assgrp, acct.fcurrencyid currency,acct.famountfor amountfor, acct.famountbalfor amountbalfor, acct.flocalcurrencyid localcurrency, acct.famount amount, acct.famountbal amountbal, acct.fbizdate bizdate, acct.fexpiredate expiredate, acct.fbiznum biznum, acct.fdescription description, acct.fstatus status, acct.fvchentryid voucherentry, acct.fsourcetype sourcetype, acct.fvoucherid voucherid").append(" from t_gl_acccurrent acct where 1=1");
        if (orgId != null && orgId != 0L) {
            sb.append(" and acct.forgid = ").append(orgId);
            sb.append(" and acct.fbooktypeid = ").append(bookTypeId);
            sb.append(" and acct.facctableid = ").append(accountTableId);
        }
        sb.append(" and acct.fvoucherid in  ( ").append(vchIdStr).append(" )");
        sb.append(" and acct.fvchentryid in ( ").append(idStr).append(" )");
        return DB.queryDataSet((String)"ErrorAccountUnit_queryCheckDataSet", (DBRoute)DBRoute.of((String)"gl"), (String)sb.toString());
    }

    @Override
    public List<AbstractReportColumn> getColums(List<AbstractReportColumn> columns) {
        return ReciprocalDataRepairUtil.getAccurrentColums(columns);
    }
}

