/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal.datarepair.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.reciprocal.datarepair.service.AbstractDataCheckAndRepairService;
import kd.fi.gl.reciprocal.datarepair.util.ReciprocalDataRepairUtil;

public class AmountErrorUnit
extends AbstractDataCheckAndRepairService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String repairSelected(String checkType, List<Long> recordIds) {
        if (CollectionUtils.isEmpty(recordIds)) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u590d\u7684\u884c", (String)"ReciprocalDataCheckAndRepairPlugin_7", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>(16);
        lstFilters.add(new QFilter("id", "in", recordIds));
        DataSet reciprocalDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_acccurrent", (String)"id as acctid,voucherentry,voucherid,status", (QFilter[])lstFilters.toArray(new QFilter[0]), null);
        ArrayList<Long> vchEntryIds = new ArrayList<Long>(16);
        ArrayList<Long> voucherIds = new ArrayList<Long>(16);
        ArrayList<Long> writeOffedIds = new ArrayList<Long>(16);
        for (Row row : reciprocalDataSet.copy()) {
            Long voucherid;
            Long voucherentry = row.getLong("voucherentry");
            if (voucherentry != null) {
                vchEntryIds.add(voucherentry);
            }
            if ((voucherid = row.getLong("voucherid")) != null) {
                voucherIds.add(voucherid);
            }
            if ("0".equals(row.getString("status"))) continue;
            writeOffedIds.add(row.getLong("acctid"));
        }
        QFilter vchfilters = new QFilter("entries.id", "in", vchEntryIds);
        QFilter voucherIdfilters = new QFilter("id", "in", voucherIds);
        DataSet vchEntryDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_voucher", (String)"entries.id entryid,entries.account.dc accountdc,entries.entrydc entrydc,entries.debitori debitori,entries.creditori creditori,entries.debitlocal debitlocal,entries.creditlocal creditlocal", (QFilter[])new QFilter[]{vchfilters, voucherIdfilters}, null);
        HashMap<Long, Tuple> entryAndAmountMap = new HashMap<Long, Tuple>(8);
        for (Row row : vchEntryDataSet) {
            Long entryid = row.getLong("entryid");
            int accountDC = Integer.parseInt(row.getString("accountdc"));
            BigDecimal debit = row.getBigDecimal("debitori");
            BigDecimal credit = row.getBigDecimal("creditori");
            BigDecimal debitlocal = row.getBigDecimal("debitlocal");
            BigDecimal creditlocal = row.getBigDecimal("creditlocal");
            int entryDC = Integer.parseInt(row.getString("entrydc"));
            BigDecimal amount = entryDC == 1 ? debit : credit;
            BigDecimal amountlocal = entryDC == 1 ? debitlocal : creditlocal;
            amount = amount.multiply(BigDecimal.valueOf(accountDC)).multiply(BigDecimal.valueOf(entryDC));
            amountlocal = amountlocal.multiply(BigDecimal.valueOf(accountDC)).multiply(BigDecimal.valueOf(entryDC));
            entryAndAmountMap.put(entryid, new Tuple((Object)amount, (Object)amountlocal));
        }
        Date now = new Date();
        String tableName = "";
        String logMessage = "";
        String status = "1";
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                DynamicObject[] accts;
                ReciprocalDataRepairUtil.doUnWriteOffByAcctIds(writeOffedIds);
                for (DynamicObject dynamicObject : accts = BusinessDataServiceHelper.load((Object[])recordIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_acccurrent"))) {
                    Tuple amountAndAmountlocalTuple = (Tuple)entryAndAmountMap.get(dynamicObject.getLong("voucherentry"));
                    if (amountAndAmountlocalTuple == null) continue;
                    dynamicObject.set("amountfor", amountAndAmountlocalTuple.item1);
                    dynamicObject.set("amountbalfor", amountAndAmountlocalTuple.item1);
                    dynamicObject.set("amount", amountAndAmountlocalTuple.item2);
                    dynamicObject.set("amountbal", amountAndAmountlocalTuple.item2);
                    dynamicObject.set("status", (Object)"0");
                }
                SaveServiceHelper.update((DynamicObject[])accts);
            }
            catch (Exception e) {
                txHandle.markRollback();
                logMessage = e.getMessage();
                status = "0";
                throw e;
            }
        }
        finally {
            ReciprocalDataRepairUtil.reciDataRepairLog(checkType, now, tableName, logMessage, status);
        }
        return "";
    }

    @Override
    public String repairByCondition(ReportQueryParam param) {
        DataSet dataSet = this.queryCheckDataSet(param);
        ArrayList<Long> recordIds = new ArrayList<Long>(8);
        for (Row row : dataSet) {
            recordIds.add(row.getLong("id"));
        }
        String checkType = (String)param.getFilter().getValue("checktype");
        return this.repairSelected(checkType, recordIds);
    }

    @Override
    public DataSet queryCheckDataSet(ReportQueryParam param) {
        FilterInfo filterInfo = param.getFilter();
        Long orgId = filterInfo.getLong("org");
        Long bookTypeId = filterInfo.getLong("booktype");
        Long accountTableId = filterInfo.getLong("accounttable");
        if (orgId != null && orgId != 0L) {
            if (bookTypeId == null || bookTypeId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"ReciprocalDataCheckAndRepairPlugin_4", (String)"fi-gl-common", (Object[])new Object[0]));
            }
            if (accountTableId == null || accountTableId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u8868", (String)"ReciprocalDataCheckAndRepairPlugin_8", (String)"fi-gl-common", (Object[])new Object[0]));
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select ").append(" acct.fid id, acct.forgid org, acct.fbooktypeid booktype, acct.fperiodid period, acct.facctableid accounttable, acct.faccountid account, acct.fassgrpid assgrp, acct.fcurrencyid currency,acct.famountfor amountfor, acct.famountbalfor amountbalfor, acct.flocalcurrencyid localcurrency, acct.famount amount, acct.famountbal amountbal, acct.fbizdate bizdate, acct.fexpiredate expiredate, acct.fbiznum biznum, acct.fdescription description, acct.fstatus status, acct.fvchentryid voucherentry, acct.fsourcetype sourcetype, acct.fvoucherid voucherid").append(" from t_gl_acccurrent acct join t_gl_voucherentry ve on acct.fvchentryid = ve.fentryid where 1 = 1");
        if (orgId != null && orgId != 0L) {
            sb.append(" and acct.forgid = ").append(orgId);
            sb.append(" and acct.fbooktypeid = ").append(bookTypeId);
            sb.append(" and acct.facctableid = ").append(accountTableId);
        }
        sb.append(" and ((abs(acct.famountfor) != abs(ve.foriginalcredit) + abs(ve.foriginaldebit)) or (abs(acct.famount) != abs(ve.flocalcredit) + abs(ve.flocaldebit)))");
        return DB.queryDataSet((String)"AmountErrorUnit_queryCheckDataSet", (DBRoute)DBRoute.of((String)"gl"), (String)sb.toString());
    }

    @Override
    public List<AbstractReportColumn> getColums(List<AbstractReportColumn> columns) {
        return ReciprocalDataRepairUtil.getAccurrentColums(columns);
    }
}

