/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal.datarepair.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.impl.ThreadPoolImpl;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.reciprocal.datarepair.service.AbstractDataCheckAndRepairService;
import kd.fi.gl.reciprocal.datarepair.util.ReciprocalDataRepairUtil;
import kd.fi.gl.util.GLUtil;

public class NoAcccurrentUnit
extends AbstractDataCheckAndRepairService {
    private static final String VOUCHERENTYFIELD = " ve.fid id,ve.fentryid entry ,vc.forgid org ,vc.fbooktypeid booktype,vc.fnumber number,ve.fperiodid period,ve.faccountid account ,ve.fassgrpid assgrp,ve.foriginalcredit originalcredit,ve.foriginaldebit originaldebit,ve.flocalcredit localcredit,ve.flocaldebit localdebit,ve.fdescription description";
    private static final Log logger = LogFactory.getLog(NoAcccurrentUnit.class);

    @Override
    public String repairSelected(String checkType, List<Long> selectedIds) {
        if (CollectionUtils.isEmpty(selectedIds)) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u590d\u7684\u884c", (String)"ReciprocalDataCheckAndRepairPlugin_7", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        HashSet<Long> vchSet = new HashSet<Long>(selectedIds);
        ReciprocalUtils.processReciprocalRecord(vchSet);
        return "";
    }

    @Override
    public String repairByCondition(ReportQueryParam param) {
        Map customParam = param.getCustomParam();
        String pageId = (String)customParam.get("pageId");
        String cacheKey = pageId + "NoAcccurrentUnit";
        DistributeCache distributeCache = CacheHelper.getDistributeCache(CacheModule.report);
        String cacheId = distributeCache.get(cacheKey);
        DataSet dataSet = Algo.getCacheDataSet((String)cacheId).toDataSet(Algo.create((String)(this.getClass().getName() + "#repairByCondition")), true);
        String checkType = (String)param.getFilter().getValue("checktype");
        logger.info("=============== repairing reciprocal data....");
        int totalCnt = 0;
        int threadCnt = 8;
        ThreadPoolExecutor _executor = new ThreadPoolExecutor(threadCnt, threadCnt, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "fi.gl.reciprocal.repair-" + this.atomicInteger.incrementAndGet());
            }
        });
        _executor.allowCoreThreadTimeOut(true);
        ThreadPoolImpl threadPool = new ThreadPoolImpl(ThreadLifeCycleManager.wrapExecutorService((ExecutorService)_executor));
        LinkedBlockingQueue<MyTask> taskQueue = new LinkedBlockingQueue<MyTask>(threadCnt);
        int batchRepairSize = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.reciprocal.repair.batch", (int)1999);
        int taskIndex = 0;
        DataSet idDS = dataSet.select("id").distinct();
        ArrayList<Long> batchVchIds = new ArrayList<Long>(batchRepairSize);
        while (idDS.hasNext()) {
            long vid = idDS.next().getLong("id");
            batchVchIds.add(vid);
            if (batchVchIds.size() < batchRepairSize) continue;
            totalCnt += batchVchIds.size();
            MyTask task = new MyTask(checkType, new ArrayList<Long>(batchVchIds), taskQueue, ++taskIndex);
            try {
                taskQueue.put(task);
            }
            catch (InterruptedException e) {
                logger.error((Throwable)e);
            }
            threadPool.execute((Runnable)task);
            batchVchIds.clear();
        }
        if (!batchVchIds.isEmpty()) {
            totalCnt += batchVchIds.size();
            logger.info("had repair batch count: {}, taskIndex: {}", (Object)batchVchIds.size(), (Object)taskIndex);
            this.repairSelected(checkType, batchVchIds);
        }
        while (taskQueue.size() > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error((Throwable)e);
            }
        }
        threadPool.close();
        logger.info("=============== finished this repair task, total count: {}", (Object)totalCnt);
        return "";
    }

    @Override
    public DataSet queryCheckDataSet(ReportQueryParam param) {
        int queryNum;
        FilterInfo filterInfo = param.getFilter();
        Long orgId = filterInfo.getLong("org");
        Long bookTypeId = filterInfo.getLong("booktype");
        if (orgId != null && orgId != 0L && (bookTypeId == null || bookTypeId == 0L)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"ReciprocalDataCheckAndRepairPlugin_4", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        int limitSize = 100000;
        FilterInfo filter = param.getFilter();
        if (filter.containProp("querynumber") && (queryNum = filter.getInt("querynumber")) > 0) {
            limitSize = queryNum;
        }
        logger.info("queryCheckDataSet_limitsize:{}", (Object)limitSize);
        DataSet resultDt = null;
        if (orgId != null && orgId != 0L) {
            QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
            QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)bookTypeId);
            QFilter isEndInit = new QFilter("isendinit", "=", (Object)true);
            DynamicObjectCollection initAccDyn = QueryServiceHelper.query((String)"gl_reci_init_state", (String)"account.masterid accmasterid, account.id accid, account.number accnumber, endinitperiod", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, isEndInit});
            int totalCount = 0;
            for (int i = 0; i < initAccDyn.size(); ++i) {
                logger.info("=====queryprogress orgid:{}. account:{}/{}", new Object[]{orgId, i + 1, initAccDyn.size()});
                DynamicObject reciInit = (DynamicObject)initAccDyn.get(i);
                long acctMasterId = reciInit.getLong("accmasterid");
                long accId = reciInit.getLong("accid");
                String accNumber = reciInit.getString("accnumber");
                DynamicObjectCollection accDy = AccountVersionUtil.listAccountFullVersion((long)accId, (long)acctMasterId, (String)accNumber, (long)orgId, (String)"id,accheck");
                List accountIds = accDy.stream().filter(x -> x.getBoolean("accheck")).map(a -> a.getLong("id")).collect(Collectors.toList());
                if (accountIds.isEmpty()) continue;
                long endInitPeriod = reciInit.getLong("endinitperiod");
                List availablePeriods = PeriodUtil.getAvailableEndPeriodIds((String)">=", (Long)endInitPeriod, (Long[])new Long[]{orgId});
                if (!availablePeriods.contains(endInitPeriod)) {
                    availablePeriods.add(endInitPeriod);
                }
                for (Long period : availablePeriods) {
                    SqlBuilder sql = new SqlBuilder();
                    sql.append("select  ve.fid id,ve.fentryid entry ,vc.forgid org ,vc.fbooktypeid booktype,vc.fnumber number,ve.fperiodid period,ve.faccountid account ,ve.fassgrpid assgrp,ve.foriginalcredit originalcredit,ve.foriginaldebit originaldebit,ve.flocalcredit localcredit,ve.flocaldebit localdebit,ve.fdescription description", new Object[0]);
                    sql.append(" from t_gl_voucherentry ve join t_gl_voucher vc on ve.fid = vc.fid ", new Object[0]);
                    sql.append(" left join t_gl_acccurrent acct on acct.fvchentryid = ve.fentryid  ", new Object[0]);
                    sql.append(" where vc.fbooktypeid = ? and ve.forgid =? and ve.fperiodid = ? and vc.forgid = ? and vc.fperiodid = ? ", new Object[]{bookTypeId, orgId, period, orgId, period});
                    sql.appendIn("and ve.faccountid ", accountIds);
                    sql.append("and vc.fbillstatus != 'A' and acct.fid is null", new Object[0]);
                    DataSet voucherDt = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);
                    if (!voucherDt.isEmpty()) {
                        int count = voucherDt.copy().count("id", false);
                        if (count > limitSize - totalCount) {
                            voucherDt = voucherDt.limit(0, limitSize - totalCount);
                        }
                        totalCount += count;
                        DataSet dataSet = resultDt = resultDt == null ? voucherDt : resultDt.union(voucherDt);
                    }
                    if (totalCount < limitSize) continue;
                    break;
                }
                if (totalCount >= limitSize) break;
            }
            if (resultDt != null) {
                logger.info("queryCheckDataSet_totalCount:{}, limitsize:{}, resultDt size: {}", new Object[]{totalCount, limitSize, resultDt.copy().count("id", false)});
            }
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("select ").append(VOUCHERENTYFIELD).append(" from t_gl_voucherentry ve join t_gl_voucher vc on ve.fid = vc.fid join t_bd_account acc on ve.faccountid = acc.fid ").append(" and acc.faccheck = '1' join t_gl_reci_init_state reit on acc.fmasterid = reit.faccountid and reit.fisendinit = '1' and reit.forgid = vc.forgid and reit.fbooktypeid = vc.fbooktypeid and vc.fperiodid >= reit.fendinitperiod").append(" left join t_gl_acccurrent acct on acct.fvchentryid = ve.fentryid where 1 =1 ");
            if (orgId != null && orgId != 0L) {
                sb.append(" and vc.forgid = ").append(orgId);
                sb.append(" and vc.fbooktypeid = ").append(bookTypeId);
            }
            sb.append(" and vc.fbillstatus != 'A' and acct.fid is null ");
            resultDt = DB.queryDataSet((String)"NoAcccurrentUnit_queryCheckDataSet", (DBRoute)DBRoute.of((String)"gl"), (String)sb.toString());
        }
        DataSet dataSet = resultDt == null ? GLUtil.getEmptyDS(this.getClass()) : resultDt;
        Map customParam = param.getCustomParam();
        String pageId = (String)customParam.get("pageId");
        String cacheKey = pageId + "NoAcccurrentUnit";
        CachedDataSet cachedDataSet = dataSet.copy().cache(CacheHint.getDefault());
        String cacheId = cachedDataSet.getCacheId();
        DistributeCache distributeCache = CacheHelper.getDistributeCache(CacheModule.report);
        distributeCache.put(cacheKey, cacheId);
        return dataSet;
    }

    @Override
    public List<AbstractReportColumn> getColums(List<AbstractReportColumn> columns) {
        ArrayList<AbstractReportColumn> customColumns = new ArrayList<AbstractReportColumn>(8);
        LocaleString orgName = new LocaleString(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"NoAcccurrentUnit_0", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn orgColumn = ReciprocalDataRepairUtil.createColumn(orgName, "org", "basedata", Boolean.FALSE);
        orgColumn.setEntityId("bos_org");
        orgColumn.setDisplayProp("name");
        customColumns.add((AbstractReportColumn)orgColumn);
        LocaleString periodName = new LocaleString(ResManager.loadKDString((String)"\u671f\u95f4", (String)"NoAcccurrentUnit_1", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn periodColumn = ReciprocalDataRepairUtil.createColumn(periodName, "period", "basedata", Boolean.FALSE);
        periodColumn.setEntityId("bd_period");
        customColumns.add((AbstractReportColumn)periodColumn);
        customColumns.addAll(columns);
        LocaleString voucherNumberName = new LocaleString(ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7", (String)"NoAcccurrentUnit_2", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn voucherNumberColumn = ReciprocalDataRepairUtil.createColumn(voucherNumberName, "number", "text", Boolean.FALSE);
        customColumns.add((AbstractReportColumn)voucherNumberColumn);
        LocaleString originaldebitName = new LocaleString(ResManager.loadKDString((String)"\u539f\u5e01\u501f\u65b9\u91d1\u989d", (String)"NoAcccurrentUnit_3", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn originaldebitColumn = ReciprocalDataRepairUtil.createColumn(originaldebitName, "originaldebit", "amount", Boolean.FALSE);
        customColumns.add((AbstractReportColumn)originaldebitColumn);
        LocaleString originalcreditName = new LocaleString(ResManager.loadKDString((String)"\u539f\u5e01\u8d37\u65b9\u91d1\u989d", (String)"NoAcccurrentUnit_4", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn originalcreditColumn = ReciprocalDataRepairUtil.createColumn(originalcreditName, "originalcredit", "amount", Boolean.FALSE);
        customColumns.add((AbstractReportColumn)originalcreditColumn);
        LocaleString localdebitName = new LocaleString(ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u501f\u65b9\u91d1\u989d", (String)"NoAcccurrentUnit_5", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn localdebitColumn = ReciprocalDataRepairUtil.createColumn(localdebitName, "localdebit", "amount", Boolean.FALSE);
        customColumns.add((AbstractReportColumn)localdebitColumn);
        LocaleString localcreditName = new LocaleString(ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u8d37\u65b9\u91d1\u989d", (String)"NoAcccurrentUnit_6", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn localcreditColumn = ReciprocalDataRepairUtil.createColumn(localcreditName, "localcredit", "amount", Boolean.FALSE);
        customColumns.add((AbstractReportColumn)localcreditColumn);
        LocaleString descName = new LocaleString(ResManager.loadKDString((String)"\u6458\u8981", (String)"NoAcccurrentUnit_7", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn descColumn = ReciprocalDataRepairUtil.createColumn(descName, "description", "text", Boolean.FALSE);
        descColumn.setDisplayProp("number");
        customColumns.add((AbstractReportColumn)descColumn);
        LocaleString idName = new LocaleString(ResManager.loadKDString((String)"\u51ed\u8bc1id", (String)"NoAcccurrentUnit_8", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn idColumn = ReciprocalDataRepairUtil.createColumn(idName, "id", "text", Boolean.FALSE);
        customColumns.add((AbstractReportColumn)idColumn);
        LocaleString entryIdName = new LocaleString(ResManager.loadKDString((String)"\u51ed\u8bc1\u5206\u5f55id", (String)"NoAcccurrentUnit_9", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn entryIdColumn = ReciprocalDataRepairUtil.createColumn(entryIdName, "entry", "text", Boolean.FALSE);
        customColumns.add((AbstractReportColumn)entryIdColumn);
        return customColumns;
    }

    private static class MyTask
    implements Runnable {
        private final String taskType;
        private final List<Long> vids;
        private final BlockingQueue<MyTask> queue;
        private final int taskIndex;

        public MyTask(String taskType, List<Long> vids, BlockingQueue<MyTask> queue, int taskIndex) {
            this.taskType = taskType;
            this.vids = vids;
            this.queue = queue;
            this.taskIndex = taskIndex;
        }

        @Override
        public void run() {
            new NoAcccurrentUnit().repairSelected(this.taskType, this.vids);
            logger.info("had repair batch count: {}, taskIndex: {}", (Object)this.vids.size(), (Object)this.taskIndex);
            this.queue.poll();
        }
    }
}

