/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal.datarepair.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.reciprocal.datarepair.service.AbstractDataCheckAndRepairService;
import kd.fi.gl.reciprocal.datarepair.util.ReciprocalDataRepairUtil;

public class NoReciprocalLogUnit
extends AbstractDataCheckAndRepairService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String repairSelected(String checkType, List<Long> recordIds) {
        if (CollectionUtils.isEmpty(recordIds)) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u590d\u7684\u884c", (String)"ReciprocalDataCheckAndRepairPlugin_7", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>(16);
        lstFilters.add(new QFilter("id", "in", recordIds));
        DataSet reciprocalDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_acccurrent", (String)"id as acctid,status,amountfor,amount", (QFilter[])lstFilters.toArray(new QFilter[0]), null);
        HashMap<Long, Tuple> entryAndAmountMap = new HashMap<Long, Tuple>(8);
        ArrayList<Long> writeOffedIds = new ArrayList<Long>(16);
        for (Row row : reciprocalDataSet.copy()) {
            BigDecimal amountfor = row.getBigDecimal("amountfor");
            BigDecimal amount = row.getBigDecimal("amount");
            Long acctId = row.getLong("acctid");
            entryAndAmountMap.put(acctId, new Tuple((Object)amountfor, (Object)amount));
            if ("0".equals(row.getString("status"))) continue;
            writeOffedIds.add(acctId);
        }
        Date now = new Date();
        String tableName = "";
        String logMessage = "";
        String status = "1";
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                DynamicObject[] accts;
                ReciprocalDataRepairUtil.doUnWriteOffByAcctIds(writeOffedIds);
                for (DynamicObject dynamicObject : accts = BusinessDataServiceHelper.load((Object[])recordIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_acccurrent"))) {
                    Tuple amountAndAmountlocalTuple = (Tuple)entryAndAmountMap.get(dynamicObject.getLong("id"));
                    if (amountAndAmountlocalTuple == null) continue;
                    dynamicObject.set("amountbalfor", amountAndAmountlocalTuple.item1);
                    dynamicObject.set("amountbal", amountAndAmountlocalTuple.item2);
                    dynamicObject.set("status", (Object)"0");
                }
                SaveServiceHelper.update((DynamicObject[])accts);
            }
            catch (Exception e) {
                txHandle.markRollback();
                logMessage = e.getMessage();
                status = "0";
                throw e;
            }
        }
        finally {
            ReciprocalDataRepairUtil.reciDataRepairLog(checkType, now, tableName, logMessage, status);
        }
        return null;
    }

    @Override
    public String repairByCondition(ReportQueryParam param) {
        DataSet dataSet = this.queryCheckDataSet(param);
        ArrayList<Long> recordIds = new ArrayList<Long>(8);
        for (Row row : dataSet) {
            recordIds.add(row.getLong("id"));
        }
        String checkType = (String)param.getFilter().getValue("checktype");
        return this.repairSelected(checkType, recordIds);
    }

    @Override
    public DataSet queryCheckDataSet(ReportQueryParam param) {
        FilterInfo filterInfo = param.getFilter();
        Long orgId = filterInfo.getLong("org");
        Long bookTypeId = filterInfo.getLong("booktype");
        Long accountTableId = filterInfo.getLong("accounttable");
        if (orgId != null && orgId != 0L) {
            if (bookTypeId == null || bookTypeId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"ReciprocalDataCheckAndRepairPlugin_4", (String)"fi-gl-common", (Object[])new Object[0]));
            }
            if (accountTableId == null || accountTableId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u8868", (String)"ReciprocalDataCheckAndRepairPlugin_8", (String)"fi-gl-common", (Object[])new Object[0]));
            }
        }
        StringBuilder buyerentrySb = new StringBuilder();
        buyerentrySb.append("select ").append(" acct.fid id, acct.forgid org, acct.fbooktypeid booktype, acct.fperiodid period, acct.facctableid accounttable, acct.faccountid account, acct.fassgrpid assgrp, acct.fcurrencyid currency,acct.famountfor amountfor, acct.famountbalfor amountbalfor, acct.flocalcurrencyid localcurrency, acct.famount amount, acct.famountbal amountbal, acct.fbizdate bizdate, acct.fexpiredate expiredate, acct.fbiznum biznum, acct.fdescription description, acct.fstatus status, acct.fvchentryid voucherentry, acct.fsourcetype sourcetype, acct.fvoucherid voucherid").append(" from t_gl_acccurrent acct  left join t_gl_reciprocal_log rin on acct.fid = rin.fbuyerentryid where acct.fstatus != '0' and rin.fid is null and acct.famountfor > 0");
        if (orgId != null && orgId != 0L) {
            buyerentrySb.append(" and acct.forgid = ").append(orgId);
            buyerentrySb.append(" and acct.fbooktypeid = ").append(bookTypeId);
            buyerentrySb.append(" and acct.facctableid = ").append(accountTableId);
        }
        DataSet buyerentrySet = DB.queryDataSet((String)"NoReciprocalLogUnit_buyerentry_queryCheckDataSet", (DBRoute)DBRoute.of((String)"gl"), (String)buyerentrySb.toString());
        StringBuilder writeoffentrySb = new StringBuilder();
        writeoffentrySb.append("select ").append(" acct.fid id, acct.forgid org, acct.fbooktypeid booktype, acct.fperiodid period, acct.facctableid accounttable, acct.faccountid account, acct.fassgrpid assgrp, acct.fcurrencyid currency,acct.famountfor amountfor, acct.famountbalfor amountbalfor, acct.flocalcurrencyid localcurrency, acct.famount amount, acct.famountbal amountbal, acct.fbizdate bizdate, acct.fexpiredate expiredate, acct.fbiznum biznum, acct.fdescription description, acct.fstatus status, acct.fvchentryid voucherentry, acct.fsourcetype sourcetype, acct.fvoucherid voucherid").append(" from t_gl_acccurrent acct left join t_gl_reciprocal_log rin on acct.fid = rin.fwriteoffentryid where acct.fstatus != '0' and rin.fid is null and acct.famountfor < 0");
        if (orgId != null && orgId != 0L) {
            writeoffentrySb.append(" and acct.forgid = ").append(orgId);
            writeoffentrySb.append(" and acct.fbooktypeid = ").append(bookTypeId);
            writeoffentrySb.append(" and acct.facctableid = ").append(accountTableId);
        }
        DataSet writeoffentrySet = DB.queryDataSet((String)"NoReciprocalLogUnit_writeoffentry_queryCheckDataSet", (DBRoute)DBRoute.of((String)"gl"), (String)writeoffentrySb.toString());
        return buyerentrySet.union(writeoffentrySet);
    }

    @Override
    public List<AbstractReportColumn> getColums(List<AbstractReportColumn> columns) {
        return ReciprocalDataRepairUtil.getAccurrentColums(columns);
    }
}

