/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal.datarepair.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.reciprocal.datarepair.service.AbstractDataCheckAndRepairService;
import kd.fi.gl.reciprocal.datarepair.util.ReciprocalDataRepairUtil;

public class ReciprocalLogErrorUnit
extends AbstractDataCheckAndRepairService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String repairSelected(String checkType, List<Long> recordIds) {
        Date now = new Date();
        String tableName = "";
        String logMessage = "";
        String status = "1";
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                QFilter[] logFilters = new QFilter[]{new QFilter("id", "in", recordIds)};
                ArrayList<Long> reciLogIds = new ArrayList<Long>(16);
                try (DataSet logDataSet = QueryServiceHelper.queryDataSet((String)"gl_ReciprocalDataCheckAndRepairPlugin_querylog", (String)"gl_reciprocal_log", (String)"id", (QFilter[])logFilters, null);){
                    for (Row row : logDataSet) {
                        reciLogIds.add(row.getLong("id"));
                    }
                }
                if (!reciLogIds.isEmpty()) {
                    ReciprocalUtils.doUnWriteOff(reciLogIds);
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                logMessage = e.getMessage();
                status = "0";
                throw e;
            }
        }
        finally {
            ReciprocalDataRepairUtil.reciDataRepairLog(checkType, now, tableName, logMessage, status);
        }
        return "";
    }

    @Override
    public String repairByCondition(ReportQueryParam param) {
        DataSet dataSet = this.queryCheckDataSet(param);
        ArrayList<Long> recordIds = new ArrayList<Long>(8);
        for (Row row : dataSet) {
            recordIds.add(row.getLong("id"));
        }
        String checkType = (String)param.getFilter().getValue("checktype");
        return this.repairSelected(checkType, recordIds);
    }

    @Override
    public DataSet queryCheckDataSet(ReportQueryParam param) {
        FilterInfo filterInfo = param.getFilter();
        Long orgId = filterInfo.getLong("org");
        Long bookTypeId = filterInfo.getLong("booktype");
        Long accountTableId = filterInfo.getLong("accounttable");
        if (orgId != null && orgId != 0L) {
            if (bookTypeId == null || bookTypeId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"ReciprocalLogErrorUnit_0", (String)"fi-gl-common", (Object[])new Object[0]));
            }
            if (accountTableId == null || accountTableId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u8868", (String)"ReciprocalLogErrorUnit_1", (String)"fi-gl-common", (Object[])new Object[0]));
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select ").append(" rin.fid id,rin.forgid org,rin.fbooktypeid booktype,rin.facctableid accounttable,rin.fperiodid period,rin.faccountid account, rin.fassgrpid assgrp,rin.famountfor amountfor,rin.famount amount,rin.fwriteoffentryid writeoffentry,rin.fbuyerentryid buyerentry,rin.fcurrencyid currency").append(" from t_gl_reciprocal_log rin join t_gl_acccurrent acct1 on rin.FBUYERENTRYID = acct1.FID join t_gl_acccurrent acct2 on rin.FWRITEOFFENTRYID = acct2.FID where (acct1.FACCOUNTID != acct2.FACCOUNTID or acct1.FASSGRPID != acct2.FASSGRPID or acct1.FORGID != acct2.FORGID or acct1.FBOOKTYPEID != acct2.FBOOKTYPEID\nor acct1.FCURRENCYID != acct2.FCURRENCYID or acct1.FLOCALCURRENCYID != acct2.FLOCALCURRENCYID or rin.FORGID != acct1.FORGID or rin.FBOOKTYPEID != acct1.FBOOKTYPEID or rin.FACCTABLEID != acct1.FACCTABLEID or rin.FACCOUNTID != acct1.FACCOUNTID or rin.FASSGRPID != acct1.FASSGRPID or rin.FLOCALCURRENCYID != acct1.FLOCALCURRENCYID)");
        if (orgId != null && orgId != 0L) {
            sb.append(" and rin.forgid = ").append(orgId);
            sb.append(" and rin.fbooktypeid = ").append(bookTypeId);
            sb.append(" and rin.facctableid = ").append(accountTableId);
        }
        return DB.queryDataSet((String)"ReciprocalLogErrorUnit_queryCheckDataSet", (DBRoute)DBRoute.of((String)"gl"), (String)sb.toString());
    }

    @Override
    public List<AbstractReportColumn> getColums(List<AbstractReportColumn> columns) {
        ArrayList<AbstractReportColumn> customColumns = new ArrayList<AbstractReportColumn>(8);
        LocaleString orgName = new LocaleString(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"NoAcccurrentUnit_0", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn orgColumn = ReciprocalDataRepairUtil.createColumn(orgName, "org", "basedata", Boolean.FALSE);
        orgColumn.setEntityId("bos_org");
        orgColumn.setDisplayProp("name");
        customColumns.add((AbstractReportColumn)orgColumn);
        LocaleString periodName = new LocaleString(ResManager.loadKDString((String)"\u671f\u95f4", (String)"NoAcccurrentUnit_1", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn periodColumn = ReciprocalDataRepairUtil.createColumn(periodName, "period", "basedata", Boolean.FALSE);
        periodColumn.setEntityId("bd_period");
        customColumns.add((AbstractReportColumn)periodColumn);
        customColumns.addAll(columns);
        LocaleString currencyName = new LocaleString(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"ReciprocalLogErrorUnit_2", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn currencyColumn = ReciprocalDataRepairUtil.createColumn(currencyName, "currency", "basedata", Boolean.FALSE);
        currencyColumn.setEntityId("bd_currency");
        currencyColumn.setDisplayProp("name");
        customColumns.add((AbstractReportColumn)currencyColumn);
        LocaleString idName = new LocaleString(ResManager.loadKDString((String)"\u6838\u9500\u65e5\u5fd7id", (String)"ReciprocalLogErrorUnit_3", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn idColumn = ReciprocalDataRepairUtil.createColumn(idName, "id", "text", Boolean.FALSE);
        customColumns.add((AbstractReportColumn)idColumn);
        LocaleString writeoffentryName = new LocaleString(ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55id", (String)"ReciprocalLogErrorUnit_4", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn writeoffentryColumn = ReciprocalDataRepairUtil.createColumn(writeoffentryName, "writeoffentry", "text", Boolean.FALSE);
        customColumns.add((AbstractReportColumn)writeoffentryColumn);
        LocaleString buyerentryName = new LocaleString(ResManager.loadKDString((String)"\u6302\u8d26\u8bb0\u5f55id", (String)"ReciprocalLogErrorUnit_5", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn buyerentryColumn = ReciprocalDataRepairUtil.createColumn(buyerentryName, "buyerentry", "text", Boolean.FALSE);
        customColumns.add((AbstractReportColumn)buyerentryColumn);
        LocaleString amountforName = new LocaleString(ResManager.loadKDString((String)"\u6838\u9500\u539f\u5e01\u91d1\u989d", (String)"ReciprocalLogErrorUnit_6", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn amountforColumn = ReciprocalDataRepairUtil.createColumn(amountforName, "amountfor", "amount", Boolean.FALSE);
        customColumns.add((AbstractReportColumn)amountforColumn);
        LocaleString amountbalforName = new LocaleString(ResManager.loadKDString((String)"\u6838\u9500\u672c\u4f4d\u5e01\u91d1\u989d", (String)"ReciprocalLogErrorUnit_7", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn amountbalforColumn = ReciprocalDataRepairUtil.createColumn(amountbalforName, "amount", "amount", Boolean.FALSE);
        customColumns.add((AbstractReportColumn)amountbalforColumn);
        return customColumns;
    }
}

