/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal.simulate.balance;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.reciprocal.ReciprocalRecord;
import kd.fi.gl.reciprocal.simulate.balance.AgingResult;
import kd.fi.gl.reciprocal.simulate.balance.WriteOffParam;
import kd.fi.gl.reciprocal.simulate.balance.vo.AssistVO;
import kd.fi.gl.reciprocal.simulate.balance.vo.BalanceVO;
import kd.fi.gl.util.AssistEntityQueryHelper;
import kd.fi.gl.util.DataSetHelper;
import kd.fi.gl.util.DataSetUtils;
import kd.fi.gl.util.DateUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MultiIndexTreeCache;

@Deprecated
public class AccCurrentOptService {
    private static final Log LOG = LogFactory.getLog(AccCurrentOptService.class);
    public static final List<String> ACCCURALLFILEDS = Splitter.on((String)",").trimResults().splitToList((CharSequence)"id, org, booktype, account,assgrp.id assgrpid,assgrp.value assval, sourcetype, currency, localcurrency, amountfor, amount , amountbalfor, amountbal, voucherid, voucherentry, description, biznum, entrydc,bizdate,expiredate, bookeddate, status");
    private PerformanceWatch watch = new PerformanceWatch(AccCurrentOptService.class, "balanceWriteOff", false);
    private long lastPeriodId = 0L;
    protected WriteOffParam writeOffParam;
    private MultiIndexTreeCache<BalanceVO> balanceCache;
    private List<Tuple<Object[], BalanceVO>> dimensionList = new ArrayList<Tuple<Object[], BalanceVO>>(8);
    private AgingResult agingResult;

    public AccCurrentOptService(WriteOffParam writeOffParam, AgingResult agingResult) {
        this.writeOffParam = writeOffParam;
        this.agingResult = agingResult;
    }

    public void balanceWriteOff() {
        if (DebugTrace.enable()) {
            LOG.info("==AccCurrentOptService_writeOffParam:{}", (Object)this.writeOffParam);
        }
        this.watch.start("queryBalance");
        DataSet balanceData = this.queryBalance();
        if (DebugTrace.enable()) {
            DataSetHelper.logDataSet("==AccCurrentOptService_deductAllBal_balanceData:", balanceData);
        }
        this.watch.stop();
        this.watch.start("balanceToTreeCache");
        this.balanceCache = this.balanceToTreeCache(balanceData);
        this.watch.stop();
        this.executeSimulate();
        LOG.info("==AccCurrentOptService :{}", (Object)this.watch.show());
    }

    private MultiIndexTreeCache<BalanceVO> balanceToTreeCache(DataSet balanceData) {
        MultiIndexTreeCache<BalanceVO> balanceCache = new MultiIndexTreeCache<BalanceVO>("balance_deposit", 10000000);
        while (balanceData.hasNext()) {
            Row row = balanceData.next();
            BigDecimal amountbalfor = row.getBigDecimal("amountbalfor");
            BigDecimal amountbal = row.getBigDecimal("amountbal");
            int dcFor = this.writeOffParam.getAccountDc() * amountbalfor.compareTo(BigDecimal.ZERO) > 0 ? 1 : -1;
            int dc = this.writeOffParam.getAccountDc() * amountbal.compareTo(BigDecimal.ZERO) > 0 ? 1 : -1;
            BalanceVO balanceVO = new BalanceVO(amountbalfor.abs(), amountbal.abs(), dcFor, dc);
            Object[] com = this.comAssgrpKey(row);
            balanceCache.addData(balanceVO, com);
            this.dimensionList.add((Tuple<Object[], BalanceVO>)new Tuple((Object)com, (Object)balanceVO));
        }
        balanceData.close();
        return balanceCache;
    }

    public void executeSimulate() {
        this.deductAllBal();
    }

    private DataSet writeOffRefoundRecord(ThreeTuple<Date, Date, List<Long>> beforeRangDate) {
        SqlBuilder buyerSql = new SqlBuilder();
        buyerSql.append("select ", new Object[0]);
        ((Set)this.writeOffParam.getAcctToAssit().getValue()).forEach(k -> buyerSql.append(k + ".fvalue", new Object[0]).append("\"" + k + "\",", new Object[0]));
        buyerSql.append("buyer.fid id, buyer.forgid org, buyer.fbooktypeid booktype, buyer.faccountid account, buyer.fassgrpid assgrpid, ass.fvalue assval, buyer.fsourcetype sourcetype, buyer.fcurrencyid currency ,buyer.flocalcurrencyid localcurrency, 0 amount, 0 amountfor, l.famountfor  famountbalfor, l.famount  famountbal, buyer.fvoucherid voucherid, buyer.fvchentryid voucherentry, buyer.fdescription description, buyer.fbiznum biznum, buyer.fentrydc entrydc,buyer.fbizdate bizdate,buyer.fexpiredate expiredate, buyer.fbookeddate bookeddate, buyer.fstatus status", new Object[0]);
        buyerSql.append(" from t_gl_reciprocal_log l", new Object[0]).append(" inner join t_gl_acccurrent buyer on l.fbuyerentryid = buyer.fid", new Object[0]).append(" inner join t_gl_acccurrent wf on l.fwriteoffentryid = wf.fid", new Object[0]).append(" inner join t_gl_assist ass on buyer.fassgrpid = ass.fid", new Object[0]);
        ((Set)this.writeOffParam.getAcctToAssit().getValue()).forEach(k -> buyerSql.append(" LEFT JOIN t_gl_assist_bd " + k + " ON " + k + ".fid=buyer.fassgrpid and " + k + ".fflexfield = ?", new Object[]{k}));
        buyerSql.append(" where l.forgid = ?", new Object[]{this.writeOffParam.getOrgId()}).append(" and l.fbooktypeid = ?", new Object[]{this.writeOffParam.getBookTypeId()}).append(" and l.facctableid = ?", new Object[]{this.writeOffParam.getAcctTableId()}).append(" and l.faccountid = ? ", new Object[]{this.writeOffParam.getAcctToAssit().getKey()}).append(" and wf.forgid = ?", new Object[]{this.writeOffParam.getOrgId()}).append(" and wf.fbooktypeid = ?", new Object[]{this.writeOffParam.getBookTypeId()}).append(" and wf.facctableid = ?", new Object[]{this.writeOffParam.getAcctTableId()}).append(" and wf.fbookeddate > ?", new Object[]{this.writeOffParam.getBookeddate()}).append(" and ? < buyer.fbizdate and buyer.fbizdate <= ?", new Object[]{beforeRangDate.item1, beforeRangDate.item2});
        ((Set)this.writeOffParam.getAcctToAssit().getValue()).forEach(k -> {
            Set<Long> assValue = this.writeOffParam.getAssistVOMap().get(k).getAssValue();
            if (assValue.size() > 0) {
                buyerSql.appendIn(" and " + k + ".fvalue", new ArrayList<Long>(assValue));
            }
        });
        if (DebugTrace.enable()) {
            LOG.info("==AccCurrentOptService_writeOffRefoundRecord_buyerSql sql:{}", (Object)buyerSql);
        }
        DataSet buyerDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)buyerSql);
        SqlBuilder wfSql = new SqlBuilder();
        wfSql.append("select ", new Object[0]);
        ((Set)this.writeOffParam.getAcctToAssit().getValue()).forEach(k -> wfSql.append(k + ".fvalue", new Object[0]).append("\"" + k + "\",", new Object[0]));
        wfSql.append("wf.fid id, wf.forgid org, wf.fbooktypeid booktype, wf.faccountid account, wf.fassgrpid fassgrpid, ass.fvalue assval, wf.fsourcetype sourcetype, wf.fcurrencyid currency ,wf.flocalcurrencyid localcurrency, 0 amount, 0 amountfor, -1 * l.famountfor  famountbalfor, -1 * l.famount  famountbal, wf.fvoucherid voucherid, wf.fvchentryid voucherentry, wf.fdescription description, wf.fbiznum biznum, wf.fentrydc entrydc,wf.fbizdate bizdate,wf.fexpiredate expiredate, wf.fbookeddate bookeddate, wf.fstatus status", new Object[0]);
        wfSql.append(" from t_gl_reciprocal_log l", new Object[0]).append(" inner join t_gl_acccurrent buyer on l.fbuyerentryid = buyer.fid", new Object[0]).append(" inner join t_gl_acccurrent wf on l.fwriteoffentryid = wf.fid", new Object[0]).append(" inner join t_gl_assist ass on wf.fassgrpid = ass.fid", new Object[0]);
        ((Set)this.writeOffParam.getAcctToAssit().getValue()).forEach(k -> wfSql.append(" LEFT JOIN t_gl_assist_bd " + k + " ON " + k + ".fid=buyer.fassgrpid and " + k + ".fflexfield = ?", new Object[]{k}));
        wfSql.append(" where l.forgid = ?", new Object[]{this.writeOffParam.getOrgId()}).append(" and l.fbooktypeid = ?", new Object[]{this.writeOffParam.getBookTypeId()}).append(" and l.facctableid = ?", new Object[]{this.writeOffParam.getAcctTableId()}).append(" and l.faccountid = ? ", new Object[]{this.writeOffParam.getAcctToAssit().getKey()}).append(" and buyer.forgid = ?", new Object[]{this.writeOffParam.getOrgId()}).append(" and buyer.fbooktypeid = ?", new Object[]{this.writeOffParam.getBookTypeId()}).append(" and buyer.facctableid = ?", new Object[]{this.writeOffParam.getAcctTableId()}).append(" and buyer.fbookeddate > ?", new Object[]{this.writeOffParam.getBookeddate()}).append(" and ? < wf.fbizdate and wf.fbizdate <= ?", new Object[]{beforeRangDate.item1, beforeRangDate.item2});
        ((Set)this.writeOffParam.getAcctToAssit().getValue()).forEach(k -> {
            Set<Long> assValue = this.writeOffParam.getAssistVOMap().get(k).getAssValue();
            if (assValue.size() > 0) {
                wfSql.appendIn(" and " + k + ".fvalue", new ArrayList<Long>(assValue));
            }
        });
        if (DebugTrace.enable()) {
            LOG.info("==AccCurrentOptService_writeOffRefoundRecord_wfSql sql:{}", (Object)wfSql);
        }
        DataSet wfDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)wfSql);
        return buyerDs.union(wfDs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deductAllBal() {
        ThreeTuple<Date, Date, List<Long>> beforeRangDate;
        Date reciInitBeginDate = this.reciInitBeginDate();
        Set balVOSet = this.dimensionList.stream().map(v -> (BalanceVO)v.item2).collect(Collectors.toSet());
        do {
            beforeRangDate = this.getBeforeRangDate(reciInitBeginDate);
            QFilter filter = new QFilter("status", "in", Arrays.asList("0", "1"));
            filter.and(new QFilter("bookeddate", "<=", (Object)this.writeOffParam.getBookeddate()));
            filter.and(new QFilter("bizdate", ">", beforeRangDate.item1));
            filter.and(new QFilter("bizdate", "<=", beforeRangDate.item2));
            boolean isFirstAdd = true;
            try (DataSet beforeAccCur = this.queryAccCurrentByDate(ACCCURALLFILEDS, filter, "currency asc, assgrp asc, bizdate desc, id desc ");){
                if (DebugTrace.enable()) {
                    DataSetHelper.logDataSet("==AccCurrentOptService_deductAllBal_beforeAccCur:", beforeAccCur);
                }
                try (DataSet refoundDs = this.writeOffRefoundRecord(beforeRangDate);){
                    DataSet beforeResult;
                    if (DebugTrace.enable()) {
                        DataSetHelper.logDataSet("==AccCurrentOptService_deductAllBal_refoundDs:", refoundDs);
                    }
                    DataSet dataSet = beforeResult = refoundDs.hasNext() ? DataSetUtils.gainSumDataSet(beforeAccCur.union(refoundDs)).orderBy(new String[]{"currency asc", "assgrpid asc", "bizdate desc", " id desc "}) : beforeAccCur;
                    if (DebugTrace.enable()) {
                        DataSetHelper.logDataSet("==AccCurrentOptService_deductAllBal_beforeResult:", beforeResult);
                    }
                    this.watch.start("==deductAllBal begin:" + filter);
                    while (beforeResult.hasNext()) {
                        ReciprocalRecord unWriteOffVO;
                        Row row = beforeResult.next();
                        BalanceVO balanceVO = this.balanceCache.retrieval(this.comAssgrpKey(row));
                        if (DebugTrace.enable()) {
                            LOG.info("==AccCurrentOptService_deductAllBal_balanceVO:{}", (Object)balanceVO);
                        }
                        if (Objects.isNull(balanceVO) || balanceVO.getLeavingAmountFor().compareTo(BigDecimal.ZERO) == 0 && balanceVO.getLeavingAmount().compareTo(BigDecimal.ZERO) == 0) {
                            LOG.info("==AccCurrentOptService_deductAllBal_balanceVO Balance:0");
                            balVOSet.remove(balanceVO);
                        }
                        if (balVOSet.size() == 0) {
                            LOG.info("==AccCurrentOptService_deductAllBal_balVOSet Size:0");
                            return;
                        }
                        if (!Objects.nonNull(balanceVO) || !Objects.nonNull(unWriteOffVO = this.buildWriteOffRecord(balanceVO, row))) continue;
                        boolean agingCalculate = this.agingResult.add(unWriteOffVO, isFirstAdd);
                        isFirstAdd = false;
                        if (agingCalculate) continue;
                        return;
                    }
                    this.watch.stop();
                }
            }
        } while (this.PreInitBeginDate().compareTo((Date)beforeRangDate.item1) != 0);
    }

    private ReciprocalRecord buildWriteOffRecord(BalanceVO balanceVO, Row row) {
        BigDecimal amountbalfor = row.getBigDecimal("amountbalfor");
        BigDecimal deductAmountFor = BigDecimal.ZERO;
        if (balanceVO.getDcFor() == 1 && amountbalfor.compareTo(BigDecimal.ZERO) > 0 || balanceVO.getDcFor() == -1 && amountbalfor.compareTo(BigDecimal.ZERO) < 0) {
            deductAmountFor = balanceVO.deductFor(amountbalfor.abs());
        }
        BigDecimal amountbal = row.getBigDecimal("amountbal");
        BigDecimal deductAmount = BigDecimal.ZERO;
        if (balanceVO.getDc() == 1 && amountbal.compareTo(BigDecimal.ZERO) > 0 || balanceVO.getDc() == -1 && amountbal.compareTo(BigDecimal.ZERO) < 0) {
            deductAmount = balanceVO.deduct(amountbal.abs());
        }
        if (DebugTrace.enable()) {
            LOG.info("==AccCurrentOptService_deductAllBal_row:{} , deductAmountFor:{}, deductAmount:{}", new Object[]{row, deductAmountFor, deductAmount});
        }
        if (deductAmountFor.compareTo(BigDecimal.ZERO) > 0 || deductAmount.compareTo(BigDecimal.ZERO) > 0) {
            ReciprocalRecord acccurrent = this.buildUnWriteOffRecords(row);
            acccurrent.setLeavingAmountFor(deductAmountFor.multiply(new BigDecimal(balanceVO.getDcFor())));
            acccurrent.setLeavingAmount(deductAmount.multiply(new BigDecimal(balanceVO.getDc())));
            return acccurrent;
        }
        return null;
    }

    private Object[] comAssgrpKey(Row row) {
        Set assistVOMap = (Set)this.writeOffParam.getAcctToAssit().getValue();
        Object[] dimensionKey = new Object[assistVOMap.size() + 1];
        int i = 0;
        for (String flexField : assistVOMap) {
            AssistVO assistVO = this.writeOffParam.getAssistVOMap().get(flexField);
            Map<Long, Set<Long>> amongOrg = assistVO.getAmongOrg();
            Set<Long> userOrgs = amongOrg.get(row.getLong("account"));
            dimensionKey[i] = Objects.nonNull(userOrgs) && userOrgs.contains(row.getLong("org")) ? row.getString(flexField) : "0";
            ++i;
        }
        dimensionKey[dimensionKey.length - 1] = row.getLong("currency");
        return dimensionKey;
    }

    private ReciprocalRecord buildUnWriteOffRecords(Row row) {
        ReciprocalRecord record = new ReciprocalRecord();
        record.setId(row.getLong("id"));
        record.setOrg(row.getLong("org"));
        record.setBookType(row.getLong("booktype"));
        record.setVoucherId(row.getLong("voucherid"));
        record.setVchEntryId(row.getLong("voucherentry"));
        record.setAccount(row.getLong("account"));
        record.setAssgrp(row.getLong("assgrpid"));
        String assval = row.getString("assval");
        if (Objects.nonNull(assval)) {
            record.setAssgrpVals((Map<String, Object>)JSONObject.parseObject((String)assval));
        }
        record.setCurrency(row.getLong("currency"));
        record.setLocalCurrency(row.getLong("localcurrency"));
        record.setBizDate(row.getDate("bizdate"));
        record.setExpireDate(row.getDate("expiredate"));
        record.setDescription(row.getString("description"));
        record.setBizNum(row.getString("biznum"));
        record.setAmountFor(row.getBigDecimal("amountfor"));
        record.setAmountBalFor(row.getBigDecimal("amountbalfor"));
        record.setEntryDc(row.getString("entrydc").trim());
        record.setAmount(row.getBigDecimal("amount"));
        record.setAmountBal(row.getBigDecimal("amountbal"));
        record.setStatus(row.getString("status"));
        return record;
    }

    public DataSet queryBalance() {
        AccountBookInfo bookInfo = this.writeOffParam.getBookInfo();
        Date maxMonthDate = DateUtils.getMaxMonthDate(this.writeOffParam.getBookeddate());
        DynamicObject periodDy = PeriodUtil.getPeriodByDate((Date)maxMonthDate, (long)bookInfo.getPeriodTypeId());
        Preconditions.checkNotNull((Object)periodDy, (Object)ResManager.loadKDString((String)"\u5148\u8fdb\u5148\u51fa\u6838\u9500\u6a21\u5f0f\u4e0b\u67e5\u8be2\u4e0d\u5230\u8bb0\u8d26\u65e5\u671f\u6240\u5728\u671f\u95f4", (String)"AccCurrentOptService_1", (String)"fi-gl-common", (Object[])new Object[0]));
        this.setLastPeriodId(periodDy.getLong("id"));
        DataSet balance = this.queryCurPeriodBalance(periodDy, this.getBalanceSelFields(Arrays.asList("endfor amountbalfor", "endlocal amountbal")));
        if (!org.apache.commons.lang3.time.DateUtils.isSameDay((Date)this.writeOffParam.getBookeddate(), (Date)periodDy.getDate("enddate"))) {
            ThreeTuple rangDate = new ThreeTuple((Object)this.writeOffParam.getBookeddate(), (Object)periodDy.getDate("enddate"), null);
            DataSet curPeriodAmount = this.getCurPeriodAmount((ThreeTuple<Date, Date, List<Long>>)rangDate);
            balance = balance.union(curPeriodAmount);
            balance = DataSetUtils.gainSumDataSet(balance);
        }
        StringBuilder filter = new StringBuilder(" (amountbalfor != 0 or amountbal != 0)");
        ((Set)this.writeOffParam.getAcctToAssit().getValue()).forEach(v -> {
            Set assVals;
            AssistVO assistVO = this.writeOffParam.getAssistVOMap().get(v);
            if (Objects.nonNull(assistVO) && (assVals = assistVO.getAssValue().stream().map(String::valueOf).collect(Collectors.toSet())).size() > 0) {
                filter.append(" and ").append((String)v).append(" in (").append(String.join((CharSequence)",", assVals)).append(")");
            }
        });
        balance = balance.filter(filter.toString());
        balance = balance.addField(this.writeOffParam.getBookInfo().getBaseCurrencyId() + "", "currencylocal");
        return balance;
    }

    private DataSet getCurPeriodAmount(ThreeTuple<Date, Date, List<Long>> rangDate) {
        String amtDc = "-1 * " + this.writeOffParam.getAccountDc();
        List acccurFields = Splitter.on((String)",").trimResults().splitToList((CharSequence)("org, booktype, account, currency,  " + amtDc + "* amountfor amountbalfor,  " + amtDc + " * amount amountbal"));
        QFilter filter = new QFilter("bookeddate", ">", rangDate.item1);
        filter.and(new QFilter("bookeddate", "<=", rangDate.item2));
        return this.queryAccCurrentByDate(acccurFields, filter, null);
    }

    private DataSet queryCurPeriodBalance(DynamicObject periodDy, List<String> fileds) {
        ArrayList<QFilter> balanceFilters = new ArrayList<QFilter>(16);
        balanceFilters.add(new QFilter("org", "=", (Object)this.writeOffParam.getOrgId()));
        balanceFilters.add(new QFilter("booktype", "=", (Object)this.writeOffParam.getBookTypeId()));
        balanceFilters.add(new QFilter("accounttable", "=", (Object)this.writeOffParam.getAcctTableId()));
        long periodId = periodDy.getLong("id");
        balanceFilters.add(new QFilter("period", ">=", (Object)(periodId / PeriodUtil.TYPE_PERIOD_L * PeriodUtil.TYPE_PERIOD_L)));
        balanceFilters.add(new QFilter("period", "<=", (Object)periodId));
        balanceFilters.add(new QFilter("endperiod", "in", (Object)PeriodUtil.getAvailableEndPeriodIds((String)">", (Long)periodId, (Long[])new Long[]{this.writeOffParam.getOrgId()})));
        balanceFilters.add(new QFilter("account", "=", this.writeOffParam.getAcctToAssit().getKey()));
        Set<Long> currencys = this.writeOffParam.getCurrencys();
        if (Objects.nonNull(currencys) && currencys.size() > 0) {
            balanceFilters.add(new QFilter("currency", "in", currencys));
        }
        if (DebugTrace.enable()) {
            LOG.info("==AccCurrentOptService_queryCurPeriodBalance filter:{}", balanceFilters);
        }
        DataSet balance = AssistEntityQueryHelper.queryWithORM("gl_balance", new ArrayList<String>((Collection)this.writeOffParam.getAcctToAssit().getValue()), balanceFilters, fileds, "", null);
        return DataSetUtils.gainSumDataSet(balance);
    }

    private DataSet queryAccCurrentByDate(List<String> selFields, QFilter qfilter, String orderBy) {
        ArrayList<QFilter> filter = new ArrayList<QFilter>(8);
        filter.add(new QFilter("org", "=", (Object)this.writeOffParam.getOrgId()));
        filter.add(new QFilter("booktype", "=", (Object)this.writeOffParam.getBookTypeId()));
        filter.add(new QFilter("accounttable", "=", (Object)this.writeOffParam.getAcctTableId()));
        filter.add(new QFilter("account", "=", this.writeOffParam.getAcctToAssit().getKey()));
        Set<Long> currencys = this.writeOffParam.getCurrencys();
        if (Objects.nonNull(currencys) && currencys.size() > 0) {
            filter.add(new QFilter("currency", "in", currencys));
        }
        if (Objects.nonNull(qfilter)) {
            filter.add(qfilter);
        }
        if (DebugTrace.enable()) {
            LOG.info("==AccCurrentOptService_queryAccCurrentByDate filter:{}", filter);
        }
        DataSet dataSet = AssistEntityQueryHelper.queryWithORM("gl_acccurrent", new ArrayList<String>((Collection)this.writeOffParam.getAcctToAssit().getValue()), filter, selFields, orderBy, null);
        StringBuilder appendFilter = new StringBuilder();
        ((Set)this.writeOffParam.getAcctToAssit().getValue()).forEach(v -> {
            Set assVals;
            AssistVO assistVO = this.writeOffParam.getAssistVOMap().get(v);
            if (Objects.nonNull(assistVO.getAssValue()) && (assVals = assistVO.getAssValue().stream().map(String::valueOf).collect(Collectors.toSet())).size() > 0) {
                if (appendFilter.length() > 1) {
                    appendFilter.append(" and ");
                }
                appendFilter.append((String)v).append(" in (").append(String.join((CharSequence)",", assVals)).append(")");
            }
        });
        if (appendFilter.length() > 0) {
            dataSet = dataSet.filter(appendFilter.toString());
        }
        return dataSet;
    }

    private ThreeTuple<Date, Date, List<Long>> getBeforeRangDate(Date reciInitBeginDate) {
        this.writeOffParam.setEndBookedDate(this.writeOffParam.getStartBookedDate());
        if (Objects.isNull(reciInitBeginDate) || this.writeOffParam.getEndBookedDate().compareTo(reciInitBeginDate) < 0) {
            return new ThreeTuple((Object)this.PreInitBeginDate(), (Object)this.writeOffParam.getEndBookedDate(), null);
        }
        Date startBookedDate = this.getStartDate(this.writeOffParam.getStartBookedDate());
        this.writeOffParam.setStartBookedDate(startBookedDate);
        List<Long> periodIdsLastYear = AccCurrentOptService.getYearPeriods(this.writeOffParam.getBookInfo().getPeriodTypeId(), this.writeOffParam.getStartBookedDate(), this.writeOffParam.getEndBookedDate());
        return new ThreeTuple((Object)this.writeOffParam.getStartBookedDate(), (Object)this.writeOffParam.getEndBookedDate(), periodIdsLastYear);
    }

    private Date reciInitBeginDate() {
        AccountBookInfo bookInfo = this.writeOffParam.getBookInfo();
        QFilter filter = new QFilter("org", "=", (Object)bookInfo.getOrgId());
        filter.and(new QFilter("booktype", "=", (Object)bookInfo.getBookTypeId()));
        filter.and(new QFilter("account", "=", this.writeOffParam.getAcctToAssit().getKey()));
        filter.and(new QFilter("isendinit", "=", (Object)Boolean.TRUE));
        try (DataSet acctDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_reci_init_state", (String)"endinitperiod.begindate", (QFilter[])filter.toArray(), (String)" endinitperiod asc");){
            if (acctDs.hasNext()) {
                Date date = acctDs.next().getDate("endinitperiod.begindate");
                return date;
            }
        }
        return null;
    }

    private Date getStartDate(Date date) {
        if ("0".equals(BillParamUtil.getStringValue((String)"83bfebc8000017ac", (String)"fi.gl.writeOff.months", (String)"6"))) {
            return this.addDay(date);
        }
        return this.addMonths(date);
    }

    public Date addMonths(Date date) {
        int amount = this.getRetralMonths() * -1;
        return this.add(date, 2, amount);
    }

    public Date addDay(Date date) {
        int amount = 0;
        Long allCount = 0L;
        String balQuerySql = "select fperiodid,fcount from t_gl_balance where forgid = ? and faccountid = ? and fendperiodid <= ? order by fperiodid desc";
        try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (String)balQuerySql, (Object[])new Object[]{this.writeOffParam.getOrgId(), this.writeOffParam.getAcctToAssit().getKey(), this.getLastPeriodId()});){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                this.setLastPeriodId(next.getLong("fperiodid"));
                Long fcount = next.getLong("fcount");
                allCount = allCount + fcount;
                if (allCount > 500000L) {
                    amount = -10;
                    break;
                }
                if (allCount > 400000L) {
                    amount = -20;
                    break;
                }
                amount -= 30;
            }
        }
        if (amount == 0) {
            return this.PreInitBeginDate();
        }
        return this.add(date, 11, amount);
    }

    public Date add(Date date, int calendarField, int amount) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    private static List<Long> getYearPeriods(long periodType, Date startDate, Date endDate) {
        QFilter f = new QFilter("beginDate", "<=", (Object)endDate);
        QFilter g = new QFilter("enddate", ">=", (Object)startDate);
        QFilter t = new QFilter("periodtype", "=", (Object)periodType);
        return QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{f, g, t}, (String)"id desc").stream().map(x -> x.getLong("id")).collect(Collectors.toList());
    }

    private List<String> getBalanceSelFields(List<String> fields) {
        ArrayList<String> allFields = new ArrayList<String>(5 + fields.size());
        allFields.add("org");
        allFields.add("booktype");
        allFields.add("account");
        allFields.add("currency");
        allFields.addAll(fields);
        return allFields;
    }

    private Integer getRetralMonths() {
        return Integer.parseInt(BillParamUtil.getStringValue((String)"83bfebc8000017ac", (String)"fi.gl.writeOff.months", (String)"6"));
    }

    private Date PreInitBeginDate() {
        return org.apache.commons.lang3.time.DateUtils.addDays((Date)GLUtil.getInitBeginDate(), (int)-1);
    }

    public long getLastPeriodId() {
        return this.lastPeriodId;
    }

    public void setLastPeriodId(long lastPeriodId) {
        this.lastPeriodId = lastPeriodId;
    }
}

