/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.business.service.PeriodService;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.report.DailyRptQueryParam;
import kd.fi.gl.util.CashFlowItemHelper;
import kd.fi.gl.util.FlexUtils;
import org.apache.commons.lang3.tuple.Triple;

public class CashFlowQueryParam
extends DailyRptQueryParam {
    private int itemLevel;
    private Map<String, Set<Long>> assistMap = new LinkedHashMap<String, Set<Long>>(16);
    private boolean isQueryByPeriod;
    private boolean isQueryFromInit;
    private boolean isUnShowInsideCf;
    private boolean isOnlyShowInsideCf;
    private boolean noZeroAmount;
    private Map<String, List<Object>> comassistMap;
    private Triple<MainEntityType, List<QFilter>, List<String>> cashflowOrmInfo;
    private Set<Long> cashFlowItemIdsByAssistType;

    public CashFlowQueryParam() {
    }

    public CashFlowQueryParam(FilterInfo filterInfo, String entityId, ReportQueryParam param) {
        super(filterInfo, entityId);
        this.isQueryByPeriod = filterInfo.getBoolean("isquerybyperiod");
        this.isUnShowInsideCf = filterInfo.getBoolean("unshowinsidecf");
        this.isOnlyShowInsideCf = filterInfo.getBoolean("onlyshowinsidecf");
        this.itemLevel = filterInfo.getInt("itemlevel");
        this.noZeroAmount = filterInfo.getBoolean("nodisplayforzero");
        List items = filterInfo.getFlexFilterItems();
        for (FilterItemInfo filterItemInfo : items) {
            String propName = filterItemInfo.getPropName();
            Set value = (Set)filterItemInfo.getValue();
            this.assistMap.put(propName, value);
        }
        this.cashflowOrmInfo = FlexUtils.buildDynamicORMAssistOnBalance(param, "gl_cashflow", false);
        this.initCashFlowItemIdsByAssistType();
    }

    public int getItemLevel() {
        return this.itemLevel;
    }

    public void setItemLevel(int itemLevel) {
        this.itemLevel = itemLevel;
    }

    public boolean isQueryByPeriod() {
        return this.isQueryByPeriod;
    }

    public void setQueryByPeriod(boolean queryByPeriod) {
        this.isQueryByPeriod = queryByPeriod;
    }

    public boolean isUnShowInsideCf() {
        return this.isUnShowInsideCf;
    }

    public void setUnShowInsideCf(boolean isUnShowInsideCf) {
        this.isUnShowInsideCf = isUnShowInsideCf;
    }

    @Override
    public boolean isNoZeroAmount() {
        return this.noZeroAmount;
    }

    public Set<Long> getAssgrpIds() {
        HashSet<Long> result = new HashSet<Long>();
        if (!this.isShowAssist() || this.assistMap.isEmpty()) {
            return null;
        }
        DataSet dataSet = this.queryAssistGroupSet();
        for (Row row : dataSet) {
            result.add(row.getLong("assisthg"));
        }
        boolean hasvalue = false;
        for (Map.Entry<String, Set<Long>> entry : this.assistMap.entrySet()) {
            Set<Long> value = entry.getValue();
            if (value == null || value.size() <= 0) continue;
            hasvalue = true;
            break;
        }
        if (!hasvalue) {
            result.add(0L);
        }
        return result;
    }

    private DataSet queryAssistGroupSet() {
        DataSet ds;
        ArrayList<DataSet> dsList = new ArrayList<DataSet>(this.assistMap.size());
        for (Map.Entry<String, Set<Long>> entry : this.assistMap.entrySet()) {
            Set<Long> value = entry.getValue();
            ds = this.queryAssistSet(entry.getKey(), value);
            dsList.add(ds);
        }
        ds = (DataSet)dsList.get(0);
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add("assisthg");
        fieldList.add("assval");
        if (dsList.size() >= 2) {
            for (int i = 1; i < dsList.size(); ++i) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("assval assval" + i);
                ds = ds.join((DataSet)dsList.get(i), JoinType.INNER).on("assisthg", "assisthg").select(fieldList.toArray(new String[0]), list.toArray(new String[0])).finish();
                fieldList.add("assval" + i);
            }
        }
        return ds;
    }

    private DataSet queryAssistSet(String ffield, Set<Long> assval) {
        String fields = "hg assisthg,asstype,assval";
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("asstype", "=", (Object)ffield);
        qfList.add(qFilter);
        if (assval != null && assval.size() > 0) {
            qFilter = new QFilter("assval", "in", assval);
            qfList.add(qFilter);
        }
        qFilter = new QFilter("assval", "!=", (Object)0);
        qfList.add(qFilter);
        return QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "gl_assist_bd"), (String)"gl_assist_bd", (String)fields, (QFilter[])qfList.toArray(new QFilter[0]), null);
    }

    public long getPeriodIdByQueryType() {
        return this.isQueryByPeriod ? this.getStartPeriod() : this.getPeriodId();
    }

    public long getPeriodEndIdByQueryType() {
        return this.isQueryByPeriod ? this.getStartPeriod() : this.getPeriodEndId();
    }

    public boolean isQueryFromInit() {
        return this.isQueryFromInit;
    }

    public void setQueryFromInit(boolean queryFromInit) {
        this.isQueryFromInit = queryFromInit;
    }

    public Map<String, List<Object>> getComassistMap() {
        return this.comassistMap;
    }

    public void setComassistMap(Map<String, List<Object>> comassistMap) {
        this.comassistMap = comassistMap;
    }

    public boolean isOnlyShowInsideCf() {
        return this.isOnlyShowInsideCf;
    }

    public void setOnlyShowInsideCf(boolean onlyShowInsideCf) {
        this.isOnlyShowInsideCf = onlyShowInsideCf;
    }

    @Override
    public List<String> getCommonAssistKeys() {
        if (!this.isShowComassist()) {
            return new ArrayList<String>();
        }
        return super.getCommonAssistKeys();
    }

    public Set<Long> getCashFlowItemIdsByAssistType() {
        return this.cashFlowItemIdsByAssistType;
    }

    private void initCashFlowItemIdsByAssistType() {
        if (this.cashFlowItemIdsByAssistType != null) {
            return;
        }
        if (this.assistMap == null || this.assistMap.isEmpty()) {
            this.cashFlowItemIdsByAssistType = Collections.emptySet();
            return;
        }
        this.cashFlowItemIdsByAssistType = new HashSet<Long>(32);
        Set<String> flex = this.assistMap.keySet();
        Date periodEndDate = PeriodService.loadSingle((Long)this.getPeriodEndIdByQueryType()).getEndDate();
        QFilterBuilder itemFilter = new QFilterBuilder().add(BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)this.getOrgs().get(0))).addEqual("isleaf", (Object)Boolean.TRUE).addEqual("isassist", (Object)Boolean.TRUE).add("startdate", "<=", (Object)periodEndDate).add("enddate", ">", (Object)periodEndDate);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"CashFlowQueryParam", (String)"gl_cashflowitem", (String)"masterid,assistentry.asstypeid.flexfield flexfield", (QFilter[])itemFilter.toArray(new QFilter[0]), (String)"masterid");){
            long masterid = 0L;
            HashSet<String> flexfields = new HashSet<String>(5);
            for (Row row : ds) {
                if (masterid != row.getLong("masterid")) {
                    if (masterid != 0L && flexfields.containsAll(flex)) {
                        this.cashFlowItemIdsByAssistType.add(masterid);
                    }
                    masterid = row.getLong("masterid");
                    flexfields.clear();
                }
                flexfields.add(row.getString("flexfield"));
            }
            if (masterid != 0L && flexfields.containsAll(flex)) {
                this.cashFlowItemIdsByAssistType.add(masterid);
            }
        }
    }

    public Triple<MainEntityType, List<QFilter>, List<String>> getCashflowOrmInfo() {
        return this.cashflowOrmInfo;
    }

    public Set<Long> getCashflowItems() {
        if (this.assistMap == null || this.assistMap.isEmpty()) {
            return null;
        }
        Set<String> flex = this.assistMap.keySet();
        HashSet<Long> cashflowMasterIds = new HashSet<Long>(32);
        Set<Long> allCfitemIds = CashFlowItemHelper.getAllCfitemIdsByOrg(this.getPorg(), this.getOrgViewId(), this.getPeriodEndIdByQueryType(), false, false);
        Map<Long, String> cashflowIds = this.getCashflowItemsByIds(allCfitemIds, flex, null);
        if (!CollectionUtils.isEmpty(cashflowIds)) {
            if (this.isVirtualOrg()) {
                allCfitemIds = CashFlowItemHelper.getAllCfitemIdsByOrg(this.getPorg(), this.getOrgViewId(), this.getPeriodEndIdByQueryType(), true, false);
                cashflowIds.putAll(this.getCashflowItemsByIds(allCfitemIds, flex, cashflowIds.values().stream().collect(Collectors.toSet())));
            }
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", cashflowIds.keySet())});
            coll.forEach(e -> cashflowMasterIds.add(e.getLong("masterid")));
        }
        return cashflowMasterIds;
    }

    private Map<Long, String> getCashflowItemsByIds(Set<Long> allCfitemIds, Set<String> flex, Set<String> longNums) {
        HashMap<Long, String> cashflowIds = new HashMap<Long, String>(32);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"CashFlowQueryParam", (String)"gl_cashflowitem", (String)"id,longnumber,assistentry.asstypeid.flexfield flexfield", (QFilter[])new QFilter[]{new QFilter("id", "in", allCfitemIds), new QFilter("isleaf", "=", (Object)true), new QFilter("isassist", "=", (Object)true)}, (String)"id");){
            long id = 0L;
            String longNum = "";
            HashSet<String> flexfields = new HashSet<String>(5);
            for (Row row : ds) {
                if (id != row.getLong("id")) {
                    if (id != 0L && flexfields.containsAll(flex)) {
                        String finalLongNum = longNum;
                        if (longNums == null || longNums.stream().anyMatch(e -> finalLongNum.startsWith((String)e))) {
                            cashflowIds.put(id, longNum);
                        }
                    }
                    id = row.getLong("id");
                    longNum = row.getString("longnumber");
                    flexfields.clear();
                }
                flexfields.add(row.getString("flexfield"));
            }
            if (id != 0L && flexfields.containsAll(flex)) {
                String finalLongNum = longNum;
                if (longNums == null || longNums.stream().anyMatch(e -> finalLongNum.startsWith((String)e))) {
                    cashflowIds.put(id, longNum);
                }
            }
        }
        return cashflowIds;
    }

    private boolean isVirtualOrg() {
        HashSet<Long> orgParent = new HashSet<Long>();
        orgParent.add(this.getPorg());
        Set<Long> childOrgId = AccSysUtil.getChildOrgId("10", this.getOrgViewId(), orgParent, false);
        return !CollectionUtils.isEmpty(childOrgId);
    }
}

