/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.google.common.collect.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.business.service.LocalCurrencyQueryService;
import kd.fi.bd.business.vo.AccountBookMCVO;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.report.CurType;
import kd.fi.gl.report.OrgType;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.util.AccBalanceSumUpHelper;
import kd.fi.gl.util.BiTreeNode;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.vo.OrgVO;

public class MulOrgQPRpt
extends QueryParamRpt
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Log LOG = LogFactory.getLog(MulOrgQPRpt.class);
    private String sumField;
    private String defaultSumField = "";
    private String accGrpField = "account,number,name,dc,level,parentid";
    private static final String curGrpField = "currencyid";
    private static final String orderBy = "total";
    private String defGrpField = "";
    private BiTreeNode<Long, OrgVO> sumUpView;
    private Set<Long> periods;
    private Map<Long, Long> orgStartPeriodMap;
    private transient Set<Long> allEntityOrgSet;

    public BiTreeNode getSumUpView() {
        return this.sumUpView;
    }

    public MulOrgQPRpt() {
    }

    public MulOrgQPRpt(FilterInfo filterInfo, String entityId) {
        super(filterInfo, entityId);
        if (this.isShowOrgTree()) {
            List<Long> filteredOrgs = this.getOrgs();
            Long orgViewId = this.getOrgViewId();
            this.sumUpView = AccBalanceSumUpHelper.computeSumUpStepViewOrgStructByAccountView(new HashSet<Long>(filteredOrgs), orgViewId);
        }
    }

    @Override
    protected final void initBookRef(FilterInfo filterInfo) {
        HashSet set;
        List<Long> orgs;
        this.init(filterInfo);
        List<AccountBookInfo> books = AccSysUtil.getBookFromAccSys(this.childOrg, this.getBookType());
        this.orgCurMap = new HashMap(books.size());
        this.orgStartPeriodMap = new HashMap<Long, Long>(books.size());
        for (AccountBookInfo bookInfo : books) {
            long orgId = bookInfo.getOrgId();
            long bcId = bookInfo.getBaseCurrencyId();
            long spId = bookInfo.getStartPeriodId();
            this.orgCurMap.put(orgId, bcId);
            this.orgStartPeriodMap.put(orgId, spId);
        }
        String mulcur = filterInfo.getString("mulcur");
        if (!Objects.isNull(mulcur) && !Objects.equals(mulcur, "LocalCurrency")) {
            Table mulCurrencyTable = LocalCurrencyQueryService.batchQueryMulCurrency((Collection)this.childOrg, (long)this.getBookType());
            this.childOrg.stream().forEach(org -> {
                Map infoMap = (Map)mulCurrencyTable.get(org, (Object)this.getBookType());
                this.orgCurMap.put(org, ((AccountBookMCVO.Info)infoMap.get(mulcur)).getCurrencyId());
            });
        }
        this.orgType = (orgs = this.getOrgs()).size() == 1 && this.orgCurMap.containsKey(orgs.get(0)) ? OrgType.ENTITY : ((set = new HashSet(this.orgCurMap.values())).size() > 1 ? OrgType.VIRTUAL_M : OrgType.VIRTUAL_S);
        this.showOrg = this.orgType != OrgType.ENTITY && this.showOrg;
        this.curLocal = this.orgType != OrgType.VIRTUAL_M && this.orgCurMap.size() > 0 ? (Long)this.orgCurMap.values().iterator().next() : 0L;
        if (this.curType == null) {
            this.curType = this.getCurrency() == this.curLocal ? CurType.NATIVE : CurType.FOREIGN;
        }
    }

    private void init(FilterInfo filterInfo) {
        ArrayList<Long> orgs = new ArrayList<Long>(this.getOrgs());
        DynamicObject orgViewItem = filterInfo.getDynamicObject("orgview");
        if (orgs.size() == 1 && orgViewItem != null) {
            this.childOrg = "gl_rpt_accountbalance".equals(this.entityId) ? AccSysUtil.getChildOrgsByViewWithTCache((Long)orgs.get(0), orgViewItem.getLong("id"), this.entityId) : AccSysUtil.getChildOrgsByView((Long)orgs.get(0), orgViewItem.getLong("id"), this.entityId);
        } else {
            List<Long> permOrgList = AccSysUtil.getAcctOrgPkList(this.entityId, false, PermissonType.VIEW);
            orgs.retainAll(permOrgList);
            QFilter entityFilter = new QFilter("isbizunit", "=", (Object)true);
            DynamicObjectCollection btCol = BatchProcessUtil.batchQueryDynColl(orgs, batchOrgs -> QueryServiceHelper.query((String)"gl_accountbook", (String)"org,bookstype id, bookstype.accounttype type", (QFilter[])new QFilter[]{new QFilter("org", "in", batchOrgs), entityFilter}));
            this.childOrg = btCol.stream().map(x -> x.getLong("org")).collect(Collectors.toSet());
        }
        List<AccountBookInfo> bookInfoList = AccSysUtil.getBookFromAccSys(this.childOrg, this.getBookType());
        this.orgStartPeriodMap = new HashMap<Long, Long>(bookInfoList.size());
        bookInfoList.stream().forEach(x -> this.orgStartPeriodMap.put(x.getOrgId(), x.getStartPeriodId()));
    }

    public Set<Long> getFilteredChildOrg() {
        long endPeriod = this.getEndPeriod();
        HashSet<Long> filteredChildOrg = new HashSet<Long>();
        if (DebugTrace.enable()) {
            LOG.info("orgStartPeriodMap: {}", (Object)SerializationUtils.toJsonString(this.orgStartPeriodMap));
        }
        this.orgStartPeriodMap.forEach((k, v) -> {
            if (v <= endPeriod && v > endPeriod / GLUtil.TYPE_PERIOD_L * GLUtil.TYPE_PERIOD_L) {
                filteredChildOrg.add((Long)k);
            }
        });
        return filteredChildOrg;
    }

    public Set<Long> getAllEntityOrgSet() {
        if (this.allEntityOrgSet == null) {
            this.allEntityOrgSet = this.getFilteredChildOrg();
        }
        return this.allEntityOrgSet;
    }

    @Override
    public List<Long> getAllEntityOrgs() {
        return new ArrayList<Long>(this.getFilteredChildOrg());
    }

    public String getSumField() {
        return this.sumField;
    }

    public void setSumField(String sumField) {
        this.sumField = sumField;
    }

    public void setDefaultSumField(String defaultSumField) {
        this.defaultSumField = defaultSumField;
    }

    public void setDefGrpField(String defGrpField) {
        this.defGrpField = defGrpField;
    }

    public String getDefGrpField() {
        return this.defGrpField;
    }

    public String getAccGrpField() {
        return this.accGrpField;
    }

    public void setAccGrpField(String accGrpField) {
        this.accGrpField = accGrpField;
    }

    public static DataSet gainSumSet(DataSet ds, String[] groupBy, String[] sumBy) {
        Field[] oldFields = ds.getRowMeta().getFields();
        String[] sel = new String[groupBy.length + sumBy.length];
        System.arraycopy(groupBy, 0, sel, 0, groupBy.length);
        System.arraycopy(sumBy, 0, sel, groupBy.length, sumBy.length);
        GroupbyDataSet groupbyDataSet = ds.select(sel).groupBy(groupBy);
        for (String sum : sumBy) {
            groupbyDataSet.sum(sum);
        }
        DataSet finish = groupbyDataSet.finish();
        finish = ReportUtils.gainSumSetHelper(finish, oldFields);
        return finish;
    }

    @Override
    public DataSet addCurLocal(String orgField, DataSet ds) {
        if (this.getOrgType() == OrgType.VIRTUAL_M) {
            if (this.isShowOrg() || this.isShowOrgTree()) {
                ds = this.addCurLocalField(orgField, ds);
            }
        } else {
            long currencyId = !this.orgCurMap.isEmpty() ? (Long)this.orgCurMap.entrySet().iterator().next().getValue() : 0L;
            ds = ds.addField("" + currencyId, "currencylocalid");
        }
        return ds;
    }

    private DataSet addCurLocalField(String orgField, DataSet ds) {
        DataSet orgCurDs = this.createOrgCur();
        List<String> cols = GLUtil.getDataSetCols(ds);
        return ds.join(orgCurDs, JoinType.LEFT).on(orgField, orgGrpField).select(cols.toArray(new String[0]), new String[]{"currencylocalid"}).finish();
    }

    public DataSet createOrgCur() {
        String[] fieldNames = new String[]{orgGrpField, "currencylocalid"};
        DataType[] dataTypes = new DataType[]{DataType.LongType, DataType.LongType};
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
        DataSetBuilder builder = Algo.create((String)(this.getClass().getName() + "addCurLocalField")).createDataSetBuilder(rowMeta);
        for (Map.Entry entry : this.orgCurMap.entrySet()) {
            builder.append(new Object[]{entry.getKey(), entry.getValue()});
        }
        return builder.build();
    }

    public Set<Long> getPeriods() {
        return this.periods;
    }

    public void setPeriods(Set<Long> periods) {
        this.periods = periods;
    }

    public Map<Long, Long> getOrgStartPeriodMap() {
        return this.orgStartPeriodMap;
    }
}

