/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.flex.FlexValueJson;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.GLUtil;

public class NavToAssRpt {
    protected ReportQueryParam param;
    protected IFormView view;
    protected List<Long> accIds;
    protected List<Long> orgIds;
    protected Long curId;
    protected Long measureunitId;
    protected List<Long> assgrpIds;
    protected String navKey;
    protected DynamicObject rowData;

    public void apply() {
        ReportShowParameter report = this.initShowParameter();
        this.view.showForm((FormShowParameter)report);
    }

    public ReportShowParameter initShowParameter() {
        ReportShowParameter report = new ReportShowParameter();
        if (this.navKey == null) {
            report.setFormId("gl_rpt_subsidiaryledger");
        } else {
            report.setFormId(this.navKey);
        }
        report.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        FilterInfo info = this.param.getFilter();
        if (this.orgIds.isEmpty()) {
            this.orgIds.add(info.getLong("org"));
        }
        Long bookType = info.getLong("booktype");
        FilterInfo filter = new FilterInfo();
        long periodType = info.getLong("periodtype");
        long startPeriod = info.getLong("startperiod");
        long endPeriod = info.getLong("endperiod");
        Date dateBegin = info.getDate("datebegin");
        Date dateEnd = info.getDate("dateend");
        if (dateBegin != null && dateEnd != null) {
            DynamicObject sp = GLUtil.getPeriodByDate(dateBegin, periodType);
            DynamicObject ep = GLUtil.getPeriodByDate(dateEnd, periodType);
            if (sp != null && ep != null) {
                startPeriod = sp.getLong("id");
                endPeriod = ep.getLong("id");
            }
        }
        Multimap<String, Object> flexProp = NavToAssRpt.getFlexProp(this.assgrpIds);
        if ("gl_rpt_assistbalance".equals(this.navKey)) {
            filter.addFilterItem("orgs", this.orgIds);
            filter.addFilterItem("showorg", (Object)info.getBoolean("showorg"));
            filter.addFilterItem("orgview", info.getValue("orgview"));
            if (this.assgrpIds.isEmpty()) {
                DynamicObject acct = BusinessDataServiceHelper.loadSingle((Object)this.accIds.get(0), (String)"bd_accountview");
                DynamicObjectCollection entry = acct.getDynamicObjectCollection("checkitementry");
                for (DynamicObject entryRow : entry) {
                    DynamicObject assit = entryRow.getDynamicObject("asstactitem");
                    flexProp.put((Object)assit.getString("flexfield"), (Object)0);
                }
            }
        }
        ArrayList<FilterItemInfo> ass = new ArrayList<FilterItemInfo>(flexProp.size());
        for (Map.Entry entry : flexProp.asMap().entrySet()) {
            ass.add(new FilterItemInfo((String)entry.getKey(), this.assgrpIds.isEmpty() ? new HashSet() : new HashSet((Collection)entry.getValue()), "in"));
        }
        String curStr = this.curId == null || this.curId == 0L ? info.getString("currency") : String.valueOf(this.curId);
        if ("t_rpt_aux_subledger".equals(this.navKey)) {
            filter.addFilterItem("orgs", this.orgIds);
        } else {
            filter.addFilterItem("org", (Object)this.orgIds.get(0));
        }
        filter.addFilterItem("booktype", (Object)bookType);
        filter.addFilterItem("periodtype", (Object)periodType);
        filter.addFilterItem("startperiod", (Object)startPeriod);
        filter.addFilterItem("endperiod", (Object)endPeriod);
        filter.addFilterItem("accounttable", (Object)info.getLong("accounttable"));
        filter.addFilterItem("account", this.accIds);
        filter.addFilterItem("accountlevel", (Object)info.getString("accountlevel"));
        filter.addFilterItem("currency", (Object)curStr);
        filter.addFilterItem("measureunits", (Object)this.measureunitId);
        filter.addFilterItem("mulcur", (Object)info.getString("mulcur"));
        filter.addFilterItem("showqty", (Object)info.getBoolean("showqty"));
        filter.addFilterItem("showleafaccount", (Object)info.getBoolean("showleafaccount"));
        filter.addFilterItem("nodisplayforzero", (Object)info.getBoolean("nodisplayforzero"));
        filter.addFilterItem("balancezero", (Object)info.getBoolean("balancezero"));
        if (info.containProp("issubstractpl")) {
            filter.addFilterItem("issubstractpl", (Object)info.getBoolean("issubstractpl"));
        }
        if (info.containProp("showrpt")) {
            filter.addFilterItem("showrpt", (Object)info.getBoolean("showrpt"));
            filter.addFilterItem("currencyrpt", (Object)info.getLong("currencyrpt"));
        }
        CommonAssistUtil.addComassitHyperParam(this.param, filter);
        filter.setFlexFilterItems(ass);
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filter);
        report.setQueryParam(queryParam);
        report.setCustomParam("accounttable", (Object)String.valueOf(info.getLong("accounttable")));
        return report;
    }

    private static Multimap<String, Object> getFlexProp(Collection<Long> assgrpIds) {
        return (Multimap)BusinessDataServiceHelper.loadFromCache((String)"gl_assist", (String)"assvals", (QFilter[])new QFilter[]{new QFilter("id", "in", assgrpIds)}).values().stream().flatMap(dyn -> new FlexValueJson(dyn.getString("assvals")).getValueMap().entrySet().stream()).collect(Collector.of(HashMultimap::create, (map, entry) -> map.put(entry.getKey(), entry.getValue()), (map1, map2) -> {
            map1.putAll((Multimap)map2);
            return map1;
        }, new Collector.Characteristics[0]));
    }

    protected NavToAssRpt(Builder builder) {
        this.param = builder.param;
        this.view = builder.view;
        this.accIds = builder.accIds;
        this.orgIds = builder.orgIds;
        this.curId = builder.curId;
        this.measureunitId = builder.measureunitId;
        this.assgrpIds = builder.assgrpIds;
        this.navKey = builder.navKey;
        this.rowData = builder.rowData;
    }

    public static class Builder {
        private ReportQueryParam param;
        private String navKey;
        private IFormView view;
        private List<Long> accIds = new ArrayList<Long>(16);
        private List<Long> orgIds = new ArrayList<Long>(16);
        private Long curId;
        private Long measureunitId;
        private DynamicObject rowData;
        private List<Long> assgrpIds = new ArrayList<Long>(16);

        public Builder(ReportQueryParam param, IFormView view) {
            this.param = param;
            this.view = view;
        }

        public Builder accountId(Long accId) {
            this.accIds.add(accId);
            return this;
        }

        public Builder accountIds(Collection<Long> toAddIds) {
            this.accIds.addAll(toAddIds);
            return this;
        }

        public Builder navKey(String navKey) {
            this.navKey = navKey;
            return this;
        }

        public Builder currencyId(Long curId) {
            this.curId = curId;
            return this;
        }

        public Builder orgId(Long orgId) {
            if (orgId != null && orgId != 0L) {
                this.orgIds.add(orgId);
            }
            return this;
        }

        public Builder orgIds(Collection<Long> toAddOrgIds) {
            this.orgIds.addAll(toAddOrgIds);
            return this;
        }

        public Builder measureunitId(Long measureunitId) {
            this.measureunitId = measureunitId;
            return this;
        }

        public Builder assgrpId(Long assgrpId) {
            if (assgrpId != null && assgrpId != 0L) {
                this.assgrpIds.add(assgrpId);
            }
            return this;
        }

        public Builder assgrpIds(Collection<Long> toAddAssgrpIds) {
            this.assgrpIds.addAll(toAddAssgrpIds);
            return this;
        }

        public Builder rowData(DynamicObject rowdata) {
            this.rowData = rowdata;
            return this;
        }

        public NavToAssRpt build() {
            return new NavToAssRpt(this);
        }
    }
}

