/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.export;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.StringType;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.ReportList;
import kd.fi.bd.model.Context;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.report.export.ExportOption;
import kd.fi.gl.report.export.convert.VoucherConverter;
import kd.fi.gl.report.export.processor.BalanceRowTransformer;
import kd.fi.gl.report.export.processor.BatchProcessorChain;
import kd.fi.gl.report.export.processor.ReportExcelTransformer;
import kd.fi.gl.report.subsidiary.SubsidiaryReportDatasetBuilder;
import kd.fi.gl.report.subsidiary.SubsidiaryRow;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.ReportFieldSettingUtil;
import kd.fi.gl.vo.ReportFieldSettingVo;

public class ReportExporter {
    private static final Log logger = LogFactory.getLog(ReportExporter.class);

    public static Context exportSubsidiary(FilterInfo filterInfo, ReportList reportList, Long[] orgIds, ExportOption exportOption) {
        long tick = System.currentTimeMillis();
        Set<Long> orgIdSet = Arrays.stream(orgIds).collect(Collectors.toSet());
        Map<String, Map> orgAccountbookMap = SubsidiaryReportDatasetBuilder.initOrgAccountbookMap(orgIdSet, filterInfo);
        long parentOrg = AccSysUtil.getParentOrgByChildre(Arrays.asList(orgIds));
        String accountNameField = GLUtil.getAcctNameBySysParam(parentOrg);
        HashMap<Long, Supplier<DataSet>> orgExportDataSetMap = new HashMap<Long, Supplier<DataSet>>(8);
        Map orgCurLocal = orgAccountbookMap.get("orgCurLocal");
        for (Long orgId : orgIds) {
            AccountBookInfo accountBook = AccSysUtil.getBookFromAccSys(orgId, filterInfo.getLong("booktype"));
            if (null == accountBook || accountBook.getStartPeriodId() > filterInfo.getLong("endperiod") || Objects.equals(orgCurLocal.get(orgId), 0L)) continue;
            Supplier<DataSet> dataSetSupplier = () -> SubsidiaryReportDatasetBuilder.buildVoucherSource(filterInfo, orgId, exportOption, accountNameField);
            orgExportDataSetMap.put(orgId, dataSetSupplier);
        }
        BatchProcessorChain chain = new BatchProcessorChain.Builder<SubsidiaryRow, Void>(exportOption, new VoucherConverter(), new BalanceRowTransformer(1000)).appendLast(new ReportExcelTransformer(reportList, 1000, filterInfo)).build();
        chain.initContext(filterInfo, orgIdSet, accountNameField, orgAccountbookMap);
        logger.info("subsidiary_multiorg init chain context cost:{}ms", (Object)(System.currentTimeMillis() - tick));
        int seq = 1;
        Map orgnameMap = (Map)chain.getContextProp("orgnameMap");
        Iterator iterator = orgExportDataSetMap.entrySet().iterator();
        List<ReportFieldSettingVo> cusFieldSettingVos = ReportFieldSettingUtil.getDisplayFieldConfigList("gl_rpt_subsidiaryledger");
        chain.registerContext("cusVoucherFields", cusFieldSettingVos);
        while (iterator.hasNext()) {
            long singleTick = System.currentTimeMillis();
            Map.Entry next = iterator.next();
            Long orgId = (Long)next.getKey();
            exportOption.setOrgId(orgId);
            exportOption.setOrgName((String)orgnameMap.get(orgId));
            exportOption.setConditionOrgName((String)orgnameMap.get(orgId));
            if (!exportOption.isSplitByOrg()) {
                StringBuilder orgNameBuilder = new StringBuilder();
                orgnameMap.values().forEach(x -> orgNameBuilder.append((String)x).append(";"));
                orgNameBuilder.deleteCharAt(orgNameBuilder.length() - 1);
                exportOption.setConditionOrgName(orgNameBuilder.toString());
            }
            HashMap<String, Object> progressCusData = new HashMap<String, Object>(8);
            progressCusData.put("complete", 0);
            progressCusData.put("total", 100);
            progressCusData.put("orgName", exportOption.getOrgName());
            exportOption.getExportProgress().feedbackCustData(progressCusData);
            exportOption.getExportProgress().feedbackProgress(100, 0);
            if (seq == orgExportDataSetMap.size()) {
                chain.setFinalDataSetFlag(true);
            }
            chain.getProcessors().forEach(processor -> processor.reset());
            DataSet dataSet = (DataSet)((Supplier)next.getValue()).get();
            logger.info("subsidiary_multiorg export init dataSet.orgId:{} cost:{}ms", (Object)orgId, (Object)(System.currentTimeMillis() - singleTick));
            RowMeta cachedRowMeta = (RowMeta)chain.getContextProp("rowMeta");
            if (Objects.isNull(cachedRowMeta)) {
                RowMeta rowMeta = dataSet.getRowMeta();
                rowMeta = ReportExporter.getNewRowMeta(cusFieldSettingVos, rowMeta);
                chain.registerRowMeta(rowMeta);
            }
            chain.feed((Iterator<Row>)dataSet);
            logger.info("subsidiary_multiorg export feed finished.orgId:{} cost:{}ms", (Object)orgId, (Object)(System.currentTimeMillis() - singleTick));
            ++seq;
        }
        logger.info("subsidiary_multiorg export total cost:{}ms", (Object)(System.currentTimeMillis() - tick));
        return chain.getContext();
    }

    public static RowMeta getNewRowMeta(List<ReportFieldSettingVo> cusFieldSettingVos, RowMeta rowMeta) {
        if (cusFieldSettingVos.isEmpty()) {
            return rowMeta;
        }
        LinkedHashSet<Field> fieldList = new LinkedHashSet<Field>();
        Field[] fields = rowMeta.getFields();
        fieldList.addAll(Arrays.asList(fields));
        fieldList.addAll(ReportExporter.getCusVoucherFields(cusFieldSettingVos));
        rowMeta = new RowMeta(fieldList.toArray(new Field[0]));
        return rowMeta;
    }

    public static List<Field> getCusVoucherFields(List<ReportFieldSettingVo> cusFieldSettingVos) {
        if (cusFieldSettingVos.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Field> fieldList = new LinkedList<Field>();
        MainEntityType voucherEntity = EntityMetadataCache.getDataEntityType((String)"gl_voucher");
        for (ReportFieldSettingVo cusFieldSettingVo : cusFieldSettingVos) {
            for (Map.Entry propMap : voucherEntity.getAllFields().entrySet()) {
                if (!Objects.equals(cusFieldSettingVo.getField(), propMap.getKey())) continue;
                IDataEntityProperty entityProperty = (IDataEntityProperty)propMap.getValue();
                StringType dataType = DataType.StringType;
                if (entityProperty instanceof AmountProp) {
                    dataType = DataType.BigDecimalType;
                } else if (entityProperty instanceof DateTimeProp) {
                    dataType = DataType.DateType;
                }
                fieldList.add(new Field(cusFieldSettingVo.getField(), (DataType)dataType));
            }
        }
        return fieldList;
    }
}

