/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.export.convert;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.Row;
import kd.bos.entity.report.FilterInfo;
import kd.fi.bd.model.Context;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.report.export.convert.IDatasetRowTypeConverter;
import kd.fi.gl.report.subsidiary.SubsidiaryPeriod;
import kd.fi.gl.report.subsidiary.SubsidiaryRow;

public class VoucherConverter
implements IDatasetRowTypeConverter<SubsidiaryRow> {
    @Override
    public SubsidiaryRow convertTo(Context context, Row row) {
        Map vouchertypeMap = (Map)context.query("vouchertypeMap");
        Map periodMap = (Map)context.query("periodMap");
        Map orgCurLocalMap = (Map)context.query("orgCurLocalMap");
        FilterInfo filterInfo = (FilterInfo)context.query("filterInfo");
        Map orgnameMap = (Map)context.query("orgnameMap");
        SubsidiaryRow subsidiaryRow = new SubsidiaryRow();
        subsidiaryRow.setRowtype(row.getString("rowtype"));
        subsidiaryRow.setOrgId(row.getLong("orgid"));
        subsidiaryRow.setOrgName((String)orgnameMap.get(row.getLong("orgid")));
        subsidiaryRow.setAccountId(row.getLong("accountid"));
        subsidiaryRow.setAccountMasterId(row.getLong("accountmasterid"));
        subsidiaryRow.setAccountName(row.getString("accountname"));
        subsidiaryRow.setAccountNumber(row.getString("accountnumber"));
        subsidiaryRow.setAccountDc(row.getInteger("accountdc"));
        subsidiaryRow.setBizDate(row.getDate("bizdate"));
        subsidiaryRow.setBookedDate(row.getDate("datefield"));
        subsidiaryRow.setVoucherDesc(row.getString("desc"));
        subsidiaryRow.setVoucherId(row.getLong("voucherid"));
        subsidiaryRow.setVoucherEntryId(row.getLong("fentryid"));
        String voucherNumber = "";
        if (Objects.nonNull(row.getLong("vouchertype"))) {
            voucherNumber = (String)vouchertypeMap.get(row.getLong("vouchertype")) + " " + row.getString("billno");
        }
        subsidiaryRow.setVoucherNum(voucherNumber);
        subsidiaryRow.setPeriodId(row.getLong("period"));
        subsidiaryRow.setPeriodYear(((SubsidiaryPeriod)periodMap.get(row.getLong("period"))).getPeriodyear());
        subsidiaryRow.setLocalRate(row.getBigDecimal("localrate"));
        if ("basecurrency".equals(filterInfo.getString("currency"))) {
            subsidiaryRow.setCurrencyId((Long)orgCurLocalMap.get(row.getLong("orgid")));
        } else if (!"allcurrency".equals(filterInfo.getString("currency"))) {
            subsidiaryRow.setCurrencyId(Long.valueOf(filterInfo.getString("currency")));
        } else {
            subsidiaryRow.setCurrencyId(row.getLong("currencycolumn"));
        }
        subsidiaryRow.setBaseCurrency((Long)orgCurLocalMap.get(row.getLong("orgid")));
        subsidiaryRow.setCreditFor(row.getBigDecimal("creditfor"));
        subsidiaryRow.setCreditLocal(row.getBigDecimal("creditlocal"));
        subsidiaryRow.setDebitFor(row.getBigDecimal("debitfor"));
        subsidiaryRow.setDebitLocal(row.getBigDecimal("debitlocal"));
        if (row.getInteger("voucherdc") == 1) {
            subsidiaryRow.setDebitQty(row.getBigDecimal("quantity"));
        } else if (row.getInteger("voucherdc") == -1) {
            subsidiaryRow.setCreditQty(row.getBigDecimal("quantity"));
        }
        subsidiaryRow.setEndDC(subsidiaryRow.getEndLocal().compareTo(BigDecimal.ZERO));
        if (!filterInfo.getBoolean("showqty")) {
            subsidiaryRow.setMeasureUnitId(0L);
        } else {
            subsidiaryRow.setMeasureUnitId(row.getLong("measureunit"));
            if (row.getInteger("voucherdc") == 1) {
                subsidiaryRow.setDebitPrice(row.getBigDecimal("price"));
            } else if (row.getInteger("voucherdc") == -1) {
                subsidiaryRow.setCreditPrice(row.getBigDecimal("price"));
            }
        }
        List flexFields = (List)context.query("flexFieldNames");
        Tuple[] flexTuple = new Tuple[flexFields.size()];
        for (int i = 0; i < flexFields.size(); ++i) {
            flexTuple[i] = Tuple.create(flexFields.get(i), row.get((String)flexFields.get(i)));
        }
        subsidiaryRow.setFlexTuple(flexTuple);
        return subsidiaryRow;
    }
}

