/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.export.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.fi.bd.model.Context;
import kd.fi.bd.util.TimerFactory;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.report.export.ExportOption;
import kd.fi.gl.report.export.convert.IDatasetRowTypeConverter;
import kd.fi.gl.report.export.processor.IBatchTransformer;
import kd.fi.gl.report.subsidiary.SubsidiaryPeriod;
import kd.fi.gl.report.subsidiary.SubsidiaryReportDatasetBuilder;

public class BatchProcessorChain<S, T> {
    private static final Log logger = LogFactory.getLog(BatchProcessorChain.class);
    private IDatasetRowTypeConverter<S> datasetRowTypeConverter;
    private final IBatchTransformer<S, ?> startNode;
    private final List<IBatchTransformer<S, ?>> processors = new LinkedList();
    private boolean isAbort;
    private boolean finalDataSetFlag = false;
    private Context context;
    private ExportOption exportOption;

    public void setDatasetRowTypeConverter(IDatasetRowTypeConverter<S> datasetRowTypeConverter) {
        this.datasetRowTypeConverter = datasetRowTypeConverter;
    }

    private BatchProcessorChain(IDatasetRowTypeConverter<S> datasetRowTypeConverter, IBatchTransformer<S, ?> startProcessor, ExportOption exportOption) {
        this.datasetRowTypeConverter = datasetRowTypeConverter;
        this.startNode = startProcessor;
        this.context = new Context();
        this.exportOption = exportOption;
    }

    public void registerProcessor(IBatchTransformer<S, ?> processor) {
        this.processors.add(processor);
    }

    public void registerContext(String prop, Object value) {
        this.context.registerContext(prop, value);
    }

    public Object getContextProp(String prop) {
        return this.context.query(prop);
    }

    public Context getContext() {
        return this.context;
    }

    public List<IBatchTransformer<S, ?>> getProcessors() {
        return this.processors;
    }

    public void feed(Iterator<Row> dataSet) {
        TimerFactory.Timer timer = (TimerFactory.Timer)this.getContext().query("timer");
        if (timer != null) {
            timer.time("feed source");
        }
        try (AlgoContext context = Algo.newContext();){
            int batchSize = this.startNode.getBatchSize();
            LinkedList<S> batch = new LinkedList<S>();
            while (dataSet.hasNext() && !this.isAbort) {
                Row row = dataSet.next();
                batch.add(this.datasetRowTypeConverter.convertTo(this.getContext(), row));
                if (batch.size() < batchSize) continue;
                if (timer != null) {
                    timer.time("### read and convert single batch");
                }
                if (!dataSet.hasNext()) {
                    this.startNode.setLastBatchFlag(true);
                }
                this.startNode.work(batch);
                if (timer != null) {
                    timer.time("done work on single batch");
                }
                batch.clear();
            }
            if (!this.isAbort) {
                this.startNode.setLastBatchFlag(true);
                this.startNode.work(batch);
                batch.clear();
                if (timer != null) {
                    timer.time("done work on last batch");
                }
            }
            if (this.isFinalDataSetFlag()) {
                this.startNode.fireFinished();
            }
        }
        catch (Exception e) {
            logger.error("batchProcessorChain feed failed.", (Throwable)e);
            throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)e.getMessage()), new Object[0]);
        }
    }

    public void initContext(FilterInfo filterInfo, Set<Long> orgIdSet, String accountNameField, Map<String, Map> orgAccountbookMap) {
        Map<Long, SubsidiaryPeriod> periodMap = SubsidiaryReportDatasetBuilder.initPeriodMap(filterInfo);
        List flexItems = filterInfo.getFlexFilterItems();
        ArrayList<String> flexFieldNames = new ArrayList<String>(flexItems.size());
        for (FilterItemInfo filterItemInfo : flexItems) {
            flexFieldNames.add(filterItemInfo.getPropName());
        }
        Map<Long, Boolean> orgAccountdcMap = SubsidiaryReportDatasetBuilder.initOrgAccountdcMap(orgIdSet);
        Map<Long, String> orgnameMap = SubsidiaryReportDatasetBuilder.initOrgnameMap(orgIdSet);
        Tuple<Map<Long, String>, Map<Long, String>> vouchertypeMap = SubsidiaryReportDatasetBuilder.initVoucherTypeMap();
        Map orgCurLocalMap = orgAccountbookMap.get("orgCurLocal");
        Map orgBookStartPeriodMap = orgAccountbookMap.get("orgBookStartPeriod");
        this.registerContext("filterInfo", filterInfo);
        this.registerContext("flexFieldNames", flexFieldNames);
        this.registerContext("accountNameField", accountNameField);
        this.registerContext("periodMap", periodMap);
        this.registerContext("orgAccountdcMap", orgAccountdcMap);
        this.registerContext("orgnameMap", orgnameMap);
        this.registerContext("vouchertypeMap", vouchertypeMap.item1);
        this.registerContext("orgCurLocalMap", orgCurLocalMap);
        this.registerContext("orgBookStartPeriodMap", orgBookStartPeriodMap);
        this.registerContext("totalCount", 0);
    }

    public void registerRowMeta(RowMeta rowMeta) {
        HashMap colIndexMap = new HashMap(rowMeta.getFieldCount());
        Arrays.stream(rowMeta.getFieldNames()).forEach(x -> colIndexMap.put(x, rowMeta.getFieldIndex(x)));
        this.registerContext("rowMeta", rowMeta);
        this.registerContext("colIndexMap", colIndexMap);
    }

    public boolean isAbort() {
        return this.isAbort;
    }

    public void abort() {
        this.isAbort = true;
    }

    public ExportOption getExportOption() {
        return this.exportOption;
    }

    public boolean isFinalDataSetFlag() {
        return this.finalDataSetFlag;
    }

    public void setFinalDataSetFlag(boolean finalDataSetFlag) {
        this.finalDataSetFlag = finalDataSetFlag;
    }

    public static class Builder<S, T> {
        private IDatasetRowTypeConverter<S> converter;
        private IBatchTransformer<S, ?> start;
        private IBatchTransformer<?, ?> last;
        private ExportOption exportOption;

        public Builder(ExportOption exportOption, IDatasetRowTypeConverter<S> datasetRowTypeConverter, IBatchTransformer<S, ?> myStart) {
            this.exportOption = exportOption;
            this.converter = datasetRowTypeConverter;
            this.start = myStart;
            this.last = myStart;
        }

        public Builder append(IBatchTransformer<?, ?> oneProcessor) {
            this.last.setNextProcessor(oneProcessor);
            this.last = oneProcessor;
            return this;
        }

        public Builder appendLast(IBatchTransformer<?, T> oneProcessor) {
            if (null == this.last) {
                throw new KDBizException("Only one specific last processor would be specified.");
            }
            this.last.setNextProcessor(oneProcessor);
            this.last = null;
            return this;
        }

        public BatchProcessorChain build() {
            if (null != this.last) {
                throw new KDBizException("please use method: 'appendLast' to finish the process builder.");
            }
            BatchProcessorChain chain = new BatchProcessorChain(this.converter, this.start, this.exportOption);
            for (IBatchTransformer<Object, Object> processor = this.start; null != processor; processor = processor.getNextProcessor()) {
                processor.setOwnedChain(chain);
                chain.registerProcessor(processor);
            }
            return chain;
        }
    }
}

