/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.rowtype;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kd.fi.gl.report.rowtype.GeneralRowTypeValue;
import kd.fi.gl.report.rowtype.MultiColAccountRowTypeValue;
import kd.fi.gl.report.rowtype.SubLedgerRTV;
import kd.fi.gl.report.rowtype.SubsiDiaryLedgerRTV;
import kd.sdk.fi.gl.extpoint.report.ReportParam;
import kd.sdk.fi.gl.extpoint.report.RowType;

public class RptRowTypeValue {
    public static final String UNSUPPORTED = "-1";
    private final String rowTypeField;
    private static final Map<RowType, Function<RptRowTypeValue, String>> getterMap = new HashMap<RowType, Function<RptRowTypeValue, String>>(8);

    public String getRowTypeField() {
        return this.rowTypeField;
    }

    protected RptRowTypeValue(String rowTypeField) {
        this.rowTypeField = rowTypeField;
    }

    public String getBeginType() {
        return UNSUPPORTED;
    }

    public String getLeafType() {
        return UNSUPPORTED;
    }

    public String getDailyType() {
        return UNSUPPORTED;
    }

    public String getPeriodType() {
        return UNSUPPORTED;
    }

    public String getYearType() {
        return UNSUPPORTED;
    }

    public String getTotalSummaryType() {
        return UNSUPPORTED;
    }

    public static RptRowTypeValue getInstance(ReportParam.ReportType reportType) {
        switch (reportType) {
            case SUB_LEDGER: {
                return new SubLedgerRTV();
            }
            case SUBSI_DIARY_LEDGER: {
                return new SubsiDiaryLedgerRTV();
            }
            case AUX_SUB_LEDGER: {
                return new SubLedgerRTV.AuxSubLedgerRTV();
            }
            case GENERAL_LEDGER: {
                return new GeneralRowTypeValue();
            }
            case MULTI_COLUMN_ACCOUNT: {
                return new MultiColAccountRowTypeValue();
            }
        }
        throw new IllegalArgumentException();
    }

    public String getValueOfType(RowType rowType) {
        return getterMap.get(rowType).apply(this);
    }

    static {
        getterMap.put(RowType.ROW_TYPE_BEGIN, RptRowTypeValue::getBeginType);
        getterMap.put(RowType.ROW_TYPE_LEAF, RptRowTypeValue::getLeafType);
        getterMap.put(RowType.ROW_TYPE_DAILY, RptRowTypeValue::getDailyType);
        getterMap.put(RowType.ROW_TYPE_PERIOD, RptRowTypeValue::getPeriodType);
        getterMap.put(RowType.ROW_TYPE_YEAR, RptRowTypeValue::getYearType);
        getterMap.put(RowType.ROW_TOTAL_SUMMARY, RptRowTypeValue::getTotalSummaryType);
    }
}

