/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary;

import com.google.common.base.Joiner;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.business.service.LocalCurrencyQueryService;
import kd.fi.bd.business.vo.AccountBookMCVO;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.enums.AssistBalBatchQueryType;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.export.ExportOption;
import kd.fi.gl.report.subsidiary.BalanceGroupRow;
import kd.fi.gl.report.subsidiary.SubsidiaryAccount;
import kd.fi.gl.report.subsidiary.SubsidiaryPeriod;
import kd.fi.gl.util.AccountUtils;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MulCurReportUtil;
import kd.fi.gl.util.SubsiDiaryHelper;
import org.apache.commons.lang3.tuple.Triple;

public class SubsidiaryReportDatasetBuilder {
    private static final Log logger = LogFactory.getLog(SubsidiaryReportDatasetBuilder.class);
    private static String[] originalGrpFields = new String[]{"orgid", "accountid", "accountmasterid", "accountnumber", "accountname", "accountdc", "currencycolumn"};
    private static String[] originalMeasureunitGrpFields = new String[]{"orgid", "accountid", "accountmasterid", "accountnumber", "accountname", "accountdc", "currencycolumn", "measureunit"};
    private static String[] originalBaseGrpFields = new String[]{"orgid", "accountid", "accountmasterid", "accountnumber", "accountname", "accountdc"};
    private static String[] originalBaseMeasureunitGrpFields = new String[]{"orgid", "accountid", "accountmasterid", "accountnumber", "accountname", "accountdc", "measureunit"};

    public static DataSet buildVoucherSource(FilterInfo filterInfo, Long orgId, ExportOption exportOption, String accountNameField) {
        QFilter[] filters = SubsidiaryReportDatasetBuilder.buildVoucherFilter(filterInfo, orgId);
        QFilter[] enhanceFilters = VoucherQueryUtils.enhanceFilters((QFilter[])filters, (boolean)true);
        String mulcur = filterInfo.getString("mulcur");
        String debitlocalField = MulCurReportUtil.getSingleVoucherLocalField(mulcur, MCT.DEBIT, "entries.", "debitlocal", "debitlocal");
        String creditlocalField = MulCurReportUtil.getSingleVoucherLocalField(mulcur, MCT.CREDIT, "entries.", "creditlocal", "creditlocal");
        String selFields = String.format("id voucherid,entries.id fentryid,bookeddate datefield,org orgid,period,entries.currency currencycolumn,entries.localrate localrate,entries.measureunit measureunit,entries.entrydc voucherdc,entries.account.id accountid,entries.account.masterid accountmasterid,entries.account.number accountnumber,entries.account.%s accountname,entries.account.dc accountdc,bizdate, vouchertype, billno,entries.edescription desc,entries.debitori debitfor,entries.creditori creditfor,%s,%s,entries.quantity quantity,entries.price price", accountNameField, debitlocalField, creditlocalField);
        List flexFilterItems = filterInfo.getFlexFilterItems();
        ArrayList<String> flexFields = new ArrayList<String>(flexFilterItems.size());
        for (int i = 0; i < flexFilterItems.size(); ++i) {
            flexFields.add("entries.assgrp_" + ((FilterItemInfo)flexFilterItems.get(i)).getPropName() + ".assval desc");
        }
        String flexFieldStr = Joiner.on((String)",").join(flexFields).concat(",");
        String orderFields = flexFieldStr + "entries.account.number,entries.account.dc,entries.currency,entries.measureunit,period";
        DataSet oriVoucherDataSet = ReportUtils.queryVoucherByAssistGrp(filterInfo, enhanceFilters, selFields, orderFields, exportOption.getTotalLimit());
        return oriVoucherDataSet.addFields(new String[]{"0L", "0.0", "0.0", "0.0", "0.0", "0.0", "''", "''", "'2'", "0.0", "0.0", "0.0", "0L"}, new String[]{"dc", "creditqty", "debitqty", "creditprice", "debitprice", "endprice", "orgname", "vouchernumber", "rowtype", "endfor", "endlocal", "endqty", "basecurrency"});
    }

    public static DataSet buildPeriodBeginBalanceSource(Long orgId, FilterInfo filterInfo, String accountNameField) {
        String mulcur = filterInfo.getString("mulcur");
        String beginlocalField = MulCurReportUtil.getSingleBalanceLocalField(mulcur, MCT.BEGIN, "beginlocal", "endlocal");
        String balanceFields = String.format("org orgid,account accountid,account.masterid accountmasterid,account.number accountnumber,account.%s accountname,account.dc accountdc,currency currencycolumn,measureunit,beginfor endfor,%s,beginqty endqty", accountNameField, beginlocalField);
        List flexItems = filterInfo.getFlexFilterItems();
        ArrayList<String> flexFieldNames = new ArrayList<String>(flexItems.size());
        for (FilterItemInfo filterItemInfo : flexItems) {
            flexFieldNames.add(filterItemInfo.getPropName());
        }
        AccountBookInfo accountBook = AccSysUtil.getBookFromAccSys(orgId, filterInfo.getLong("booktype"));
        long startperiod = filterInfo.getLong("startperiod");
        if (startperiod < accountBook.getStartPeriodId()) {
            startperiod = accountBook.getStartPeriodId();
        }
        DataSet dataSet = SubsidiaryReportDatasetBuilder.buildBalanceSource(orgId, filterInfo, startperiod, filterInfo.getLong("endperiod"), balanceFields);
        String desc = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"ReportRowType_0", (String)"fi-gl-common", (Object[])new Object[0]);
        String currencyVal = filterInfo.getString("currency");
        String[] grpFields = SubsidiaryReportDatasetBuilder.addFlexFields(originalGrpFields, flexFieldNames);
        if (filterInfo.getBoolean("showqty")) {
            grpFields = SubsidiaryReportDatasetBuilder.addFlexFields(originalMeasureunitGrpFields, flexFieldNames);
        }
        if ("basecurrency".equals(currencyVal)) {
            grpFields = SubsidiaryReportDatasetBuilder.addFlexFields(originalBaseGrpFields, flexFieldNames);
            if (filterInfo.getBoolean("showqty")) {
                grpFields = SubsidiaryReportDatasetBuilder.addFlexFields(originalBaseMeasureunitGrpFields, flexFieldNames);
            }
        }
        dataSet = dataSet.groupBy(grpFields).sum("endfor").sum("endlocal").sum("endqty").finish().addFields(new String[]{"'" + desc + "'", startperiod + "L", "'1'", "0L"}, new String[]{"desc", "period", "rowtype", "basecurrency"});
        return dataSet;
    }

    public static DataSet buildYearBalanceSource(Long orgId, FilterInfo filterInfo, String accountNameField) {
        String currencyVal;
        String mulcur = filterInfo.getString("mulcur");
        String yeardebitlocalField = MulCurReportUtil.getSingleBalanceLocalField(mulcur, MCT.YEAR_DEBIT, "yeardebitlocal", "yeardebitlocal");
        String yearcreditlocalField = MulCurReportUtil.getSingleBalanceLocalField(mulcur, MCT.YEAR_CREDIT, "yearcreditlocal", "yearcreditlocal");
        String balanceFields = String.format("org orgid,account accountid,account.masterid accountmasterid,account.number accountnumber,account.%s accountname,account.dc accountdc,currency currencycolumn,measureunit,yeardebitfor,%s,yeardebitqty,yearcreditfor,%s,yearcreditqty", accountNameField, yeardebitlocalField, yearcreditlocalField);
        List flexItems = filterInfo.getFlexFilterItems();
        ArrayList<String> flexFieldNames = new ArrayList<String>(flexItems.size());
        for (FilterItemInfo filterItemInfo : flexItems) {
            flexFieldNames.add(filterItemInfo.getPropName());
        }
        AccountBookInfo accountBook = AccSysUtil.getBookFromAccSys(orgId, filterInfo.getLong("booktype"));
        long startperiod = filterInfo.getLong("startperiod");
        if (startperiod < accountBook.getStartPeriodId()) {
            startperiod = accountBook.getStartPeriodId();
        }
        DataSet dataSet = SubsidiaryReportDatasetBuilder.buildBalanceSource(orgId, filterInfo, startperiod, startperiod, balanceFields);
        String[] grpFields = SubsidiaryReportDatasetBuilder.addFlexFields(originalGrpFields, flexFieldNames);
        if (filterInfo.getBoolean("showqty")) {
            grpFields = SubsidiaryReportDatasetBuilder.addFlexFields(originalMeasureunitGrpFields, flexFieldNames);
        }
        if ("basecurrency".equals(currencyVal = filterInfo.getString("currency"))) {
            grpFields = SubsidiaryReportDatasetBuilder.addFlexFields(originalBaseGrpFields, flexFieldNames);
            if (filterInfo.getBoolean("showqty")) {
                grpFields = SubsidiaryReportDatasetBuilder.addFlexFields(originalBaseMeasureunitGrpFields, flexFieldNames);
            }
        }
        dataSet = dataSet.groupBy(grpFields).sum("yeardebitfor").sum("yeardebitlocal").sum("yeardebitqty").sum("yearcreditfor").sum("yearcreditlocal").sum("yearcreditqty").finish().addFields(new String[]{"''", startperiod + "L", "'4'"}, new String[]{"desc", "period", "rowtype"});
        return dataSet;
    }

    public static DataSet buildBalanceSource(Long orgId, FilterInfo filterInfo, Long startPeriod, Long endPeriod, String selectFields) {
        String currencyVal;
        QueryParam queryParam = new QueryParam();
        queryParam.setZeroAmtNoDisplay(filterInfo.getBoolean("nodisplayforzero"));
        queryParam.setZeroBalNoDisplay(filterInfo.getBoolean("balancezero"));
        queryParam.setSubstractPL(filterInfo.getBoolean("issubstractpl"));
        queryParam.setAccountVersionPeriodId(filterInfo.getLong("endperiod"));
        queryParam.setAccountFilter(new QFilter("id", "in", (Object)SubsiDiaryHelper.getAcctIDs(filterInfo, orgId)));
        queryParam.setOnlyLeafAcctBal(true);
        if (filterInfo.getDynamicObjectCollection("measureunits") != null) {
            DynamicObjectCollection unitsDynColl = filterInfo.getDynamicObjectCollection("measureunits");
            ArrayList<Long> uList = new ArrayList<Long>(unitsDynColl.size());
            for (DynamicObject dyn : unitsDynColl) {
                uList.add(dyn.getLong("id"));
            }
            queryParam.setMeasureUnitIds(uList.toArray(new Long[0]));
        }
        if (!"basecurrency".equals(currencyVal = filterInfo.getString("currency")) && !"allcurrency".equals(currencyVal)) {
            queryParam.setCurrencyIds(new Long[]{Long.parseLong(filterInfo.getString("currency"))});
        } else if ("basecurrency".equals(currencyVal)) {
            queryParam.setAddAmountFilter(false);
        }
        ReportQueryParam reportQueryParam = new ReportQueryParam();
        reportQueryParam.setFilter(filterInfo);
        Triple<MainEntityType, List<QFilter>, List<String>> balanceOrmInfo = FlexUtils.buildDynamicORMAssistOnBalance(reportQueryParam, "gl_balance", true);
        queryParam.setBalEntityType((MainEntityType)balanceOrmInfo.getLeft());
        ArrayList customFiter = queryParam.getCustomFilter();
        if (customFiter == null) {
            customFiter = new ArrayList(8);
        }
        customFiter.addAll((Collection)balanceOrmInfo.getMiddle());
        queryParam.setCustomFilter(customFiter);
        String flexFields = Joiner.on((String)",").join((Iterable)balanceOrmInfo.getRight());
        DataSet dataSet = BalanceQueryExecutor.getInstance().getBalance(selectFields + "," + flexFields, new Long[]{orgId}, filterInfo.getLong("booktype"), filterInfo.getLong("accounttable"), startPeriod.longValue(), endPeriod.longValue(), queryParam);
        return dataSet;
    }

    private static String[] addFlexFields(String[] sel, List<String> flexFields) {
        List<String> list = Arrays.asList(sel);
        ArrayList<String> assTypeList = new ArrayList<String>();
        assTypeList.addAll(flexFields);
        assTypeList.addAll(list);
        String[] resultSel = assTypeList.toArray(new String[0]);
        return resultSel;
    }

    public static Map<Long, SubsidiaryPeriod> initPeriodMap(FilterInfo filterInfo) {
        QFilter filter1 = new QFilter("id", ">=", (Object)filterInfo.getLong("startperiod"));
        QFilter filter2 = new QFilter("id", "<=", (Object)filterInfo.getLong("endperiod"));
        QFilter filter3 = new QFilter("periodtype", "=", (Object)filterInfo.getLong("periodtype"));
        return SubsidiaryReportDatasetBuilder.queryPeriod(filter1.and(filter2).and(filter3));
    }

    public static Map<Long, SubsidiaryPeriod> initPeriodMap(Long startPeriod, Long endPeriod) {
        QFilter filter1 = new QFilter("id", ">=", (Object)startPeriod);
        QFilter filter2 = new QFilter("id", "<=", (Object)endPeriod);
        QFilter filter3 = new QFilter("periodtype", "=", (Object)(endPeriod / GLUtil.TYPE_PERIOD_L));
        return SubsidiaryReportDatasetBuilder.queryPeriod(filter1.and(filter2).and(filter3));
    }

    public static Map<Long, SubsidiaryPeriod> queryPeriod(QFilter qFilter) {
        DataSet periodSet = QueryServiceHelper.queryDataSet((String)(SubsidiaryReportDatasetBuilder.class.getName() + "#initPeriodMap"), (String)"bd_period", (String)"id, enddate, periodyear", (QFilter[])qFilter.toArray(), (String)"enddate,id");
        LinkedHashMap<Long, SubsidiaryPeriod> periodMap = new LinkedHashMap<Long, SubsidiaryPeriod>(8);
        for (Row row : periodSet) {
            SubsidiaryPeriod subsidiaryPeriod = new SubsidiaryPeriod();
            subsidiaryPeriod.setPeriod(row.getLong("id"));
            subsidiaryPeriod.setPeriodyear(row.getInteger("periodyear"));
            subsidiaryPeriod.setEnddate(row.getDate("enddate"));
            periodMap.put(row.getLong("id"), subsidiaryPeriod);
        }
        return periodMap;
    }

    public static Map<String, Map> initOrgAccountbookMap(Set<Long> orgIdSet, FilterInfo filterInfo) {
        String mulcur;
        Long bookTypeId = filterInfo.getLong("booktype");
        HashMap<String, Map> orgAccountbookMap = new HashMap<String, Map>(2);
        HashMap orgCurLocalMap = new HashMap(orgIdSet.size());
        HashMap orgBookStartPeriodMap = new HashMap(orgIdSet.size());
        orgIdSet.forEach(x -> {
            orgCurLocalMap.put(x, 0L);
            orgBookStartPeriodMap.put(x, 0L);
        });
        List<AccountBookInfo> books = AccSysUtil.getBookFromAccSys(orgIdSet, (long)bookTypeId);
        if (books.size() > 0) {
            books.forEach(x -> {
                orgCurLocalMap.put(x.getOrgId(), x.getBaseCurrencyId());
                orgBookStartPeriodMap.put(x.getOrgId(), x.getStartPeriodId());
            });
        }
        if (!Objects.isNull(mulcur = filterInfo.getString("mulcur")) && !Objects.equals(mulcur, "LocalCurrency")) {
            Table mulCurrencyTable = LocalCurrencyQueryService.batchQueryMulCurrency(orgIdSet, (long)bookTypeId);
            orgIdSet.stream().forEach(org -> {
                Map infoMap = (Map)mulCurrencyTable.get(org, (Object)bookTypeId);
                if (Objects.isNull(infoMap) || Objects.isNull(infoMap.get(mulcur))) {
                    orgCurLocalMap.put(org, 0L);
                } else {
                    orgCurLocalMap.put(org, ((AccountBookMCVO.Info)infoMap.get(mulcur)).getCurrencyId());
                }
            });
        }
        orgAccountbookMap.put("orgCurLocal", orgCurLocalMap);
        orgAccountbookMap.put("orgBookStartPeriod", orgBookStartPeriodMap);
        return orgAccountbookMap;
    }

    public static Map<Long, Boolean> initOrgAccountdcMap(Set<Long> orgIdSet) {
        HashMap<Long, Boolean> orgAccountdcMap = new HashMap<Long, Boolean>(8);
        orgIdSet.forEach(orgId -> {
            Boolean isShowByAccountDC = (Boolean)GLUtil.getSystemParam("showbyaccountdc", orgId);
            if (isShowByAccountDC == null) {
                isShowByAccountDC = false;
            }
            orgAccountdcMap.put((Long)orgId, isShowByAccountDC);
        });
        return orgAccountdcMap;
    }

    public static Map<Long, String> initOrgnameMap(Set<Long> orgIdSet) {
        HashMap<Long, String> orgnameMap = new HashMap<Long, String>(8);
        DataSet orgSet = QueryServiceHelper.queryDataSet((String)(SubsidiaryReportDatasetBuilder.class.getName() + "#addOrgField"), (String)"bos_org", (String)"id, name", (QFilter[])new QFilter("id", "in", orgIdSet).toArray(), null);
        for (Row row : orgSet) {
            orgnameMap.put(row.getLong("id"), row.getString("name"));
        }
        return orgnameMap;
    }

    public static Tuple<Map<Long, String>, Map<Long, String>> initVoucherTypeMap() {
        HashMap<Long, String> voucherTypeMap = new HashMap<Long, String>(8);
        HashMap<Long, String> voucherNumberMap = new HashMap<Long, String>(8);
        DataSet vchTypeDataSet = QueryServiceHelper.queryDataSet((String)(SubsidiaryReportDatasetBuilder.class.getName() + "#addVchTypeField"), (String)"gl_vouchertype", (String)"id,name,number", null, null);
        for (Row row : vchTypeDataSet) {
            voucherTypeMap.put(row.getLong("id"), row.getString("name"));
            voucherNumberMap.put(row.getLong("id"), row.getString("number"));
        }
        return new Tuple<Map<Long, String>, Map<Long, String>>(voucherTypeMap, voucherNumberMap);
    }

    private static QFilter[] buildVoucherFilter(FilterInfo filter, Long orgId) {
        Map deFilterMap;
        String currencyVal;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        long startPeriodId = filter.getLong("startperiod");
        long endPeriodId = filter.getLong("endperiod");
        QFilter fperiod = new QFilter("period", ">=", (Object)startPeriodId).and(new QFilter("period", "<=", (Object)endPeriodId));
        filters.add(fperiod);
        String[] fBillStatus = "B,C".split(",");
        if (filter.getBoolean("issubstractpl")) {
            filters.add(new QFilter("sourcetype", "!=", (Object)"1"));
        }
        QFilter billFilter = new QFilter("billstatus", "in", (Object)fBillStatus);
        filters.add(billFilter);
        QFilter orgf = new QFilter("org", "=", (Object)orgId);
        filters.add(orgf);
        filters.add(new QFilter("booktype", "=", (Object)filter.getLong("booktype")));
        filters.add(new QFilter("entries.account", "in", (Object)SubsiDiaryHelper.getAcctIDs(filter, orgId)));
        if (filter.getString("currency") != null && !"basecurrency".equals(currencyVal = filter.getString("currency")) && !"allcurrency".equals(currencyVal)) {
            QFilter fcurrency = new QFilter("entries.currency", "=", (Object)Long.parseLong(filter.getString("currency")));
            filters.add(fcurrency);
        }
        if (filter.getDynamicObjectCollection("measureunits") != null) {
            DynamicObjectCollection unitsDynColl = filter.getDynamicObjectCollection("measureunits");
            ArrayList<Long> ids = new ArrayList<Long>(unitsDynColl.size());
            for (DynamicObject dyn : unitsDynColl) {
                ids.add(dyn.getLong("id"));
            }
            QFilter funits = new QFilter("entries.measureunit", "in", (Object)ids.toArray());
            filters.add(funits);
        }
        if ((deFilterMap = filter.getCommFilters()).get("gl_voucher") != null) {
            filters.addAll((Collection)deFilterMap.get("gl_voucher"));
        }
        return filters.toArray(new QFilter[0]);
    }

    public static DataSet queryPeriodBeginByBatch(ReportQueryParam reportQueryParam, BalanceGroupRow batchFilter, AssistBalBatchQueryType batchType, Map<String, Set<Object>> flexValueMap) {
        MulOrgQPRpt qpRpt = (MulOrgQPRpt)reportQueryParam.getCustomParam().get("queryParamRpt");
        ArrayList<String> queryFields = new ArrayList<String>(16);
        queryFields.add("org");
        queryFields.add("account");
        queryFields.add("period");
        queryFields.add("endperiod");
        queryFields.add("beginlocal");
        queryFields.add("endlocal");
        queryFields.add("debitlocal");
        queryFields.add("creditlocal");
        queryFields.add("yeardebitlocal");
        queryFields.add("yearcreditlocal");
        if (qpRpt.isQueryCurrency()) {
            queryFields.add("currency");
            queryFields.add("beginfor");
            queryFields.add("endfor");
            queryFields.add("debitfor");
            queryFields.add("creditfor");
            queryFields.add("yeardebitfor");
            queryFields.add("yearcreditfor");
        }
        if (qpRpt.isShowQty() && !Objects.equals(qpRpt.getEntityId(), "t_rpt_aux_subledger")) {
            queryFields.add("measureunit");
            queryFields.add("beginqty");
            queryFields.add("endqty");
            queryFields.add("debitqty");
            queryFields.add("creditqty");
            queryFields.add("yeardebitqty");
            queryFields.add("yearcreditqty");
        }
        if (qpRpt.isNoZeroAmount()) {
            queryFields.add("count");
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("period", "<=", (Object)qpRpt.getEndPeriod()));
        filters.add(new QFilter("period", ">=", (Object)(qpRpt.getEndPeriod() / GLUtil.TYPE_PERIOD_L * GLUtil.TYPE_PERIOD_L)));
        filters.add(new QFilter("booktype", "=", (Object)qpRpt.getBookType()));
        filters.add(new QFilter("accounttable", "=", (Object)qpRpt.getAccountTable()));
        filters.add(new QFilter("org", "in", (Object)batchFilter.getOrgId()));
        filters.add(new QFilter("endperiod", "in", (Object)PeriodUtil.getAvailableEndPeriodIds((String)">", (Long)qpRpt.getStartPeriod(), (Long[])new Long[]{batchFilter.getOrgId()})));
        if (batchType == AssistBalBatchQueryType.GROUP) {
            filters.add(new QFilter("account", "=", (Object)batchFilter.getAccountMasterId()));
            filters.add(new QFilter("currency", "=", (Object)batchFilter.getCurrencyId()));
        } else {
            filters.add(new QFilter("account", "in", (Object)SubsiDiaryHelper.getAcctMasterIds(qpRpt.getFilterInfo(), batchFilter.getOrgId())));
            if (!qpRpt.isSynCurrency() && !qpRpt.isAllCurrency()) {
                filters.add(new QFilter("currency", "=", (Object)qpRpt.getCurrency()));
            }
        }
        DataSet dataSet = SubsidiaryReportDatasetBuilder.queryOrmBalanceDataSet(flexValueMap, queryFields, filters);
        return dataSet;
    }

    public static DataSet queryBalanceGroupDataSet(ReportQueryParam reportQueryParam, int limit) {
        MulOrgQPRpt qpRpt = (MulOrgQPRpt)reportQueryParam.getCustomParam().get("queryParamRpt");
        ArrayList<String> queryFields = new ArrayList<String>(16);
        queryFields.add("org");
        queryFields.add("account");
        queryFields.add("currency");
        queryFields.add("period");
        queryFields.add("count");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("org", "in", qpRpt.getAllEntityOrgs()));
        filters.add(new QFilter("booktype", "=", (Object)qpRpt.getBookType()));
        filters.add(new QFilter("accounttable", "=", (Object)qpRpt.getAccountTable()));
        filters.add(new QFilter("account", "in", qpRpt.getMasterIdSet()));
        if (!qpRpt.isSynCurrency() && !qpRpt.isAllCurrency()) {
            filters.add(new QFilter("currency", "=", (Object)qpRpt.getCurrency()));
        }
        filters.add(new QFilter("endperiod", "in", (Object)PeriodUtil.getAvailableEndPeriodIds((String)">", (Long)qpRpt.getStartPeriod(), (Long[])qpRpt.getAllEntityOrgs().toArray(new Long[0]))));
        filters.add(new QFilter("period", "<=", (Object)qpRpt.getEndPeriod()));
        filters.add(new QFilter("period", ">=", (Object)(qpRpt.getEndPeriod() / GLUtil.TYPE_PERIOD_L * GLUtil.TYPE_PERIOD_L)));
        DataSet dataSet = SubsidiaryReportDatasetBuilder.queryOrmBalanceLimitedDataSet(reportQueryParam, queryFields, filters, limit);
        return dataSet;
    }

    public static DataSet queryOrmBalanceDataSet(Map<String, Set<Object>> flexValueMap, List<String> queryFields, List<QFilter> filters) {
        long tick = System.currentTimeMillis();
        Triple<MainEntityType, List<QFilter>, List<String>> balanceOrmInfo = FlexUtils.buildDynamicORMAssistOnBalanceWithoutCache(flexValueMap, "gl_balance", false);
        ORM orm = ORM.create();
        orm.setDataEntityType("gl_balance", (IDataEntityType)balanceOrmInfo.getLeft());
        filters.addAll((Collection)balanceOrmInfo.getMiddle());
        List flexFields = (List)balanceOrmInfo.getRight();
        queryFields.addAll(flexFields);
        DataSet beginDataSet = orm.queryDataSet(SubsidiaryReportDatasetBuilder.class.getName() + "#getBalance", "gl_balance", Joiner.on((String)",").join(queryFields), filters.toArray(new QFilter[0]), null);
        logger.info("query balanceDataSet cost:{}ms", (Object)(System.currentTimeMillis() - tick));
        return beginDataSet;
    }

    public static DataSet queryOrmBalanceLimitedDataSet(ReportQueryParam reportQueryParam, List<String> queryFields, List<QFilter> filters, int limit) {
        long tick = System.currentTimeMillis();
        Triple<MainEntityType, List<QFilter>, List<String>> balanceOrmInfo = FlexUtils.buildDynamicORMAssistOnBalanceWithoutCache(reportQueryParam, "gl_balance", false);
        ORM orm = ORM.create();
        orm.setDataEntityType("gl_balance", (IDataEntityType)balanceOrmInfo.getLeft());
        filters.addAll((Collection)balanceOrmInfo.getMiddle());
        List flexFields = (List)balanceOrmInfo.getRight();
        queryFields.addAll(flexFields);
        DataSet beginDataSet = orm.queryDataSet(SubsidiaryReportDatasetBuilder.class.getName() + "#getBalance", "gl_balance", Joiner.on((String)",").join(queryFields), filters.toArray(new QFilter[0]), null, limit);
        logger.info("query balanceDataSet cost:{}ms", (Object)(System.currentTimeMillis() - tick));
        return beginDataSet;
    }

    public static DataSet queryVoucherByBatch(ReportQueryParam reportQueryParam, BalanceGroupRow batchFilter, int limit, AssistBalBatchQueryType batchType, Map<String, Set<Object>> flexValueMap, QFilter accountQF) {
        QueryParamRpt qpRpt = (QueryParamRpt)reportQueryParam.getCustomParam().get("queryParamRpt");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)batchFilter.getOrgId()));
        filters.add(accountQF);
        if (batchType == AssistBalBatchQueryType.GROUP) {
            filters.add(new QFilter("entries.currency", "=", (Object)batchFilter.getCurrencyId()));
        } else if (!qpRpt.isSynCurrency() && !qpRpt.isAllCurrency()) {
            filters.add(new QFilter("entries.currency", "=", (Object)qpRpt.getCurrency()));
        }
        filters.add(new QFilter("booktype", "=", (Object)qpRpt.getBookType()));
        filters.add(new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}));
        filters.add(new QFilter("period", ">=", (Object)qpRpt.getStartPeriod()));
        filters.add(new QFilter("period", "<=", (Object)qpRpt.getEndPeriod()));
        QFilter commonFilter = reportQueryParam.getFilter().getCommFilter("gl_voucher");
        if (commonFilter != null) {
            filters.add(commonFilter);
        }
        return SubsidiaryReportDatasetBuilder.queryOrmVoucher(reportQueryParam, filters, limit, flexValueMap);
    }

    public static DataSet queryOrmVoucher(ReportQueryParam reportQueryParam, List<QFilter> filters, int limit, Map<String, Set<Object>> flexValueMap) {
        QueryParamRpt qpRpt = (QueryParamRpt)reportQueryParam.getCustomParam().get("queryParamRpt");
        long tick = System.currentTimeMillis();
        ArrayList<String> queryFields = new ArrayList<String>(16);
        queryFields.add("id voucherid");
        queryFields.add("billno");
        queryFields.add("vouchertype");
        queryFields.add("bookeddate");
        queryFields.add("bizdate");
        queryFields.add("org");
        queryFields.add(String.join((CharSequence)"", "entries", ".", "id", " ", "fentryid"));
        queryFields.add(String.join((CharSequence)"", "entries", ".", "edescription", " ", "desc"));
        queryFields.add(String.join((CharSequence)"", "entries", ".", "account", " ", "account"));
        queryFields.add(String.join((CharSequence)"", "entries", ".", "debitlocal", " ", "debitlocal"));
        queryFields.add(String.join((CharSequence)"", "entries", ".", "creditlocal", " ", "creditlocal"));
        queryFields.add(String.join((CharSequence)"", "entries", ".", "entrydc", " ", "entrydc"));
        queryFields.add(String.join((CharSequence)"", "entries", ".", "seq", " ", "accountseq"));
        if (qpRpt.isQueryCurrency()) {
            queryFields.add(String.join((CharSequence)"", "entries", ".", "currency", " ", "currency"));
            queryFields.add(String.join((CharSequence)"", "entries", ".", "debitori", " ", "debitfor"));
            queryFields.add(String.join((CharSequence)"", "entries", ".", "creditori", " ", "creditfor"));
        }
        if (qpRpt.isShowQty()) {
            queryFields.add(String.join((CharSequence)"", "entries", ".", "measureunit", " ", "measureunit"));
            queryFields.add(String.join((CharSequence)"", "entries", ".", "quantity", " ", "creditqty"));
            queryFields.add(String.join((CharSequence)"", "entries", ".", "quantity", " ", "debitqty"));
        }
        queryFields.add("period");
        QFilter[] enhanceFilters = VoucherQueryUtils.enhanceFilters((QFilter[])filters.toArray(new QFilter[0]), (boolean)true);
        Triple<MainEntityType, List<QFilter>, List<String>> voucherOrmInfo = FlexUtils.buildDynamicORMAssistOnVoucher(flexValueMap);
        filters = Arrays.stream(enhanceFilters).collect(Collectors.toList());
        filters.addAll((Collection)voucherOrmInfo.getMiddle());
        List flexFields = (List)voucherOrmInfo.getRight();
        queryFields.addAll(flexFields);
        ORM orm = ORM.create();
        orm.setDataEntityType("gl_voucher", (IDataEntityType)voucherOrmInfo.getLeft());
        DataSet voucherDataSet = orm.queryDataSet(SubsidiaryReportDatasetBuilder.class.getName() + "#queryOrmVoucher", "gl_voucher", Joiner.on((String)",").join(queryFields), filters.toArray(new QFilter[0]), null, limit);
        voucherDataSet = voucherDataSet.addFields(new String[]{"0L", "0L", "0.0", "0.0", "0.0", "''", "2", "0L", "''", "''", "''", "''"}, new String[]{"accountdc", "dc", "endlocal", "endfor", "endqty", "voucherno", "rowtype", "currencylocalid", "accountname", "accountnumber", "vtnumber", "bookeddatestr"});
        logger.info("query voucherDataSet cost:{}ms", (Object)(System.currentTimeMillis() - tick));
        return voucherDataSet;
    }

    public static Map<Long, SubsidiaryAccount> initAcctMID2IDMap(QueryParamRpt qpRpt) {
        HashMap<Long, SubsidiaryAccount> acctMID2IDMap = new HashMap<Long, SubsidiaryAccount>(32);
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)qpRpt.getEndPeriod(), (String)"bd_period");
        try (DataSet accSet = ReportUtils.getAccountInfos((Long)qpRpt.getPorg(), qpRpt.getAccountTable(), period.getDate("enddate"));){
            for (Row row : accSet) {
                SubsidiaryAccount account = new SubsidiaryAccount();
                account.setId(row.getLong("account"));
                account.setMasterid(row.getLong("masterid"));
                account.setName(row.getString("name"));
                account.setDc(row.getInteger("dc"));
                account.setNumber(row.getString("number"));
                acctMID2IDMap.put(account.getMasterid(), account);
            }
        }
        return acctMID2IDMap;
    }

    public static Map<Long, SubsidiaryAccount> initAcctID2MIDMap(QueryParamRpt qpRpt) {
        HashMap<Long, SubsidiaryAccount> acctID2MIDMap = new HashMap<Long, SubsidiaryAccount>(32);
        HashSet<Long> accMasterIdSet = AccountUtils.getAccMasterIdSet(qpRpt);
        QFilter qFilters = new QFilter("masterid", "in", accMasterIdSet);
        String accountNameField = GLUtil.getAcctNameBySysParam(qpRpt.getPorg());
        String selFields = String.format("masterid, id account, dc, %s name, number", accountNameField);
        try (DataSet accSet = QueryServiceHelper.queryDataSet((String)(SubsidiaryReportDatasetBuilder.class.getName() + "#initAcctID2MIDMap"), (String)"bd_accountview", (String)selFields, (QFilter[])qFilters.toArray(), null);){
            for (Row row : accSet) {
                SubsidiaryAccount account = new SubsidiaryAccount();
                account.setId(row.getLong("account"));
                account.setMasterid(row.getLong("masterid"));
                account.setName(row.getString("name"));
                account.setDc(row.getInteger("dc"));
                account.setNumber(row.getString("number"));
                acctID2MIDMap.put(account.getId(), account);
            }
        }
        return acctID2MIDMap;
    }

    public static Map<Long, SubsidiaryAccount> initAcctMap(QueryParamRpt qpRpt) {
        HashMap<Long, SubsidiaryAccount> acctMap = new HashMap<Long, SubsidiaryAccount>(32);
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)qpRpt.getEndPeriod(), (String)"bd_period");
        try (DataSet accSet = ReportUtils.getAccountInfos((Long)qpRpt.getPorg(), qpRpt.getAccountTable(), period.getDate("enddate"));){
            for (Row row : accSet) {
                SubsidiaryAccount account = new SubsidiaryAccount();
                account.setId(row.getLong("account"));
                account.setMasterid(row.getLong("masterid"));
                account.setName(row.getString("name"));
                account.setDc(row.getInteger("dc"));
                account.setNumber(row.getString("number"));
                acctMap.put(account.getMasterid(), account);
                acctMap.put(account.getId(), account);
            }
        }
        return acctMap;
    }

    public static DataSet queryVoucherGroupDataSet(ReportQueryParam reportQueryParam, int limit) {
        QueryParamRpt qpRpt = (QueryParamRpt)reportQueryParam.getCustomParam().get("queryParamRpt");
        List<Object> filters = new ArrayList<QFilter>();
        Set<Long> orgSet = qpRpt.getChildOrg();
        filters.add(new QFilter("org", "in", orgSet));
        filters.add(new QFilter("entries.account.masterid", "in", qpRpt.getMasterIdSet()));
        if (!qpRpt.isSynCurrency() && !qpRpt.isAllCurrency()) {
            filters.add(new QFilter("entries.currency", "=", (Object)qpRpt.getCurrency()));
        }
        filters.add(new QFilter("booktype", "=", (Object)qpRpt.getBookType()));
        filters.add(new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}));
        filters.add(new QFilter("period", ">=", (Object)qpRpt.getStartPeriod()));
        filters.add(new QFilter("period", "<=", (Object)qpRpt.getEndPeriod()));
        QFilter commonFilter = reportQueryParam.getFilter().getCommFilter("gl_voucher");
        if (commonFilter != null) {
            filters.add(commonFilter);
        }
        ArrayList<String> queryFields = new ArrayList<String>(16);
        queryFields.add("org");
        queryFields.add(String.join((CharSequence)"", "entries", ".", "account", " ", "account"));
        queryFields.add(String.join((CharSequence)"", "entries", ".", "currency", " ", "currency"));
        QFilter[] enhanceFilters = VoucherQueryUtils.enhanceFilters((QFilter[])filters.toArray(new QFilter[0]), (boolean)true);
        Triple<MainEntityType, List<QFilter>, List<String>> voucherOrmInfo = FlexUtils.buildDynamicORMAssistOnVoucher(reportQueryParam);
        filters = Arrays.stream(enhanceFilters).collect(Collectors.toList());
        filters.addAll((Collection)voucherOrmInfo.getMiddle());
        List flexFields = (List)voucherOrmInfo.getRight();
        queryFields.addAll(flexFields);
        ORM orm = ORM.create();
        orm.setDataEntityType("gl_voucher", (IDataEntityType)voucherOrmInfo.getLeft());
        DataSet voucherDataSet = orm.queryDataSet(SubsidiaryReportDatasetBuilder.class.getName() + "#queryOrmVoucher", "gl_voucher", Joiner.on((String)",").join(queryFields), filters.toArray(new QFilter[0]), null, limit);
        return voucherDataSet;
    }
}

