/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary.v2.display;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.report.IReportView;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.gl.report.CurType;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.subsidiary.v2.core.model.RowType;
import kd.fi.gl.report.subsidiary.v2.display.RptColumnHandler;
import kd.fi.gl.util.MulCurReportUtil;
import kd.fi.gl.util.ReportFieldSettingUtil;
import kd.fi.gl.util.SubsiDiaryHelper;
import kd.fi.gl.vo.ReportFieldSettingVo;

public class SubsidiaryProcessRowDataHelper {
    static final RptColumnHandler ASSIST_COLUMN = new RptColumnHandler(){

        @Override
        public void processVchRow(DynamicObject rptRow, DynamicObject vchEntryRow, RptColumnHandler.FormatContext context) {
            super.processVchRow(rptRow, vchEntryRow, context);
            this.setAssistValue(rptRow, context);
        }

        @Override
        public void processSumRow(DynamicObject rptRow, RptColumnHandler.FormatContext context) {
            super.processSumRow(rptRow, context);
            this.setAssistValue(rptRow, context);
        }

        private void setAssistValue(DynamicObject rptRow, RptColumnHandler.FormatContext context) {
            Map<String, Object> selectedFlexValueGrp = context.getSelectedFlexValueGrp();
            context.getQueryParamRpt().getFilterInfo().getFlexFilterItems().stream().map(FilterItemInfo::getPropName).forEach(flexField -> rptRow.set(flexField, selectedFlexValueGrp.get(flexField)));
        }

        @Override
        public boolean enable(RptColumnHandler.FormatContext context) {
            return SubsiDiaryHelper.isExportByQuery(context.getQueryParamRpt().getFilterInfo());
        }
    };
    static final RptColumnHandler SUMMARY_DESC_COLUMN = new RptColumnHandler(){

        @Override
        public void processSumRow(DynamicObject rptRow, RptColumnHandler.FormatContext context) {
            super.processSumRow(rptRow, context);
            String desc = null;
            switch (RowType.of(rptRow.getString("rowtype"))) {
                case BEGIN: {
                    desc = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"SubsiDiaryTreeFormRpt_101", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                    break;
                }
                case PERIOD: {
                    rptRow.set("datefield", (Object)rptRow.getDate("period.enddate"));
                    desc = ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"SubsiDiaryTreeFormRpt_103", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                    break;
                }
                case YEAR: {
                    rptRow.set("datefield", (Object)rptRow.getDate("period.enddate"));
                    desc = ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"SubsiDiaryTreeFormRpt_104", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                    break;
                }
                case TOTAL: {
                    desc = ResManager.loadKDString((String)"\u672c\u671f\u603b\u5408\u8ba1", (String)"SubsiDiaryTreeFormRpt_105", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                    break;
                }
            }
            if (desc != null) {
                rptRow.set("desc", desc);
            }
        }
    };
    static final RptColumnHandler EXT_VCH_COLUMN = new RptColumnHandler(){

        @Override
        public void processVchRow(DynamicObject rptRow, DynamicObject vchEntryRow, RptColumnHandler.FormatContext context) {
            this.getRptVchFields(context).forEach(vo -> rptRow.set(vo.getField(), vchEntryRow.get(vo.getFieldMark())));
        }

        @Override
        protected List<ReportFieldSettingVo> getRptVchFields(RptColumnHandler.FormatContext context) {
            return ReportFieldSettingUtil.getDisplayFieldConfigListWithCache("gl_rpt_subsidiaryledger");
        }
    };
    static final RptColumnHandler DEFAULT_VCH_COLUMN = new RptColumnHandler(){

        @Override
        public void processVchRow(DynamicObject rptRow, DynamicObject vchEntryRow, RptColumnHandler.FormatContext context) {
            rptRow.set("bizdate", vchEntryRow.get("v_bizdate"));
            rptRow.set("desc", vchEntryRow.get("e_desc"));
            String vtName = context.getVtName(vchEntryRow.getLong("v_vt"));
            rptRow.set("vouchernumber", (Object)(vtName + " " + vchEntryRow.getString("v_billno")));
        }

        @Override
        protected List<ReportFieldSettingVo> getRptVchFields(RptColumnHandler.FormatContext context) {
            return Arrays.asList(SubsidiaryProcessRowDataHelper.createFieldVo("bizdate", "v_bizdate"), SubsidiaryProcessRowDataHelper.createFieldVo("vouchertype", "v_vt"), SubsidiaryProcessRowDataHelper.createFieldVo("billno", "v_billno"), SubsidiaryProcessRowDataHelper.createFieldVo("entries.edescription", "e_desc"));
        }
    };
    static final RptColumnHandler BASE_CURRENCY_COLUMN_GROUP = new RptColumnHandler(){

        @Override
        public void processVchRow(DynamicObject rptRow, DynamicObject vchEntryRow, RptColumnHandler.FormatContext context) {
            super.processVchRow(rptRow, vchEntryRow, context);
            rptRow.set("basecurrency", (Object)context.getBaseCurrency());
        }

        @Override
        public void processSumRow(DynamicObject rptRow, RptColumnHandler.FormatContext context) {
            super.processSumRow(rptRow, context);
            rptRow.set("basecurrency", (Object)context.getBaseCurrency());
        }
    };
    static final RptColumnHandler CURRENCY_COLUMN_GROUP = new RptColumnHandler(){

        @Override
        public void processVchRow(DynamicObject rptRow, DynamicObject vchEntryRow, RptColumnHandler.FormatContext context) {
            rptRow.set("localrate", vchEntryRow.get("e_localrate"));
        }

        @Override
        protected List<ReportFieldSettingVo> getRptVchFields(RptColumnHandler.FormatContext context) {
            return Collections.singletonList(SubsidiaryProcessRowDataHelper.createFieldVo("entries.localrate", "e_localrate"));
        }

        @Override
        public boolean enable(RptColumnHandler.FormatContext context) {
            return context.getQueryParamRpt().isQueryCurrency();
        }
    };
    static final RptColumnHandler MEASURE_UNIT_COLUMN_GROUP = new RptColumnHandler(){

        @Override
        protected List<ReportFieldSettingVo> getRptVchFields(RptColumnHandler.FormatContext context) {
            return Arrays.asList(SubsidiaryProcessRowDataHelper.createFieldVo("entries.price", "e_price"), SubsidiaryProcessRowDataHelper.createFieldVo("entries.entrydc", "e_dc"));
        }

        @Override
        public void processVchRow(DynamicObject rptRow, DynamicObject vchEntryRow, RptColumnHandler.FormatContext context) {
            if ("1".equals(vchEntryRow.getString("e_dc"))) {
                rptRow.set("debitprice", (Object)vchEntryRow.getBigDecimal("e_price"));
            } else {
                rptRow.set("creditprice", (Object)vchEntryRow.getBigDecimal("e_price"));
            }
            BigDecimal endQty = rptRow.getBigDecimal("endqty");
            if (endQty.compareTo(BigDecimal.ZERO) != 0) {
                CurType curType = context.getQueryParamRpt().getCurType();
                String amtField = curType == CurType.ALL || curType == CurType.FOREIGN ? "endfor" : "endlocal";
                String currencyField = curType == CurType.BASE || curType == CurType.NATIVE ? "basecurrency" : "currencycolumn";
                int precision = rptRow.getInt(currencyField + ".priceprecision");
                rptRow.set("endprice", (Object)rptRow.getBigDecimal(amtField).divide(endQty, precision, RoundingMode.HALF_UP).abs());
            }
        }

        @Override
        public void processSumRow(DynamicObject rptRow, RptColumnHandler.FormatContext context) {
            super.processSumRow(rptRow, context);
            if (rptRow.get("measureunit") != null) {
                BigDecimal endQty;
                CurType curType = context.getQueryParamRpt().getCurType();
                String currencyField = curType == CurType.BASE || curType == CurType.NATIVE ? "basecurrency" : "currencycolumn";
                int precision = rptRow.getInt(currencyField + ".priceprecision");
                boolean foreignCurrency = curType == CurType.ALL || curType == CurType.FOREIGN;
                String amtField = foreignCurrency ? "debitfor" : "debitlocal";
                BigDecimal debitQty = rptRow.getBigDecimal("debitqty");
                if (BigDecimal.ZERO.compareTo(debitQty) != 0) {
                    rptRow.set("debitprice", (Object)rptRow.getBigDecimal(amtField).divide(debitQty, precision, RoundingMode.HALF_UP).abs());
                }
                amtField = foreignCurrency ? "creditfor" : "creditlocal";
                BigDecimal creditQty = rptRow.getBigDecimal("creditqty");
                if (BigDecimal.ZERO.compareTo(creditQty) != 0) {
                    rptRow.set("creditprice", (Object)rptRow.getBigDecimal(amtField).divide(creditQty, precision, RoundingMode.HALF_UP).abs());
                }
                if ((endQty = rptRow.getBigDecimal("endqty")).compareTo(BigDecimal.ZERO) != 0) {
                    amtField = foreignCurrency ? "endfor" : "endlocal";
                    rptRow.set("endprice", (Object)rptRow.getBigDecimal(amtField).divide(endQty, precision, RoundingMode.HALF_UP).abs());
                }
            }
        }

        @Override
        public boolean enable(RptColumnHandler.FormatContext context) {
            return context.getQueryParamRpt().isShowQty() && context.getQueryParamRpt().isShowPrice();
        }
    };
    static final RptColumnHandler ACCOUNT_NAME_NUM_COLUMN = new RptColumnHandler(){

        @Override
        public void processSumRow(DynamicObject rptRow, RptColumnHandler.FormatContext context) {
            super.processSumRow(rptRow, context);
            RowType rowType = RowType.of(rptRow.getString("rowtype"));
            if (rowType == RowType.TOTAL && context.isPrint()) {
                String accountName = context.getView().getPageCache().get("lastAccountName");
                String accountNumber = context.getView().getPageCache().get("lastAccountNumber");
                rptRow.set("accountname", (Object)accountName);
                rptRow.set("accountnumber", (Object)accountNumber);
            }
            if (rowType != RowType.TOTAL && (context.isExport() || RowType.BEGIN == rowType)) {
                this.setAccount(rptRow, context);
            }
        }

        @Override
        public void processVchRow(DynamicObject rptRow, DynamicObject vchEntryRow, RptColumnHandler.FormatContext context) {
            super.processVchRow(rptRow, vchEntryRow, context);
            if (context.isExport()) {
                this.setAccount(rptRow, context);
            }
        }

        private void setAccount(DynamicObject rptRow, RptColumnHandler.FormatContext context) {
            if (Objects.isNull(rptRow.get("account1"))) {
                return;
            }
            String accountNumber = rptRow.getString("account1.number");
            String accountName = "";
            boolean showAccountFullName = context.getQueryParamRpt().isShowAccountFullName();
            accountName = showAccountFullName ? rptRow.getLocaleString("account1.fullname").getLocaleValue() : rptRow.getLocaleString("account1.name").getLocaleValue();
            rptRow.set("accountnumber", (Object)accountNumber);
            rptRow.set("accountname", (Object)accountName);
            RowType rowType = RowType.of(rptRow.getString("rowtype"));
            if (rowType == RowType.BEGIN) {
                context.getView().getPageCache().put("lastAccountName", accountName);
                context.getView().getPageCache().put("lastAccountNumber", accountNumber);
            }
        }
    };
    private static final List<RptColumnHandler> ALL_COLUMN_SETTERS = Arrays.asList(SUMMARY_DESC_COLUMN, ASSIST_COLUMN, DEFAULT_VCH_COLUMN, CURRENCY_COLUMN_GROUP, MEASURE_UNIT_COLUMN_GROUP, ACCOUNT_NAME_NUM_COLUMN, EXT_VCH_COLUMN, BASE_CURRENCY_COLUMN_GROUP);

    public static void processRowData(DynamicObjectCollection rowData, IReportView view, QueryParamRpt queryParam) {
        RptColumnHandler.FormatContext context = new RptColumnHandler.FormatContext(view, queryParam);
        SubsidiaryProcessRowDataHelper.setMulCurrency(context);
        List setters = ALL_COLUMN_SETTERS.stream().filter(columnSetter -> columnSetter.enable(context)).collect(Collectors.toList());
        ArrayList<ReportFieldSettingVo> vchSelectFields = new ArrayList<ReportFieldSettingVo>(8);
        setters.stream().map(rptColumnHandler -> rptColumnHandler.getRptVchFields(context)).forEach(vchSelectFields::addAll);
        Map<Long, DynamicObject> vchEntryMap = ReportUtils.getVoucherInfo(vchSelectFields, rowData);
        rowData.forEach(row -> {
            DynamicObject vchEntry = (DynamicObject)vchEntryMap.get(row.getLong("fentryid"));
            setters.forEach(setter -> {
                if (vchEntry != null) {
                    setter.processVchRow((DynamicObject)row, vchEntry, context);
                } else {
                    setter.processSumRow((DynamicObject)row, context);
                }
            });
        });
    }

    static ReportFieldSettingVo createFieldVo(String oriField, String maskField) {
        ReportFieldSettingVo vo = new ReportFieldSettingVo();
        vo.setFieldMark(oriField + " " + maskField);
        vo.setField(oriField);
        return vo;
    }

    static void setMulCurrency(RptColumnHandler.FormatContext context) {
        FilterInfo filterInfo = context.getQueryParamRpt().getFilterInfo();
        String mulCur = filterInfo.getString("mulcur");
        if (MulCurReportUtil.localCurrency(mulCur)) {
            return;
        }
        LocalCurrencyConfigVO configVO = LocalCurrencyConfigService.getCurrencyConfig((String)mulCur);
        long baseCurrencyId = configVO.getCurrencyId(filterInfo.getLong("org"), filterInfo.getLong("booktype"));
        context.getQueryParamRpt().setCurLocal(baseCurrencyId);
    }
}

