/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.impl.ThreadPoolImpl;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;
import kd.fi.gl.util.DataSetHelper;

@Deprecated
public class GLThreadService {
    private static final Log LOG = LogFactory.getLog(GLThreadService.class);
    private static final Map<String, ThreadPoolExecutor> ThreadPoolExecutorHolder = new ConcurrentHashMap<String, ThreadPoolExecutor>(16);
    private static ThreadPool BALANCE_CALCULATED = GLThreadPool.access$000("fi.gl.calculate_balance", 6, 12);
    private static ThreadPool ACCT_CALCULATED = GLThreadPool.access$000("fi.gl.calculate_acct", 5, 8);
    private static ThreadPool COMMON_ASYNC_TASK = GLThreadPool.access$000("fi.gl.common_async", 6, 10);
    private static ThreadPool PAGE_ASYNC_TASK = GLThreadPool.access$000("fi.gl.page_async", 4, 6);
    private static ThreadPool PARELLEL_COMPUTE = GLThreadPool.access$000("fi.gl.paralleling_compute", 8, 10);
    private static final long PERFORMANCE_THRESHOLD = 2000L;

    public static void ayncCallBalance(String taskName, Runnable runnable) {
        BALANCE_CALCULATED.execute((Runnable)new RunnableEnhance(taskName, runnable), RequestContext.getOrCreate());
    }

    public static <T> Future<T> computeAcct(Callable<T> task) {
        return ACCT_CALCULATED.submit(new CallableEnhance<T>("acct", task), RequestContext.getOrCreate());
    }

    public static void ayncCommonTask(String taskName, Runnable runnable) {
        COMMON_ASYNC_TASK.execute((Runnable)new RunnableEnhance(taskName, runnable), RequestContext.getOrCreate());
    }

    public static void ayncPageLoadingTask(String taskName, Runnable runnable) {
        PAGE_ASYNC_TASK.execute((Runnable)new RunnableEnhance(taskName, runnable), RequestContext.getOrCreate());
    }

    public static <T> Future<T> submitAndGetResult(String taskName, Callable<T> task) {
        return PARELLEL_COMPUTE.submit(new CallableEnhance<T>(taskName, task), RequestContext.getOrCreate());
    }

    public static void submit(String taskName, Runnable task) {
        PARELLEL_COMPUTE.execute((Runnable)new RunnableEnhance(taskName, task), RequestContext.getOrCreate());
    }

    public static void monitor() {
        ArrayList<String> fields = new ArrayList<String>(8);
        fields.add("PoolName");
        fields.add("CorePoolSize");
        fields.add("MaximumPoolSize");
        fields.add("PoolSize");
        fields.add("LargestPoolSize");
        fields.add("ActiveCount");
        fields.add("CompletedTaskCount");
        fields.add("TaskCount");
        fields.add("Queue_size");
        ArrayList<DataType> dataTypes = new ArrayList<DataType>(8);
        for (int i = 0; i < fields.size(); ++i) {
            dataTypes.add((DataType)DataType.StringType);
        }
        ArrayList<List<Object>> values = new ArrayList<List<Object>>(8);
        ThreadPoolExecutorHolder.entrySet().forEach(kv -> {
            ArrayList<Object> row = new ArrayList<Object>(8);
            String poolName = (String)kv.getKey();
            ThreadPoolExecutor executor = (ThreadPoolExecutor)kv.getValue();
            row.add(poolName);
            row.add(executor.getCorePoolSize());
            row.add(executor.getMaximumPoolSize());
            row.add(executor.getPoolSize());
            row.add(executor.getLargestPoolSize());
            row.add(executor.getActiveCount());
            row.add(executor.getCompletedTaskCount());
            row.add(executor.getTaskCount());
            row.add(executor.getQueue().size());
            values.add(row);
        });
        DataSet infoDS = DataSetHelper.createDatSet(GLThreadService.class, fields, dataTypes, values);
        LOG.warn("gl_thread_monitor:\n" + String.join((CharSequence)"\n", DataSetHelper.printDataSet(infoDS, 1000, null)));
    }

    static {
        ThreadPoolExecutorHolder.entrySet().forEach(p -> ConfigurationUtil.observeChange((String)((String)p.getKey() + ".pool_maxthread"), (ConfigurationChangeListener)new ConfigurationChangeListener((Map.Entry)p){
            final /* synthetic */ Map.Entry val$p;
            {
                this.val$p = entry;
            }

            public void onChange(Object key, Object newValue) {
                LOG.info("update thread pool thread size to {}", newValue);
                Integer newMaxThread = Integer.getInteger(newValue.toString());
                if (newMaxThread != null && newMaxThread > 0) {
                    LOG.info("updated thread pool thread size to {}", (Object)newMaxThread);
                    ((ThreadPoolExecutor)this.val$p.getValue()).setCorePoolSize(newMaxThread);
                }
            }
        }));
    }

    private static class CallableEnhance<V>
    implements Callable<V> {
        private final String parentTraceId;
        private final String taskName;
        private final Callable<V> callable;

        public CallableEnhance(String taskName, Callable<V> callable) {
            this.taskName = taskName;
            this.parentTraceId = TraceIdUtil.getCurrentTraceIdString();
            this.callable = callable;
        }

        @Override
        public V call() throws Exception {
            V v;
            if (StringUtils.isNotEmpty((String)this.parentTraceId)) {
                TraceIdUtil.setCurrentTraceId((String)this.parentTraceId);
                RequestContext.get().setTraceId(this.parentTraceId);
            }
            LOG.info("start GL_thread_bind, thread name:{}, name: {}, traceid: {}, OperationContext: {}", new Object[]{Thread.currentThread().getName(), this.taskName, RequestContext.getOrCreate().getTraceId(), OperationContext.get()});
            long tick = System.currentTimeMillis();
            try {
                v = this.callable.call();
            }
            catch (Exception e) {
                try {
                    LOG.error(String.format("thread name: %s, task: %s, execution error: %s", Thread.currentThread().getName(), this.taskName, e.getMessage()), (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (System.currentTimeMillis() - tick > 2000L) {
                        LOG.info("performance monitor GL_thread_bind, thread name:{}, name: {}, traceid: {}, cost time: {}", new Object[]{Thread.currentThread().getName(), this.taskName, RequestContext.getOrCreate().getTraceId(), System.currentTimeMillis() - tick});
                    }
                    throw throwable;
                }
            }
            if (System.currentTimeMillis() - tick > 2000L) {
                LOG.info("performance monitor GL_thread_bind, thread name:{}, name: {}, traceid: {}, cost time: {}", new Object[]{Thread.currentThread().getName(), this.taskName, RequestContext.getOrCreate().getTraceId(), System.currentTimeMillis() - tick});
            }
            return v;
        }
    }

    private static class RunnableEnhance
    implements Runnable {
        private final String parentTraceId;
        private final String taskName;
        private final Runnable runnable;

        public RunnableEnhance(String taskName, Runnable runnable) {
            this.taskName = taskName;
            this.parentTraceId = TraceIdUtil.getCurrentTraceIdString();
            this.runnable = runnable;
        }

        @Override
        public void run() {
            if (StringUtils.isNotEmpty((String)this.parentTraceId)) {
                TraceIdUtil.setCurrentTraceId((String)this.parentTraceId);
            }
            LOG.info("start GL_thread_bind, thread name:{}, name: {}, traceid: {}", new Object[]{Thread.currentThread().getName(), this.taskName, RequestContext.getOrCreate().getTraceId()});
            long tick = System.currentTimeMillis();
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                try {
                    LOG.error(String.format("thread name: %s, task: %s, execution error: %s", Thread.currentThread().getName(), this.taskName, e.getMessage()), (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (System.currentTimeMillis() - tick > 2000L) {
                        LOG.info("performance monitor GL_thread_bind, thread name:{}, name: {}, traceid: {}, cost time: {}", new Object[]{Thread.currentThread().getName(), this.taskName, RequestContext.getOrCreate().getTraceId(), System.currentTimeMillis() - tick});
                    }
                    throw throwable;
                }
            }
            if (System.currentTimeMillis() - tick > 2000L) {
                LOG.info("performance monitor GL_thread_bind, thread name:{}, name: {}, traceid: {}, cost time: {}", new Object[]{Thread.currentThread().getName(), this.taskName, RequestContext.getOrCreate().getTraceId(), System.currentTimeMillis() - tick});
            }
        }
    }

    private static class GLThreadPool {
        private GLThreadPool() {
        }

        private static ThreadPool createCachedExecutorService(String poolName, int coreThread, int maxThread) {
            return new ThreadPoolImpl(ThreadLifeCycleManager.wrapExecutorService((ExecutorService)GLThreadPool.genThreadPoolExecutor(poolName, coreThread, maxThread)));
        }

        private static ThreadPoolExecutor genThreadPoolExecutor(final String poolName, int coreThread, int maxThread) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(coreThread, maxThread, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
                private AtomicInteger atomicInteger = new AtomicInteger(0);

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, poolName + "-" + this.atomicInteger.incrementAndGet());
                }
            });
            executor.allowCoreThreadTimeOut(true);
            ThreadPoolExecutorHolder.put(poolName, executor);
            return executor;
        }

        static /* synthetic */ ThreadPool access$000(String x0, int x1, int x2) {
            return GLThreadPool.createCachedExecutorService(x0, x1, x2);
        }
    }
}

