/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.taxreport;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.taxreport.AbstractTaxReportDataHandler;
import kd.fi.gl.util.TaxReportFormHelper;
import kd.fi.gl.util.TaxReportParam;

public class BalanceSheetDataHandler
extends AbstractTaxReportDataHandler {
    private static final String assetEntryKey = "assetentryentity";
    private static final String equityEntryKey = "equityentryentity";

    @Override
    protected DynamicObjectCollection getParentBalSheet(TaxReportParam param) {
        return TaxReportFormHelper.getBalSheetsByEntityType(Collections.singleton(param.getParentOrg()), param.getAccTableId(), new QFilter[]{new QFilter("booktype", "=", (Object)param.getBookTypeId())}, param.getSelectField(), param.getOrderBys());
    }

    @Override
    protected DynamicObjectCollection getChildBalSheet(Long childOrg, TaxReportParam param) {
        return TaxReportFormHelper.getBalSheetsByEntityType(Collections.singleton(childOrg), param.getAccTableId(), new QFilter[]{new QFilter("booktype", "=", (Object)param.getBookTypeId())}, param.getSelectField(), param.getOrderBys());
    }

    @Override
    protected List<List<BigDecimal>> collectChildOrgBal(Long childOrg, TaxReportParam param) {
        return TaxReportFormHelper.collectBal(Collections.singletonList(childOrg), Collections.singleton(childOrg), param.getOrgViewId(), param.getBookTypeId(), param.getAccTableId(), param.getPeriodTypeId(), param.getPeriodId(), param.getType(), param.getEntityType(), param.getAmtprecision(), false);
    }

    @Override
    protected DynamicObjectCollection getSheetExps(TaxReportParam param) {
        Set<Long> orgIds = Collections.singleton(param.getParentOrg());
        return TaxReportFormHelper.getBalSheetExps(orgIds, param.getAccTableId(), param.getBookTypeId());
    }

    @Override
    protected void handleSingleOrgRowAmt(Map<Long, Tuple<String, BigDecimal[]>> itemAndAmtMap, DynamicObjectCollection childBalSheet, List<List<BigDecimal>> resultList, TaxReportParam param) {
        for (int i = 0; i < childBalSheet.size(); ++i) {
            BigDecimal[] equityAmtVals;
            Long equityMasterId;
            DynamicObject childBal = (DynamicObject)childBalSheet.get(i);
            List<BigDecimal> balVals = resultList.get(i);
            if (assetEntryKey.equals(param.getEntityType())) {
                BigDecimal[] assetAmtVals;
                Long assetMasterId = childBal.getLong("assetmasterid");
                if (!itemAndAmtMap.containsKey(assetMasterId) || (assetAmtVals = (BigDecimal[])itemAndAmtMap.get((Object)assetMasterId).item2) == null) continue;
                assetAmtVals[0] = assetAmtVals[0].add(balVals.get(0));
                assetAmtVals[1] = assetAmtVals[1].add(balVals.get(1));
                continue;
            }
            if (!equityEntryKey.equals(param.getEntityType()) || !itemAndAmtMap.containsKey(equityMasterId = Long.valueOf(childBal.getLong("equitymasterid"))) || (equityAmtVals = (BigDecimal[])itemAndAmtMap.get((Object)equityMasterId).item2) == null) continue;
            equityAmtVals[0] = equityAmtVals[0].add(balVals.get(0));
            equityAmtVals[1] = equityAmtVals[1].add(balVals.get(1));
        }
    }

    @Override
    protected Map<String, List<BigDecimal>> transToMap(Map<Long, Tuple<String, BigDecimal[]>> itemAndAmtMap, List<Long> rowAndItemMap, TaxReportParam param) {
        LinkedHashMap<String, List<BigDecimal>> resultMap = new LinkedHashMap<String, List<BigDecimal>>(itemAndAmtMap.size());
        for (Long item : rowAndItemMap) {
            ArrayList<BigDecimal> singleRow = new ArrayList<BigDecimal>(2);
            BigDecimal[] assetAmt = (BigDecimal[])itemAndAmtMap.get((Object)item).item2;
            if (assetAmt != null) {
                singleRow.add(assetAmt[0]);
                singleRow.add(assetAmt[1]);
            } else {
                singleRow.add(BigDecimal.ZERO);
                singleRow.add(BigDecimal.ZERO);
            }
            resultMap.put((String)itemAndAmtMap.get((Object)item).item1, (List<BigDecimal>)singleRow);
        }
        return resultMap;
    }
}

