/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.tools;

import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.gl.tools.AssistDuplicateRepairTool;
import kd.fi.gl.tools.DuplicateAssistIdFinder;

public class DuplicateAssistRepairService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(DuplicateAssistRepairService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            int totalReplaceCount = AssistDuplicateRepairTool.work(new DuplicateAssistIdFinder());
            AssistDuplicateRepairTool.fixUniqueIndex();
            result.setSuccess(true);
            result.setLog("repair " + totalReplaceCount + " count success. ");
        }
        catch (Exception e) {
            LOGGER.error("failed repair on " + e.getMessage(), (Throwable)e);
            result.setSuccess(false);
            String err = "repair failed, traceid:" + RequestContext.getOrCreate().getTraceId();
            result.setErrorInfo(err);
            result.setLog(err);
        }
        return result;
    }
}

