/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.util.BiTreeNode;
import kd.fi.gl.vo.OrgVO;

public class AccBalanceSumUpHelper {
    private static final Log logger = LogFactory.getLog(AccBalanceSumUpHelper.class);

    public static BiTreeNode<Long, OrgVO> computeSumUpStepViewOrgStructByAccountView(Set<Long> accountViewOrgs, long specificOrgViewId) {
        if (CollectionUtils.isEmpty(accountViewOrgs)) {
            return null;
        }
        HashMap<Long, BiTreeNode<Long, OrgVO>> orgIndex = new HashMap<Long, BiTreeNode<Long, OrgVO>>(8);
        BiTreeNode<Long, OrgVO> rootNode = null;
        int accountingViewMaxLevel = 1;
        DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"AccBalanceMergeHelper.queryView", (String)"bos_org_structure", (String)"org,org.name name,parent,level", (QFilter[])new QFilter[]{new QFilter("view.treetype", "=", (Object)"10"), new QFilter("view", "=", (Object)specificOrgViewId)}, (String)"level asc");
        Object object = null;
        try {
            for (Row row : orgDataSet) {
                Long org = row.getLong("org");
                int level = row.getInteger("level");
                if (Objects.nonNull(orgIndex.get(org))) {
                    logger.info(" duplicate org id:" + org);
                    continue;
                }
                accountingViewMaxLevel = level > accountingViewMaxLevel ? level : accountingViewMaxLevel;
                Long parentId = row.getLong("parent");
                BiTreeNode<Long, OrgVO> orgNode = new BiTreeNode<Long, OrgVO>(org, new OrgVO(row.getString("name")));
                orgNode.setPropValue("level", level);
                if (Objects.nonNull(parentId) && orgIndex.containsKey(parentId)) {
                    BiTreeNode parentNode = (BiTreeNode)orgIndex.get(parentId);
                    Assert.notNull((Object)parentNode);
                    orgNode.setParent(parentNode);
                } else if (Objects.isNull(rootNode)) {
                    rootNode = orgNode;
                }
                orgIndex.put(org, orgNode);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (orgDataSet != null) {
                if (object != null) {
                    try {
                        orgDataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    orgDataSet.close();
                }
            }
        }
        if (accountViewOrgs.size() == 1) {
            BiTreeNode selectNode = (BiTreeNode)orgIndex.get(accountViewOrgs.iterator().next());
            selectNode.setParent(null);
            selectNode.preTravel(x -> {});
            return selectNode;
        }
        ArrayList pathList = new ArrayList(accountViewOrgs.size());
        for (BiTreeNode selectNode : accountViewOrgs.stream().map(x -> (BiTreeNode)orgIndex.get(x)).collect(Collectors.toSet())) {
            ArrayList nodePath = new ArrayList(8);
            nodePath.add(selectNode.getId());
            selectNode.setPropValue("isretain", true);
            BiTreeNode pNode = selectNode;
            while (Objects.nonNull(pNode.getParent())) {
                pNode = pNode.getParent();
                nodePath.add(pNode.getId());
                pNode.setPropValue("isretain", true);
            }
            pathList.add(nodePath);
        }
        List firstPath = (List)pathList.get(0);
        for (int i = 1; i < pathList.size(); ++i) {
            firstPath.retainAll((Collection)pathList.get(i));
        }
        if (CollectionUtils.isNotEmpty((Collection)firstPath)) {
            rootNode = (BiTreeNode<Long, OrgVO>)orgIndex.get(firstPath.get(0));
        }
        for (BiTreeNode selectNode : accountViewOrgs.stream().map(x -> (BiTreeNode)orgIndex.get(x)).collect(Collectors.toSet())) {
            selectNode.preTravel(c -> c.setPropValue("isretain", true));
        }
        if (Objects.isNull(rootNode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u6811\u5f62\u903b\u8f91\u6709\u8bef\uff0c\u7f3a\u5c11\u6839\u8282\u70b9\u3002", (String)"AccBalanceSumUpHelper_0", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        rootNode.preTravel(node -> {
            if (Objects.isNull(node.getPropValue("isretain"))) {
                node.setParent(null);
            }
        });
        rootNode.setParent(null);
        return rootNode;
    }
}

