/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.consts.AccountType;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.enums.AccountingType;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;

public class AccountUtils {
    private static final QFilter LEAF_FILTER = new QFilter("isleaf", "=", (Object)Character.valueOf('1'));

    private AccountUtils() {
    }

    @Deprecated
    public static QFBuilder getAccountFilter(long orgId, long accountTableId, Date date, boolean isOnlyLeaf, QFilter customFilter) {
        QFBuilder qfBuilder = AccountUtils.getAccountFilter(orgId, accountTableId, isOnlyLeaf, customFilter);
        if (Objects.isNull(date)) {
            qfBuilder.add("enddate", "=", GLUtil.getEndDate());
        } else {
            qfBuilder.add("startdate", "<=", date);
            qfBuilder.add("enddate", ">", date);
        }
        return qfBuilder;
    }

    @Deprecated
    public static QFBuilder getAccountFilter(long orgId, long accountTableId, long periodId, boolean isOnlyLeaf, QFilter customFilter) {
        DynamicObject periodDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter("id", "=", (Object)periodId).toArray());
        if (null == periodDO) {
            return AccountUtils.getAccountFilter(orgId, accountTableId, null, isOnlyLeaf, customFilter);
        }
        return AccountUtils.getAccountFilter(orgId, accountTableId, periodDO.getDate("enddate"), isOnlyLeaf, customFilter);
    }

    @Deprecated
    public static QFBuilder getAccountFilerOnBookAndPeriod(AccountBookInfo book, long periodID, QFilter customFilter, boolean onlyLeaf) {
        long orgID = book.getOrgId();
        long bookTypeID = book.getBookTypeId();
        long acctTableID = AccSysUtil.getCurPeriodAccountTableId(orgID, bookTypeID, periodID);
        return AccountUtils.getAccountFilter(orgID, acctTableID, periodID, onlyLeaf, customFilter);
    }

    public static long getAccountOnBookAndPeriod(AccountBookInfo book, long periodId, String accNum, boolean onlyLeaf) {
        QFBuilder accountFilterOnBookAndPeriod = AccountUtils.getAccountFilerOnBookAndPeriod(book, periodId, new QFilter("number", "=", (Object)accNum), onlyLeaf);
        List accId = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])accountFilterOnBookAndPeriod.toArray(), (String)"id", (int)1);
        return accId.size() != 0 ? Long.parseLong(accId.get(0).toString()) : 0L;
    }

    public static QFBuilder getAccountFilter(long orgId, long accountTableId, Date startDate, Date endDate, boolean isOnlyLeaf, QFilter customFilter) {
        QFBuilder qfBuilder = AccountUtils.getAccountFilter(orgId, accountTableId, isOnlyLeaf, customFilter);
        if (Objects.isNull(startDate)) {
            qfBuilder.add("enddate", ">=", GLUtil.getInitBeginDate());
        } else {
            qfBuilder.add("enddate", ">=", startDate);
        }
        if (Objects.isNull(endDate)) {
            qfBuilder.add("startdate", "<=", GLUtil.getEndDate());
        } else {
            qfBuilder.add("startdate", "<=", endDate);
        }
        return qfBuilder;
    }

    private static QFBuilder getAccountFilter(long orgId, long accountTableId, boolean isOnlyLeaf, QFilter customFilter) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("accounttable", "=", accountTableId);
        qfBuilder.add("enable", "=", "1");
        if (!Objects.isNull(customFilter)) {
            qfBuilder.add(customFilter);
        }
        if (isOnlyLeaf) {
            qfBuilder.add(LEAF_FILTER);
        }
        qfBuilder.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId));
        return qfBuilder;
    }

    public static List<DynamicObject> getAccountDOs(long orgId, long accountTableId, Date date, boolean isOnlyLeaf, QFilter customFilter, String ... fields) {
        QFBuilder qfBuilder = AccountUtils.getAccountFilter(orgId, accountTableId, date, isOnlyLeaf, customFilter);
        if (Objects.isNull(fields) || fields.length == 0) {
            return new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (QFilter[])qfBuilder.toArray()).values());
        }
        DynamicObject[] accountDOs = BusinessDataServiceHelper.load((String)"bd_accountview", (String)String.join((CharSequence)",", fields), (QFilter[])qfBuilder.toArray());
        return Stream.of(accountDOs).collect(Collectors.toList());
    }

    public static DataSet getAccountDataSet(long orgId, long accountTableId, Date date, boolean isOnlyLeaf, QFilter customFilter, String ... fields) {
        QFBuilder qfBuilder = AccountUtils.getAccountFilter(orgId, accountTableId, date, isOnlyLeaf, customFilter);
        if (Objects.isNull(fields) || fields.length == 0) {
            fields = new String[]{"id"};
        }
        return QueryServiceHelper.queryDataSet((String)AccountUtils.class.getName(), (String)"bd_accountview", (String)String.join((CharSequence)",", fields), (QFilter[])qfBuilder.toArray(), (String)"id");
    }

    public static DataSet getAccountDataSet(List<Long> orgIds, long accountTableId, Date date, boolean isOnlyLeaf, QFilter customFilter, String ... fields) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("accounttable", "=", accountTableId);
        if (!Objects.isNull(customFilter)) {
            qfBuilder.add(customFilter);
        }
        if (isOnlyLeaf) {
            qfBuilder.add(LEAF_FILTER);
        }
        qfBuilder.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", orgIds, (boolean)false));
        if (Objects.isNull(date)) {
            qfBuilder.add("enddate", "=", GLUtil.getEndDate());
        } else {
            qfBuilder.add("startdate", "<=", date);
            qfBuilder.add("enddate", ">", date);
        }
        if (Objects.isNull(fields) || fields.length == 0) {
            fields = new String[]{"id"};
        }
        return QueryServiceHelper.queryDataSet((String)AccountUtils.class.getName(), (String)"bd_accountview", (String)String.join((CharSequence)",", fields), (QFilter[])qfBuilder.toArray(), (String)"id");
    }

    @Deprecated
    public static Set<Long> getAccountIdSet(long orgId, long accountTableId, long periodId, boolean isOnlyLeaf, QFilter customFilter) {
        QFBuilder qfBuilder = AccountUtils.getAccountFilter(orgId, accountTableId, periodId, isOnlyLeaf, customFilter);
        List pkValueList = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])qfBuilder.toArray(), null, (int)-1);
        return pkValueList.stream().map(x -> Long.parseLong(x.toString())).collect(Collectors.toSet());
    }

    public static DataSet getAccountDataSet(long orgId, long accountTableId, Date startDate, Date endDate, boolean isOnlyLeaf, QFilter customFilter, String ... fields) {
        QFBuilder qfBuilder = AccountUtils.getAccountFilter(orgId, accountTableId, startDate, endDate, isOnlyLeaf, customFilter);
        if (Objects.isNull(fields) || fields.length == 0) {
            fields = new String[]{"id"};
        }
        return QueryServiceHelper.queryDataSet((String)AccountUtils.class.getName(), (String)"bd_accountview", (String)String.join((CharSequence)",", fields), (QFilter[])qfBuilder.toArray(), (String)"id");
    }

    @Deprecated
    public static QFilter getBaseAcctFilter(Long endPeriod, Long pOrg, Long accountableId, Set<Long> masterIdSet, List<Long> accountList) {
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"enddate", (QFilter[])new QFilter("id", "=", (Object)endPeriod).toArray());
        QFilter atFilter = new QFilter("startdate", "<=", (Object)period.getDate("enddate"));
        atFilter.and(new QFilter("enddate", ">=", (Object)period.getDate("enddate")));
        atFilter.and(new QFilter("accounttable", "=", (Object)accountableId));
        atFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)pOrg));
        if (null != masterIdSet) {
            atFilter.and(new QFilter("id", "in", accountList));
        }
        return atFilter;
    }

    @Deprecated
    public static DataSet getAllLeafAcct(Set<String> numbers, Long endPeriod, Long pOrg, Long accountableId) {
        HashSet<Long> ids = new HashSet<Long>(100);
        QFilter atFilter = AccountUtils.getBaseAcctFilter(endPeriod, pOrg, accountableId, null, null);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(AccountUtils.class.getName() + "#getAcctLongNumber"), (String)"bd_accountview", (String)"id,longnumber", (QFilter[])atFilter.toArray(), null);){
            for (Row row : dataSet) {
                String[] split;
                String longnumber = row.getString("longnumber");
                for (String s : split = longnumber.split("_")) {
                    if (!numbers.contains(s)) continue;
                    ids.add(row.getLong("id"));
                }
            }
            QFilter filter = new QFilter("id", "in", ids);
            DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)(AccountUtils.class.getName() + "#getAllLeafAcct"), (String)"bd_accountview", (String)"id,masterid,parent.id parent,parent.number pnum,number,level,isleaf,dc,isassist,isqty", (QFilter[])filter.toArray(), null);
            return dataSet2;
        }
    }

    public static HashSet<Long> getAccMasterIdSet(QueryParamRpt qpRpt) {
        HashSet<Long> accMasterIdSet;
        block40: {
            accMasterIdSet = new HashSet<Long>(8);
            QFilter atFilter = kd.fi.bd.util.AccountUtils.getBaseAcctFilter((Long)qpRpt.getEndPeriod(), (Long)qpRpt.getPorg(), (Long)qpRpt.getAccountTable(), qpRpt.getMasterIdSet(), qpRpt.getAccountList());
            if (qpRpt.getMasterIdSet() != null) {
                try (DataSet accDS = QueryServiceHelper.queryDataSet((String)(AccountUtils.class.getName() + "#getAccount"), (String)"bd_accountview", (String)"number", (QFilter[])atFilter.toArray(), null);){
                    HashSet<String> selAcctSet = new HashSet<String>(10);
                    for (Row row : accDS) {
                        selAcctSet.add(row.getString("number"));
                    }
                    try (DataSet childrenDS = kd.fi.bd.util.AccountUtils.getAllLeafAcct(selAcctSet, (Long)qpRpt.getEndPeriod(), (Long)qpRpt.getPorg(), (Long)qpRpt.getAccountTable());){
                        for (Row row : childrenDS) {
                            accMasterIdSet.add(row.getLong("masterid"));
                        }
                        break block40;
                    }
                }
            }
            try (DataSet accDS = QueryServiceHelper.queryDataSet((String)(AccountUtils.class.getName() + "#getAccount"), (String)"bd_accountview", (String)"masterid", (QFilter[])atFilter.toArray(), null);){
                for (Row row : accDS) {
                    accMasterIdSet.add(row.getLong("masterid"));
                }
            }
        }
        return accMasterIdSet;
    }

    public static QFilter getAccTypeFilter(long curAccTableId, boolean isFinancial) {
        return new QFilter("accounttype", "in", AccountUtils.getAccTypeId(curAccTableId, isFinancial));
    }

    public static Set<Long> getAccTypeId(long curAccTableId, boolean isFinancial) {
        HashSet<Long> ids = new HashSet<Long>(8);
        String[] accType = isFinancial ? AccountType.FINANCIAL_ACCOUNT : AccountType.BUDGET_ACCOUNT;
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("accounttype", "in", (Object)accType));
        qfBuilder.add(new QFilter("accounttableid", "=", (Object)curAccTableId));
        try (DataSet accountType = QueryServiceHelper.queryDataSet((String)(AccountUtils.class.getName() + "#getAccTypeId"), (String)"bd_accounttype", (String)"id", (QFilter[])qfBuilder.toArray(), null);){
            for (Row row : accountType) {
                ids.add(row.getLong("id"));
            }
        }
        return ids;
    }

    public static Set<Long> getAccountIdSet(long orgId, long accountTableId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("accounttable", "=", accountTableId);
        qfBuilder.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId));
        List pkValueList = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])qfBuilder.toArray(), null, (int)-1);
        return pkValueList.stream().map(x -> Long.parseLong(x.toString())).collect(Collectors.toSet());
    }

    public static String parseAccountingType(DynamicObject accountDyn) {
        if (accountDyn == null) {
            return "";
        }
        return AccountType.isBudgetType((long)accountDyn.getLong("accounttype_id")) ? AccountingType.BUDGET.getValue() : AccountingType.FINANCIAL.getValue();
    }

    public static Map<String, Set<String>> getLeafAcctNumByNum(long orgId, long accountTableId, Collection<String> accountNumSet, Collection<QFilter> customFilters) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(8);
        filterList.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId));
        filterList.add(new QFilter("accounttable", "=", (Object)accountTableId));
        filterList.add(new QFilter("isleaf", "=", (Object)"1"));
        if (CollectionUtils.isNotEmpty(customFilters)) {
            filterList.addAll(customFilters);
        }
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>(8);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)AccountUtils.class.getName(), (String)"bd_accountview", (String)"number, longnumber", (QFilter[])filterList.toArray(new QFilter[0]), null);){
            for (Row row : dataSet) {
                Set leafAcctNumberSet;
                String[] accountNums = row.getString("longnumber").split("_");
                String leafAccountNum = row.getString("number");
                if (CollectionUtils.isNotEmpty(accountNumSet)) {
                    for (String accountNum : accountNums) {
                        if (!accountNumSet.contains(accountNum)) continue;
                        leafAcctNumberSet = resultMap.computeIfAbsent(accountNum, k -> new HashSet(8));
                        leafAcctNumberSet.add(leafAccountNum);
                    }
                    continue;
                }
                for (String accountNum : accountNums) {
                    leafAcctNumberSet = resultMap.computeIfAbsent(accountNum, k -> new HashSet(8));
                    leafAcctNumberSet.add(leafAccountNum);
                }
            }
        }
        return resultMap;
    }

    public static Map<Long, Set<Long>> getLeafAcctIdById(long orgId, long accountTableId, Collection<Long> accountIdSet, Collection<QFilter> customFilters) {
        HashMap<String, Set> accountNumToIdMap = new HashMap<String, Set>(8);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)AccountUtils.class.getName(), (String)"bd_accountview", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("id", "in", accountIdSet)}, null);){
            for (Row row : dataSet) {
                Set curAccountIdSet = accountNumToIdMap.computeIfAbsent(row.getString("number"), k -> new HashSet(8));
                curAccountIdSet.add(row.getLong("id"));
            }
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(8);
        filterList.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId));
        filterList.add(new QFilter("accounttable", "=", (Object)accountTableId));
        filterList.add(new QFilter("isleaf", "=", (Object)"1"));
        if (CollectionUtils.isNotEmpty(customFilters)) {
            filterList.addAll(customFilters);
        }
        HashMap<Long, Set<Long>> resultMap = new HashMap<Long, Set<Long>>(8);
        Set accountNumSet = accountNumToIdMap.keySet();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)AccountUtils.class.getName(), (String)"bd_accountview", (String)"id, longnumber", (QFilter[])filterList.toArray(new QFilter[0]), null);){
            for (Row row : dataSet) {
                String[] accountNums = row.getString("longnumber").split("_");
                Long leafAccountId = row.getLong("id");
                for (String accountNum : accountNums) {
                    if (!accountNumSet.contains(accountNum)) continue;
                    Set acctIdSet = (Set)accountNumToIdMap.get(accountNum);
                    acctIdSet.forEach(id -> {
                        Set leafAcctNumberSet = resultMap.computeIfAbsent((Long)id, k -> new HashSet(8));
                        leafAcctNumberSet.add(leafAccountId);
                    });
                }
            }
        }
        return resultMap;
    }

    public static DataSet getAccountDataSet(long accountTableId, Date date, boolean isOnlyLeaf, QFilter customFilter, String ... fields) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("accounttable", "=", accountTableId);
        qfBuilder.add("enable", "=", "1");
        if (!Objects.isNull(customFilter)) {
            qfBuilder.add(customFilter);
        }
        if (isOnlyLeaf) {
            qfBuilder.add(LEAF_FILTER);
        }
        if (Objects.isNull(date)) {
            qfBuilder.add("enddate", "=", GLUtil.getEndDate());
        } else {
            qfBuilder.add("startdate", "<=", date);
            qfBuilder.add("enddate", ">", date);
        }
        if (Objects.isNull(fields) || fields.length == 0) {
            fields = new String[]{"id"};
        }
        return QueryServiceHelper.queryDataSet((String)AccountUtils.class.getName(), (String)"bd_accountview", (String)String.join((CharSequence)",", fields), (QFilter[])qfBuilder.toArray(), (String)"id");
    }
}

