/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import com.google.common.base.Equivalence;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Triple;

public class AmountDimensionalMap<K> {
    private final Map<K, BigDecimal> map = new LinkedHashMap<K, BigDecimal>(8);
    private BigDecimal sum = BigDecimal.ZERO;

    @SafeVarargs
    public final void accumulate(BigDecimal amount, K ... dimension) {
        for (K d : dimension) {
            this.map.compute(d, (k, v) -> v == null ? amount : v.add(amount));
        }
        this.sum = this.sum.add(amount);
    }

    public BigDecimal getSum() {
        return this.sum;
    }

    public BigDecimal getSum(int scale) {
        return this.sum.setScale(scale, RoundingMode.HALF_UP);
    }

    public Optional<Triple<K, BigDecimal, BigDecimal>> differenceWith(AmountDimensionalMap<K> rightMap) {
        MapDifference mapDifference = Maps.difference(this.map, rightMap.map, (Equivalence)new BigDecimalEquivalence());
        if (mapDifference.areEqual()) {
            return Optional.empty();
        }
        Iterator iteratorBuf = mapDifference.entriesOnlyOnLeft().entrySet().iterator();
        if (iteratorBuf.hasNext()) {
            Map.Entry next = iteratorBuf.next();
            return Optional.of(Triple.of(next.getKey(), next.getValue(), (Object)BigDecimal.ZERO));
        }
        iteratorBuf = mapDifference.entriesOnlyOnRight().entrySet().iterator();
        if (iteratorBuf.hasNext()) {
            Map.Entry next = iteratorBuf.next();
            return Optional.of(Triple.of(next.getKey(), (Object)BigDecimal.ZERO, next.getValue()));
        }
        Map.Entry next = mapDifference.entriesDiffering().entrySet().iterator().next();
        return Optional.of(Triple.of(next.getKey(), (Object)((MapDifference.ValueDifference)next.getValue()).leftValue(), (Object)((MapDifference.ValueDifference)next.getValue()).rightValue()));
    }

    public Optional<Triple<K, BigDecimal, BigDecimal>> differenceWith(AmountDimensionalMap<K> rightMap, int scale) {
        MapDifference mapDifference = Maps.difference(this.map, rightMap.map, (Equivalence)new BigDecimalEquivalence());
        if (mapDifference.areEqual()) {
            return Optional.empty();
        }
        Iterator iteratorBuf = mapDifference.entriesOnlyOnLeft().entrySet().iterator();
        if (iteratorBuf.hasNext()) {
            Map.Entry next = iteratorBuf.next();
            return Optional.of(Triple.of(next.getKey(), (Object)((BigDecimal)next.getValue()).setScale(scale, RoundingMode.HALF_UP), (Object)BigDecimal.ZERO));
        }
        iteratorBuf = mapDifference.entriesOnlyOnRight().entrySet().iterator();
        if (iteratorBuf.hasNext()) {
            Map.Entry next = iteratorBuf.next();
            return Optional.of(Triple.of(next.getKey(), (Object)BigDecimal.ZERO, (Object)((BigDecimal)next.getValue()).setScale(scale, RoundingMode.HALF_UP)));
        }
        Map.Entry next = mapDifference.entriesDiffering().entrySet().iterator().next();
        return Optional.of(Triple.of(next.getKey(), (Object)((BigDecimal)((MapDifference.ValueDifference)next.getValue()).leftValue()).setScale(scale, RoundingMode.HALF_UP), (Object)((BigDecimal)((MapDifference.ValueDifference)next.getValue()).rightValue()).setScale(scale, RoundingMode.HALF_UP)));
    }

    private static class BigDecimalEquivalence
    extends Equivalence<BigDecimal> {
        private BigDecimalEquivalence() {
        }

        protected boolean doEquivalent(BigDecimal b1, BigDecimal b2) {
            return b1.compareTo(b2) == 0;
        }

        protected int doHash(BigDecimal bigDecimal) {
            return bigDecimal.hashCode();
        }
    }
}

