/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.enums.TaxReportFetchrule;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.TaxReportFormHelper;

public class AnalysisRptUtils {
    private static final String BALANCESHEET = "balancesheet";
    private static final String INCOME = "income";
    private static final String ISTOTALROW = "istotalrow";
    private static final String BALROWID = "balrowid";
    private static final String COLUMNKEY = "columnkey";
    private static final String TYPE = "type";
    private static final String ORGVIEW = "orgview";
    private static final String BOOKTYPE = "booktype";
    private static final String ACCTABLE = "accounttable";
    private static final String PERIOD = "period";

    public static void showAccountBalanceRpt(AbstractFormPlugin form, DynamicObject item, int rowIndex, int colIndex, String type) {
        if (item != null && item.getBoolean(ISTOTALROW)) {
            form.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u5355\u5143\u683c\u4e3a\u5408\u8ba1\u884c\uff0c\u4e0d\u5141\u8bb8\u8054\u67e5\u3002", (String)"AnalysisRptUtils_0", (String)"fi-gl-common", (Object[])new Object[0]));
            return;
        }
        IDataModel model = form.getView().getModel();
        String childOrgSetStr = form.getPageCache().get("childOrgSet");
        if (childOrgSetStr == null) {
            return;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        Long accTableId = (Long)model.getValue("accounttable_id");
        Long bookTypeId = (Long)model.getValue(GLField.id_(BOOKTYPE));
        Tuple2<Set<String>, Set<Long>> accountIds = null;
        DynamicObjectCollection dyOrgs = (DynamicObjectCollection)model.getValue("orgs");
        for (DynamicObject dyn : dyOrgs) {
            DynamicObject base = dyn.getDynamicObject("fbasedataid");
            if (base == null) continue;
            orgIds.add(base.getLong("id"));
        }
        accountIds = orgIds.size() == 1 ? AnalysisRptUtils.queryExpAccountIds((Long)orgIds.get(0), accTableId, bookTypeId, rowIndex, colIndex, type) : AnalysisRptUtils.queryMultOrgExpAccountIds(orgIds, accTableId, bookTypeId, item, rowIndex, colIndex, type);
        if (accountIds == null || ((Set)accountIds.t2).size() <= 0) {
            form.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5355\u5143\u683c\u5bf9\u5e94\u516c\u5f0f\uff0c\u8bf7\u68c0\u67e5\u62a5\u8868\u7f16\u8f91\u3002", (String)"AnalysisRptUtils_1", (String)"fi-gl-common", (Object[])new Object[0]));
            return;
        }
        ReportQueryParam queryParam = AnalysisRptUtils.getRptParam(form, orgIds, accountIds);
        if (queryParam == null) {
            return;
        }
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId("gl_rpt_accountbalance");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setQueryParam(queryParam);
        form.getView().showForm((FormShowParameter)parameter);
    }

    private static Tuple2<Set<String>, Set<Long>> queryExpAccountIds(Long orgId, Long accTableId, Long bookTypeId, int rowIndex, int colIndex, String type) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)orgId));
        filters.add(new QFilter(ACCTABLE, "=", (Object)accTableId));
        filters.add(new QFilter(BOOKTYPE, "=", (Object)bookTypeId));
        filters.add(new QFilter(BALROWID, "=", (Object)String.valueOf(rowIndex)));
        filters.add(new QFilter(COLUMNKEY, "=", (Object)String.valueOf(colIndex)));
        filters.add(new QFilter(ISTOTALROW, "=", (Object)"0"));
        if (!BALANCESHEET.equals(type)) {
            filters.add(new QFilter(TYPE, "=", (Object)type));
        }
        return AnalysisRptUtils.queryRuleAndAcctMap(type, filters);
    }

    private static Tuple2<Set<String>, Set<Long>> queryMultOrgExpAccountIds(List<Long> orgIds, Long accTableId, Long bookTypeId, DynamicObject item, int rowIndex, int colIndex, String type) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter(ACCTABLE, "=", (Object)accTableId));
        if (item != null && BALANCESHEET.equals(type)) {
            Long masterId = item.getLong("masterid");
            QFilter[] itemFilters = new QFilter[]{new QFilter(BOOKTYPE, "=", (Object)bookTypeId), new QFilter("equityentryentity.equity.masterid", "=", (Object)masterId).or(new QFilter("assetentryentity.asset.masterid", "=", (Object)masterId))};
            DynamicObjectCollection sheetCollection = TaxReportFormHelper.getBalSheet(new HashSet<Long>(orgIds), accTableId, itemFilters);
            AnalysisRptUtils.addMulOrgFilter(colIndex, filters, sheetCollection);
        } else if (item != null && INCOME.equals(type)) {
            Long masterId = item.getLong("masterid");
            QFilter[] itemFilters = new QFilter[]{new QFilter(BOOKTYPE, "=", (Object)bookTypeId), new QFilter("entryentity.project.masterid", "=", (Object)masterId)};
            DynamicObjectCollection sheetCollection = TaxReportFormHelper.getIncomeEdit(new HashSet<Long>(orgIds), accTableId, type, itemFilters);
            AnalysisRptUtils.addMulOrgFilter(colIndex, filters, sheetCollection);
        } else {
            filters.add(new QFilter("org", "in", orgIds));
        }
        filters.add(new QFilter(BALROWID, "=", (Object)String.valueOf(rowIndex)));
        filters.add(new QFilter(COLUMNKEY, "=", (Object)String.valueOf(colIndex)));
        filters.add(new QFilter(ISTOTALROW, "=", (Object)"0"));
        if (!BALANCESHEET.equals(type)) {
            filters.add(new QFilter(TYPE, "=", (Object)type));
        }
        return AnalysisRptUtils.queryRuleAndAcctMap(type, filters);
    }

    private static void addMulOrgFilter(int colIndex, List<QFilter> filters, DynamicObjectCollection sheetCollection) {
        HashMap<String, Set> idxAndOrgsMap = new HashMap<String, Set>(sheetCollection.size());
        for (DynamicObject sheet : sheetCollection) {
            String balRowId = sheet.getString("seq");
            Set orgs = idxAndOrgsMap.computeIfAbsent(balRowId, p -> new HashSet(32));
            orgs.add(sheet.getLong("orgid"));
        }
        QFilter idxFilter = null;
        for (Map.Entry entry : idxAndOrgsMap.entrySet()) {
            QFilter filter = new QFilter("org", "in", entry.getValue()).and(new QFilter(BALROWID, "=", entry.getKey())).and(new QFilter(COLUMNKEY, "=", (Object)String.valueOf(colIndex)));
            idxFilter = idxFilter == null ? filter : idxFilter.or(filter);
        }
        filters.add(idxFilter);
    }

    private static Tuple2<Set<String>, Set<Long>> queryRuleAndAcctMap(String type, List<QFilter> filters) {
        String entityName = BALANCESHEET.equals(type) ? "gl_balancesheetexpression" : "gl_incomeexpression";
        HashSet<Long> accountIds = new HashSet<Long>();
        HashSet<String> fetchrules = new HashSet<String>();
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)"AnalysisRptUtils.queryExpAccountIds", (String)entityName, (String)"entryentity.project.id accountid, entryentity.fetchrule fetchrule", (QFilter[])filters.toArray(new QFilter[0]), null);){
            for (Row row : dSet) {
                accountIds.add(row.getLong("accountid"));
                fetchrules.add(row.getString("fetchrule"));
            }
        }
        return new Tuple2(fetchrules, accountIds);
    }

    private static ReportQueryParam getRptParam(AbstractFormPlugin form, List<Long> orgIds, Tuple2<Set<String>, Set<Long>> accountIds) {
        long previousYearSamePeriod;
        IDataModel model = form.getView().getModel();
        FilterInfo filter = new FilterInfo();
        filter.addFilterItem("orgs", orgIds);
        filter.addFilterItem(BOOKTYPE, model.getValue("booktype_id"));
        filter.addFilterItem(ORGVIEW, model.getValue("orgview_id"));
        long curPeriod = (Long)model.getValue("period_id");
        Long endPeriod = curPeriod;
        Long startPeriod = curPeriod;
        Set fetchrules = (Set)accountIds.t1;
        boolean isLastYearMinPeriod = false;
        boolean isLastYearSamePeriod = false;
        boolean isCurPeriod = false;
        boolean isSubstractPL = false;
        for (String fetchrule : fetchrules) {
            TaxReportFetchrule value = TaxReportFetchrule.getValue(fetchrule);
            if (value == null) continue;
            if (value.isLastYearPL()) {
                isLastYearMinPeriod = true;
            } else if (value.isLastSamePeriodPL()) {
                isLastYearSamePeriod = true;
            } else {
                isCurPeriod = true;
            }
            if (!value.isLastYearPL() && !value.isLastSamePeriodPL() && !value.isCurPL()) continue;
            isSubstractPL = true;
        }
        if (isLastYearMinPeriod) {
            DynamicObject previousYearLastPeriod;
            DynamicObject previousYearMinPeriod = GLUtil.getPreviousYearMinPeriod(curPeriod);
            if (previousYearMinPeriod != null) {
                startPeriod = previousYearMinPeriod.getLong("id");
            }
            if (!isCurPeriod && (previousYearLastPeriod = GLUtil.getPreviousYearLastPeriod(curPeriod)) != null) {
                endPeriod = previousYearLastPeriod.getLong("id");
            }
        } else if (isLastYearSamePeriod && (previousYearSamePeriod = GLUtil.getPreviousYearSamePeriod(curPeriod)) > 0L) {
            startPeriod = previousYearSamePeriod;
            if (!isCurPeriod) {
                endPeriod = previousYearSamePeriod;
            }
        }
        filter.addFilterItem("startperiod", (Object)startPeriod);
        filter.addFilterItem("endperiod", (Object)endPeriod);
        filter.addFilterItem("periodtype", model.getValue("periodtype_id"));
        filter.addFilterItem(ACCTABLE, model.getValue("accounttable_id"));
        DynamicObjectCollection dyLevel = QueryServiceHelper.query((String)"bd_accountview", (String)"max(level) level", (QFilter[])new QFilter[]{new QFilter("id", "in", accountIds.t2)});
        if (dyLevel != null && !dyLevel.isEmpty()) {
            int level = ((DynamicObject)dyLevel.get(0)).getInt("level");
            filter.addFilterItem("accountlevel", level > 0 ? Integer.valueOf(level) : "1");
        } else {
            filter.addFilterItem("accountlevel", (Object)"1");
        }
        filter.addFilterItem("account", accountIds.t2);
        filter.addFilterItem("currency", (Object)"allcurrency");
        filter.addFilterItem("issubstractpl", (Object)isSubstractPL);
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filter);
        return queryParam;
    }

    public static List<String> buildReportHeadInfo(AbstractFormPlugin formPlugin) {
        DynamicObject dyPeriod;
        IFormView view = formPlugin.getView();
        IDataModel model = view.getModel();
        ArrayList<String> headInfos = new ArrayList<String>();
        headInfos.add(view.getFormShowParameter().getFormName());
        DynamicObjectCollection dyOrgs = (DynamicObjectCollection)model.getValue("orgs");
        if (dyOrgs != null) {
            StringBuilder orgBuilder = new StringBuilder(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff1a", (String)"AnalysisRptUtils_2", (String)"fi-gl-common", (Object[])new Object[0]));
            ArrayList<Long> orgIds = new ArrayList<Long>(dyOrgs.size());
            for (int i = 0; i < dyOrgs.size(); ++i) {
                DynamicObject dyOrg = ((DynamicObject)dyOrgs.get(i)).getDynamicObject("fbasedataid");
                orgBuilder.append(dyOrg.getString("name"));
                orgIds.add(dyOrg.getLong("id"));
                if (i >= dyOrgs.size() - 1) continue;
                orgBuilder.append(",");
            }
            headInfos.add(orgBuilder.toString());
            if (orgIds.size() == 1) {
                AnalysisRptUtils.setOrgValue(view, model, headInfos, orgIds);
            } else {
                AnalysisRptUtils.setMulOrgValue(view, model, headInfos, orgIds);
            }
        }
        if ((dyPeriod = (DynamicObject)model.getValue(PERIOD)) != null) {
            headInfos.add(String.format(ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4\uff1a%s", (String)"AnalysisRptUtils_3", (String)"fi-gl-common", (Object[])new Object[0]), dyPeriod.getString("name")));
        }
        return headInfos;
    }

    private static void setOrgValue(IFormView view, IDataModel model, List<String> headInfos, List<Long> orgIds) {
        DynamicObject dyPeriodType;
        DynamicObject dyAccountTable;
        DynamicObject dyBookType;
        DynamicObject dyOrgView;
        Long orgId = orgIds.get(0);
        Set<Long> orgViewSet = AccSysUtil.getViewByOrg(orgId);
        if (orgViewSet.size() > 1 && (dyOrgView = (DynamicObject)model.getValue(ORGVIEW)) != null) {
            headInfos.add(String.format(ResManager.loadKDString((String)"\u7edf\u8ba1\u89c6\u56fe\uff1a%s", (String)"AnalysisRptUtils_4", (String)"fi-gl-common", (Object[])new Object[0]), dyOrgView.getString("name")));
        }
        Long orgViewId = (Long)model.getValue("orgview_id");
        HashSet<Long> orgParent = new HashSet<Long>();
        orgParent.add(orgId);
        Set<Long> childOrgIds = AccSysUtil.getChildOrgId("10", orgViewId, orgParent, true);
        Set<Long> bookTypes = AnalysisRptUtils.getBookTypes(orgId, orgViewId, view.getEntityId(), childOrgIds);
        if (bookTypes != null && bookTypes.size() > 1 && (dyBookType = (DynamicObject)model.getValue(BOOKTYPE)) != null) {
            headInfos.add(String.format(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\uff1a%s", (String)"AnalysisRptUtils_5", (String)"fi-gl-common", (Object[])new Object[0]), dyBookType.getString("name")));
        }
        Long bookTypeId = (Long)model.getValue("booktype_id");
        List<AccountBookInfo> bookInfoList = AccSysUtil.getBookFromAccSys(childOrgIds, (long)bookTypeId);
        HashSet<Long> accTables = new HashSet<Long>(bookInfoList.size());
        HashSet<Long> periodTypes = new HashSet<Long>(bookInfoList.size());
        for (AccountBookInfo bookInfo : bookInfoList) {
            accTables.add(bookInfo.getAccountTableId());
            periodTypes.add(bookInfo.getPeriodTypeId());
        }
        if (accTables.size() > 1 && (dyAccountTable = (DynamicObject)model.getValue(ACCTABLE)) != null) {
            headInfos.add(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u8868\uff1a%s", (String)"AnalysisRptUtils_6", (String)"fi-gl-common", (Object[])new Object[0]), dyAccountTable.getString("name")));
        }
        if (periodTypes.size() > 1 && (dyPeriodType = (DynamicObject)model.getValue("periodtype")) != null) {
            headInfos.add(String.format(ResManager.loadKDString((String)"\u671f\u95f4\u7c7b\u578b\uff1a%s", (String)"AnalysisRptUtils_7", (String)"fi-gl-common", (Object[])new Object[0]), dyPeriodType.getString("name")));
        }
    }

    private static void setMulOrgValue(IFormView view, IDataModel model, List<String> headInfos, List<Long> orgIds) {
        DynamicObject dyPeriodType;
        DynamicObject dyAccountTable;
        DynamicObject dyBookType;
        QFilter orgFiler = new QFilter("org", "in", orgIds);
        List<Long> ids = AccSysUtil.getBookTypeDataPermission(orgIds);
        if (ids != null) {
            orgFiler = orgFiler.and(new QFilter("bookstype", "in", ids));
        }
        QFilter entityFilter = new QFilter("isbizunit", "=", (Object)true);
        DynamicObjectCollection btCol = QueryServiceHelper.query((String)"gl_accountbook", (String)"org,bookstype id, bookstype.accounttype type", (QFilter[])new QFilter[]{orgFiler, entityFilter});
        LinkedHashSet<Long> bookTypes = new LinkedHashSet<Long>();
        for (DynamicObject bt : btCol) {
            bookTypes.add(bt.getLong("id"));
        }
        if (bookTypes.size() > 1 && (dyBookType = (DynamicObject)model.getValue(BOOKTYPE)) != null) {
            headInfos.add(String.format(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\uff1a%s", (String)"AnalysisRptUtils_5", (String)"fi-gl-common", (Object[])new Object[0]), dyBookType.getString("name")));
        }
        if ((dyAccountTable = (DynamicObject)model.getValue(ACCTABLE)) != null) {
            headInfos.add(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u8868\uff1a%s", (String)"AnalysisRptUtils_6", (String)"fi-gl-common", (Object[])new Object[0]), dyAccountTable.getString("name")));
        }
        if ((dyPeriodType = (DynamicObject)model.getValue("periodtype")) != null) {
            headInfos.add(String.format(ResManager.loadKDString((String)"\u671f\u95f4\u7c7b\u578b\uff1a%s", (String)"AnalysisRptUtils_7", (String)"fi-gl-common", (Object[])new Object[0]), dyPeriodType.getString("name")));
        }
    }

    private static Set<Long> getBookTypes(long orgId, long orgViewId, String entityId, Set<Long> childOrgIds) {
        HashSet<Long> bookTypes = new HashSet<Long>();
        List<Long> permOrgList = AccSysUtil.getAcctOrgPkList(entityId, true, PermissonType.VIEW);
        HashSet<Long> childOrgSet = new HashSet<Long>();
        childOrgSet.addAll(childOrgIds);
        childOrgSet.retainAll(permOrgList);
        Map<Long, Map<Long, List<Long>>> viewOrgBTMap = AccSysUtil.getViewOrgBTMap();
        Map<Long, List<Long>> orgBTMap = viewOrgBTMap.get(orgViewId);
        if (orgBTMap != null) {
            childOrgSet.retainAll(orgBTMap.keySet());
            for (Map.Entry<Long, List<Long>> entry : orgBTMap.entrySet()) {
                if (!childOrgSet.contains(entry.getKey())) continue;
                bookTypes.addAll((Collection<Long>)entry.getValue());
            }
        }
        return bookTypes;
    }

    public static void checkExistsRefManageItem(ExtendedDataEntity[] entities, ValidateResult result) {
        HashMap<String, Set> typeAndIdsMap = new HashMap<String, Set>();
        HashMap<Long, ExtendedDataEntity> idAndEntityMap = new HashMap<Long, ExtendedDataEntity>(entities.length);
        for (ExtendedDataEntity entity : entities) {
            DynamicObject item = entity.getDataEntity();
            String type = item.getString("rptunit");
            Long id = item.getLong("id");
            Set ids = typeAndIdsMap.computeIfAbsent(type, p -> new HashSet());
            ids.add(id);
            idAndEntityMap.put(id, entity);
        }
        for (Map.Entry entry : typeAndIdsMap.entrySet()) {
            String type = (String)entry.getKey();
            Set ids = (Set)entry.getValue();
            AnalysisRptUtils.queryRefInfo(type, ids, idAndEntityMap, result);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void queryRefInfo(String type, Set<Long> ids, Map<Long, ExtendedDataEntity> idAndEntityMap, ValidateResult result) {
        QFilter filter = null;
        String expEntityName = "";
        HashMap<String, Long> cellAndItemIdMap = new HashMap<String, Long>();
        HashMap<Long, String> orgAndNameMap = new HashMap<Long, String>();
        HashSet<Long> existsErrorIds = new HashSet<Long>();
        if ("gl_balancesheet".equals(type)) {
            expEntityName = "gl_balancesheetexpression";
            try (DataSet editSet = QueryServiceHelper.queryDataSet((String)"AnalysisRptUtils.checkExistsRefManageItem", (String)"gl_balancesheetedit", (String)"org, org.name orgname, accounttable, assetentryentity.assetrowid assetrowid,equityentryentity.equityrowid equityrowid,assetentryentity.asset asset, equityentryentity.equity equity", (QFilter[])new QFilter[]{new QFilter("assetentryentity.asset", "in", ids).or(new QFilter("equityentryentity.equity", "in", ids))}, null);){
                int count = 0;
                for (Row row : editSet) {
                    ++count;
                    Long orgId = row.getLong("org");
                    Long accountTableId = row.getLong(ACCTABLE);
                    String assetrowid = row.getString("assetrowid");
                    String equityrowid = row.getString("equityrowid");
                    Long asset = row.getLong("asset");
                    Long equity = row.getLong("equity");
                    QFilter tmpFilter = new QFilter("org", "=", (Object)orgId).and(new QFilter(ACCTABLE, "=", (Object)accountTableId)).and(new QFilter("rowtag", "in", (Object)new String[]{assetrowid, equityrowid}));
                    if (ids.contains(asset)) {
                        tmpFilter = tmpFilter.and(new QFilter(COLUMNKEY, "in", (Object)new String[]{"1", "2"}));
                        filter = filter == null ? tmpFilter : filter.or(tmpFilter);
                        cellAndItemIdMap.put(AnalysisRptUtils.getKey(orgId, accountTableId, assetrowid, "1"), asset);
                        cellAndItemIdMap.put(AnalysisRptUtils.getKey(orgId, accountTableId, assetrowid, "2"), asset);
                    } else if (ids.contains(equity)) {
                        tmpFilter = tmpFilter.and(new QFilter(COLUMNKEY, "in", (Object)new String[]{"3", "4"}));
                        filter = filter == null ? tmpFilter : filter.or(tmpFilter);
                        cellAndItemIdMap.put(AnalysisRptUtils.getKey(orgId, accountTableId, equityrowid, "3"), equity);
                        cellAndItemIdMap.put(AnalysisRptUtils.getKey(orgId, accountTableId, equityrowid, "4"), equity);
                    }
                    orgAndNameMap.put(orgId, row.getString("orgname"));
                    if (count <= 199) continue;
                    AnalysisRptUtils.addErrorInfo(idAndEntityMap, result, filter, expEntityName, cellAndItemIdMap, orgAndNameMap, existsErrorIds);
                    filter = null;
                    count = 0;
                }
                if (filter == null) return;
                AnalysisRptUtils.addErrorInfo(idAndEntityMap, result, filter, expEntityName, cellAndItemIdMap, orgAndNameMap, existsErrorIds);
                return;
            }
        }
        expEntityName = "gl_incomeexpression";
        try (DataSet editSet = QueryServiceHelper.queryDataSet((String)"AnalysisRptUtils.checkExistsRefManageItem", (String)"gl_incomeedit", (String)"org, org.name orgname, accounttable, entryentity.rowid browid , entryentity.project project", (QFilter[])new QFilter[]{new QFilter("entryentity.project", "in", ids)}, null);){
            int count = 0;
            for (Row row : editSet) {
                ++count;
                Long orgId = row.getLong("org");
                Long accountTableId = row.getLong(ACCTABLE);
                String rowid = row.getString("browid");
                Long projectId = row.getLong("project");
                QFilter tmpFilter = new QFilter("org", "=", (Object)orgId).and(new QFilter(ACCTABLE, "=", (Object)accountTableId)).and(new QFilter("rowtag", "=", (Object)rowid));
                filter = filter == null ? tmpFilter : filter.or(tmpFilter);
                cellAndItemIdMap.put(AnalysisRptUtils.getKey(orgId, accountTableId, rowid, "1"), projectId);
                cellAndItemIdMap.put(AnalysisRptUtils.getKey(orgId, accountTableId, rowid, "2"), projectId);
                orgAndNameMap.put(orgId, row.getString("orgname"));
                if (count <= 199) continue;
                filter = AnalysisRptUtils.appendUnit(type, filter);
                AnalysisRptUtils.addErrorInfo(idAndEntityMap, result, filter, expEntityName, cellAndItemIdMap, orgAndNameMap, existsErrorIds);
                filter = null;
                count = 0;
            }
            if (filter == null) return;
            filter = AnalysisRptUtils.appendUnit(type, filter);
            AnalysisRptUtils.addErrorInfo(idAndEntityMap, result, filter, expEntityName, cellAndItemIdMap, orgAndNameMap, existsErrorIds);
            return;
        }
    }

    private static void addErrorInfo(Map<Long, ExtendedDataEntity> idAndEntityMap, ValidateResult result, QFilter filter, String expEntityName, Map<String, Long> cellAndItemIdMap, Map<Long, String> orgAndNameMap, HashSet<Long> existsErrorIds) {
        try (DataSet expSet = QueryServiceHelper.queryDataSet((String)"AnalysisRptUtils.checkExistsRefManageItem", (String)expEntityName, (String)"org, accounttable, rowtag, columnkey, accounttable.name acctblname,entryentity.project project, entryentity.rptitem rptitem", (QFilter[])new QFilter[]{filter}, null);){
            for (Row row : expSet) {
                String colKey;
                String rowtag;
                Long accountTableId;
                Long orgId;
                Long id;
                Long itemId = row.getLong("rptitem");
                Long projectId = row.getLong("project");
                if (itemId.equals(0L) && projectId.equals(0L) || (id = cellAndItemIdMap.get(AnalysisRptUtils.getKey(orgId = row.getLong("org"), accountTableId = row.getLong(ACCTABLE), rowtag = row.getString("rowtag"), colKey = row.getString(COLUMNKEY)))) == null || existsErrorIds.contains(id)) continue;
                existsErrorIds.add(id);
                ExtendedDataEntity dataEntity = idAndEntityMap.get(id);
                if (dataEntity == null) continue;
                Object pkId = dataEntity.getBillPkId();
                int dataIndex = dataEntity.getDataEntityIndex();
                String orgName = orgAndNameMap.get(orgId) + "";
                String errMsg = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d\u5728\u6838\u7b97\u7ec4\u7ec7\u201c%2$s\u201d\u7684\u79d1\u76ee\u8868\u201c%3$s\u201d\u4e0b\u5b58\u5728\u516c\u5f0f\u5f15\u7528\uff0c\u8bf7\u5148\u5220\u9664\u516c\u5f0f\u540e\u7981\u7528\u3002", (String)"AnalysisRptUtils_8", (String)"fi-gl-common", (Object[])new Object[0]), dataEntity.getBillNo(), orgName, row.getString("acctblname"));
                ValidationErrorInfo info = new ValidationErrorInfo("", pkId, dataIndex, dataEntity.getRowIndex(), "errorcode_001", ResManager.loadKDString((String)"\u7981\u7528", (String)"AnalysisRptUtils_9", (String)"fi-gl-common", (Object[])new Object[0]), errMsg, ErrorLevel.Error);
                result.addErrorInfo((OperateErrorInfo)info);
            }
        }
    }

    private static QFilter appendUnit(String type, QFilter filter) {
        String rptUnit = "";
        if ("gl_showincome".equals(type)) {
            rptUnit = INCOME;
        } else if ("gl_taxshow".equals(type)) {
            rptUnit = "taxshow";
        } else if ("gl_cashflowstat".equals(type)) {
            rptUnit = "cashflow";
        }
        filter = filter.and(new QFilter(TYPE, "=", (Object)rptUnit));
        return filter;
    }

    private static String getKey(Long orgId, Long accountTableId, String balrowid, String colKey) {
        return orgId + "&" + accountTableId + "&" + balrowid + "&" + colKey;
    }
}

