/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;

public class AssgrpRelationUtil {
    private static final String CARRIED_FLEX = "kd.fi.gl.carried_flex";
    private static final String BOS_ADMINORG = "bos_adminorg";
    private static final String STRUCTURE_ORG = "org";
    private static final String STRUCTURE_VIEW = "view";

    private static Set<String> removeCarriedFlex(Collection<String> flexs) {
        Set carriedFlexSet = (Set)ThreadCache.get((Object)CARRIED_FLEX, () -> new HashSet(8));
        return flexs.stream().filter(x -> !carriedFlexSet.contains(x)).collect(Collectors.toSet());
    }

    private static void addCarriedFlex(Collection<String> flexs) {
        Set carriedFlexSet = (Set)ThreadCache.get((Object)CARRIED_FLEX, () -> new HashSet(8));
        carriedFlexSet.addAll(flexs);
        ThreadCache.put((Object)CARRIED_FLEX, (Object)carriedFlexSet);
    }

    public static Map<String, Object> getAssgrpValByRelation(String fromflex, Set<String> toflexs, String entity, Object fromval, Long orgid) {
        Set<String> toFlexSet = AssgrpRelationUtil.removeCarriedFlex(toflexs);
        boolean isUser = "bos_user".equals(entity);
        String dptFieldKey = null;
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        Map<String, String> bToProp = AssgrpRelationUtil.getRelationMapByFromFlex(fromflex, toFlexSet, orgid);
        if (!bToProp.isEmpty()) {
            HashSet<String> selectfields = new HashSet<String>(bToProp.size());
            for (Map.Entry<String, String> bprop : bToProp.entrySet()) {
                String toflex = bprop.getKey();
                String prop = bprop.getValue();
                selectfields.add(prop + " " + toflex);
                if (!isUser || !"entryentity.dpt".equals(prop)) continue;
                dptFieldKey = toflex;
            }
            QFilter filter = new QFilter("id", "=", fromval);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.util.AssgrpRelationUtil.getValueByRelationMap", (String)entity, (String)String.join((CharSequence)",", selectfields), (QFilter[])filter.toArray(), null);){
                if (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    for (String key : bToProp.keySet()) {
                        Object val = row.get(key);
                        if (val == null || isUser && key.equals(dptFieldKey) && !AssgrpRelationUtil.isOrgValueLegal(dptFieldKey, val)) continue;
                        result.put(key, val);
                    }
                }
            }
        }
        AssgrpRelationUtil.addCarriedFlex(result.keySet());
        return result;
    }

    public static List<QFilter> getFilterByRelationMap(String fromFlex, Map<String, Object> toFlexToVal, Long orgid) {
        Map<String, String> bToProp = AssgrpRelationUtil.getRelationMapByFromFlex(fromFlex, toFlexToVal.keySet(), orgid);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        for (Map.Entry<String, String> bprop : bToProp.entrySet()) {
            Object toFlexVal = toFlexToVal.get(bprop.getKey());
            if (AssgrpRelationUtil.isValNull(toFlexVal)) continue;
            QFilter filter = new QFilter(bprop.getValue(), "=", toFlexVal);
            filters.add(filter);
        }
        return filters;
    }

    public static Map<String, String> getRelationMapByFromFlex(String fromFlex, Set<String> flexs, Long orgid) {
        String selectFields = "targetassgrp.flexfield toflex, propvalue";
        List<Object> assgrRelaPKByOrg = GLUtil.getAssgrRelaPKByOrg(orgid);
        QFilter[] filters = new QFilter[]{new QFilter("assgrp.flexfield", "=", (Object)fromFlex), new QFilter("targetassgrp.flexfield", "in", flexs), new QFilter("enable", "=", (Object)Character.valueOf('1')), new QFilter("id", "in", assgrRelaPKByOrg)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.util.AssgrpRelationUtil.getRelationMap", (String)"gl_assgrprelation", (String)selectFields, (QFilter[])filters, null);){
            HashMap<String, String> bToProp = new HashMap<String, String>(16);
            for (Row row : dataSet) {
                String toflex = row.getString("toflex");
                String prop = row.getString("propvalue");
                bToProp.put(toflex, prop);
            }
            HashMap<String, String> hashMap = bToProp;
            return hashMap;
        }
    }

    public static boolean isValNull(Object obj) {
        return StringUtils.isBlank((Object)obj) || "0".equals(String.valueOf(obj));
    }

    private static boolean isOrgValueLegal(String flexField, Object orgPkValue) {
        long orgFunc = AssgrpRelationUtil.getFuncId(flexField);
        if (orgFunc > 0L) {
            return AssgrpRelationUtil.existsOrgInFunc(orgFunc, orgPkValue);
        }
        return true;
    }

    private static long getFuncId(String flexField) {
        FlexProperty flexProperty = FlexEntityMetaUtils.getFlexProperty((String)flexField);
        if (null == flexProperty) {
            return 0L;
        }
        long orgFunc = flexProperty.getOrgFunc();
        if (orgFunc > 0L) {
            return orgFunc;
        }
        String valueSource = flexProperty.getValueSource();
        if ("bos_org".equals(valueSource)) {
            return Long.parseLong("15");
        }
        if (BOS_ADMINORG.equals(valueSource)) {
            return Long.parseLong("01");
        }
        return 0L;
    }

    private static boolean existsOrgInFunc(long orgFuncId, Object orgPkValue) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(STRUCTURE_ORG, "=", orgPkValue);
        qfBuilder.add(STRUCTURE_VIEW, "=", orgFuncId);
        return QueryServiceHelper.exists((String)"bos_org_structure", (QFilter[])qfBuilder.toArray());
    }
}

